/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.analyse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.TimeLineStyle;
import kd.bos.form.control.Timeline;
import kd.bos.form.control.TimelineContentOption;
import kd.bos.form.control.TimelineLabelOption;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineOptionKey;
import kd.bos.form.control.TimelineText;
import kd.bos.instance.Instance;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.ReadyTasks;
import kd.bos.schedule.message.RunningTasks;
import kd.bos.schedule.message.rpc.ExecutorServerData;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public abstract class AbstractTaskAnalyse {
    static final String PRE_ANALYSE_RESULT = "preAnalyseResult";
    static final String SERVICE_NODE_ANALYSE_RESULT = "serviceNodeAnalyseResult";
    static final String PARAMS_ERROR_NODE = "paramsErrorNode";
    static final String THREAD_ERROR_NODE = "threadErrorNode";
    static final String BUSY_NODE = "busyNode";
    static final String MSERVICE_NODE = "mserviceNode";
    static final String MSERVICE_NODE_INDEX = "mserviceNodeIndex";
    static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    static final String TASKID = "taskId";
    static final String GREEN_COLOR = "#339933";
    static final String ANALYSE_STEP = "analyseStep";
    static final String BEGIN_ANALYSE = "beginAnalyse";
    static final String GET_THREAD_DUMP = "getThreadDump";
    static final String APPSPLIT_GET_MSERVICE = "appSplitGetMservice";
    static final String APPNOTSPLIT_GET_MSERVICE = "appNotSplitGetMservice";
    static final String ANALYSE_MSERVICE = "analyseMservice";
    static final String SHOW_RESULT = "showResult";
    static final String END = "end";
    static final String VIEW_THREAD_DUMP = "viewThreadDump";
    IFormView view;
    String analyseTimelineKey = "timelineKey";

    public void analyse() {
        String taskId = (String)this.view.getFormShowParameter().getCustomParam(TASKID);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        String taskAnalyseStep = this.getTaskAnalyseCache(ANALYSE_STEP);
        if (StringUtils.equals((CharSequence)taskAnalyseStep, (CharSequence)END)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskAnalyseStep)) {
            this.taskStatusAnalyse(taskInfo);
        } else {
            this.nextAnalyse();
        }
    }

    public void optionClick(String optionKey) {
        if (StringUtils.isNotBlank((CharSequence)optionKey)) {
            String[] optionKeys = optionKey.split("\\$");
            String key = optionKeys[0];
            String instanceIp = optionKeys[1];
            if (StringUtils.equals((CharSequence)key, (CharSequence)VIEW_THREAD_DUMP)) {
                this.viewRunningTaskThreadDump(instanceIp);
            }
        } else {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6807\u8bc6\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u8005\u3002", (String)"AbstractTaskAnalyse_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    void analyseThread(ExecutorServerData executorServerData, TimelineOption analyseNodeOption) {
    }

    public String getAnalyseTimelineKey() {
        return this.analyseTimelineKey;
    }

    String getTaskAnalyseCache(String key) {
        return this.view.getPageCache().get(key);
    }

    void putTaskAnalyseCache(String key, String value) {
        this.view.getPageCache().put(key, value);
    }

    void nextAnalyse() {
        this.stopProgressBar();
    }

    private void taskStatusAnalyse(TaskInfo taskInfo) {
        ArrayList<TimelineOption> timelineOptions = new ArrayList<TimelineOption>();
        TimelineOption taskStatusTimelineOption = this.getTaskStatusTimelineOption(taskInfo);
        timelineOptions.add(taskStatusTimelineOption);
        this.putTaskAnalyseCache(PRE_ANALYSE_RESULT, SerializationUtils.toJsonString(timelineOptions));
        Timeline analyseTimeline = (Timeline)this.view.getControl(this.analyseTimelineKey);
        analyseTimeline.setClientTimelineOptions(timelineOptions);
        this.putTaskAnalyseCache(ANALYSE_STEP, BEGIN_ANALYSE);
        this.startProgressBar();
    }

    private TimelineOption getTaskStatusTimelineOption(TaskInfo taskInfo) {
        TimelineOption timelineOption = new TimelineOption();
        timelineOption.setLabel(new TimelineLabelOption());
        String contentTitle = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001", (String)"AbstractTaskAnalyse_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
        String contentDesc = this.getStatusDesc(taskInfo);
        timelineOption.setContent(new TimelineContentOption(new LocaleString(contentTitle), new LocaleString(contentDesc)));
        return timelineOption;
    }

    private String getStatusDesc(TaskInfo taskInfo) {
        String status;
        String statusName = "";
        switch (status = taskInfo.getStatus()) {
            case "BEGIN": {
                statusName = ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"AbstractTaskAnalyse_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case "ABORTED": {
                statusName = String.format(ResManager.loadKDString((String)"\u7ec8\u6b62\uff0c\u539f\u56e0\uff1a%s", (String)"AbstractTaskAnalyse_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), TaskStatusConstant.getStatusName((String)taskInfo.getStatusDesc()));
                break;
            }
            case "COMPLETED": {
                statusName = ResManager.loadKDString((String)"\u5b8c\u6210\uff0c\u4efb\u52a1\u5206\u6790\u7ed3\u675f", (String)"AbstractTaskAnalyse_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case "SCHEDULED": {
                statusName = ResManager.loadKDString((String)"\u8ba1\u5212", (String)"AbstractTaskAnalyse_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case "READY": {
                statusName = ResManager.loadKDString((String)"\u5c31\u7eea", (String)"AbstractTaskAnalyse_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case "FAILED": {
                statusName = ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u5efa\u8bae\u901a\u8fc7\u9519\u8bef\u539f\u56e0\u6216\u5f02\u5e38\u65e5\u5fd7\u67e5\u770b\u5931\u8d25\u8be6\u60c5", (String)"AbstractTaskAnalyse_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case "SKIP": {
                statusName = String.format(ResManager.loadKDString((String)"\u8df3\u8fc7\uff0c\u539f\u56e0\uff1a%s", (String)"AbstractTaskAnalyse_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), TaskStatusConstant.getStatusName((String)taskInfo.getStatusDesc()));
                break;
            }
            case "TIMEOUT": {
                statusName = ResManager.loadKDString((String)"\u8d85\u65f6\uff0c\u4efb\u52a1\u5206\u6790\u7ed3\u675f", (String)"AbstractTaskAnalyse_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            default: {
                statusName = status;
            }
        }
        return statusName;
    }

    TimelineOption createTimelineOption(String contentTitle, TimeLineStyle contentTitleStyle, String contentValue, TimeLineStyle contentValueStyle) {
        ArrayList<TimelineText> timelineContentValues = new ArrayList<TimelineText>(1);
        TimelineText timelineContentValue = new TimelineText(new LocaleString(contentValue), contentValueStyle);
        timelineContentValues.add(timelineContentValue);
        TimelineText timelineContentTitle = new TimelineText(new LocaleString(contentTitle), contentTitleStyle);
        TimelineContentOption timelineContentOption = new TimelineContentOption(timelineContentTitle, timelineContentValues);
        return new TimelineOption(new TimelineLabelOption(), timelineContentOption);
    }

    TimelineOption createTimelineOption(String contentTitle, TimeLineStyle contentTitleStyle, List<TimelineText> contentValues) {
        TimelineText timelineContentTitle = new TimelineText(new LocaleString(contentTitle), contentTitleStyle);
        TimelineContentOption timelineContentOption = new TimelineContentOption(timelineContentTitle, contentValues);
        return new TimelineOption(new TimelineLabelOption(), timelineContentOption);
    }

    void updateTimeline(List<TimelineOption> timelineOptions) {
        Timeline timeline = (Timeline)this.view.getControl(this.analyseTimelineKey);
        timeline.setClientTimelineOptions(timelineOptions);
        this.putTaskAnalyseCache(PRE_ANALYSE_RESULT, SerializationUtils.toJsonString(timelineOptions));
    }

    void startProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.view.getControl("progressbarap");
        progressBar.start();
    }

    void stopProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.view.getControl("progressbarap");
        progressBar.stop();
        this.putTaskAnalyseCache(ANALYSE_STEP, END);
    }

    public static ExecutorServerData remoteGetExecutorServerData(MessageType messageType) {
        ExecutorServerData executorServerData = new ExecutorServerData();
        executorServerData.setIp(ZkConfig.getHostIpAddress());
        executorServerData.setInstanceId(Instance.getInstanceId());
        ExecutorService executorService = ExecutorService.getInstance();
        executorServerData.setStarted(executorService != null && executorService.isStarted());
        executorServerData.setDisableToWork(Boolean.getBoolean("Schedule.disableToWork"));
        executorServerData.setDeployMode(ZkConfig.getDeployMode());
        executorServerData.setMqConsumerRegister(Boolean.getBoolean("mq.consumer.register"));
        executorServerData.setDevMode(ZkConfig.getRunMode() == AbstractService.RunMode.Dev);
        executorServerData.setMessageAccessType(ZkConfig.getAccessJobMsgType());
        executorServerData.setReadyTaskSize(ReadyTasks.getInstance((MessageType)messageType).getTaskSize().intValue());
        executorServerData.setMaxReadyTaskSize(ZkConfig.getReadyTasksSize());
        executorServerData.setRunningTaskSize(RunningTasks.getInstance((MessageType)messageType).size());
        executorServerData.setMaxNumOfWorkThread(ZkConfig.getMaxNumOfWorkThread((MessageType)messageType));
        return executorServerData;
    }

    TimeLineStyle createErrorStyle() {
        TimeLineStyle style = new TimeLineStyle();
        style.setColor("#CC3333");
        return style;
    }

    TimeLineStyle createSuccessStyle() {
        TimeLineStyle style = new TimeLineStyle();
        style.setColor(GREEN_COLOR);
        return style;
    }

    TimeLineStyle createWarnStyle() {
        TimeLineStyle style = new TimeLineStyle();
        style.setColor("#ff9900");
        return style;
    }

    void viewRunningTaskThreadDump(String instanceIp) {
        String taskId = (String)this.view.getFormShowParameter().getCustomParam(TASKID);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        MessageType messageType = ClientObservableUtils.convertType((JobType)taskInfo.getJobType());
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("messageType", (Object)messageType);
        fsp.setCustomParam("instanceIp", (Object)instanceIp);
        fsp.setFormId("sch_taskthreaddump");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.view.showForm(fsp);
    }

    List<TimelineOption> getPreAnalyseResult() {
        String preAnalyseResultStr = this.getTaskAnalyseCache(PRE_ANALYSE_RESULT);
        return SerializationUtils.fromJsonStringToList((String)preAnalyseResultStr, TimelineOption.class);
    }

    List<TimelineOptionKey> createViewThreadDumpOption(String instanceIp) {
        ArrayList<TimelineOptionKey> optionKeys = new ArrayList<TimelineOptionKey>(1);
        TimelineOptionKey optionKey = new TimelineOptionKey(ResManager.getLocaleString((String)"\u67e5\u770b\u4efb\u52a1\u7ebf\u7a0b\u5806\u6808", (String)"AbstractTaskAnalyse_10", (String)BOS_SCHEDULE_FORMPLUGIN), "viewThreadDump$" + instanceIp);
        optionKeys.add(optionKey);
        return optionKeys;
    }

    void updateTimelineAndStopProgressBar(String contentTitle, String contentValue, List<TimelineOption> preAnalyseResult, boolean isError) {
        if (isError) {
            TimelineOption timelineOption = this.createTimelineOption(contentTitle, null, contentValue, this.createErrorStyle());
            preAnalyseResult.add(timelineOption);
        } else {
            TimelineOption timelineOption = this.createTimelineOption(contentTitle, null, contentValue, null);
            preAnalyseResult.add(timelineOption);
        }
        this.updateTimeline(preAnalyseResult);
        this.stopProgressBar();
    }

    Map<String, List<String>> getServiceNodeAnalyseResult() {
        String serviceNodeAnalyseResult = this.getTaskAnalyseCache(SERVICE_NODE_ANALYSE_RESULT);
        if (StringUtils.isNotBlank((CharSequence)serviceNodeAnalyseResult)) {
            return (Map)SerializationUtils.fromJsonString((String)serviceNodeAnalyseResult, Map.class);
        }
        return new HashMap<String, List<String>>();
    }

    void cacheServiceNodeAnalyseResult(Map<String, List<String>> serviceNodeAnalyseResult) {
        this.putTaskAnalyseCache(SERVICE_NODE_ANALYSE_RESULT, SerializationUtils.toJsonString(serviceNodeAnalyseResult));
    }
}

