/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.analyse;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineText;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.service.LivingServiceUtils;
import kd.bos.schedule.analyse.AbstractTaskAnalyse;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.message.rpc.ExecutorServerData;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ReadyTaskAnalyse
extends AbstractTaskAnalyse {
    private static final Log log = LogFactory.getLog(ReadyTaskAnalyse.class);

    public ReadyTaskAnalyse(IFormView view) {
        this.view = view;
    }

    @Override
    void nextAnalyse() {
        String analyseStep = this.getTaskAnalyseCache("analyseStep");
        if (StringUtils.isBlank((CharSequence)analyseStep)) {
            this.stopProgressBar();
        } else {
            String taskId = (String)this.view.getFormShowParameter().getCustomParam("taskId");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            switch (analyseStep) {
                case "beginAnalyse": {
                    this.beginAnalyse(taskInfo);
                    break;
                }
                case "analyseMservice": {
                    this.analyseServiceNode(taskInfo);
                    break;
                }
                default: {
                    this.stopProgressBar();
                }
            }
        }
    }

    private void analyseServiceNode(TaskInfo taskInfo) {
        JobType jobType = taskInfo.getJobType();
        String runAtIp = taskInfo.getRunAt();
        String contentTitle = ResManager.loadKDString((String)"\u7ebf\u7a0b\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5", (String)"ReadyTaskAnalyse_3", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        List<TimelineOption> preAnalyseResult = this.getPreAnalyseResult();
        if (StringUtils.isBlank((CharSequence)runAtIp)) {
            String runAtIpNull = ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1\u7684\u670d\u52a1\u5668\u4e3a\u7a7a\uff0c\u83b7\u53d6\u7ebf\u7a0b\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5\u5931\u8d25", (String)"ReadyTaskAnalyse_7", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            this.updateTimelineAndStopProgressBar(contentTitle, runAtIpNull, preAnalyseResult, true);
            return;
        }
        if (jobType == null) {
            String jobTypeNull = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u83b7\u53d6\u7ebf\u7a0b\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5\u5931\u8d25", (String)"ReadyTaskAnalyse_8", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            this.updateTimelineAndStopProgressBar(contentTitle, jobTypeNull, preAnalyseResult, true);
            return;
        }
        MessageType messageType = ClientObservableUtils.convertType((JobType)jobType);
        try {
            ExecutorServerData executorServerData = (ExecutorServerData)RPCHelper.remoteGetExecutorServerData((String)runAtIp, (MessageType)messageType);
            TimelineOption analyseServiceNodeOption = this.createTimelineOption(contentTitle, null, new ArrayList<TimelineText>());
            this.analyseThread(executorServerData, analyseServiceNodeOption);
            preAnalyseResult.add(analyseServiceNodeOption);
            this.updateTimeline(preAnalyseResult);
            this.stopProgressBar();
        }
        catch (Exception e) {
            log.error("Schedule***\u4efb\u52a1\u8bca\u65ad\u5f02\u5e38\uff0ctaskId:{}", (Object)taskInfo.getId(), (Object)e);
            String errorValue = String.format(ResManager.loadKDString((String)"\u8bbf\u95ee\u5b9e\u4f8b\uff08%s\uff09\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ReadyTaskAnalyse_6", (String)"bos-schedule-formplugin", (Object[])new Object[0]), taskInfo.getInstanceId());
            TimelineOption timelineOption = this.createTimelineOption(contentTitle, null, errorValue, this.createErrorStyle());
            preAnalyseResult.add(timelineOption);
            this.updateTimeline(preAnalyseResult);
            this.stopProgressBar();
        }
    }

    @Override
    void analyseThread(ExecutorServerData executorServerData, TimelineOption analyseNodeOption) {
        int runningTaskSize = executorServerData.getRunningTaskSize();
        int maxNumOfWorkThread = executorServerData.getMaxNumOfWorkThread();
        TimelineText desc = null;
        if (runningTaskSize == maxNumOfWorkThread) {
            desc = new TimelineText(new LocaleString(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u6ca1\u6709\u7a7a\u95f2\u7ebf\u7a0b\uff0c\u4efb\u52a1\u6392\u961f\u7b49\u5f85\u6267\u884c\u3002\uff08\u8282\u70b9\u8fd0\u884c\u4e2d\u4efb\u52a1\u6570\u91cf\u7b49\u4e8e\u5141\u8bb8\u5904\u7406\u7684\u6700\u5927\u4efb\u52a1\u6570\u91cf %s\uff09", (String)"ReadyTaskAnalyse_4", (String)"bos-schedule-formplugin", (Object[])new Object[0]), maxNumOfWorkThread)), this.createWarnStyle());
            analyseNodeOption.setOptionKeys(this.createViewThreadDumpOption(executorServerData.getIp()));
        } else {
            desc = new TimelineText(new LocaleString(String.format(ResManager.loadKDString((String)"\u5f02\u5e38\uff0c\u5f53\u524d\u8282\u70b9\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u6570\u91cf %1$s\uff0c\u5141\u8bb8\u5904\u7406\u7684\u6700\u5927\u4efb\u52a1\u6570\u91cf %2$s\uff0c\u65e0\u6cd5\u5904\u7406\u5f53\u524d\u8282\u70b9\u7684\u5c31\u7eea\u4efb\u52a1\uff0c\u5efa\u8bae\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ReadyTaskAnalyse_5", (String)"bos-schedule-formplugin", (Object[])new Object[0]), runningTaskSize, maxNumOfWorkThread)), this.createErrorStyle());
        }
        analyseNodeOption.getContent().getDescriptions().add(desc);
    }

    private void beginAnalyse(TaskInfo taskInfo) {
        String instanceId = taskInfo.getInstanceId();
        boolean instanceAlive = LivingServiceUtils.isInstanceAlive((String)instanceId);
        String instanceAliveContentTitle = ResManager.loadKDString((String)"\u5f53\u524d\u63a5\u6536\u6b64\u4efb\u52a1\u7684\u8282\u70b9\u72b6\u6001", (String)"ReadyTaskAnalyse_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        List<TimelineOption> preAnalyseResult = this.getPreAnalyseResult();
        if (instanceAlive) {
            String instanceAliveStr = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u6b63\u5e38\uff0c\u6b63\u5728\u68c0\u67e5\u8282\u70b9\u7684\u7ebf\u7a0b\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5", (String)"ReadyTaskAnalyse_1", (String)"bos-schedule-formplugin", (Object[])new Object[0]), instanceId);
            TimelineOption timelineOption = this.createTimelineOption(instanceAliveContentTitle, null, instanceAliveStr, this.createSuccessStyle());
            preAnalyseResult.add(timelineOption);
            this.updateTimeline(preAnalyseResult);
            this.putTaskAnalyseCache("analyseStep", "analyseMservice");
        } else {
            String instanceNotAlive = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u5df2\u4e0b\u7ebf\uff0c\u7b49\u5f85\u540e\u53f0\u4e8b\u52a1\uff08Schedule ClearUpTask\uff09\u5b9e\u65f6\u4efb\u52a1\u6267\u884c\uff0c\u5c06\u4efb\u52a1\u91cd\u65b0\u8c03\u5ea6", (String)"ReadyTaskAnalyse_2", (String)"bos-schedule-formplugin", (Object[])new Object[0]), instanceId);
            TimelineOption timelineOption = this.createTimelineOption(instanceAliveContentTitle, null, instanceNotAlive, this.createErrorStyle());
            preAnalyseResult.add(timelineOption);
            this.updateTimeline(preAnalyseResult);
            this.stopProgressBar();
        }
    }
}

