/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.analyse;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.form.control.TimelineOption;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.service.LivingServiceUtils;
import kd.bos.schedule.analyse.AbstractTaskAnalyse;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class RunningTaskAnalyse
extends AbstractTaskAnalyse {
    public static final Log log = LogFactory.getLog(RunningTaskAnalyse.class);

    public RunningTaskAnalyse(IFormView view) {
        this.view = view;
    }

    @Override
    void nextAnalyse() {
        String analyseStep = this.getTaskAnalyseCache("analyseStep");
        if (StringUtils.isBlank((CharSequence)analyseStep)) {
            this.stopProgressBar();
        } else {
            String taskId = (String)this.view.getFormShowParameter().getCustomParam("taskId");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            switch (analyseStep) {
                case "beginAnalyse": {
                    this.beginAnalyse(taskInfo);
                    break;
                }
                case "getThreadDump": {
                    this.getThreadDump(taskInfo);
                    break;
                }
                default: {
                    this.stopProgressBar();
                }
            }
        }
    }

    private void beginAnalyse(TaskInfo taskInfo) {
        String instanceId = taskInfo.getInstanceId();
        boolean instanceAlive = LivingServiceUtils.isInstanceAlive((String)instanceId);
        List<TimelineOption> preAnalyseResult = this.getPreAnalyseResult();
        String nextAnalyseContentTitle = ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u4efb\u52a1\u7684\u8282\u70b9\u72b6\u6001", (String)"RunningTaskAnalyse_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        if (instanceAlive) {
            this.putTaskAnalyseCache("analyseStep", "getThreadDump");
            String nextAnalyseContentValue = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u5b9e\u4f8b\u6b63\u5e38\uff0c\u6b63\u5728\u68c0\u67e5\u4efb\u52a1\u8fd0\u884c\u7ebf\u7a0b\u5806\u6808", (String)"RunningTaskAnalyse_1", (String)"bos-schedule-formplugin", (Object[])new Object[0]), instanceId);
            TimelineOption nextAnalyseResult = this.createTimelineOption(nextAnalyseContentTitle, null, nextAnalyseContentValue, null);
            preAnalyseResult.add(nextAnalyseResult);
            this.updateTimeline(preAnalyseResult);
        } else {
            this.instanceNotAlive(nextAnalyseContentTitle, preAnalyseResult, instanceId);
            this.stopProgressBar();
        }
    }

    private void getThreadDump(TaskInfo taskInfo) {
        String instanceIp = this.getInstanceIp(taskInfo.getRunAt());
        String messageId = taskInfo.getMessageId();
        JobType jobType = taskInfo.getJobType();
        String threadDumpContentTitle = ResManager.loadKDString((String)"\u7ebf\u7a0b\u5806\u6808", (String)"RunningTaskAnalyse_3", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        List<TimelineOption> preAnalyseResult = this.getPreAnalyseResult();
        if (StringUtils.isBlank((CharSequence)instanceIp)) {
            String ipNull = ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1\u7684\u670d\u52a1\u5668\u4e3a\u7a7a\uff0c\u83b7\u53d6\u7ebf\u7a0b\u5806\u6808\u5931\u8d25", (String)"RunningTaskAnalyse_6", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            this.updateTimelineAndStopProgressBar(threadDumpContentTitle, ipNull, preAnalyseResult, true);
            return;
        }
        if (StringUtils.isBlank((CharSequence)messageId)) {
            String messageIdNull = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1messageId\u4e3a\u7a7a\uff0c\u83b7\u53d6\u7ebf\u7a0b\u5806\u6808\u5931\u8d25", (String)"RunningTaskAnalyse_7", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            this.updateTimelineAndStopProgressBar(threadDumpContentTitle, messageIdNull, preAnalyseResult, true);
            return;
        }
        if (jobType == null) {
            String jobTypeNull = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u83b7\u53d6\u7ebf\u7a0b\u5bf9\u6218\u5931\u8d25", (String)"RunningTaskAnalyse_8", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            this.updateTimelineAndStopProgressBar(threadDumpContentTitle, jobTypeNull, preAnalyseResult, true);
            return;
        }
        MessageType messageType = ClientObservableUtils.convertType((JobType)jobType);
        try {
            String threadDumpStr = (String)RPCHelper.remoteGetRunningTaskThreadDump((String)instanceIp, (MessageType)messageType, (String)RequestContext.get().getAccountId(), (String)messageId);
            if (StringUtils.isNotBlank((CharSequence)threadDumpStr)) {
                Html html = (Html)this.view.getControl("htmlap");
                html.setConent(threadDumpStr);
                this.stopProgressBar();
            } else {
                String value = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ebf\u7a0b\u5806\u6808\uff0c\u8bf7\u518d\u6b21\u68c0\u67e5\u4efb\u52a1\u72b6\u6001\u662f\u5426\u5df2\u5b8c\u6210\uff0c\u6216\u8005\u54a8\u8be2\u7ba1\u7406\u5458", (String)"RunningTaskAnalyse_4", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
                this.updateTimelineAndStopProgressBar(threadDumpContentTitle, value, preAnalyseResult, false);
            }
        }
        catch (Throwable t) {
            log.error("Schedule***\u4efb\u52a1\u8bca\u65ad\u5f02\u5e38\uff0c\u83b7\u53d6\u7ebf\u7a0b\u5806\u6808\u5f02\u5e38\uff0ctaskId={}", (Object)taskInfo.getId(), (Object)t);
            String value = ResManager.loadKDString((String)"\u83b7\u53d6\u7ebf\u7a0b\u5806\u6808\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"RunningTaskAnalyse_5", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            this.updateTimelineAndStopProgressBar(threadDumpContentTitle, value, preAnalyseResult, true);
        }
    }

    private void instanceNotAlive(String nextAnalyseContentTitle, List<TimelineOption> preAnalyseResult, String instanceId) {
        String nextAnalyseContentValue = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u5df2\u4e0b\u7ebf\uff0c\u7b49\u5f85\u540e\u53f0\u4e8b\u52a1\uff08Schedule ClearUpTask\uff09\u5b9e\u65f6\u4efb\u52a1\u6267\u884c\uff0c\u5c06\u4efb\u52a1\u72b6\u6001\u6539\u4e3a\u7ec8\u6b62\u3002", (String)"RunningTaskAnalyse_2", (String)"bos-schedule-formplugin", (Object[])new Object[0]), instanceId);
        TimelineOption nextAnalyseResult = this.createTimelineOption(nextAnalyseContentTitle, null, nextAnalyseContentValue, null);
        preAnalyseResult.add(nextAnalyseResult);
        this.updateTimeline(preAnalyseResult);
    }

    private String getInstanceIp(String runAt) {
        List executorServerInfos = ClientObservableUtils.queryExecutorServerStatus();
        String instanceIp = "";
        if (executorServerInfos == null) {
            return instanceIp;
        }
        for (ExecutorServerInfo executorServerInfo : executorServerInfos) {
            if (!StringUtils.equals((CharSequence)executorServerInfo.getName(), (CharSequence)runAt)) continue;
            Map detail = executorServerInfo.getDetail();
            instanceIp = (String)detail.get("host");
            break;
        }
        return instanceIp;
    }
}

