/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.dao.dbImpl.DbJobDao;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class ErrorJobListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(ErrorJobListPlugin.class);
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        if ("jobexecute".equals(operate.getOperateKey())) {
            if (evt.getListSelectedData().size() > 20) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u91cd\u65b0\u6267\u884c\u6700\u591a\u9009\u62e9%s\u6761\u6570\u636e\u3002", (String)"ErrorJobListPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), 20));
                evt.setCancel(true);
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("executejob", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u91cd\u65b0\u6267\u884c\u8be5\u4f5c\u4e1a\uff1f", (String)"ErrorJobListPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IListView currentView = (IListView)messageBoxClosedEvent.getSource();
            ListSelectedRowCollection selectedRows = currentView.getSelectedRows();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sch_errorjob");
            if (selectedRows != null && !selectedRows.isEmpty()) {
                Object[] params = new SqlParameter[selectedRows.size()];
                SqlBuilder sBuilder = new SqlBuilder();
                sBuilder.append("select a.ftaskid,a.fjobid,b.fscheduleid from t_sch_errorjob a left join t_sch_task b on a.ftaskid = b.fid  where ", new Object[0]);
                ArrayList<String> taskIds = new ArrayList<String>(6);
                for (int i = 0; i < selectedRows.size(); ++i) {
                    params[i] = new SqlParameter("ftaskid", type.getPrimaryKey().getDbType(), selectedRows.get(i).getPrimaryKeyValue());
                    taskIds.add((String)selectedRows.get(i).getPrimaryKeyValue());
                }
                sBuilder.appendIn("ftaskid", params);
                ArrayList scheduleid = new ArrayList();
                ArrayList jobids = new ArrayList();
                DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sBuilder, rs -> {
                    while (rs.next()) {
                        jobids.add(rs.getString("fjobid"));
                        scheduleid.add(rs.getString("fscheduleid"));
                    }
                    return jobids;
                });
                StringBuilder errMsgBuilder = new StringBuilder();
                DbJobDao jobdao = new DbJobDao();
                List taskInfos = ScheduleServiceHelper.queryTask(taskIds);
                for (int j = 0; j < jobids.size(); ++j) {
                    TaskInfo taskInfo;
                    JobInfo jobInfo = jobdao.get((String)jobids.get(j));
                    if (!jobInfo.isEnable()) {
                        errMsgBuilder.append(String.format(ResManager.loadKDString((String)"%s\u8c03\u5ea6\u4f5c\u4e1a,\u672a\u542f\u7528\u3002\r\n", (String)"ErrorJobListPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), jobInfo.getlName()));
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)jobInfo.getAppId()) || (taskInfo = (TaskInfo)taskInfos.get(j)) != null) {
                        // empty if block
                    }
                    jobInfo.setScheduleId((String)scheduleid.get(j));
                    JobClient.dispatch((JobInfo)jobInfo);
                }
                if (StringUtils.isNotBlank((CharSequence)errMsgBuilder.toString())) {
                    FormShowParameter showParameter = new FormShowParameter();
                    String errMsg = errMsgBuilder.toString();
                    showParameter.setCustomParam("errMsg", (Object)errMsg);
                    showParameter.setFormId("sch_scheduletip_details");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                } else {
                    BillList billList = (BillList)this.getView().getControl("billlistap");
                    billList.refresh();
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u5df2\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u8fd0\u884c\u65e5\u5fd7\u5217\u8868\u3002", (String)"ErrorJobListPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ErrorJobListPluginImpl());
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u65e5\u5fd7\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"ErrorJobListPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), 3));
        }
    }

    private boolean check(List<QFilter> qfilters) {
        int intervalMonth = 3;
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        for (QFilter filter : qfilters) {
            if (!"fexecutetime".equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime start = LocalDateTime.parse(startTime, dateTimeFormatter);
                LocalDateTime end = LocalDateTime.parse(endTime, dateTimeFormatter);
                long duration = ChronoUnit.DAYS.between(start, end);
                if (duration > (long)(intervalMonth * 31)) {
                    checkResult = false;
                    continue;
                }
                checkResult = true;
            }
            catch (Exception px) {
                logger.error((Throwable)px);
                return checkResult;
            }
        }
        return checkResult;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        args.setCancel(true);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sch_errorjob");
        long taskId = Long.parseLong(billList.getCurrentSelectedRowInfo().getPrimaryKeyValue().toString());
        FormShowParameter showParameter = new FormShowParameter();
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        StringBuilder sqlBuffTemp = new StringBuilder();
        String sql = sqlBuffTemp.append("SELECT A.fjobid,A.fjobid\"id\",A.fexecutetime,E.fnumber,A.ftaskid,A.frunat,A.ferrorreason ,B.FSCHEDULEID ,B.FNUMBER,D.FNAME,C.FNAME \"jobName\" FROM t_sch_errorjob A ").append("LEFT JOIN T_SCH_TASK B ON A.FTASKID = B.FID ").append("LEFT JOIN T_SCH_JOB_L C ON A.FJOBID = C.FID AND C.FLOCALEID ='").append(lang).append("'").append("LEFT JOIN T_SCH_JOB E ON C.FID  = E.FID ").append("LEFT JOIN T_SCH_SCHEDULE_L D ON D.FID = B.FSCHEDULEID AND D.FLOCALEID ='").append(lang).append("'").append("WHERE A.FTASKID IN").append("(").append("?").append(")").toString();
        HashMap data = new HashMap();
        Object[] params = new SqlParameter[]{new SqlParameter("ftaskid", type.getPrimaryKey().getDbType(), billList.getCurrentSelectedRowInfo().getPrimaryKeyValue())};
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                data.put("ftaskid", rs.getString("fnumber"));
                data.put("id", rs.getString("ftaskid"));
                data.put("jobnametemp", rs.getString("jobName"));
                data.put("planname", rs.getString("fname"));
                data.put("frunat", rs.getString("frunat"));
                data.put("ferrorreason", rs.getString("ferrorreason"));
            }
            return data;
        });
        showParameter.setFormId("sch_errorjob_details");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskId", (Object)taskId);
        showParameter.setCustomParam("jobnumber", data.get("ftaskid"));
        showParameter.setCustomParam("jobname", data.get("jobnametemp"));
        showParameter.setCustomParam("planname", data.get("planname"));
        this.getView().showForm(showParameter);
    }

    private static String listToSqlString(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : list) {
            if (StringUtils.isEmpty((CharSequence)item)) continue;
            sb.append('\'').append(item).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }

    static class ErrorJobListPluginImpl
    extends ListDataProvider {
        ErrorJobListPluginImpl() {
        }

        protected boolean isRegisterProperty() {
            return true;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            QueryBuilder queryBuilder = this.getQueryBuilder();
            MainEntityType dt = (MainEntityType)queryBuilder.getReturnEntityType();
            dt.registerSimpleProperty(new DynamicSimpleProperty("planname", String.class, (Object)""));
            dt.registerSimpleProperty(new DynamicSimpleProperty("operation", String.class, (Object)""));
            DynamicObjectCollection dynamicObjectData = new DynamicObjectCollection((DynamicObjectType)dt, null);
            String lang = RequestContext.get().getLang().toString();
            ORM orm = ORM.create();
            String orderBy = queryBuilder.getOrderBys();
            if (StringUtils.isNotBlank((CharSequence)orderBy)) {
                String[] splits = orderBy.split(",");
                ArrayList<String> orderByList = new ArrayList<String>(splits.length);
                for (String orderField : splits) {
                    if ("id".equals(orderField.trim().split(" ")[0].trim())) {
                        orderField = orderField.replace("id", "ftaskid");
                    }
                    orderByList.add(orderField);
                }
                orderBy = String.join((CharSequence)",", orderByList);
            }
            ArrayList<String> taskIdList = new ArrayList<String>();
            DataSet ds = orm.queryDataSet("sch_errorjob", "sch_errorjob", "ftaskid", queryBuilder.getFilters(), orderBy, start, limit);
            Object object = null;
            try {
                DynamicObjectCollection dynamicObjectBefore = orm.toPlainDynamicObjectCollection(ds);
                for (DynamicObject dynamicObject : dynamicObjectBefore) {
                    taskIdList.add(String.valueOf(dynamicObject.get("ftaskid")));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (StringUtils.equals((CharSequence)queryBuilder.getOrderBys(), (CharSequence)"")) {
                orderBy = "fexecutetime desc";
            }
            if (CollectionUtils.isEmpty(taskIdList)) {
                return dynamicObjectData;
            }
            SqlBuilder sBuilder = new SqlBuilder();
            sBuilder.append("SELECT A.fjobid, A.fexecutetime,A.ftaskid,A.frunat, B.FSCHEDULEID, D.FNAME FROM t_sch_errorjob A ", new Object[0]).append("LEFT JOIN T_SCH_TASK B ON A.FTASKID = B.FID ", new Object[0]).append("LEFT JOIN T_SCH_JOB_L C ON A.FJOBID = C.FID AND ", new Object[0]).append(String.format("C.FLOCALEID = '%s' ", lang), new Object[0]).append("LEFT JOIN T_SCH_JOB E ON C.FID  = E.FID ", new Object[0]).append("LEFT JOIN T_SCH_SCHEDULE_L D ON D.FID = B.FSCHEDULEID AND ", new Object[0]).append(String.format("D.FLOCALEID = '%s' ", lang), new Object[0]).append("WHERE ", new Object[0]).appendIn("A.FTASKID ", taskIdList.toArray()).append("ORDER BY ", new Object[0]).append(orderBy, new Object[0]);
            DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sBuilder, rs -> {
                while (rs.next()) {
                    DynamicObject displayStatus = new DynamicObject((DynamicObjectType)dt);
                    displayStatus.set("ftaskid", (Object)rs.getString("ftaskid"));
                    displayStatus.set("id", (Object)rs.getString("ftaskid"));
                    displayStatus.set("fjobid_id", (Object)rs.getString("fjobid"));
                    displayStatus.set("planname", (Object)rs.getString("fname"));
                    displayStatus.set("frunat", (Object)rs.getString("frunat"));
                    displayStatus.set("fexecutetime", (Object)rs.getTimestamp("fexecutetime").getTime());
                    displayStatus.set("operation", (Object)ResManager.loadKDString((String)"\u65e5\u5fd7\u8be6\u60c5", (String)"ErrorJobListPlugin_3", (String)ErrorJobListPlugin.BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    dynamicObjectData.add((Object)displayStatus);
                }
                return dynamicObjectData;
            });
            BusinessDataServiceHelper.loadRefence((Object[])dynamicObjectData.toArray(), (IDataEntityType)dt);
            this.getQueryResult().setDataCount(taskIdList.size());
            this.getQueryResult().setCollection(dynamicObjectData);
            return dynamicObjectData;
        }

        public int getRealCount() {
            QueryBuilder queryBuilder = this.getQueryBuilder();
            ORM orm = ORM.create();
            return orm.count("sch_errorjob", "sch_errorjob", queryBuilder.getFilters());
        }
    }
}

