/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.instance.AppGroup;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;

public class JobListPlugin
extends StandardTreeListPlugin {
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static final String NUMBER_LIST = "numberList";
    private static final String TASKCLASSNAME_APPID = "taskclassname.appid";
    private static final String DEFAULT_APPID = "bos";
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final String Sch_JOB = "sch_job";
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.formplugin.JobListPlugin");
    private List<AppInfo> grayAppInfoList = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            ListSelectedRowCollection listSelectedData;
            String operaKey = ((AbstractOperate)args.getSource()).getOperateKey();
            if ("disable".equals(operaKey) || "enable".equals(operaKey)) {
                ListSelectedRowCollection col = ((ListView)this.getView()).getSelectedRows();
                if (col.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"JobListPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.cancel = true;
                    return;
                }
            } else if ("modify".equals(operaKey) && (listSelectedData = args.getListSelectedData()) != null) {
                boolean status;
                ListSelectedRow listSelectedRow;
                Object primaryKeyValue;
                DynamicObject dynamicObject;
                if (listSelectedData.size() > 1) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8c03\u5ea6\u4f5c\u4e1a\u8fdb\u884c\u4fee\u6539\u3002", (String)"JobListPlugin_14", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                } else if (listSelectedData.size() == 1 && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)Sch_JOB, (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue = (listSelectedRow = listSelectedData.get(0)).getPrimaryKeyValue())})) != null && (status = dynamicObject.getBoolean("status"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f5c\u4e1a\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u7981\u7528\u540e\u518d\u4fee\u6539\u3002", (String)"JobListPlugin_15", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            String operaKey = ((AbstractOperate)args.getSource()).getOperateKey();
            switch (operaKey.toLowerCase(Locale.ENGLISH)) {
                case "disable": {
                    this.setStatus(false, args.getOperationResult());
                    break;
                }
                case "enable": {
                    this.setStatus(true, args.getOperationResult());
                    break;
                }
                case "enabletasktrace": {
                    this.setTaskTraceStatus("1", args.getOperationResult());
                    break;
                }
                case "disabletasktrace": {
                    this.setTaskTraceStatus("0", args.getOperationResult());
                    break;
                }
                case "disablealltasktrace": {
                    this.disableAllTaskTrace();
                    break;
                }
            }
        }
    }

    private void disableAllTaskTrace() {
        ScheduleService scheduleService = ScheduleService.getInstance();
        if (scheduleService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u672a\u542f\u52a8\uff0c\u8be5\u670d\u52a1\u5668\u8282\u70b9bos.lifecycle.servicelist\u672a\u6ce8\u518cScheduleService\uff0c\u6216lifecyclemanager\u542f\u52a8\u5931\u8d25\u3002", (String)"JobListPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        String sql = "SELECT FID FROM T_SCH_JOB WHERE FTASKTRACE = ?";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FTASKTRACE", 1, (Object)"1")};
        try (DataSet ds = DB.queryDataSet((String)"getEnableTaskTraceJobId", (DBRoute)Sch_Route, (String)sql, (Object[])sqlParameters);){
            ArrayList<String> jobIds = new ArrayList<String>(8);
            while (ds.hasNext()) {
                Row row = ds.next();
                jobIds.add(row.getString("FID"));
                if (jobIds.size() != 100) continue;
                this.updateTaskTraceStatus("0", jobIds, scheduleManager, scheduleService);
            }
            if (!CollectionUtils.isEmpty(jobIds)) {
                this.updateTaskTraceStatus("0", jobIds, scheduleManager, scheduleService);
            }
        }
        this.getView().updateView("billlistap");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
    }

    private void setTaskTraceStatus(String status, OperationResult operationResult) {
        if (operationResult != null && !CollectionUtils.isEmpty((Collection)operationResult.getSuccessPkIds())) {
            ScheduleService scheduleService = ScheduleService.getInstance();
            if (scheduleService == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u672a\u542f\u52a8\uff0c\u8be5\u670d\u52a1\u5668\u8282\u70b9bos.lifecycle.servicelist\u672a\u6ce8\u518cScheduleService\uff0c\u6216lifecyclemanager\u542f\u52a8\u5931\u8d25\u3002", (String)"JobListPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            List successPkIds = operationResult.getSuccessPkIds();
            ArrayList<String> jobIds = new ArrayList<String>(8);
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            for (Object successPkId : successPkIds) {
                String jobId = String.valueOf(successPkId);
                jobIds.add(jobId);
                if (jobIds.size() != 100) continue;
                this.updateTaskTraceStatus(status, jobIds, scheduleManager, scheduleService);
            }
            if (!jobIds.isEmpty()) {
                this.updateTaskTraceStatus(status, jobIds, scheduleManager, scheduleService);
            }
        }
        this.getView().updateView("billlistap");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
    }

    private void updateTaskTraceStatus(String status, List<String> jobIds, ScheduleManager scheduleManager, ScheduleService scheduleService) {
        ArrayList<String> successJobIds = new ArrayList<String>();
        JobDao jobDao = scheduleService.getObjectFactory().getJobDao();
        if ("1".equals(status)) {
            for (String jobId : jobIds) {
                boolean success = jobDao.enableTaskTrace(jobId);
                if (!success) continue;
                successJobIds.add(jobId);
            }
        } else if ("0".equals(status)) {
            for (String jobId : jobIds) {
                boolean success = jobDao.disableTaskTrace(jobId);
                if (!success) continue;
                successJobIds.add(jobId);
            }
        }
        if (!successJobIds.isEmpty()) {
            scheduleManager.batchUpdateJob(successJobIds);
        }
        jobIds.clear();
    }

    private void setStatus(boolean isEnable, OperationResult operationResult) {
        if (operationResult != null && !CollectionUtils.isEmpty((Collection)operationResult.getSuccessPkIds())) {
            List successPkIds = operationResult.getSuccessPkIds();
            try {
                for (Object successPkId : successPkIds) {
                    ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                    String jobId = (String)successPkId;
                    if (isEnable) {
                        scheduleManager.enableJob(jobId);
                        continue;
                    }
                    scheduleManager.disableJob(jobId);
                }
            }
            catch (KDException e) {
                if ("SCHEDULE_PRC_MASTER_LOST".equals(e.getErrorCode().getCode())) {
                    log.warn((Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4e3b\u8282\u70b9\u672a\u51c6\u5907\u597d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScheduleListPlugin_21", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                }
                throw e;
            }
        }
        this.getView().updateView("billlistap");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
    }

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(e.getNodeId().toString(), 3);
        e.setChildNodes(currentNode.getChildren());
    }

    private TreeNode loadAllAppNodes() {
        TreeNode root = new TreeNode();
        JSONObject map = new JSONObject();
        map.put("type", (Object)"root");
        root.setId("-1");
        root.setData((Object)map);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"JobListPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        if (!cloudNodes.isEmpty()) {
            root.setChildren(cloudNodes);
        }
        return root;
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl("treeView");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (focusNode == null) {
            return;
        }
        this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
        ((ListView)this.getView()).setNeedRefreshTree(false);
        this.setTreeBarVisible(false);
    }

    private void setTreeBarVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnnew"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnedit"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btndel"});
    }

    public void initializeTree(EventObject e) {
        this.initTree();
        this.getTreeListView().getTreeModel().setRoot(this.loadAllAppNodes());
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.setTreeBarVisible(false);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        if (nodeId.equalsIgnoreCase("-1")) {
            return;
        }
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 2);
        Map nodeData = (Map)current.getData();
        String nodeType = (String)nodeData.get("type");
        QFilter qFilter = null;
        if (nodeType.equals("cloud")) {
            if (current.getChildren() != null && !current.getChildren().isEmpty()) {
                ArrayList apps = new ArrayList();
                for (TreeNode node : current.getChildren()) {
                    Map data = (Map)node.getData();
                    List appNumbers = (List)data.get(NUMBER_LIST);
                    apps.addAll(appNumbers);
                }
                qFilter = new QFilter(TASKCLASSNAME_APPID, "in", apps);
            } else {
                qFilter = new QFilter(TASKCLASSNAME_APPID, "in", (Object)"noappid");
            }
        } else if (nodeType.equals("app")) {
            ArrayList apps = new ArrayList();
            Map data = (Map)current.getData();
            List appNumbers = (List)data.get(NUMBER_LIST);
            apps.addAll(appNumbers);
            qFilter = new QFilter(TASKCLASSNAME_APPID, "in", apps);
        }
        e.addQFilter(qFilter);
        e.setCancel(true);
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String cloudId = appInfo.getCloudId();
                String appId = appInfo.getId();
                TreeNode cloudNode = root.getTreeNode(cloudId, 5);
                TreeNode appNode = root.getTreeNode(appId, 5);
                if (cloudNode == null || appNode != null) continue;
                ArrayList<TreeNode> appTreeNodes = cloudNode.getChildren();
                if (appTreeNodes == null) {
                    appTreeNodes = new ArrayList<TreeNode>(10);
                    cloudNode.setChildren(appTreeNodes);
                }
                appTreeNodes.add(new TreeNode(cloudId, appId, appInfo.getName().toString()));
            }
        }
        Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
        log.info("Cloud is diabled : {}, Appid is diabled : {}, needAdminAppRange : {}, rangeApp size : {}", new Object[]{disabledCloudIds, disabledAppIds, adminAppResult.needAdminAppRange(), adminAppResult.getAppIds() == null ? "null" : Integer.valueOf(adminAppResult.getAppIds().size())});
        if (log.isDebugEnabled()) {
            log.debug("rangeAppIds:{}", (Object)(adminAppResult.getAppIds() == null ? "null" : String.join((CharSequence)",", adminAppResult.getAppIds())));
        }
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>();
        HashMap<String, List<String>> appNumIndex = new HashMap<String, List<String>>();
        this.getOriginExtendAppRelMap(originExtendAppRelMap, appNumIndex);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            HashMap<String, String> cloudData = new HashMap<String, String>();
            cloudData.put("type", "cloud");
            String cloudId = cloud.getId();
            String cloudNodeId = "cloud_" + cloudId;
            cloud.setId(cloudNodeId);
            cloud.setData(cloudData);
            List apps = cloud.getChildren();
            if (apps == null || disabledCloudIds.contains(cloudId)) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                boolean adminNotCharge;
                TreeNode app = (TreeNode)appIterator.next();
                HashMap<String, String> appData = new HashMap<String, String>();
                appData.put("type", "app");
                String appId = app.getId();
                String appNodeId = "app_" + appId;
                boolean bl = adminNotCharge = adminAppResult.needAdminAppRange() && (adminAppResult.getAppIds() == null || !adminAppResult.getAppIds().contains(appId));
                if (disabledAppIds.contains(appId) || adminNotCharge) {
                    appIterator.remove();
                    continue;
                }
                String masterId = (String)originExtendAppRelMap.get(appNodeId);
                appData.put(NUMBER_LIST, (String)appNumIndex.get(masterId));
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData(appData);
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private Map<String, String> getOriginExtendAppRelMap(Map<String, String> originExtendAppRelMap, Map<String, List<String>> appNumIndex) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allApps) {
            String type = app.getString("type");
            String number = app.getString("number");
            String appId = app.getString("id");
            String nodeId = "app_" + appId;
            if ("0".equals(type)) {
                originExtendAppRelMap.put(nodeId, nodeId);
                this.addToList(appNumIndex, nodeId, number);
                continue;
            }
            String masterId = app.getString("masterid");
            String masterNodeId = "app_" + masterId;
            originExtendAppRelMap.put(nodeId, masterNodeId);
            this.addToList(appNumIndex, masterNodeId, number);
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String nodeId = "app_" + appInfo.getId();
                originExtendAppRelMap.put(nodeId, nodeId);
                this.addToList(appNumIndex, nodeId, appInfo.getNumber());
            }
        }
        return originExtendAppRelMap;
    }

    private void addToList(Map<String, List<String>> appNumIndex, String key, String value) {
        if (appNumIndex.get(key) != null) {
            appNumIndex.get(key).add(value);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            appNumIndex.put(key, list);
        }
    }

    private List<AppInfo> getGrayAppInfos() {
        if (this.grayAppInfoList != null) {
            return this.grayAppInfoList;
        }
        this.grayAppInfoList = new ArrayList<AppInfo>(10);
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        if (AppGroup.isGrayUpgrade()) {
            List appInfoStrList = metadataService.loadGrayAppInfoList();
            for (String infoStr : appInfoStrList) {
                if (StringUtils.isBlank((CharSequence)infoStr)) continue;
                AppInfo appInfo = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
                this.grayAppInfoList.add(appInfo);
            }
        }
        return this.grayAppInfoList;
    }

    public void setFilter(SetFilterEvent e) {
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
        if (adminAppResult.needAdminAppRange()) {
            List adminAppIds = adminAppResult.getAppIds();
            if (!CollectionUtils.isEmpty((Collection)adminAppIds)) {
                Set<String> adminAppNums = this.convertAppIdToAppNum(adminAppIds);
                this.appendSysApp(adminAppNums);
                QFilter adminFilter = new QFilter(TASKCLASSNAME_APPID, "in", adminAppNums);
                e.addCustomQFilter(adminFilter);
            } else {
                QFilter adminFilter = new QFilter(TASKCLASSNAME_APPID, "in", Collections.emptyList());
                e.addCustomQFilter(adminFilter);
            }
        } else {
            Set appids = ManageServiceHelper.getDisabledAppIds();
            HashSet<String> set = new HashSet<String>(appids.size());
            for (String appid : appids) {
                String appNum = BizAppServiceHelp.getAppNumByAppId((String)appid);
                set.add(appNum);
            }
            QFilter filter = new QFilter(TASKCLASSNAME_APPID, "not in", set);
            e.addCustomQFilter(filter);
        }
    }

    private Set<String> convertAppIdToAppNum(List<String> appIds) {
        appIds.remove("");
        if (appIds.isEmpty()) {
            return Collections.emptySet();
        }
        String sql = String.format("SELECT FNUMBER FROM T_META_BIZAPP WHERE FID IN ('%s')", String.join((CharSequence)"','", appIds));
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            HashSet<String> appNums = new HashSet<String>(appIds.size());
            while (rs.next()) {
                appNums.add(rs.getString("FNUMBER"));
            }
            return appNums;
        });
    }

    private void appendSysApp(Set<String> adminAppNums) {
        List sysAppNums = PermissionServiceHelper.queryAllSysApp((boolean)true, (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)sysAppNums)) {
            for (String sysAppNum : sysAppNums) {
                if (!adminAppNums.contains(sysAppNum)) continue;
                adminAppNums.add(DEFAULT_APPID);
                break;
            }
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        List comboItems;
        if (args != null && "jobtype".equals(args.getListFieldKey()) && (comboItems = args.getComboItems()) != null) {
            comboItems.removeIf(valueItem -> JobType.DETECT.name().equals(valueItem.getValue()));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent billListHyperLinkClickEvent;
        ListSelectedRow currentRow;
        if (args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent && (currentRow = (billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow()) != null) {
            args.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(Sch_JOB);
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setPkId(currentRow.getPrimaryKeyValue());
            String pageId = this.getView().getPageCache().get(String.valueOf(currentRow.getPrimaryKeyValue()));
            if (StringUtils.isNotBlank((CharSequence)pageId)) {
                billShowParameter.setPageId(pageId);
            }
            this.getView().showForm((FormShowParameter)billShowParameter);
            if (StringUtils.isBlank((CharSequence)pageId)) {
                this.getView().getPageCache().put(String.valueOf(currentRow.getPrimaryKeyValue()), billShowParameter.getPageId());
            }
        }
    }
}

