/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.schedule.server.next.ServerObservableUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.smc.ManageServiceHelper;

public class ScheduleDetecTaskPlugin
extends AbstractFormPlugin {
    private static final String EXECUTOR_SERVER_INFO_CACHE = "executorServerInfoCache";
    private static final String PROGRESSBAR_KEY = "progressbarap";
    private static final String DETECT_STEP = "detectStep";
    private static final String EXECUTOR_DETECT = "executorDetect";
    private static final String MIDDLE_DETECT_MQ = "middleDetect_mq";
    private static final String MIDDLE_DETECT_REDIS = "middleDetect_redis";
    private static final String MIDDLE_DETECT_ZK = "middleDetect_zk";
    private static final String EXECUTOR_INDEX = "executorIndex";
    private static final String TAB_ACTIVE_MIDDLE = "tabActiveMiddle";
    private static final String TAB_ACTIVE_JOB_INFO = "tabActiveJobInfo";
    private static final String TAB_ACTIVE_TASK_DETECT = "tabActiveDetectTask";
    private static final String JOB_INFO_DETECT = "jobInfoDetect";
    private static final String DETECT_FIRST_JOB = "detectFirstJob";
    private static final String DETECT_OTHER_JOB = "detectOtherJob";
    private static final String JOB_INFO_DETECT_JOB_INDEX = "jobInfoDetectJobIndex";
    private static final String JOB_INFO_DETECT_RESCHEDULE = "rescheduleDetect";
    private static final String JOB_INFO_DETECT_JOBNUMBER = "jobNumberDetect";
    private static final String JOB_INFO_DETECT_JOB_STATUS = "jobStatusDetect";
    private static final String JOB_INFO_DETECT_APP_STATUS = "appDetect";
    private static final String JOB_INFO_DETECT_RUN_ORDER = "runOrderDetect";
    private static final String JOB_INFO_DETECT_ORG = "orgDetect";
    private static final String JOB_INFO_DETECT_RUN_USER = "runUserDetect";
    private static final String JOB_INFO_DETECT_ENV_LANG = "envLangDetect";
    private static final String SEND_DETECT_TASK = "sendDetectTask";
    private static final String COLOR_GREEN = "#26b175";
    private static final String COLOR_RED = "#fb2323";
    private static final String COLOR_YELLOW = "#FFA940";
    private static final String COLOR_GRAY = "#999999";
    private static final String GENERAL_FLEX_HEIGHT = "25px";
    private static final String GENERAL_ICON_FLEX_WIDTH = "30px";
    private static final String GENERAL_JOB_NUMBER_LEFT_MARGIN = "10px";
    private static final String GENERAL_JOB_NUMBER_WIDTH = "270px";
    private static final String GENERAL_CHECK_ITEM_FLEX_LEFT_MARGIN = "140px";
    private static final String GENERAL_JOB_CHECK_ITEM_RESULT_LABWITH = "130px";
    private static final String GENERAL_TASK_CHECK_ITEM_RESULT_LABWITH = "170px";
    private static final String FLEX_DIRECTION_ROW = "row";
    private static final String APPID = "appId";
    private static final String TASKID = "taskId";
    private static final String DETECT_TASKS = "detectTasks";
    private static final String JOB_NUMBER_FLEX = "jobnumberflex";
    private static final String JOB_CHECK_FLEX = "jobcheckflex";
    private static final String ICON_FLEX = "iconflex";
    private static final String REFRESH_FONT = "kdfont kdfont-shuaxin2";
    private static final String JOB_LAB = "joblab";
    private static final String JOB_STATUS_FLEX = "jobstatusflex";
    private static final String JOB_STATUS_LAB = "jobstatuslab";
    private static final String APP_STATUS_FLEX = "appstatusflex";
    private static final String APP_STATUS_LAB = "appstatuslab";
    private static final String RESCHEDULE_FLEX = "rescheduleflex";
    private static final String RESCHEDULE_LAB = "reschedulelab";
    private static final String RUN_ORDER_FLEX = "runorderflex";
    private static final String RUN_ORDER_LAB = "runorderlab";
    private static final String RUN_LANG_FLEX = "runlangflex";
    private static final String RUN_LANG_LAB = "runlanglab";
    private static final String RUN_ORG_FLEX = "runorgflex";
    private static final String RUN_ORG_LAB = "runorglab";
    private static final String RUN_USER_FLEX = "runuserflex";
    private static final String RUN_USER_LAB = "runuserlab";
    private static final String TASK_DETECT_STEP = "taskDetectStep";
    private static final String TASK_DETECT_FIRST_RESULT = "taskDetectFirstResult";
    private static final String TASK_DETECT_OTHER_RESULT = "taskDetectOtherResult";
    private static final String TASK_DETECT_RESULT_INDEX = "taskDetectResultIndex";
    private static final String TASK_DETECT_JOB_NUMBER = "taskdetectjobnumber";
    private static final String TASK_STEP_JOB_NUMBER = "taskJobNumber";
    private static final String TASK_STEP_DISABLE_JOB = "taskDisableJob";
    private static final String NORMAL_APP = "normalApp";
    private static final String UNBIND_APP = "taskUnBindApp";
    private static final String DISABLE_APP = "taskDisableApp";
    private static final String UNDEPLOY_APP = "taskUnDeployApp";
    private static final String TASK_STEP_GEN_TIME = "taskGenTime";
    private static final String TASK_STEP_ALLOW_FIRE = "taskAllowFire";
    private static final String TASK_STEP_DISPATCH_JOB = "taskDispatchJob";
    private static final String TASK_STEP_RECEIVE_TASK_EXE = "receiveTaskExe";
    private static final String TASK_STEP_RECEIVE_TASK_EXE_IP = "receiveTaskExeIp";
    private static final String TASK_STEP_RECEIVE_TASK = "taskReceiveTask";
    private static final String TASK_STEP_EXECUTE_TASK = "taskExecuteTask";
    private static final String TASK_STEP_COMPLETE_TASK = "taskCompleteTask";
    private static final String TASK_REFRESH_ICON = "taskrefreshicon";
    private static final String TASK_APP_ERROR_RESULT_LAB = "apperrorlab";
    private static final String TASK_GEN_TIME_RESULT_LAB = "gentime";
    private static final String TASK_ALLOW_FIRE_TIME_RESULT_LAB = "allowfiretime";
    private static final String TASK_DISPATCH_JOB_TIME_RESULT_LAB = "dispatchjobtime";
    private static final String TASK_RECEIVE_TASK_EXE_RESULT_LAB = "instanceid";
    private static final String TASK_RECEIVE_TASK_EXE_IP_RESULT_LAB = "instanceip";
    private static final String TASK_RECEIVE_TIME_RESULT_LAB = "receivetime";
    private static final String TASK_EXECUTE_TASK_TIME_RESULT_LAB = "executetasktime";
    private static final String TASK_COMPLETE_TASK_TIME_RESULT_LAB = "completetasktime";
    private static final String TASK_APP_ERROR_FLEX = "apperrorflex";
    private static final String TASK_DISABLE_JOB_FLEX = "disablejobflex";
    private static final String TASK_GEN_TIME_FLEX = "gentimeflex";
    private static final String TASK_GEN_TIME_LAB = "gentimelab";
    private static final String TASK_ALLOW_FIRE_FLEX = "allowfireflex";
    private static final String TASK_ALLOW_FIRE_LAB = "allowfirelab";
    private static final String TASK_DISPATCH_JOB_FLEX = "dispatchjobflex";
    private static final String TASK_DISPATCH_JOB_LAB = "dispatchjoblab";
    private static final String TASK_RECEIVE_TASK_EXE_FLEX = "receivetaskexeflex";
    private static final String TASK_RECEIVE_TASK_EXE_LAB = "receivetaskexelab";
    private static final String TASK_RECEIVE_TASK_EXE_IP_FLEX = "receivetaskexeipflex";
    private static final String TASK_RECEIVE_TASK_EXE_IP_LAB = "receivetaskexeiplab";
    private static final String TASK_RECEIVE_TASK_FLEX = "receivetaskflex";
    private static final String TASK_RECEIVE_TASK_LAB = "receivetasklab";
    private static final String TASK_EXECUTE_TASK_FLEX = "executetaskflex";
    private static final String TASK_EXECUTE_TASK_LAB = "executetasklab";
    private static final String TASK_COMPLETE_TASK_FLEX = "completetaskflex";
    private static final String TASK_COMPLETE_TASK_LAB = "completetasklab";
    private static final String TASK_JOB_NUMBER_FLEX = "taskjobnumberflex";
    private static final String TASK_REFRESH_ICON_FLEX = "taskrefreshiconflex";
    private static final String TASK_JOB_LAB = "taskjoblab";
    private static final String TASK_DETECT_FLEX = "taskdetectflex";
    private static final String TAB_KEY_MIDDLE = "middledetect";
    private static final String TAB_KEY_JOB_INFO = "jobinfodetect";
    private static final String TAB_KEY_TASK = "taskdetect";
    private static final String EXE_MACHINE_FLEX = "exemachineflex";
    private static final String EXE_IP_LAB = "exeiplab";
    private static final String EXE_STATUS_LAB = "exestatuslab";
    private static final String EXE_STATUS_FLEX = "exestatusflex";
    private static final String MASTER_REFRESH_ICON = "masterrefreshicon";
    private static final String EXE_REFRESH_ICON = "exerefreshicon";
    private static final String MQ_REFRESH_ICON = "mqrefreshicon";
    private static final String REDIS_REFRESH_ICON = "redisrefreshicon";
    private static final String ZK_REFRESH_ICON = "zkrefreshicon";
    private static final String JOB_REFRESH_ICON = "jobrefreshicon";
    private static final String MA_STATUS = "mqstatus";
    private static final String REDIS_STATUS = "redisstatus";
    private static final String ZK_STATUS = "zkstatus";
    private static final String JOB_NUMBER = "jobnumber";
    private static final String JOB_STATUS = "jobstatus";
    private static final String APP_STATUS = "appstatus";
    private static final String APP_STATUS_NUM = "appstatusnum";
    private static final String APP_STATUS_DESC = "appstatusdesc";
    private static final String APP_STATUS_COLOR = "appstatuscolor";
    private static final String RUN_ORDER = "runorder";
    private static final String RUN_LANG = "runlang";
    private static final String RUN_ORG = "runorg";
    private static final String RUN_USER = "runuser";
    private static final String RESCHEDULE_STATUS = "reschedule";
    private static final String CUSTOM_DETECT_SCHEDULE_INFO = "detectScheduleInfos";
    private static final String DETECT_SUCCESS = "detectSuccess";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static final String ENABLE_JOB = "1";
    private static final String FLEX_ALIGN_ITEMS = "center";
    private static final Log logger = LogFactory.getLog(ScheduleDetecTaskPlugin.class);

    public void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR_KEY);
        progressBar.addProgressListener(new ProgresssListener(){

            public void onProgress(ProgressEvent arg0) {
                ScheduleDetecTaskPlugin.this.detectTask();
            }
        });
    }

    private void detectTask() {
        IPageCache pageCache = this.getView().getPageCache();
        String detectStep = pageCache.get(DETECT_STEP);
        if (StringUtils.isNotBlank((CharSequence)detectStep)) {
            try {
                switch (detectStep) {
                    case "executorDetect": {
                        this.getView().setVisible(Boolean.TRUE, new String[]{EXE_MACHINE_FLEX});
                        this.getView().setVisible(Boolean.FALSE, new String[]{MASTER_REFRESH_ICON});
                        this.detectExecutor(pageCache);
                        break;
                    }
                    case "tabActiveMiddle": {
                        this.getView().setVisible(Boolean.FALSE, new String[]{EXE_REFRESH_ICON});
                        this.activeTab(TAB_KEY_MIDDLE, MIDDLE_DETECT_MQ, pageCache);
                        this.getView().setVisible(Boolean.TRUE, new String[]{MQ_REFRESH_ICON});
                        if (ZkConfig.isSupportZk()) break;
                        this.getView().setVisible(Boolean.FALSE, new String[]{"zkflex"});
                        break;
                    }
                    case "middleDetect_mq": {
                        this.detectMiddle("mq", MA_STATUS, MIDDLE_DETECT_REDIS, pageCache);
                        this.getView().setVisible(Boolean.TRUE, new String[]{REDIS_REFRESH_ICON});
                        this.getView().setVisible(Boolean.FALSE, new String[]{MQ_REFRESH_ICON});
                        break;
                    }
                    case "middleDetect_redis": {
                        if (ZkConfig.isSupportZk()) {
                            this.detectMiddle("redis", REDIS_STATUS, MIDDLE_DETECT_ZK, pageCache);
                            this.getView().setVisible(Boolean.TRUE, new String[]{ZK_REFRESH_ICON});
                        } else {
                            this.detectMiddle("redis", REDIS_STATUS, TAB_ACTIVE_JOB_INFO, pageCache);
                        }
                        this.getView().setVisible(Boolean.FALSE, new String[]{REDIS_REFRESH_ICON});
                        break;
                    }
                    case "middleDetect_zk": {
                        this.detectMiddle("zk", ZK_STATUS, TAB_ACTIVE_JOB_INFO, pageCache);
                        this.getView().setVisible(Boolean.FALSE, new String[]{ZK_REFRESH_ICON});
                        break;
                    }
                    case "tabActiveJobInfo": {
                        this.activeTab(TAB_KEY_JOB_INFO, DETECT_FIRST_JOB, pageCache);
                        pageCache.put(JOB_INFO_DETECT, JOB_INFO_DETECT_JOBNUMBER);
                        this.getView().setVisible(Boolean.TRUE, new String[]{JOB_NUMBER});
                        this.getView().setVisible(Boolean.TRUE, new String[]{JOB_REFRESH_ICON});
                        break;
                    }
                    case "detectFirstJob": {
                        this.detectFirstJob();
                        break;
                    }
                    case "detectOtherJob": {
                        this.detectOtherJob();
                        break;
                    }
                    case "tabActiveDetectTask": {
                        this.activeTab(TAB_KEY_TASK, SEND_DETECT_TASK, pageCache);
                        break;
                    }
                    case "sendDetectTask": {
                        this.sendDetectTask(pageCache);
                        break;
                    }
                    case "taskDetectFirstResult": {
                        this.taskDetectFirstResultFill();
                        break;
                    }
                    case "taskDetectOtherResult": {
                        this.taskDetectOtherResultFill();
                        break;
                    }
                    case "detectSuccess": {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u6210\u529f\u3002", (String)"ScheduleDetecTaskPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        this.stopProgressBar();
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Schedule***detectTask error", t);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6821\u9a8c\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScheduleDetecTaskPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                this.stopProgressBar();
            }
        }
    }

    private void startProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBAR_KEY);
        progressBar.start();
    }

    private void stopProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBAR_KEY);
        progressBar.stop();
    }

    private void taskDetectOtherResultFill() {
        String detectTasksStr = this.getView().getPageCache().get(DETECT_TASKS);
        List detectTasks = null;
        if (StringUtils.isNotBlank((CharSequence)detectTasksStr)) {
            detectTasks = SerializationUtils.fromJsonStringToList((String)detectTasksStr, Map.class);
        }
        if (detectTasks == null || detectTasks.isEmpty()) {
            logger.info("detectTask have no detectTask");
            this.stopProgressBar();
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        int taskIndex = Integer.parseInt(pageCache.get(TASK_DETECT_RESULT_INDEX));
        if (detectTasks.size() > taskIndex) {
            Map detectTask = (Map)detectTasks.get(taskIndex);
            String taskId = (String)detectTask.get(TASKID);
            String jobStatus = (String)detectTask.get(JOB_STATUS);
            String appStatusNum = (String)detectTask.get(APP_STATUS_NUM);
            String taskDetectStep = pageCache.get(TASK_DETECT_STEP);
            String taskItemLabName = "";
            switch (taskDetectStep) {
                case "taskJobNumber": {
                    if (UNBIND_APP.equals(appStatusNum)) {
                        this.createTaskDetectJobNumberFlex(taskIndex, (String)detectTask.get(JOB_NUMBER), TASK_STEP_JOB_NUMBER);
                        this.createTaskDetectErrorFlex(TASK_APP_ERROR_FLEX + taskIndex, TASK_APP_ERROR_RESULT_LAB + taskIndex, ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u672a\u914d\u7f6e\u6240\u5c5e\u5e94\u7528\uff0c\u4efb\u52a1\u68c0\u6d4b\u7ec8\u6b62\u3002", (String)"ScheduleDetecTaskPlugin_31", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        this.nextTaskResultFillStep(detectTasks, taskIndex);
                        break;
                    }
                    if (UNDEPLOY_APP.equals(appStatusNum)) {
                        this.createTaskDetectJobNumberFlex(taskIndex, (String)detectTask.get(JOB_NUMBER), TASK_STEP_JOB_NUMBER);
                        this.createTaskDetectErrorFlex(TASK_APP_ERROR_FLEX + taskIndex, TASK_APP_ERROR_RESULT_LAB + taskIndex, ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u6240\u5c5e\u5e94\u7528\u672a\u90e8\u7f72\uff0c\u4efb\u52a1\u68c0\u6d4b\u7ec8\u6b62\u3002", (String)"ScheduleDetecTaskPlugin_32", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        this.nextTaskResultFillStep(detectTasks, taskIndex);
                        break;
                    }
                    if (DISABLE_APP.equals(appStatusNum)) {
                        this.createTaskDetectJobNumberFlex(taskIndex, (String)detectTask.get(JOB_NUMBER), TASK_STEP_JOB_NUMBER);
                        this.createTaskDetectErrorFlex(TASK_APP_ERROR_FLEX + taskIndex, TASK_APP_ERROR_RESULT_LAB + taskIndex, ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u6240\u5c5e\u5e94\u7528\u5df2\u7981\u7528\uff0c\u4efb\u52a1\u68c0\u6d4b\u7ec8\u6b62\u3002", (String)"ScheduleDetecTaskPlugin_34", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        this.nextTaskResultFillStep(detectTasks, taskIndex);
                        break;
                    }
                    if (!StringUtils.equals((CharSequence)ENABLE_JOB, (CharSequence)jobStatus)) {
                        this.createTaskDetectJobNumberFlex(taskIndex, (String)detectTask.get(JOB_NUMBER), TASK_STEP_JOB_NUMBER);
                        this.createTaskDetectErrorFlex(TASK_DISABLE_JOB_FLEX + taskIndex, TASK_DISPATCH_JOB_LAB + taskIndex, ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u5ea6\u4f5c\u4e1a\u5df2\u7981\u7528\uff0c\u4efb\u52a1\u68c0\u6d4b\u7ec8\u6b62\u3002", (String)"ScheduleDetecTaskPlugin_33", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        this.nextTaskResultFillStep(detectTasks, taskIndex);
                        break;
                    }
                    this.createTaskDetectJobNumberFlex(taskIndex, (String)detectTask.get(JOB_NUMBER), TASK_STEP_ALLOW_FIRE);
                    break;
                }
                case "taskAllowFire": {
                    String allowFireTime = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"allowFire");
                    taskItemLabName = ResManager.loadKDString((String)"\u5141\u8bb8\u89e6\u53d1\u8c03\u5ea6\u4efb\u52a1", (String)"ScheduleDetecTaskPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_ALLOW_FIRE_FLEX, TASK_ALLOW_FIRE_LAB, taskItemLabName, TASK_ALLOW_FIRE_TIME_RESULT_LAB, allowFireTime, TASK_STEP_GEN_TIME);
                    break;
                }
                case "taskGenTime": {
                    String genTime = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"generateTime");
                    taskItemLabName = ResManager.loadKDString((String)"\u751f\u6210\u8c03\u5ea6\u65f6\u95f4\u70b9", (String)"ScheduleDetecTaskPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_GEN_TIME_FLEX, TASK_GEN_TIME_LAB, taskItemLabName, TASK_GEN_TIME_RESULT_LAB, genTime, TASK_STEP_DISPATCH_JOB);
                    break;
                }
                case "taskDispatchJob": {
                    String dispatchTime = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"dispatchJobSuccess");
                    taskItemLabName = ResManager.loadKDString((String)"\u4e3b\u8282\u70b9\u5206\u914d\u4efb\u52a1", (String)"ScheduleDetecTaskPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_DISPATCH_JOB_FLEX, TASK_DISPATCH_JOB_LAB, taskItemLabName, TASK_DISPATCH_JOB_TIME_RESULT_LAB, dispatchTime, TASK_STEP_RECEIVE_TASK_EXE);
                    break;
                }
                case "receiveTaskExe": {
                    String receiveTaskExe = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"instanceId");
                    taskItemLabName = ResManager.loadKDString((String)"\u6267\u884c\u673a\u5b9e\u4f8b", (String)"ScheduleDetecTaskPlugin_29", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_RECEIVE_TASK_EXE_FLEX, TASK_RECEIVE_TASK_EXE_LAB, taskItemLabName, TASK_RECEIVE_TASK_EXE_RESULT_LAB, receiveTaskExe, TASK_STEP_RECEIVE_TASK_EXE_IP);
                    break;
                }
                case "receiveTaskExeIp": {
                    String receiveTaskExeIp = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"instanceIp");
                    taskItemLabName = ResManager.loadKDString((String)"\u6267\u884c\u673aip", (String)"ScheduleDetecTaskPlugin_30", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_RECEIVE_TASK_EXE_IP_FLEX, TASK_RECEIVE_TASK_EXE_IP_LAB, taskItemLabName, TASK_RECEIVE_TASK_EXE_IP_RESULT_LAB, receiveTaskExeIp, TASK_STEP_RECEIVE_TASK);
                    break;
                }
                case "taskReceiveTask": {
                    String receiveTime = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"receiveTaskSuccess");
                    taskItemLabName = ResManager.loadKDString((String)"\u6267\u884c\u673a\u63a5\u53d7\u4efb\u52a1", (String)"ScheduleDetecTaskPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_RECEIVE_TASK_FLEX, TASK_RECEIVE_TASK_LAB, taskItemLabName, TASK_RECEIVE_TIME_RESULT_LAB, receiveTime, TASK_STEP_EXECUTE_TASK);
                    break;
                }
                case "taskExecuteTask": {
                    String executeTime = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"executeTask");
                    taskItemLabName = ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1", (String)"ScheduleDetecTaskPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_EXECUTE_TASK_FLEX, TASK_EXECUTE_TASK_LAB, taskItemLabName, TASK_EXECUTE_TASK_TIME_RESULT_LAB, executeTime, TASK_STEP_COMPLETE_TASK);
                    break;
                }
                case "taskCompleteTask": {
                    String completeTime = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)"completeTask");
                    taskItemLabName = ResManager.loadKDString((String)"\u5b8c\u6210\u8c03\u5ea6\u4efb\u52a1", (String)"ScheduleDetecTaskPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createTaskItemCheckFlex(taskIndex, TASK_COMPLETE_TASK_FLEX, TASK_COMPLETE_TASK_LAB, taskItemLabName, TASK_COMPLETE_TASK_TIME_RESULT_LAB, completeTime, "");
                    this.getView().setVisible(Boolean.FALSE, new String[]{TASK_REFRESH_ICON + taskIndex});
                    if (detectTasks.size() - 1 > taskIndex) {
                        pageCache.put(DETECT_STEP, TASK_DETECT_OTHER_RESULT);
                        pageCache.put(TASK_DETECT_STEP, TASK_STEP_JOB_NUMBER);
                        pageCache.put(TASK_DETECT_RESULT_INDEX, String.valueOf(taskIndex + 1));
                        break;
                    }
                    pageCache.put(DETECT_STEP, DETECT_SUCCESS);
                }
            }
        } else {
            this.stopProgressBar();
        }
    }

    private void taskDetectFirstResultFill() {
        String taskDetectStep;
        String detectTaskStr = this.getView().getPageCache().get(DETECT_TASKS);
        List detectTasks = null;
        if (StringUtils.isNotBlank((CharSequence)detectTaskStr)) {
            detectTasks = SerializationUtils.fromJsonStringToList((String)detectTaskStr, Map.class);
        }
        if (detectTasks == null || detectTasks.isEmpty()) {
            logger.info("detectTask have no detectTask");
            this.stopProgressBar();
            return;
        }
        Map firstDetectTask = (Map)detectTasks.get(0);
        String taskId = (String)firstDetectTask.get(TASKID);
        String jobStatus = (String)firstDetectTask.get(JOB_STATUS);
        String appStatusNum = (String)firstDetectTask.get(APP_STATUS_NUM);
        IPageCache pageCache = this.getView().getPageCache();
        switch (taskDetectStep = pageCache.get(TASK_DETECT_STEP)) {
            case "taskJobNumber": {
                Label taskDetectJobNumber = (Label)this.getView().getControl(TASK_DETECT_JOB_NUMBER);
                taskDetectJobNumber.setText((String)firstDetectTask.get(JOB_NUMBER));
                if (UNBIND_APP.equals(appStatusNum)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TASK_APP_ERROR_FLEX});
                    this.setLabelTextAndColor(TASK_APP_ERROR_RESULT_LAB, ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u672a\u914d\u7f6e\u6240\u5c5e\u5e94\u7528\uff0c\u4efb\u52a1\u68c0\u6d4b\u7ec8\u6b62\u3002", (String)"ScheduleDetecTaskPlugin_31", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), COLOR_RED);
                    this.secondTaskResultFillStep(detectTasks);
                    break;
                }
                if (UNDEPLOY_APP.equals(appStatusNum)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TASK_APP_ERROR_FLEX});
                    this.setLabelTextAndColor(TASK_APP_ERROR_RESULT_LAB, ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u6240\u5c5e\u5e94\u7528\u672a\u90e8\u7f72\uff0c\u4efb\u52a1\u68c0\u6d4b\u7ec8\u6b62\u3002", (String)"ScheduleDetecTaskPlugin_32", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), COLOR_RED);
                    this.secondTaskResultFillStep(detectTasks);
                    break;
                }
                if (DISABLE_APP.equals(appStatusNum)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TASK_APP_ERROR_FLEX});
                    this.setLabelTextAndColor(TASK_APP_ERROR_RESULT_LAB, ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u6240\u5c5e\u5e94\u7528\u5df2\u7981\u7528\uff0c\u4efb\u52a1\u68c0\u6d4b\u7ec8\u6b62\u3002", (String)"ScheduleDetecTaskPlugin_34", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), COLOR_RED);
                    this.secondTaskResultFillStep(detectTasks);
                    break;
                }
                if (!StringUtils.equals((CharSequence)ENABLE_JOB, (CharSequence)jobStatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TASK_DISABLE_JOB_FLEX});
                    this.secondTaskResultFillStep(detectTasks);
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{TASK_ALLOW_FIRE_FLEX});
                pageCache.put(TASK_DETECT_STEP, TASK_STEP_ALLOW_FIRE);
                break;
            }
            case "taskAllowFire": {
                this.firstDetectStepResult(taskId, "allowFire", TASK_ALLOW_FIRE_TIME_RESULT_LAB, "", TASK_GEN_TIME_FLEX, TASK_STEP_GEN_TIME);
                break;
            }
            case "taskGenTime": {
                this.firstDetectStepResult(taskId, "generateTime", TASK_GEN_TIME_RESULT_LAB, "", TASK_DISPATCH_JOB_FLEX, TASK_STEP_DISPATCH_JOB);
                break;
            }
            case "taskDispatchJob": {
                this.firstDetectStepResult(taskId, "dispatchJobSuccess", TASK_DISPATCH_JOB_TIME_RESULT_LAB, "", TASK_RECEIVE_TASK_EXE_FLEX, TASK_STEP_RECEIVE_TASK_EXE);
                break;
            }
            case "receiveTaskExe": {
                this.firstDetectStepResult(taskId, "instanceId", TASK_RECEIVE_TASK_EXE_RESULT_LAB, "", TASK_RECEIVE_TASK_EXE_IP_FLEX, TASK_STEP_RECEIVE_TASK_EXE_IP);
            }
            case "receiveTaskExeIp": {
                this.firstDetectStepResult(taskId, "instanceIp", TASK_RECEIVE_TASK_EXE_IP_RESULT_LAB, "", TASK_RECEIVE_TASK_FLEX, TASK_STEP_RECEIVE_TASK);
                break;
            }
            case "taskReceiveTask": {
                this.firstDetectStepResult(taskId, "receiveTaskSuccess", TASK_RECEIVE_TIME_RESULT_LAB, "", TASK_EXECUTE_TASK_FLEX, TASK_STEP_EXECUTE_TASK);
                break;
            }
            case "taskExecuteTask": {
                this.firstDetectStepResult(taskId, "executeTask", TASK_EXECUTE_TASK_TIME_RESULT_LAB, "", TASK_COMPLETE_TASK_FLEX, TASK_STEP_COMPLETE_TASK);
                break;
            }
            case "taskCompleteTask": {
                this.firstDetectStepResult(taskId, "completeTask", TASK_COMPLETE_TASK_TIME_RESULT_LAB, "", "", TASK_STEP_JOB_NUMBER);
                this.getView().setVisible(Boolean.FALSE, new String[]{TASK_REFRESH_ICON});
                if (detectTasks.size() > 1) {
                    pageCache.put(DETECT_STEP, TASK_DETECT_OTHER_RESULT);
                    pageCache.put(TASK_DETECT_STEP, TASK_STEP_JOB_NUMBER);
                    pageCache.put(TASK_DETECT_RESULT_INDEX, ENABLE_JOB);
                    break;
                }
                pageCache.put(DETECT_STEP, DETECT_SUCCESS);
            }
        }
    }

    private void secondTaskResultFillStep(List<Map<String, String>> detectTasks) {
        IPageCache pageCache = this.getView().getPageCache();
        this.getView().setVisible(Boolean.FALSE, new String[]{TASK_REFRESH_ICON});
        if (detectTasks.size() > 1) {
            pageCache.put(DETECT_STEP, TASK_DETECT_OTHER_RESULT);
            pageCache.put(TASK_DETECT_STEP, TASK_STEP_JOB_NUMBER);
            pageCache.put(TASK_DETECT_RESULT_INDEX, ENABLE_JOB);
        } else {
            pageCache.put(DETECT_STEP, DETECT_SUCCESS);
        }
    }

    private void nextTaskResultFillStep(List<Map<String, String>> detectTasks, int taskIndex) {
        IPageCache pageCache = this.getView().getPageCache();
        this.getView().setVisible(Boolean.FALSE, new String[]{TASK_REFRESH_ICON + taskIndex});
        if (detectTasks.size() - 1 > taskIndex) {
            pageCache.put(DETECT_STEP, TASK_DETECT_OTHER_RESULT);
            pageCache.put(TASK_DETECT_STEP, TASK_STEP_JOB_NUMBER);
            pageCache.put(TASK_DETECT_RESULT_INDEX, String.valueOf(taskIndex + 1));
        } else {
            pageCache.put(DETECT_STEP, DETECT_SUCCESS);
        }
    }

    private void firstDetectStepResult(String taskId, String setCacheKey, String taskDetectLabelKey, String taskDetectResultLabelColor, String nextTaskDetectFlex, String nextDetectStep) {
        String genTime = ClientObservableUtils.getDetectTaskData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)taskId, (String)setCacheKey);
        if (StringUtils.isNotBlank((CharSequence)genTime)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{taskDetectLabelKey});
            if (StringUtils.isNotBlank((CharSequence)nextTaskDetectFlex)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{nextTaskDetectFlex});
            }
            this.setLabelTextAndColor(taskDetectLabelKey, genTime, taskDetectResultLabelColor);
            this.getView().getPageCache().put(TASK_DETECT_STEP, nextDetectStep);
        }
    }

    private void sendDetectTask(IPageCache pageCache) {
        try {
            String detectScheduleInfosStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_DETECT_SCHEDULE_INFO);
            List detectScheduleInfos = SerializationUtils.fromJsonStringToList((String)detectScheduleInfosStr, Map.class);
            ArrayList detectTasks = new ArrayList(detectScheduleInfos.size());
            for (Map detectScheduleInfo : detectScheduleInfos) {
                String jobStatus = String.valueOf(detectScheduleInfo.get(JOB_STATUS));
                Object appNumObj = detectScheduleInfo.get(APPID);
                Map<String, String> appStatusMap = this.getAppStatus(appNumObj);
                String taskId = "";
                if (StringUtils.equals((CharSequence)jobStatus, (CharSequence)ENABLE_JOB) && StringUtils.equals((CharSequence)appStatusMap.get(APP_STATUS_NUM), (CharSequence)NORMAL_APP)) {
                    JobInfo jobInfo = new JobInfo();
                    jobInfo.setId(String.valueOf(detectScheduleInfo.get("jobId")));
                    jobInfo.setScheduleId(String.valueOf(detectScheduleInfo.get("scheduleId")));
                    jobInfo.setAppId(String.valueOf(detectScheduleInfo.get(APPID)));
                    taskId = String.valueOf(DB.genLongId((String)"T_SCH_TASK"));
                    jobInfo.setTaskId(taskId);
                    jobInfo.setJobType(JobType.DETECT);
                    jobInfo.setNumber(String.valueOf(detectScheduleInfo.get(JOB_NUMBER)));
                    MessageInfo messageInfo = MessageCreator.createJobMessage((JobInfo)jobInfo);
                    messageInfo.setTaskId(taskId);
                    ClientObservableUtils.sendDetectTask((MessageInfo)messageInfo);
                }
                HashMap<String, String> detectTask = new HashMap<String, String>();
                detectTask.put(TASKID, taskId);
                detectTask.put(JOB_NUMBER, String.valueOf(detectScheduleInfo.get(JOB_NUMBER)));
                detectTask.put(JOB_STATUS, String.valueOf(detectScheduleInfo.get(JOB_STATUS)));
                detectTask.put(APP_STATUS_NUM, appStatusMap.get(APP_STATUS_NUM));
                Object appIdObj = detectScheduleInfo.get(APPID);
                if (StringUtils.isNotBlank(appIdObj)) {
                    detectTask.put(APPID, String.valueOf(detectScheduleInfo.get(APPID)));
                }
                detectTasks.add(detectTask);
            }
            if (!CollectionUtils.isEmpty(detectTasks)) {
                pageCache.put(DETECT_TASKS, SerializationUtils.toJsonString(detectTasks));
                pageCache.put(DETECT_STEP, TASK_DETECT_FIRST_RESULT);
                pageCache.put(TASK_DETECT_STEP, TASK_STEP_JOB_NUMBER);
                this.getView().setVisible(Boolean.TRUE, new String[]{TASK_DETECT_JOB_NUMBER, TASK_REFRESH_ICON});
            }
        }
        catch (Throwable t) {
            this.stopProgressBar();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u9001\u63a2\u6d4b\u4efb\u52a1\u5931\u8d25\uff0c\u8be6\u60c5\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScheduleDetecTaskPlugin_15", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            logger.error("Schedule***ScheduleDetectTask fail", t);
        }
    }

    private void detectOtherJob() {
        String detectScheduleInfosStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_DETECT_SCHEDULE_INFO);
        List detectScheduleInfos = SerializationUtils.fromJsonStringToList((String)detectScheduleInfosStr, Map.class);
        IPageCache pageCache = this.getView().getPageCache();
        Integer jobInfoIndex = Integer.parseInt(pageCache.get(JOB_INFO_DETECT_JOB_INDEX));
        if (detectScheduleInfos.size() > jobInfoIndex) {
            Map jobInfo = (Map)detectScheduleInfos.get(jobInfoIndex);
            String jobInfoDetect = pageCache.get(JOB_INFO_DETECT);
            String itemLabText = "";
            switch (jobInfoDetect) {
                case "jobNumberDetect": {
                    this.createJobNumberFlex(jobInfoIndex, String.valueOf(jobInfo.get(JOB_NUMBER)), JOB_INFO_DETECT_JOB_STATUS);
                    break;
                }
                case "jobStatusDetect": {
                    String jobStatus = String.valueOf(jobInfo.get(JOB_STATUS));
                    itemLabText = ResManager.loadKDString((String)"\u6240\u5c5e\u4f5c\u4e1a\u72b6\u6001", (String)"ScheduleDetecTaskPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createJobItemCheckFlex(jobInfoIndex, JOB_STATUS_FLEX, JOB_STATUS_LAB, itemLabText, JOB_STATUS, JOB_INFO_DETECT_APP_STATUS, this.createJobStatusInfoItem(jobStatus));
                    break;
                }
                case "appDetect": {
                    itemLabText = ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528\u72b6\u6001", (String)"ScheduleDetecTaskPlugin_20", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createJobItemCheckFlex(jobInfoIndex, APP_STATUS_FLEX, APP_STATUS_LAB, itemLabText, APP_STATUS, JOB_INFO_DETECT_RESCHEDULE, this.createAppStatusInfoItem(jobInfo));
                    break;
                }
                case "rescheduleDetect": {
                    itemLabText = ResManager.loadKDString((String)"\u652f\u6301\u91cd\u65b0\u8c03\u5ea6\u914d\u7f6e", (String)"ScheduleDetecTaskPlugin_21", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createJobItemCheckFlex(jobInfoIndex, RESCHEDULE_FLEX, RESCHEDULE_LAB, itemLabText, RESCHEDULE_STATUS, JOB_INFO_DETECT_RUN_ORDER, this.createGeneralInfoItem(jobInfo, RESCHEDULE_STATUS));
                    break;
                }
                case "runOrderDetect": {
                    itemLabText = ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u987a\u5e8f", (String)"ScheduleDetecTaskPlugin_22", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createJobItemCheckFlex(jobInfoIndex, RUN_ORDER_FLEX, RUN_ORDER_LAB, itemLabText, RUN_ORDER, JOB_INFO_DETECT_ENV_LANG, this.createGeneralInfoItem(jobInfo, RUN_ORDER));
                    break;
                }
                case "envLangDetect": {
                    itemLabText = ResManager.loadKDString((String)"\u6267\u884c\u8bed\u8a00\u73af\u5883", (String)"ScheduleDetecTaskPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createJobItemCheckFlex(jobInfoIndex, RUN_LANG_FLEX, RUN_LANG_LAB, itemLabText, RUN_LANG, JOB_INFO_DETECT_ORG, this.createGeneralInfoItem(jobInfo, RUN_LANG));
                    break;
                }
                case "orgDetect": {
                    itemLabText = ResManager.loadKDString((String)"\u6267\u884c\u7ec4\u7ec7", (String)"ScheduleDetecTaskPlugin_24", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createJobItemCheckFlex(jobInfoIndex, RUN_ORG_FLEX, RUN_ORG_LAB, itemLabText, RUN_ORG, JOB_INFO_DETECT_RUN_USER, this.createOrgInfoItem(jobInfo));
                    break;
                }
                case "runUserDetect": {
                    itemLabText = ResManager.loadKDString((String)"\u6267\u884c\u7528\u6237", (String)"ScheduleDetecTaskPlugin_25", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    this.createJobItemCheckFlex(jobInfoIndex, RUN_USER_FLEX, RUN_USER_LAB, itemLabText, RUN_USER, JOB_INFO_DETECT_JOBNUMBER, this.createUserInfoItem(jobInfo));
                    this.getView().setVisible(Boolean.FALSE, new String[]{JOB_REFRESH_ICON + jobInfoIndex});
                    if (detectScheduleInfos.size() - 1 > jobInfoIndex) {
                        pageCache.put(DETECT_STEP, DETECT_OTHER_JOB);
                        pageCache.put(JOB_INFO_DETECT_JOB_INDEX, String.valueOf(jobInfoIndex + 1));
                        break;
                    }
                    pageCache.put(DETECT_STEP, TAB_ACTIVE_TASK_DETECT);
                    break;
                }
            }
        } else {
            this.stopProgressBar();
        }
    }

    private void detectFirstJob() {
        String jobInfoDetect;
        String detectScheduleInfosStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_DETECT_SCHEDULE_INFO);
        List detectScheduleInfos = SerializationUtils.fromJsonStringToList((String)detectScheduleInfosStr, Map.class);
        Map firstJobInfo = (Map)detectScheduleInfos.get(0);
        IPageCache pageCache = this.getView().getPageCache();
        switch (jobInfoDetect = pageCache.get(JOB_INFO_DETECT)) {
            case "jobNumberDetect": {
                Label jobNumber = (Label)this.getView().getControl(JOB_NUMBER);
                jobNumber.setText(String.valueOf(firstJobInfo.get(JOB_NUMBER)));
                this.getView().setVisible(Boolean.TRUE, new String[]{JOB_STATUS_FLEX});
                pageCache.put(JOB_INFO_DETECT, JOB_INFO_DETECT_JOB_STATUS);
                break;
            }
            case "jobStatusDetect": {
                String jobStatus = String.valueOf(firstJobInfo.get(JOB_STATUS));
                this.detectJobInfo(APP_STATUS_FLEX, JOB_STATUS, JOB_INFO_DETECT_APP_STATUS, this.createJobStatusInfoItem(jobStatus));
                break;
            }
            case "appDetect": {
                this.detectJobInfo(RESCHEDULE_FLEX, APP_STATUS, JOB_INFO_DETECT_RESCHEDULE, this.createAppStatusInfoItem(firstJobInfo));
                break;
            }
            case "rescheduleDetect": {
                this.detectJobInfo(RUN_ORDER_FLEX, RESCHEDULE_STATUS, JOB_INFO_DETECT_RUN_ORDER, this.createGeneralInfoItem(firstJobInfo, RESCHEDULE_STATUS));
                break;
            }
            case "runOrderDetect": {
                this.detectJobInfo(RUN_LANG_FLEX, RUN_ORDER, JOB_INFO_DETECT_ENV_LANG, this.createGeneralInfoItem(firstJobInfo, RUN_ORDER));
                break;
            }
            case "envLangDetect": {
                this.detectJobInfo(RUN_ORG_FLEX, RUN_LANG, JOB_INFO_DETECT_ORG, this.createGeneralInfoItem(firstJobInfo, RUN_LANG));
                break;
            }
            case "orgDetect": {
                this.detectJobInfo(RUN_USER_FLEX, RUN_ORG, JOB_INFO_DETECT_RUN_USER, this.createOrgInfoItem(firstJobInfo));
                break;
            }
            case "runUserDetect": {
                this.detectJobInfo("", RUN_USER, JOB_INFO_DETECT_JOBNUMBER, this.createUserInfoItem(firstJobInfo));
                this.getView().setVisible(Boolean.FALSE, new String[]{JOB_REFRESH_ICON});
                if (detectScheduleInfos.size() > 1) {
                    pageCache.put(DETECT_STEP, DETECT_OTHER_JOB);
                    pageCache.put(JOB_INFO_DETECT_JOB_INDEX, ENABLE_JOB);
                    break;
                }
                pageCache.put(DETECT_STEP, TAB_ACTIVE_TASK_DETECT);
                break;
            }
        }
    }

    private InfoItem createUserInfoItem(Map<String, Object> firstJobInfo) {
        InfoItem userInfoItem = new InfoItem();
        Object runUser = firstJobInfo.get(RUN_USER);
        if (runUser == null) {
            userInfoItem.setItemName(ResManager.loadKDString((String)"\u672a\u9009\u62e9", (String)"ScheduleDetecTaskPlugin_28", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            userInfoItem.setItemColor(COLOR_YELLOW);
        } else {
            userInfoItem.setItemName(String.valueOf(runUser));
            userInfoItem.setItemColor(COLOR_GREEN);
        }
        return userInfoItem;
    }

    private InfoItem createOrgInfoItem(Map<String, Object> firstJobInfo) {
        InfoItem orgInfoItem = new InfoItem();
        Object runOrg = firstJobInfo.get(RUN_ORG);
        String runOrgName = "";
        if (runOrg == null) {
            runOrgName = ResManager.loadKDString((String)"\u672a\u9009\u62e9", (String)"ScheduleDetecTaskPlugin_28", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
            orgInfoItem.setItemColor(COLOR_YELLOW);
        } else {
            runOrgName = String.valueOf(runOrg);
            orgInfoItem.setItemColor(COLOR_GREEN);
        }
        orgInfoItem.setItemName(runOrgName);
        return orgInfoItem;
    }

    private InfoItem createGeneralInfoItem(Map<String, Object> firstJobInfo, String itemKey) {
        InfoItem generalInfoItem = new InfoItem();
        generalInfoItem.setItemName(String.valueOf(firstJobInfo.get(itemKey)));
        generalInfoItem.setItemColor(COLOR_GREEN);
        return generalInfoItem;
    }

    private InfoItem createAppStatusInfoItem(Map<String, Object> firstJobInfo) {
        Object appIdObj = firstJobInfo.get(APPID);
        Map<String, String> appStatusMap = this.getAppStatus(appIdObj);
        InfoItem appInfoItem = new InfoItem();
        appInfoItem.setItemName(appStatusMap.get(APP_STATUS_DESC));
        appInfoItem.setItemColor(appStatusMap.get(APP_STATUS_COLOR));
        return appInfoItem;
    }

    private Map<String, String> getAppStatus(Object appNumObj) {
        String appStatusNum = "";
        String appStatusDesc = "";
        String appStatusColor = "";
        if (StringUtils.isNotBlank((Object)appNumObj)) {
            String appNum = String.valueOf(appNumObj);
            List executorServerInfos = ClientObservableUtils.queryExecutorServerStatus((String)appNum);
            if (CollectionUtils.isEmpty((Collection)executorServerInfos)) {
                appStatusNum = UNDEPLOY_APP;
                appStatusDesc = ResManager.loadKDString((String)"\u672a\u90e8\u7f72", (String)"ScheduleDetecTaskPlugin_18", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                appStatusColor = COLOR_YELLOW;
            } else {
                String appIdByAppNumber;
                Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
                if (disabledAppIds.contains(appIdByAppNumber = BizAppServiceHelp.getAppIdByAppNumber((String)appNum))) {
                    appStatusNum = DISABLE_APP;
                    appStatusDesc = ResManager.loadKDString((String)"\u5df2\u7981\u7528", (String)"ScheduleDetecTaskPlugin_38", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    appStatusColor = COLOR_YELLOW;
                } else {
                    appStatusNum = NORMAL_APP;
                    appStatusDesc = ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ScheduleDetecTaskPlugin_19", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    appStatusColor = COLOR_GREEN;
                }
            }
        } else {
            appStatusNum = UNBIND_APP;
            appStatusDesc = ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u672a\u7ed1\u5b9a\u6240\u5c5e\u5e94\u7528", (String)"ScheduleDetecTaskPlugin_17", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
            appStatusColor = COLOR_YELLOW;
        }
        HashMap<String, String> appStatusMap = new HashMap<String, String>(2);
        appStatusMap.put(APP_STATUS_NUM, appStatusNum);
        appStatusMap.put(APP_STATUS_DESC, appStatusDesc);
        appStatusMap.put(APP_STATUS_COLOR, appStatusColor);
        return appStatusMap;
    }

    private InfoItem createJobStatusInfoItem(String jobStatus) {
        InfoItem statusInfoItem = new InfoItem();
        statusInfoItem.setItemName(this.getJobStatusStr(jobStatus));
        statusInfoItem.setItemColor(this.toHealthLevelColor(Integer.parseInt(jobStatus)));
        return statusInfoItem;
    }

    private String getJobStatusStr(Object jobStatus) {
        return StringUtils.equals((CharSequence)String.valueOf(jobStatus), (CharSequence)"0") ? ResManager.loadKDString((String)"\u7981\u7528", (String)"ScheduleDetecTaskPlugin_26", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u542f\u7528", (String)"ScheduleDetecTaskPlugin_27", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
    }

    private void detectJobInfo(String nextDetectFlex, String detectLabelKey, String nextDetectStep, InfoItem infoItem) {
        this.getView().setVisible(Boolean.TRUE, new String[]{detectLabelKey});
        if (StringUtils.isNotBlank((CharSequence)nextDetectFlex)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{nextDetectFlex});
        }
        this.setLabelTextAndColor(detectLabelKey, infoItem.getItemName(), infoItem.getItemColor());
        this.getView().getPageCache().put(JOB_INFO_DETECT, nextDetectStep);
    }

    private void activeTab(String tabKey, String nextDetectStep, IPageCache pageCache) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(tabKey);
        pageCache.put(DETECT_STEP, nextDetectStep);
    }

    private void detectMiddle(String middleKey, String middleStatusKey, String nextMiddleDetectStep, IPageCache pageCache) {
        JSONObject middlewareStatus = ServerObservableUtils.getMiddlewareStatus();
        Integer middleStatus = middlewareStatus.getInteger(middleKey);
        this.setLabelTextAndColor(middleStatusKey, this.toHealthLevelText(middleStatus), this.toHealthLevelColor(middleStatus));
        this.getView().setVisible(Boolean.TRUE, new String[]{middleStatusKey});
        pageCache.put(DETECT_STEP, nextMiddleDetectStep);
    }

    private void setLabelTextAndColor(String labelKey, String labelText, String labelColor) {
        Label statusLab = (Label)this.getView().getControl(labelKey);
        statusLab.setText(labelText);
        if (StringUtils.isNotBlank((CharSequence)labelColor)) {
            this.changeControlColor(labelKey, labelColor);
        }
    }

    private void detectExecutor(IPageCache pageCache) {
        String executorServerInfoStr = pageCache.get(EXECUTOR_SERVER_INFO_CACHE);
        List executorServerInfos = null;
        if (StringUtils.isNotBlank((CharSequence)executorServerInfoStr)) {
            executorServerInfos = SerializationUtils.fromJsonStringToList((String)executorServerInfoStr, Map.class);
        }
        if (executorServerInfos != null && !executorServerInfos.isEmpty()) {
            String executorIndexStr = pageCache.get(EXECUTOR_INDEX);
            if (StringUtils.isNotBlank((CharSequence)executorIndexStr)) {
                int executorIndex = Integer.parseInt(executorIndexStr);
                if (executorIndex < executorServerInfos.size()) {
                    Map executorServerInfo = (Map)executorServerInfos.get(executorIndex);
                    this.addExeMachineDetect(executorIndexStr, String.valueOf(executorServerInfo.get("ip")), (Boolean)executorServerInfo.get("isStarted"));
                    pageCache.put(EXECUTOR_INDEX, String.valueOf(++executorIndex));
                }
                if (executorIndex >= executorServerInfos.size()) {
                    pageCache.put(DETECT_STEP, TAB_ACTIVE_MIDDLE);
                    pageCache.remove(EXECUTOR_INDEX);
                }
            }
        } else {
            this.addExeMachineDetect("0", ResManager.loadKDString((String)"\u65e0\u6267\u884c\u673a", (String)"ScheduleDetecTaskPlugin_36", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), false);
            pageCache.put(DETECT_STEP, TAB_ACTIVE_MIDDLE);
        }
    }

    private void changeControlColor(String key, String color) {
        HashMap<String, String> colorMap = new HashMap<String, String>(1);
        colorMap.put("fc", color);
        this.getView().updateControlMetadata(key, colorMap);
    }

    private String toHealthLevelColor(int i) {
        String color = i == 1 ? COLOR_GREEN : (i == 2 || i == 3 ? COLOR_YELLOW : COLOR_RED);
        return color;
    }

    private String toHealthLevelText(int i) {
        String text = i == 1 ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ScheduleDetecTaskPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (i == 2 || i == 3 ? ResManager.loadKDString((String)"\u7e41\u5fd9", (String)"ScheduleDetecTaskPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (i == -1 ? ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ScheduleDetecTaskPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316", (String)"ScheduleDetecTaskPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        return text;
    }

    private void addExeMachineDetect(String executorIndex, String executorIp, boolean executorStatus) {
        LabelAp exeLabel = new LabelAp();
        exeLabel.setId(EXE_IP_LAB + executorIndex);
        exeLabel.setKey(EXE_IP_LAB + executorIndex);
        exeLabel.setName(new LocaleString(executorIp));
        exeLabel.setForeColor(COLOR_GRAY);
        exeLabel.setWidth(new LocaleString("190px"));
        exeLabel.setParentId(EXE_MACHINE_FLEX + executorIndex);
        exeLabel.setGrow(0);
        exeLabel.setShrink(0);
        LabelAp statusLabel = new LabelAp();
        statusLabel.setId(EXE_STATUS_LAB + executorIndex);
        statusLabel.setKey(EXE_STATUS_LAB + executorIndex);
        if (executorStatus) {
            statusLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ScheduleDetecTaskPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
            statusLabel.setForeColor(COLOR_GREEN);
        } else {
            statusLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ScheduleDetecTaskPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
            statusLabel.setForeColor(COLOR_RED);
        }
        FlexPanelAp statusFlex = new FlexPanelAp();
        statusFlex.setId(EXE_STATUS_FLEX + executorIndex);
        statusFlex.setKey(EXE_STATUS_FLEX + executorIndex);
        statusFlex.setWidth(new LocaleString("110px"));
        statusFlex.getItems().add(statusLabel);
        statusFlex.setGrow(0);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(EXE_MACHINE_FLEX + executorIndex);
        flexPanelAp.setHeight(new LocaleString(GENERAL_FLEX_HEIGHT));
        flexPanelAp.setWidth(new LocaleString("100%"));
        flexPanelAp.setGrow(0);
        flexPanelAp.setShrink(0);
        flexPanelAp.setDirection(FLEX_DIRECTION_ROW);
        flexPanelAp.setJustifyContent("space-between");
        flexPanelAp.setWrap(false);
        flexPanelAp.getItems().add(exeLabel);
        flexPanelAp.getItems().add(statusFlex);
        Container exeMachineFlex = (Container)this.getView().getControl("exestatus");
        ArrayList<Map> items = new ArrayList<Map>();
        items.add(flexPanelAp.createControl());
        exeMachineFlex.addControls(items);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List executorServerInfos = ClientObservableUtils.queryExecutorServerStatus();
        if (executorServerInfos != null) {
            ArrayList executorServerInfosCache = new ArrayList(executorServerInfos.size());
            for (ExecutorServerInfo executorServerInfo : executorServerInfos) {
                HashMap<String, Object> executorServerInfoMap = new HashMap<String, Object>(2);
                executorServerInfoMap.put("ip", executorServerInfo.getName());
                executorServerInfoMap.put("isStarted", executorServerInfo.isStarted());
                executorServerInfosCache.add(executorServerInfoMap);
            }
            this.getView().getPageCache().put(EXECUTOR_SERVER_INFO_CACHE, SerializationUtils.toJsonString(executorServerInfosCache));
        }
        this.hideInVisibleControl();
        String detectScheduleInfosStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_DETECT_SCHEDULE_INFO);
        if (StringUtils.isEmpty((CharSequence)detectScheduleInfosStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4f5c\u4e1a\u3002", (String)"ScheduleDetecTaskPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.detecMaster();
        this.getView().getPageCache().put(DETECT_STEP, EXECUTOR_DETECT);
        this.getView().getPageCache().put(EXECUTOR_INDEX, "0");
        this.startProgressBar();
    }

    private void hideInVisibleControl() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"masterrun"});
        this.getView().setVisible(Boolean.FALSE, new String[]{EXE_MACHINE_FLEX, MA_STATUS, REDIS_STATUS, ZK_STATUS, MQ_REFRESH_ICON, REDIS_REFRESH_ICON, ZK_REFRESH_ICON});
        this.getView().setVisible(Boolean.FALSE, new String[]{JOB_REFRESH_ICON});
        this.getView().setVisible(Boolean.FALSE, new String[]{JOB_NUMBER, JOB_STATUS, APP_STATUS, RESCHEDULE_STATUS, RUN_ORDER, RUN_LANG, RUN_ORG, RUN_USER});
        this.getView().setVisible(Boolean.FALSE, new String[]{JOB_STATUS_FLEX, APP_STATUS_FLEX, RESCHEDULE_FLEX, RUN_ORDER_FLEX, RUN_LANG_FLEX, RUN_ORG_FLEX, RUN_USER_FLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{TASK_REFRESH_ICON});
        this.getView().setVisible(Boolean.FALSE, new String[]{TASK_GEN_TIME_RESULT_LAB, TASK_ALLOW_FIRE_TIME_RESULT_LAB, TASK_DISPATCH_JOB_TIME_RESULT_LAB, TASK_RECEIVE_TASK_EXE_RESULT_LAB, TASK_RECEIVE_TASK_EXE_IP_RESULT_LAB, TASK_RECEIVE_TIME_RESULT_LAB, TASK_EXECUTE_TASK_TIME_RESULT_LAB, TASK_COMPLETE_TASK_TIME_RESULT_LAB});
        this.getView().setVisible(Boolean.FALSE, new String[]{TASK_APP_ERROR_FLEX, TASK_DISABLE_JOB_FLEX, TASK_GEN_TIME_FLEX, TASK_ALLOW_FIRE_FLEX, TASK_DISPATCH_JOB_FLEX, TASK_RECEIVE_TASK_EXE_FLEX, TASK_RECEIVE_TASK_EXE_IP_FLEX, TASK_RECEIVE_TASK_FLEX, TASK_EXECUTE_TASK_FLEX, TASK_COMPLETE_TASK_FLEX});
    }

    private void createTaskDetectJobNumberFlex(int taskInfoIndex, String jobNumber, String nextDetectStep) {
        FlexPanelAp jobNumberFlex = new FlexPanelAp();
        jobNumberFlex.setKey(TASK_JOB_NUMBER_FLEX + taskInfoIndex);
        jobNumberFlex.setId(TASK_JOB_NUMBER_FLEX + taskInfoIndex);
        jobNumberFlex.setHeight(new LocaleString(GENERAL_FLEX_HEIGHT));
        jobNumberFlex.setShrink(0);
        jobNumberFlex.setGrow(0);
        jobNumberFlex.setDirection(FLEX_DIRECTION_ROW);
        jobNumberFlex.setAlignItems(FLEX_ALIGN_ITEMS);
        FlexPanelAp iconFlex = new FlexPanelAp();
        iconFlex.setId(TASK_REFRESH_ICON_FLEX + taskInfoIndex);
        iconFlex.setKey(TASK_REFRESH_ICON_FLEX + taskInfoIndex);
        iconFlex.setWidth(new LocaleString(GENERAL_ICON_FLEX_WIDTH));
        VectorAp icon = new VectorAp();
        icon.setId(TASK_REFRESH_ICON + taskInfoIndex);
        icon.setKey(TASK_REFRESH_ICON + taskInfoIndex);
        icon.setfontClass(REFRESH_FONT);
        iconFlex.getItems().add(icon);
        jobNumberFlex.getItems().add(iconFlex);
        LabelAp jobLab = new LabelAp();
        jobLab.setId(TASK_JOB_LAB + taskInfoIndex);
        jobLab.setKey(TASK_JOB_LAB + taskInfoIndex);
        jobLab.setWidth(new LocaleString("100px"));
        Margin margin = new Margin();
        margin.setRight(GENERAL_JOB_NUMBER_LEFT_MARGIN);
        Style style = new Style();
        style.setMargin(margin);
        jobLab.setStyle(style);
        jobLab.setName(new LocaleString(ResManager.loadKDString((String)"\u6240\u5c5e\u8c03\u5ea6\u4f5c\u4e1a", (String)"ScheduleDetecTaskPlugin_37", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        jobNumberFlex.getItems().add(jobLab);
        LabelAp jobNumberLab = new LabelAp();
        jobNumberLab.setId(TASK_DETECT_JOB_NUMBER + taskInfoIndex);
        jobNumberLab.setKey(TASK_DETECT_JOB_NUMBER + taskInfoIndex);
        jobNumberLab.setName(new LocaleString(jobNumber));
        jobNumberLab.setWidth(new LocaleString(GENERAL_JOB_NUMBER_WIDTH));
        jobNumberFlex.getItems().add(jobNumberLab);
        Container jobCheckFlex = (Container)this.getView().getControl(TASK_DETECT_FLEX);
        ArrayList<Map> items = new ArrayList<Map>(1);
        items.add(jobNumberFlex.createControl());
        jobCheckFlex.addControls(items);
        this.getView().getPageCache().put(TASK_DETECT_STEP, nextDetectStep);
    }

    private void createTaskDetectErrorFlex(String flexKey, String labKey, String labText) {
        FlexPanelAp disableJobFlex = new FlexPanelAp();
        disableJobFlex.setHeight(new LocaleString(GENERAL_FLEX_HEIGHT));
        disableJobFlex.setId(flexKey);
        disableJobFlex.setKey(flexKey);
        disableJobFlex.setShrink(0);
        disableJobFlex.setGrow(0);
        disableJobFlex.setDirection(FLEX_DIRECTION_ROW);
        disableJobFlex.setAlignItems(FLEX_ALIGN_ITEMS);
        Margin margin = new Margin();
        margin.setLeft(GENERAL_CHECK_ITEM_FLEX_LEFT_MARGIN);
        Style style = new Style();
        style.setMargin(margin);
        disableJobFlex.setStyle(style);
        LabelAp disableJobLab = new LabelAp();
        disableJobLab.setForeColor(COLOR_RED);
        disableJobLab.setId(labKey);
        disableJobLab.setKey(labKey);
        disableJobLab.setName(new LocaleString(labText));
        disableJobFlex.getItems().add(disableJobLab);
        Container taskDetectFlex = (Container)this.getView().getControl(TASK_DETECT_FLEX);
        ArrayList<Map> items = new ArrayList<Map>(1);
        items.add(disableJobFlex.createControl());
        taskDetectFlex.addControls(items);
    }

    private void createTaskItemCheckFlex(int taskInfoIndex, String taskItemFlexKey, String taskItemLabKey, String taskItemLabName, String taskItemLabTimeKey, String timeResult, String nextDetectStep) {
        if (StringUtils.isBlank((CharSequence)timeResult)) {
            return;
        }
        FlexPanelAp taskItemFlex = new FlexPanelAp();
        taskItemFlex.setId(taskItemFlexKey + taskInfoIndex);
        taskItemFlex.setKey(taskItemFlexKey + taskInfoIndex);
        taskItemFlex.setHeight(new LocaleString(GENERAL_FLEX_HEIGHT));
        taskItemFlex.setWidth(new LocaleString("300px"));
        taskItemFlex.setShrink(0);
        taskItemFlex.setGrow(0);
        taskItemFlex.setDirection(FLEX_DIRECTION_ROW);
        taskItemFlex.setAlignItems(FLEX_ALIGN_ITEMS);
        Margin margin = new Margin();
        margin.setLeft(GENERAL_CHECK_ITEM_FLEX_LEFT_MARGIN);
        Style style = new Style();
        style.setMargin(margin);
        taskItemFlex.setStyle(style);
        LabelAp taskItemLab = new LabelAp();
        taskItemLab.setKey(taskItemLabKey + taskInfoIndex);
        taskItemLab.setName(new LocaleString(taskItemLabName));
        taskItemLab.setForeColor(COLOR_GRAY);
        taskItemLab.setWidth(new LocaleString("150px"));
        taskItemFlex.getItems().add(taskItemLab);
        FlexPanelAp taskItemTimeFlex = new FlexPanelAp();
        String taskItemTimeFlexKey = taskItemFlexKey + "itemStatusFlex" + taskInfoIndex;
        taskItemTimeFlex.setId(taskItemTimeFlexKey);
        taskItemTimeFlex.setKey(taskItemTimeFlexKey);
        taskItemTimeFlex.setWidth(new LocaleString("150px"));
        taskItemTimeFlex.setGrow(0);
        LabelAp taskItemTime = new LabelAp();
        taskItemTime.setKey(taskItemLabTimeKey + taskInfoIndex);
        taskItemTime.setWidth(new LocaleString(GENERAL_TASK_CHECK_ITEM_RESULT_LABWITH));
        taskItemTime.setForeColor(COLOR_GREEN);
        taskItemTime.setName(new LocaleString(timeResult));
        taskItemTimeFlex.getItems().add(taskItemTime);
        taskItemFlex.getItems().add(taskItemTimeFlex);
        ArrayList<Map> items = new ArrayList<Map>(1);
        items.add(taskItemFlex.createControl());
        Container jobCheckFlex = (Container)this.getView().getControl(TASK_DETECT_FLEX);
        jobCheckFlex.addControls(items);
        this.getView().getPageCache().put(TASK_DETECT_STEP, nextDetectStep);
    }

    private void createJobNumberFlex(int jobInfoIndex, String jobNumber, String nextDetectStep) {
        FlexPanelAp jobNumberFlex = new FlexPanelAp();
        jobNumberFlex.setKey(JOB_NUMBER_FLEX + jobInfoIndex);
        jobNumberFlex.setId(JOB_NUMBER_FLEX + jobInfoIndex);
        jobNumberFlex.setHeight(new LocaleString(GENERAL_FLEX_HEIGHT));
        jobNumberFlex.setShrink(0);
        jobNumberFlex.setGrow(0);
        jobNumberFlex.setAlignItems(FLEX_ALIGN_ITEMS);
        FlexPanelAp iconFlex = new FlexPanelAp();
        iconFlex.setId(ICON_FLEX + jobInfoIndex);
        iconFlex.setKey(ICON_FLEX + jobInfoIndex);
        iconFlex.setWidth(new LocaleString(GENERAL_ICON_FLEX_WIDTH));
        VectorAp icon = new VectorAp();
        icon.setId(JOB_REFRESH_ICON + jobInfoIndex);
        icon.setKey(JOB_REFRESH_ICON + jobInfoIndex);
        icon.setfontClass(REFRESH_FONT);
        iconFlex.getItems().add(icon);
        jobNumberFlex.getItems().add(iconFlex);
        LabelAp jobLab = new LabelAp();
        jobLab.setId(JOB_LAB + jobInfoIndex);
        jobLab.setKey(JOB_LAB + jobInfoIndex);
        jobLab.setWidth(new LocaleString("100px"));
        Margin margin = new Margin();
        margin.setRight(GENERAL_JOB_NUMBER_LEFT_MARGIN);
        Style style = new Style();
        style.setMargin(margin);
        jobLab.setStyle(style);
        jobLab.setName(new LocaleString(ResManager.loadKDString((String)"\u6240\u5c5e\u8c03\u5ea6\u4f5c\u4e1a", (String)"ScheduleDetecTaskPlugin_37", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        jobNumberFlex.getItems().add(jobLab);
        LabelAp jobNumberLab = new LabelAp();
        jobNumberLab.setId(JOB_NUMBER + jobInfoIndex);
        jobNumberLab.setKey(JOB_NUMBER + jobInfoIndex);
        jobNumberLab.setName(new LocaleString(jobNumber));
        jobNumberLab.setWidth(new LocaleString(GENERAL_JOB_NUMBER_WIDTH));
        jobNumberFlex.getItems().add(jobNumberLab);
        Container jobCheckFlex = (Container)this.getView().getControl(JOB_CHECK_FLEX);
        ArrayList<Map> items = new ArrayList<Map>(1);
        items.add(jobNumberFlex.createControl());
        jobCheckFlex.addControls(items);
        this.getView().getPageCache().put(JOB_INFO_DETECT, nextDetectStep);
    }

    private void createJobItemCheckFlex(int jobInfoIndex, String itemFlexKey, String itemLabKey, String itemLabText, String itemStatusKey, String nextDetectStep, InfoItem infoItem) {
        FlexPanelAp jobItemFlex = new FlexPanelAp();
        jobItemFlex.setId(itemFlexKey + jobInfoIndex);
        jobItemFlex.setKey(itemFlexKey + jobInfoIndex);
        jobItemFlex.setHeight(new LocaleString(GENERAL_FLEX_HEIGHT));
        jobItemFlex.setWidth(new LocaleString("300px"));
        jobItemFlex.setShrink(0);
        jobItemFlex.setGrow(0);
        jobItemFlex.setDirection(FLEX_DIRECTION_ROW);
        jobItemFlex.setJustifyContent("space-between");
        jobItemFlex.setAlignItems(FLEX_ALIGN_ITEMS);
        Margin margin = new Margin();
        margin.setLeft(GENERAL_CHECK_ITEM_FLEX_LEFT_MARGIN);
        Style style = new Style();
        style.setMargin(margin);
        jobItemFlex.setStyle(style);
        LabelAp jobItemLab = new LabelAp();
        jobItemLab.setKey(itemLabKey + jobInfoIndex);
        jobItemLab.setName(new LocaleString(itemLabText));
        jobItemLab.setShrink(0);
        jobItemLab.setGrow(0);
        jobItemLab.setForeColor(COLOR_GRAY);
        jobItemLab.setWidth(new LocaleString("200px"));
        jobItemFlex.getItems().add(jobItemLab);
        String jobItemStatusFlexKey = itemFlexKey + "itemStatusFlex" + jobInfoIndex;
        FlexPanelAp jobItemStatusFlex = new FlexPanelAp();
        jobItemStatusFlex.setId(jobItemStatusFlexKey);
        jobItemStatusFlex.setKey(jobItemStatusFlexKey);
        jobItemStatusFlex.setWidth(new LocaleString("100px"));
        jobItemStatusFlex.setGrow(0);
        LabelAp jobItemStatus = new LabelAp();
        jobItemStatus.setKey(itemStatusKey + jobInfoIndex);
        jobItemStatus.setForeColor(infoItem.getItemColor());
        jobItemStatus.setName(new LocaleString(infoItem.getItemName()));
        jobItemStatusFlex.getItems().add(jobItemStatus);
        jobItemFlex.getItems().add(jobItemStatusFlex);
        ArrayList<Map> items = new ArrayList<Map>(1);
        items.add(jobItemFlex.createControl());
        Container jobCheckFlex = (Container)this.getView().getControl(JOB_CHECK_FLEX);
        jobCheckFlex.addControls(items);
        this.getView().getPageCache().put(JOB_INFO_DETECT, nextDetectStep);
    }

    private void detecMaster() {
        Map masterServerInfo = ServerObservableUtils.getMasterServerInfo();
        Boolean isStarted = (Boolean)masterServerInfo.get("isStarted");
        String masterIp = (String)masterServerInfo.get("masterName");
        Label masterIpLabel = (Label)this.getView().getControl("masterip");
        masterIpLabel.setText(masterIp);
        if (isStarted.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"masterrun"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"mastererror"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mastererror"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"masterrun"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{MASTER_REFRESH_ICON});
    }

    private static class InfoItem {
        private String itemName;
        private String itemColor;

        private InfoItem() {
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemColor() {
            return this.itemColor;
        }

        public void setItemColor(String itemColor) {
            this.itemColor = itemColor;
        }
    }
}

