/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class ScheduleExportPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeCheckListener {
    private static final String KEY_LEFTTREEVIEW = "lefttree";
    private static final String KEY_RIGHTTREEVIEW = "righttree";
    private static final String KEY_LEFTSEARCHAP = "leftsearch";
    private static final String KEY_RIGHTSEARCHAP = "rightsearch";
    private static final String KEY_LEFTALL = "leftselectall";
    private static final String KEY_RIGHTALL = "rightselectall";
    private static final String KEY_LEFTCOUNT = "leftcount";
    private static final String KEY_RIGHTCOUNT = "rightcount";
    private static final String CACHE_ROOTNODE = "cache_rootNodeStr";
    private static final String CACHEKEY_LEFTFILTERCONTENT = "cache_leftfilter";
    private static final String CACHEKEY_RIGHTFILTERCONTENT = "cache_rightfilter";
    private static final String CACHEKEY_CHECKEDSCHEDULENODE = "cache_checkedschedulenode";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static String COUNTPATTERN = "(%s/%s)";
    private static String TREENODE_PARENTMARK = "isParent";
    private static String TREENODE_CLOUDMARK = "cloud";
    private TreeNode root = null;
    private Map<String, List<String>> localTaskIndexs = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search appSearch = (Search)this.getControl(KEY_LEFTSEARCHAP);
        appSearch.addEnterListener((SearchEnterListener)this);
        Search selectedSearch = (Search)this.getControl(KEY_RIGHTSEARCHAP);
        selectedSearch.addEnterListener((SearchEnterListener)this);
        TreeView apptreeview = (TreeView)this.getControl(KEY_LEFTTREEVIEW);
        apptreeview.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView selectedtree = (TreeView)this.getControl(KEY_RIGHTTREEVIEW);
        selectedtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addClickListeners(new String[]{"btn_addnode", "btn_delnode", "btnok"});
    }

    public void search(SearchEnterEvent evt) {
        Object src = evt.getSource();
        if (!(src instanceof Search)) {
            return;
        }
        Search search = (Search)src;
        String value = evt.getText();
        switch (search.getKey()) {
            case "leftsearch": {
                this.getPageCache().put(CACHEKEY_LEFTFILTERCONTENT, value);
                this.refreshLeftTree();
                break;
            }
            case "rightsearch": {
                this.getPageCache().put(CACHEKEY_RIGHTFILTERCONTENT, value);
                this.refreshRightTree();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeNode leftRoot = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        this.fillScheduleNode(leftRoot);
        TreeView leftTree = (TreeView)this.getControl(KEY_LEFTTREEVIEW);
        leftTree.addNode(leftRoot);
        this.updateCountLabel(KEY_LEFTCOUNT, String.format(COUNTPATTERN, 0, this.getLeafNodes(leftRoot).size()));
        TreeView rightTree = (TreeView)this.getControl(KEY_RIGHTTREEVIEW);
        TreeNode rightRoot = new TreeNode(leftRoot.getParentid(), leftRoot.getId(), leftRoot.getText(), leftRoot.getData());
        rightRoot.setIsOpened(true);
        rightRoot.setExpend(true);
        rightTree.addNode(rightRoot);
        this.updateCountLabel(KEY_RIGHTCOUNT, String.format(COUNTPATTERN, 0, 0));
    }

    private void refreshLeftTree() {
        String filterValue = this.getPageCache().get(CACHEKEY_LEFTFILTERCONTENT);
        AppTreeBuilder builder = new AppTreeBuilder(this.getRoot(), false, filterValue, this.getSelectedScheduleIds());
        TreeNode node = builder.build();
        TreeView treeView = (TreeView)this.getControl(KEY_LEFTTREEVIEW);
        treeView.updateNode(node);
        this.updateCountLabel(KEY_LEFTCOUNT, String.format(COUNTPATTERN, 0, this.getLeafNodes(node).size()));
    }

    private void refreshRightTree() {
        String filterValue = this.getPageCache().get(CACHEKEY_RIGHTFILTERCONTENT);
        AppTreeBuilder builder = new AppTreeBuilder(this.getRoot(), true, filterValue, this.getSelectedScheduleIds());
        TreeNode node = builder.build();
        TreeView treeView = (TreeView)this.getControl(KEY_RIGHTTREEVIEW);
        treeView.updateNode(node);
        this.updateCountLabel(KEY_RIGHTCOUNT, String.format(COUNTPATTERN, 0, this.getLeafNodes(node).size()));
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        if (!(evt.getSource() instanceof TreeView)) {
            return;
        }
        TreeView treeView = (TreeView)evt.getSource();
        String key = treeView.getKey();
        List checkedNodes = treeView.getTreeState().getSelectedNodes();
        int select = 0;
        for (Map checkedNode : checkedNodes) {
            if (Boolean.parseBoolean(String.valueOf(checkedNode.get(TREENODE_PARENTMARK)))) continue;
            ++select;
        }
        int total = 0;
        String filterValue = "";
        AppTreeBuilder builder = null;
        TreeNode currentRoot = new TreeNode();
        String labelKey = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_LEFTTREEVIEW)) {
            filterValue = this.getPageCache().get(CACHEKEY_LEFTFILTERCONTENT);
            builder = new AppTreeBuilder(this.getRoot(), false, filterValue, this.getSelectedScheduleIds());
            currentRoot = builder.build();
            labelKey = KEY_LEFTCOUNT;
            total = this.getLeafNodes(currentRoot).size();
            if (!evt.getChecked().booleanValue()) {
                this.clearSelectAllMark(KEY_LEFTALL, false);
            } else if (evt.getChecked().booleanValue() && select == total) {
                this.clearSelectAllMark(KEY_LEFTALL, true);
            } else {
                this.clearSelectAllMark(KEY_LEFTALL, false);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_RIGHTTREEVIEW)) {
            filterValue = this.getPageCache().get(CACHEKEY_RIGHTFILTERCONTENT);
            builder = new AppTreeBuilder(this.getRoot(), true, filterValue, this.getSelectedScheduleIds());
            currentRoot = builder.build();
            labelKey = KEY_RIGHTCOUNT;
            total = this.getLeafNodes(currentRoot).size();
            if (!evt.getChecked().booleanValue()) {
                this.clearSelectAllMark(KEY_RIGHTALL, false);
            } else if (evt.getChecked().booleanValue() && select == total) {
                this.clearSelectAllMark(KEY_RIGHTALL, true);
            } else {
                this.clearSelectAllMark(KEY_RIGHTALL, false);
            }
        }
        this.updateCountLabel(labelKey, String.format(COUNTPATTERN, select, total));
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        Button button = (Button)src;
        Set<String> leafSelectedNodeIds = this.getSelectedScheduleIds();
        switch (button.getKey()) {
            case "btn_addnode": {
                TreeView view = (TreeView)this.getControl(KEY_LEFTTREEVIEW);
                view.getTreeState().getCheckedNodes().forEach(it -> {
                    if (!Boolean.parseBoolean(String.valueOf(it.get(TREENODE_PARENTMARK)))) {
                        leafSelectedNodeIds.add((String)it.get("id"));
                    }
                });
                this.saveSelectedScheduleIds(leafSelectedNodeIds);
                this.refreshRightTree();
                this.clearSelectAllMark(KEY_RIGHTALL, false);
                break;
            }
            case "btn_delnode": {
                TreeView view = (TreeView)this.getControl(KEY_RIGHTTREEVIEW);
                view.getTreeState().getCheckedNodes().forEach(it -> {
                    if (!Boolean.parseBoolean(String.valueOf(it.get(TREENODE_PARENTMARK)))) {
                        leafSelectedNodeIds.remove((String)it.get("id"));
                    }
                });
                this.saveSelectedScheduleIds(leafSelectedNodeIds);
                this.refreshLeftTree();
                this.refreshRightTree();
                this.clearSelectAllMark(KEY_LEFTALL, false);
                this.clearSelectAllMark(KEY_RIGHTALL, false);
                break;
            }
            case "btnok": {
                HashMap<String, Object> retrunData = new HashMap<String, Object>(3);
                Set<String> selectedIds = this.getSelectedScheduleIds();
                if (selectedIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8c03\u5ea6\u6587\u4ef6\u3002", (String)"ScheduleExportPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (selectedIds.size() > 1000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u5bfc\u51fa\u6700\u591a\u5141\u8bb8\u9009\u62e91000\u6761\u8ba1\u5212\u3002", (String)"ScheduleExportPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                retrunData.put("scheduleIds", this.getSelectedScheduleIds());
                retrunData.put("override", this.getModel().getValue("override"));
                this.getView().returnDataToParent(retrunData);
                this.getView().close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        TreeNode node;
        String key = e.getProperty().getName();
        if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_LEFTALL) && !StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_RIGHTALL)) {
            return;
        }
        Boolean value = (Boolean)e.getChangeSet()[0].getNewValue();
        String filterValue = "";
        AppTreeBuilder builder = null;
        int total = 0;
        TreeView treeView = null;
        String labelKey = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_LEFTALL)) {
            filterValue = this.getPageCache().get(CACHEKEY_LEFTFILTERCONTENT);
            builder = new AppTreeBuilder(this.getRoot(), false, filterValue, this.getSelectedScheduleIds());
            node = builder.build();
            total = this.getLeafNodes(node).size();
            treeView = (TreeView)this.getControl(KEY_LEFTTREEVIEW);
            labelKey = KEY_LEFTCOUNT;
        } else {
            filterValue = this.getPageCache().get(CACHEKEY_RIGHTFILTERCONTENT);
            builder = new AppTreeBuilder(this.getRoot(), true, filterValue, this.getSelectedScheduleIds());
            treeView = (TreeView)this.getControl(KEY_RIGHTTREEVIEW);
            node = builder.build();
            total = this.getLeafNodes(node).size();
            labelKey = KEY_RIGHTCOUNT;
        }
        if (value.booleanValue()) {
            treeView.checkNodes(builder.build().getChildren());
            this.updateCountLabel(labelKey, String.format(COUNTPATTERN, total, total));
        } else {
            ArrayList nodeIds = new ArrayList(10);
            builder.build().getChildren().forEach(t -> nodeIds.add(t.getId()));
            treeView.uncheckNodes(nodeIds);
            this.updateCountLabel(labelKey, String.format(COUNTPATTERN, 0, total));
        }
    }

    private void clearSelectAllMark(String key, boolean select) {
        this.getModel().beginInit();
        this.getModel().setValue(key, (Object)select);
        this.getModel().endInit();
        this.getView().updateView(key);
    }

    private void updateCountLabel(String key, String value) {
        Label label = (Label)this.getControl(key);
        label.setText(value);
    }

    private Set<String> getLeafNodes(TreeNode node) {
        HashSet<String> nodeIds = new HashSet<String>(10);
        List cloudNodes = node.getChildren();
        if (cloudNodes != null) {
            cloudNodes.forEach(n -> {
                if (!StringUtils.equals((CharSequence)TREENODE_CLOUDMARK, (CharSequence)String.valueOf(n.getData()))) {
                    return;
                }
                List apps = n.getChildren();
                if (apps != null) {
                    for (TreeNode app : apps) {
                        List schedules = app.getChildren();
                        if (schedules == null) continue;
                        for (TreeNode schNode : schedules) {
                            nodeIds.add(schNode.getId());
                        }
                    }
                }
            });
        }
        return nodeIds;
    }

    private Set<String> getSelectedScheduleIds() {
        String idStr = this.getPageCache().get(CACHEKEY_CHECKEDSCHEDULENODE);
        if (StringUtils.isBlank((CharSequence)idStr)) {
            return new HashSet<String>(3);
        }
        return (Set)SerializationUtils.fromJsonString((String)idStr, Set.class);
    }

    private Set<String> getAppNodeIds(TreeNode root, boolean onlySelected) {
        HashSet<String> result = new HashSet<String>(10);
        List childs = root.getChildren();
        if (StringUtils.equals((CharSequence)"app", (CharSequence)String.valueOf(root.getData())) && (root.isCheckable() || !onlySelected)) {
            result.add(root.getId());
        } else {
            if (childs == null) {
                return result;
            }
            boolean isCloudNode = StringUtils.equals((CharSequence)TREENODE_CLOUDMARK, (CharSequence)String.valueOf(root.getData()));
            for (TreeNode child : childs) {
                if (root.isCheckable() && !onlySelected && isCloudNode) {
                    result.add(child.getId());
                    continue;
                }
                result.addAll(this.getAppNodeIds(child, onlySelected));
            }
        }
        return result;
    }

    private void saveSelectedScheduleIds(Set<String> ids) {
        String idStr = SerializationUtils.toJsonString(ids);
        this.getPageCache().put(CACHEKEY_CHECKEDSCHEDULENODE, idStr);
    }

    private TreeNode getRoot() {
        if (this.root == null) {
            String rootStr = this.getPageCache().get(CACHE_ROOTNODE);
            if (StringUtils.isBlank((CharSequence)rootStr)) {
                TreeNode node = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
                this.fillScheduleNode(node);
                String str = SerializationUtils.toJsonString((Object)node);
                this.root = node;
                this.getPageCache().put(CACHE_ROOTNODE, str);
            } else {
                this.root = (TreeNode)SerializationUtils.fromJsonString((String)rootStr, TreeNode.class);
            }
        }
        return this.root;
    }

    private void fillScheduleNode(TreeNode root) {
        List clouds = root.getChildren();
        if (clouds == null) {
            return;
        }
        ArrayList assignedSchIds = new ArrayList(10);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            List apps = cloud.getChildren();
            if (apps == null || apps.isEmpty()) {
                cloudIterator.remove();
                continue;
            }
            HashSet<String> appIds = new HashSet<String>(3);
            for (TreeNode app : apps) {
                appIds.add(app.getId());
            }
            DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloud.getId());
            HashMap<String, String> appNums = new HashMap<String, String>(3);
            for (DynamicObject bizApp : allBizApps) {
                if (!appIds.contains(bizApp.get("id"))) continue;
                appNums.put(bizApp.getString("id"), bizApp.getString("number"));
            }
            QFilter f = new QFilter("job.taskclassname.appid", "in", appNums.values());
            DynamicObject[] nameObjs = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,name", (QFilter[])new QFilter[]{f});
            HashMap<String, String> scheduleNameInfos = new HashMap<String, String>(nameObjs.length);
            for (DynamicObject nameObj : nameObjs) {
                scheduleNameInfos.put(nameObj.getPkValue().toString(), nameObj.getString("name"));
            }
            DynamicObjectCollection objs = QueryServiceHelper.query((String)"sch_schedule", (String)"id,job.taskclassname.appid", (QFilter[])new QFilter[]{f});
            HashMap<String, HashSet<String>> appidScheduleinfos = new HashMap<String, HashSet<String>>(objs.size());
            for (DynamicObject obj : objs) {
                String appid = obj.getString("job.taskclassname.appid");
                if (!StringUtils.isNotEmpty((CharSequence)"appid")) continue;
                HashSet<String> schIds = (HashSet<String>)appidScheduleinfos.get(appid);
                if (schIds == null) {
                    schIds = new HashSet<String>(8);
                    appidScheduleinfos.put(appid, schIds);
                }
                schIds.add(String.valueOf(obj.get("id")));
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                TreeNode app = (TreeNode)appIterator.next();
                Set scheduleInfos = (Set)appidScheduleinfos.get(appNums.get(app.getId()));
                if (scheduleInfos == null || scheduleInfos.isEmpty()) {
                    appIterator.remove();
                    continue;
                }
                assignedSchIds.addAll(scheduleInfos);
                for (String schId : scheduleInfos) {
                    ArrayList<TreeNode> childs = app.getChildren();
                    if (childs == null) {
                        childs = new ArrayList<TreeNode>();
                        app.setChildren(childs);
                    }
                    String name = (String)scheduleNameInfos.get(schId);
                    childs.add(new TreeNode(app.getId(), schId, name, (Object)"schedule"));
                }
            }
            if (cloud.getChildren() != null && !cloud.getChildren().isEmpty()) continue;
            cloudIterator.remove();
        }
        QFilter f = new QFilter("id", "not in", assignedSchIds);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,name", (QFilter[])new QFilter[]{f});
        if (objs.length > 0 && !clouds.isEmpty()) {
            TreeNode otherCloud = new TreeNode(((TreeNode)clouds.get(0)).getParentid(), "unkown_cloud", ResManager.loadKDString((String)"\u672a\u5206\u914d", (String)"ScheduleExportPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), (Object)TREENODE_CLOUDMARK);
            clouds.add(otherCloud);
            TreeNode otherApp = new TreeNode("unkown_cloud", "unkown_app", ResManager.loadKDString((String)"\u672a\u5206\u914d", (String)"ScheduleExportPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), (Object)"app");
            otherCloud.setChildren(new ArrayList(1));
            otherApp.setChildren(new ArrayList(objs.length));
            otherCloud.getChildren().add(otherApp);
            for (DynamicObject obj : objs) {
                otherApp.addChild(new TreeNode("unkown_app", obj.getPkValue().toString(), obj.getString("name"), (Object)"schedule"));
            }
        }
    }

    private Map<String, String> getScheduleIdsByAppId(Set<String> appIds) {
        Map<String, List<String>> taskIndexs = this.getTaskIndexs();
        ArrayList<String> taskIds = new ArrayList<String>(10);
        for (String appId : appIds) {
            List<String> data = taskIndexs.get(appId);
            if (data == null) continue;
            taskIds.addAll(data);
        }
        if (taskIds.isEmpty()) {
            return new HashMap<String, String>(3);
        }
        QFilter f = new QFilter("job.taskclassname.appid", "in", taskIds);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,name", (QFilter[])new QFilter[]{f});
        HashMap<String, String> result = new HashMap<String, String>(objs.length);
        for (DynamicObject obj : objs) {
            result.put(obj.getPkValue().toString(), obj.getString("name"));
        }
        return result;
    }

    private Map<String, List<String>> getTaskIndexs() {
        if (this.localTaskIndexs != null) {
            return this.localTaskIndexs;
        }
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>();
        HashMap<String, String> appNumIndex = new HashMap<String, String>();
        this.getOriginExtendAppRelMap(originExtendAppRelMap, appNumIndex);
        this.localTaskIndexs = this.getTaskIndexMap(originExtendAppRelMap, appNumIndex);
        return this.localTaskIndexs;
    }

    private Map<String, String> getOriginExtendAppRelMap(Map<String, String> originExtendAppRelMap, Map<String, String> appNumIndex) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allApps) {
            String type = app.getString("type");
            String number = app.getString("number");
            String appId = app.getString("id");
            String nodeId = "app_" + appId;
            if ("0".equals(type)) {
                originExtendAppRelMap.put(nodeId, nodeId);
                appNumIndex.put(number, appId);
                continue;
            }
            String masterId = app.getString("masterid");
            String masterNodeId = "app_" + masterId;
            originExtendAppRelMap.put(nodeId, masterNodeId);
            appNumIndex.put(number, masterId);
        }
        return originExtendAppRelMap;
    }

    private Map<String, List<String>> getTaskIndexMap(Map<String, String> originExtendAppRelMap, Map<String, String> appNumIndex) {
        HashMap<String, List<String>> taskIndex = new HashMap<String, List<String>>();
        String fields = "id,appid";
        try (DataSet ds = ORM.create().queryDataSet("sch_taskdefine", "sch_taskdefine", fields, null, null);){
            for (Row row : ds) {
                String taskId = row.getString("id");
                String appnumber = row.getString("appid");
                String masterId = appNumIndex.get(appnumber);
                if (StringUtils.isBlank((CharSequence)masterId)) continue;
                if (taskIndex.get(masterId) != null) {
                    ((List)taskIndex.get(masterId)).add(taskId);
                    continue;
                }
                ArrayList<String> taskIds = new ArrayList<String>();
                taskIds.add(taskId);
                taskIndex.put(masterId, taskIds);
            }
        }
        return taskIndex;
    }

    static class AppTreeBuilder {
        private TreeNode root = null;
        private boolean onlyChecked = false;
        private String filter = "";
        private Set<String> selectedNodes = new HashSet<String>(3);

        public AppTreeBuilder(TreeNode root, boolean onlyChecked, String filter, Set<String> selectedNodes) {
            this.root = root;
            this.onlyChecked = onlyChecked;
            this.filter = filter;
            this.selectedNodes = selectedNodes;
        }

        public TreeNode build() {
            LinkedHashMap allCloudMap = new LinkedHashMap(10);
            LinkedHashMap allAppMap = new LinkedHashMap(10);
            LinkedHashMap scheduleMap = new LinkedHashMap(10);
            List cloudNodes = this.root.getChildren();
            ArrayList appNodes = new ArrayList(10);
            ArrayList scheduleNodes = new ArrayList(10);
            if (cloudNodes != null) {
                cloudNodes.forEach(n -> {
                    if (!StringUtils.equals((CharSequence)TREENODE_CLOUDMARK, (CharSequence)String.valueOf(n.getData()))) {
                        return;
                    }
                    allCloudMap.put(n.getId(), n);
                    List apps = n.getChildren();
                    if (apps != null) {
                        appNodes.addAll(apps);
                        for (TreeNode app : apps) {
                            allAppMap.put(app.getId(), app);
                            List schedules = app.getChildren();
                            if (schedules == null) continue;
                            scheduleNodes.addAll(schedules);
                        }
                    }
                });
            }
            boolean needFilter = StringUtils.isNotBlank((CharSequence)this.filter);
            scheduleNodes.forEach(n -> {
                if (!StringUtils.equals((CharSequence)"schedule", (CharSequence)String.valueOf(n.getData()))) {
                    return;
                }
                if (needFilter && n.getText() != null && n.getText().contains(this.filter) || !needFilter) {
                    scheduleMap.put(n.getId(), n);
                }
            });
            if (this.onlyChecked) {
                HashSet toDoRemove = new HashSet(scheduleMap.keySet());
                toDoRemove.removeAll(this.selectedNodes);
                toDoRemove.forEach(scheduleMap::remove);
            }
            LinkedHashMap<String, TreeNode> appMap = new LinkedHashMap<String, TreeNode>(10);
            LinkedHashMap<String, TreeNode> cloudMap = new LinkedHashMap<String, TreeNode>(10);
            for (Map.Entry it : scheduleMap.entrySet()) {
                ArrayList<TreeNode> appChilds;
                String pAppid = ((TreeNode)it.getValue()).getParentid();
                TreeNode pAppTree = (TreeNode)appMap.get(pAppid);
                TreeNode orginAppTree = (TreeNode)allAppMap.get(pAppid);
                String pCloudId = orginAppTree.getParentid();
                TreeNode pCloudTree = (TreeNode)cloudMap.get(pCloudId);
                if (pCloudTree == null) {
                    pCloudTree = this.createNewNode((TreeNode)allCloudMap.get(pCloudId));
                    cloudMap.put(pCloudId, pCloudTree);
                    ArrayList cloudChilds = pCloudTree.getChildren();
                    if (cloudChilds == null) {
                        cloudChilds = new ArrayList(10);
                        pCloudTree.setChildren(cloudChilds);
                    }
                }
                if (pAppTree == null) {
                    pAppTree = this.createNewNode(orginAppTree);
                    appMap.put(pAppid, pAppTree);
                    pCloudTree.getChildren().add(pAppTree);
                }
                if ((appChilds = pAppTree.getChildren()) == null) {
                    appChilds = new ArrayList<TreeNode>(10);
                    pAppTree.setChildren(appChilds);
                }
                appChilds.add(this.createNewNode((TreeNode)it.getValue()));
            }
            TreeNode newRoot = this.createNewNode(this.root);
            newRoot.setChildren(new ArrayList(cloudMap.values()));
            for (String nodeId : this.selectedNodes) {
                TreeNode n2 = newRoot.getTreeNode(nodeId);
                if (n2 == null) continue;
                n2.setCheckable(true);
            }
            newRoot.setExpend(true);
            newRoot.setIsOpened(true);
            return newRoot;
        }

        private TreeNode createNewNode(TreeNode node) {
            TreeNode newNode = new TreeNode(node.getParentid(), node.getId(), node.getText(), node.getData());
            newNode.setExpend(node.isExpend());
            newNode.setIsOpened(node.getIsOpened());
            newNode.setCheckable(node.isCheckable());
            return newNode;
        }
    }
}

