/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.utils.ScheduleGrayGroup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ScheduleGrayConfigPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Object pkId = this.getView().getFormShowParameter().getCustomParam("selectId");
        if (StringUtils.isBlank((Object)pkId)) {
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sch_graysetting");
        boolean allApp = obj.getBoolean("iswholeapp");
        String ver = obj.getString("grayver");
        this.getModel().setValue("prodnum", (Object)ver);
        this.getModel().setValue("group", (Object)obj.getString("group"));
        if (allApp) {
            this.getModel().setValue("bizapp", ((DynamicObject)obj.get("bizapp")).getPkValue());
            this.getModel().setValue("type", (Object)"1");
        } else {
            this.getModel().setValue("schedule", (Object)obj.getDynamicObject("schedule"));
            this.getModel().setValue("type", (Object)"0");
        }
    }

    private void adjustViewStatus() {
        FieldEdit bizapp = (FieldEdit)this.getView().getControl("bizapp");
        FieldEdit schedule = (FieldEdit)this.getView().getControl("schedule");
        if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)String.valueOf(this.getModel().getValue("type")))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizapp"});
            if (bizapp != null) {
                bizapp.setMustInput(true);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"schedule"});
            if (schedule != null) {
                schedule.setMustInput(false);
            }
            this.getModel().setValue("schedule", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"schedule"});
            if (schedule != null) {
                schedule.setMustInput(true);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizapp"});
            if (bizapp != null) {
                bizapp.setMustInput(false);
            }
            this.getModel().setValue("bizapp", null);
        }
    }

    public void afterBindData(EventObject e) {
        this.adjustViewStatus();
        Map data = ScheduleGrayGroup.getGrayProdNum();
        ComboEdit prodnum = (ComboEdit)this.getControl("prodnum");
        prodnum.setMustInput(true);
        if (data != null) {
            List items = data.keySet().stream().map(k -> new ComboItem(new LocaleString(k), k)).collect(Collectors.toList());
            prodnum.setComboItems(items);
            if (items.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u7fa4\u4e0d\u5b58\u5728\u7070\u5ea6\u7248\u672c\u8bbe\u7f6e\u3002", (String)"ScheduleGrayConfigPlugin_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("prodnum".equals(e.getProperty().getName())) {
            Object prodNum = e.getChangeSet()[0].getNewValue();
            Map data = ScheduleGrayGroup.getGrayProdNum();
            if (prodNum == null) {
                this.getModel().setValue("group", (Object)"");
            } else {
                Map appGroupMapping = (Map)data.get(prodNum.toString());
                if (appGroupMapping != null && !appGroupMapping.isEmpty()) {
                    String group = appGroupMapping.values().stream().findFirst().orElse("");
                    this.getModel().setValue("group", (Object)group);
                } else {
                    this.getModel().setValue("group", (Object)"");
                }
            }
        } else if ("type".equals(e.getProperty().getName())) {
            this.adjustViewStatus();
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            long userId = RequestContext.get().getCurrUserId();
            if ("btnok".equals(btn.getKey())) {
                ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
                String type = (String)this.getModel().getValue("type");
                if ("1".equals(type)) {
                    DynamicObject bizapp = (DynamicObject)this.getModel().getValue("bizapp");
                    if (bizapp == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528", (String)"ScheduleGrayConfigPlugin_1", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sch_graysetting");
                    obj.set("bizapp", bizapp.getPkValue());
                    obj.set("iswholeapp", (Object)true);
                    obj.set("createdatefield", (Object)new Date());
                    obj.set("modifydatefield", (Object)new Date());
                    obj.set("createrfield", (Object)userId);
                    obj.set("grayver", this.getModel().getValue("prodnum"));
                    Object group = this.getModel().getValue("group");
                    obj.set("group", (Object)(StringUtils.isBlank((Object)group) ? "" : group.toString()));
                    datas.add(obj);
                } else if ("0".equals(type)) {
                    DynamicObject schedule = (DynamicObject)this.getModel().getValue("schedule");
                    if (schedule == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u5ea6\u8ba1\u5212", (String)"ScheduleGrayConfigPlugin_2", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sch_graysetting");
                    obj.set("schedule", schedule.getPkValue());
                    obj.set("iswholeapp", (Object)false);
                    obj.set("createdatefield", (Object)new Date());
                    obj.set("modifydatefield", (Object)new Date());
                    obj.set("createrfield", (Object)userId);
                    obj.set("grayver", this.getModel().getValue("prodnum"));
                    Object group = this.getModel().getValue("group");
                    obj.set("group", (Object)(StringUtils.isBlank((Object)group) ? "" : group.toString()));
                    datas.add(obj);
                }
                Object pkId = this.getView().getFormShowParameter().getCustomParam("selectId");
                if (StringUtils.isNotBlank((Object)pkId)) {
                    BusinessDataWriter.delete((String)"sch_graysetting", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
                }
                OperationServiceHelper.executeOperate((String)"save", (String)"sch_graysetting", (DynamicObject[])datas.toArray(new DynamicObject[datas.size()]));
                this.getView().close();
            } else if ("btncancel".equals(btn.getKey())) {
                this.getView().close();
            }
        }
    }
}

