/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ScheduleJobRunParamPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String PARAMID = "paramid";
    private static final String VISIBLE = "visible";
    private static Log log = LogFactory.getLog(ScheduleJobRunParamPlugin.class);
    private static final String BTCONFIRM = "btconfirm";
    private static final String BTCANCEL = "btcancel";
    private static final String PARAMVALUE = "paramvalue";
    private static final String PARAMDEFVALUE = "paramdefvalue";
    private static final String PARAMCALLBACK = "paramCallBack";
    private static final String PARAMTYPE = "paramtype";
    private static final String SELECT_PROPERTIES = "entryentity,paramname,paramdefvalue,paramvalue,paramtype,basedatainfo,must";
    private static final String PARAMNAME = "paramname";
    private static final String BASEDATAVALUE = "basedatavalue";
    private static final String BASEDATADEFVALUE = "basedatadefvalue";
    private static final String BASEDATAINFO = "basedatainfo";
    private static final String MUST = "must";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTCONFIRM, BTCANCEL, PARAMVALUE});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (BTCONFIRM.equals(key)) {
            DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject entryentity : entryentitys) {
                if (!entryentity.getBoolean(MUST) || !StringUtils.isBlank((Object)entryentity.get(PARAMVALUE))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fd0\u884c\u53c2\u6570%s\u7684\u53c2\u6570\u503c\u4e3a\u5fc5\u586b\u9879\u3002", (String)"ScheduleJobRunParamPlugin_2", (String)"bos-schedule-formplugin", (Object[])new Object[0]), entryentity.get(PARAMNAME)));
                return;
            }
            for (DynamicObject entryentity : entryentitys) {
                this.updateParamValue(entryentity.getString(PARAMID), entryentity.getString(PARAMVALUE), entryentity.getString(BASEDATAINFO));
            }
            String pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
            this.updateJobParams(pkId);
            OperationServiceHelper.executeOperate((String)"save", (String)"sch_job", (Object[])new Object[]{pkId});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fd0\u884c\u53c2\u6570\u4fee\u6539\u6210\u529f\u3002", (String)"ScheduleJobRunParamPlugin_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object pkId = parameter.getCustomParam("pkId");
        if (!StringUtils.isBlank((Object)pkId)) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sch_job", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            DynamicObject dynamicObject = dynamicObjects[0];
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
            DynamicObjectCollection sh_entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            this.bindEntryentityData(dynamicObjectCollection, sh_entryentity);
        }
    }

    private void bindEntryentityData(DynamicObjectCollection dynamicObjectCollection, DynamicObjectCollection sh_entryentity) {
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject row = sh_entryentity.addNew();
            DynamicObject basedataDy = (DynamicObject)dynamicObjectCollection.get(i);
            row.set("seq", (Object)(i + 1));
            row.set(PARAMID, basedataDy.get("id"));
            row.set(PARAMNAME, basedataDy.get(PARAMNAME));
            row.set(PARAMTYPE, basedataDy.get(PARAMTYPE));
            row.set(BASEDATAINFO, basedataDy.get(BASEDATAINFO));
            row.set(MUST, (Object)basedataDy.getBoolean(MUST));
            String paramValue = "";
            if (StringUtils.equals((CharSequence)"8", (CharSequence)((String)basedataDy.get(PARAMTYPE)))) {
                String basedataInfo = (String)basedataDy.get(BASEDATAINFO);
                if (StringUtils.isBlank((CharSequence)basedataInfo)) continue;
                Map basedataInfoMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class);
                Map basedataValueMap = (Map)basedataInfoMap.get(BASEDATAVALUE);
                if (basedataValueMap == null) {
                    basedataValueMap = (Map)basedataInfoMap.get(BASEDATADEFVALUE);
                }
                if (basedataValueMap == null) continue;
                Object number = basedataValueMap.get("number");
                Object id = basedataValueMap.get("id");
                if (id == null) continue;
                DynamicObject basedataValueDy = BusinessDataServiceHelper.loadSingle(id, (String)((String)number));
                ILocaleString name = basedataValueDy.getLocaleString("name");
                paramValue = name.getLocaleValue();
            } else {
                paramValue = (String)basedataDy.get(PARAMVALUE);
            }
            row.set(PARAMVALUE, (Object)paramValue);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Map returnData = (Map)evt.getReturnData();
        if (PARAMCALLBACK.equals(actionId) && returnData != null) {
            Map dataMap = (Map)returnData.get("returnData");
            String basedataInfo = (String)this.getModel().getValue(BASEDATAINFO);
            if (StringUtils.isBlank((CharSequence)basedataInfo)) {
                this.getModel().setValue(PARAMVALUE, dataMap.get(PARAMVALUE));
                return;
            }
            Map basedataInfoMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class);
            basedataInfoMap.put(BASEDATAVALUE, dataMap.get(BASEDATAVALUE));
            if (dataMap.get(PARAMVALUE) != null) {
                this.getModel().setValue(PARAMVALUE, dataMap.get(PARAMVALUE));
                this.getModel().setValue(BASEDATAINFO, (Object)JSON.toJSONString((Object)basedataInfoMap));
            } else {
                this.getModel().setValue(PARAMVALUE, (Object)"");
            }
        }
    }

    public boolean updateParamValue(String id, String paramValue, String basedataInfo) {
        boolean isSuccess = true;
        String sql = "update t_sch_jobparams set FParamValue = ? ,fbasedatainfo = ? where fentryid = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FParamValue", 12, (Object)paramValue), new SqlParameter(":fbasedatainfo", 12, (Object)basedataInfo), new SqlParameter(":fid", 12, (Object)id)};
        Throwable throwable = null;
        try (TXHandle handle = TX.beginNew();){
            boolean bl = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            return bl;
        }
        catch (Exception e) {
            isSuccess = false;
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return isSuccess;
    }

    public boolean updateJobParams(String jobId) {
        boolean isSuccess = true;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)"sch_job");
        if (dynamicObject == null) {
            return false;
        }
        DynamicObjectCollection dyCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        for (DynamicObject dyObject : dyCollection) {
            this.buildParams(paramsMap, dyObject);
        }
        String paramStr = JSON.toJSONString(paramsMap);
        String sql = "update t_sch_job set fparams = ? where fid = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fparams", 12, (Object)paramStr), new SqlParameter(":fid", 12, (Object)jobId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.beginNew();){
            boolean bl = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            return bl;
        }
        catch (Exception e) {
            isSuccess = false;
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return isSuccess;
    }

    private void buildParams(Map<String, String> paramsMap, DynamicObject dyObject) {
        String paramType = dyObject.getString(PARAMTYPE);
        String paramValue = dyObject.getString(PARAMVALUE);
        if (StringUtils.equals((CharSequence)"8", (CharSequence)paramType)) {
            String baseDataInfo = dyObject.getString(BASEDATAINFO);
            if (StringUtils.isNotBlank((CharSequence)baseDataInfo)) {
                Map baseDataInfoMap = (Map)SerializationUtils.fromJsonString((String)baseDataInfo, Map.class);
                Map baseDataValue = (Map)baseDataInfoMap.get(BASEDATAVALUE);
                if (baseDataValue == null || StringUtils.isBlank(baseDataValue.get("id"))) {
                    baseDataValue = (Map)baseDataInfoMap.get(BASEDATADEFVALUE);
                }
                paramValue = JSON.toJSONString((Object)baseDataValue);
            }
        } else if (StringUtils.isBlank((CharSequence)paramValue)) {
            paramValue = dyObject.getString(PARAMDEFVALUE);
        }
        paramsMap.put(dyObject.getString(PARAMNAME), paramValue);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Map basedataInfo;
        Map basedatadefvalue;
        DynamicObjectCollection entryEntitys;
        DynamicObject dynamicObject;
        ChangeData changeData;
        String name = e.getProperty().getName();
        if (PARAMVALUE.equals(name) && StringUtils.isNotBlank((Object)(changeData = e.getChangeSet()[0]).getOldValue()) && StringUtils.isBlank((Object)changeData.getNewValue()) && "8".equals((dynamicObject = (DynamicObject)(entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY)).get(changeData.getRowIndex())).getString(PARAMTYPE)) && StringUtils.isNotBlank((CharSequence)dynamicObject.getString(BASEDATAINFO)) && (basedatadefvalue = (Map)(basedataInfo = (Map)SerializationUtils.fromJsonString((String)dynamicObject.getString(BASEDATAINFO), Map.class)).get(BASEDATAVALUE)) != null) {
            basedatadefvalue.remove("id");
            dynamicObject.set(BASEDATAINFO, (Object)JSON.toJSONString((Object)basedataInfo));
        }
    }
}

