/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.instance.AppGroup;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;

public class ScheduleListPlugin
extends StandardTreeListPlugin {
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.formplugin.ScheduleListPlugin");
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String DEFAULT_APPID = "bos";
    private List<AppInfo> grayAppInfoList = null;

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
        this.setTreeBarVisible(false);
    }

    private void setTreeBarVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnnew"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnedit"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btndel"});
    }

    private List<String> getTaskListFormNode(TreeNode node) {
        Map map = (Map)node.getData();
        List taskList = (List)map.get("taskIds");
        if (taskList != null) {
            return taskList;
        }
        return new ArrayList<String>();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            ListSelectedRowCollection listSelectedData;
            String operaKey = ((AbstractOperate)args.getSource()).getOperateKey();
            if ("disable".equals(operaKey) || "enable".equals(operaKey)) {
                ListSelectedRowCollection col = ((ListView)this.getView()).getSelectedRows();
                if (col.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e!", (String)"ScheduleListPlugin_14", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if ("modify".equals(operaKey) && (listSelectedData = args.getListSelectedData()) != null) {
                boolean status;
                ListSelectedRow listSelectedRow;
                Object primaryKeyValue;
                DynamicObject dynamicObject;
                if (listSelectedData.size() > 1) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8c03\u5ea6\u8ba1\u5212\u8fdb\u884c\u4fee\u6539\u3002", (String)"ScheduleListPlugin_19", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                } else if (listSelectedData.size() == 1 && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)SCH_SCHEDULE, (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue = (listSelectedRow = listSelectedData.get(0)).getPrimaryKeyValue())})) != null && (status = dynamicObject.getBoolean("status"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u7981\u7528\u540e\u518d\u4fee\u6539\u3002", (String)"ScheduleListPlugin_20", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            String operaKey = ((AbstractOperate)args.getSource()).getOperateKey();
            OperationResult operationResult = args.getOperationResult();
            if (operationResult != null) {
                switch (operaKey) {
                    case "disable": {
                        this.setStatus(false, operationResult);
                        break;
                    }
                    case "enable": {
                        this.setStatus(true, operationResult);
                        break;
                    }
                }
            }
        }
    }

    private void executeOnce() {
        ListSelectedRowCollection col = ((ListView)this.getView()).getSelectedRows();
        if (col.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u3002", (String)"ScheduleListPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Object pk = col.get(0).getPrimaryKeyValue();
        DynamicObject schedule = BusinessDataServiceHelper.loadSingle((Object)pk, (String)SCH_SCHEDULE);
        if (schedule == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"ScheduleListPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!schedule.getBoolean("status")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f00\u542f\u8c03\u5ea6\u8ba1\u5212\u3002", (String)"ScheduleListPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject job = schedule.getDynamicObject("job");
        if (job == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"ScheduleListPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!job.getBoolean("status")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u5173\u8054\u7684\u8c03\u5ea6\u4f5c\u4e1a\u3002", (String)"ScheduleListPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (ScheduleService.getInstance() == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u672a\u542f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ScheduleListPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(String.valueOf(job.getPkValue()));
        JobClient.dispatch((JobInfo)jobInfo);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ScheduleListPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void setStatus(boolean isEnable, OperationResult operationResult) {
        List successPkIds = operationResult.getSuccessPkIds();
        if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
            try {
                for (Object scheduleId : successPkIds) {
                    ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                    if (isEnable) {
                        scheduleManager.enableSchedule(scheduleId.toString());
                        continue;
                    }
                    scheduleManager.disableSchedule(scheduleId.toString());
                }
            }
            catch (KDException e) {
                if ("SCHEDULE_PRC_MASTER_LOST".equals(e.getErrorCode().getCode())) {
                    log.warn((Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4e3b\u8282\u70b9\u672a\u51c6\u5907\u597d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScheduleListPlugin_21", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                }
                throw e;
            }
        }
        ((ListView)this.getView()).clearSelection();
        this.getView().updateView("billlistap");
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(e.getNodeId().toString(), 5);
        e.setChildNodes(node.getChildren());
    }

    private void initTree() {
        List<TreeNode> cloudNodes = this.getCloudNodes();
        TreeNode root = new TreeNode();
        root.setId("root");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ScheduleListPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setTreeBarVisible(false);
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String cloudId = appInfo.getCloudId();
                String appId = appInfo.getId();
                TreeNode cloudNode = root.getTreeNode(cloudId, 5);
                TreeNode appNode = root.getTreeNode(appId, 5);
                if (cloudNode == null || appNode != null) continue;
                ArrayList<TreeNode> appTreeNodes = cloudNode.getChildren();
                if (appTreeNodes == null) {
                    appTreeNodes = new ArrayList<TreeNode>(10);
                    cloudNode.setChildren(appTreeNodes);
                }
                appTreeNodes.add(new TreeNode(cloudId, appId, appInfo.getName().toString()));
            }
        }
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>();
        HashMap<String, String> appNumIndex = new HashMap<String, String>();
        this.getOriginExtendAppRelMap(originExtendAppRelMap, appNumIndex);
        Map<String, List<String>> taskIndex = this.getTaskIndexMap(originExtendAppRelMap, appNumIndex);
        Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
        log.info("Cloud is diabled : {}, Appid is diabled : {}, needAdminAppRange : {}, rangeApp size : {}", new Object[]{disabledCloudIds, disabledAppIds, adminAppResult.needAdminAppRange(), adminAppResult.getAppIds() == null ? "null" : Integer.valueOf(adminAppResult.getAppIds().size())});
        if (log.isDebugEnabled()) {
            log.debug("rangeAppIds:{}", (Object)(adminAppResult.getAppIds() == null ? "null" : String.join((CharSequence)",", adminAppResult.getAppIds())));
        }
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            HashMap<String, String> cloudData = new HashMap<String, String>();
            cloudData.put("type", "cloud");
            String cloudId = cloud.getId();
            String cloudNodeId = "cloud_" + cloudId;
            cloud.setId(cloudNodeId);
            cloud.setData(cloudData);
            List apps = cloud.getChildren();
            if (apps == null || disabledCloudIds.contains(cloudId)) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                boolean adminNotCharge;
                TreeNode app = (TreeNode)appIterator.next();
                HashMap<String, Object> appData = new HashMap<String, Object>();
                appData.put("type", "app");
                String appId = app.getId();
                String appNodeId = "app_" + appId;
                boolean bl = adminNotCharge = adminAppResult.needAdminAppRange() && (adminAppResult.getAppIds() == null || !adminAppResult.getAppIds().contains(appId));
                if (disabledAppIds.contains(appId) || adminNotCharge) {
                    appIterator.remove();
                    continue;
                }
                String masterId = (String)originExtendAppRelMap.get(appNodeId);
                appData.put("taskIds", taskIndex.get(masterId));
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData(appData);
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private Map<String, String> getOriginExtendAppRelMap(Map<String, String> originExtendAppRelMap, Map<String, String> appNumIndex) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allApps) {
            String type = app.getString("type");
            String number = app.getString("number");
            String appId = app.getString("id");
            String nodeId = "app_" + appId;
            if ("0".equals(type)) {
                originExtendAppRelMap.put(nodeId, nodeId);
                appNumIndex.put(number, appId);
                continue;
            }
            String masterId = app.getString("masterid");
            String masterNodeId = "app_" + masterId;
            originExtendAppRelMap.put(nodeId, masterNodeId);
            appNumIndex.put(number, masterId);
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String nodeId = "app_" + appInfo.getId();
                originExtendAppRelMap.put(nodeId, nodeId);
                appNumIndex.put(appInfo.getAppId(), appInfo.getId());
            }
        }
        return originExtendAppRelMap;
    }

    private List<AppInfo> getGrayAppInfos() {
        if (this.grayAppInfoList != null) {
            return this.grayAppInfoList;
        }
        this.grayAppInfoList = new ArrayList<AppInfo>(10);
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        if (AppGroup.isGrayUpgrade()) {
            List appInfoStrList = metadataService.loadGrayAppInfoList();
            for (String infoStr : appInfoStrList) {
                if (StringUtils.isBlank((CharSequence)infoStr)) continue;
                AppInfo appInfo = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
                this.grayAppInfoList.add(appInfo);
            }
        }
        return this.grayAppInfoList;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter filter = this.getFilter(nodeId);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private boolean isTopNode(String currNodeId) {
        String rootId = this.getTreeModel().getRoot().getId();
        return StringUtils.equals((CharSequence)rootId, (CharSequence)currNodeId);
    }

    private QFilter getFilter(String nodeId) {
        if (this.isTopNode(nodeId)) {
            return null;
        }
        if (nodeId.contains("cloud_")) {
            return new QFilter("job.taskclassname.id", "in", this.getCloudFilter(nodeId));
        }
        if (nodeId.contains("app_")) {
            return new QFilter("job.taskclassname.id", "in", this.getAppFilter(nodeId));
        }
        return null;
    }

    private List<String> getAppFilter(String appNodeId) {
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(appNodeId, 3);
        ArrayList<String> job = new ArrayList<String>();
        job.addAll(this.getTaskListFormNode(current));
        return job;
    }

    private List<String> getCloudFilter(String cloudNodeId) {
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(cloudNodeId, 3);
        ArrayList<String> job = new ArrayList<String>();
        if (current.getChildren() != null && !current.getChildren().isEmpty()) {
            for (TreeNode node : current.getChildren()) {
                job.addAll(this.getTaskListFormNode(node));
            }
        }
        return job;
    }

    private Map<String, List<String>> getTaskIndexMap(Map<String, String> originExtendAppRelMap, Map<String, String> appNumIndex) {
        HashMap<String, List<String>> taskIndex = new HashMap<String, List<String>>();
        String fields = "id,appid";
        try (DataSet ds = ORM.create().queryDataSet("sch_taskdefine", "sch_taskdefine", fields, null, null);){
            for (Row row : ds) {
                String taskId = row.getString("id");
                String appnumber = row.getString("appid");
                String masterId = appNumIndex.get(appnumber);
                if (StringUtils.isBlank((CharSequence)masterId)) continue;
                masterId = "app_" + masterId;
                if (taskIndex.get(masterId) != null) {
                    ((List)taskIndex.get(masterId)).add(taskId);
                    continue;
                }
                ArrayList<String> taskIds = new ArrayList<String>();
                taskIds.add(taskId);
                taskIndex.put(masterId, taskIds);
            }
        }
        return taskIndex;
    }

    public void setFilter(SetFilterEvent e) {
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
        if (adminAppResult.needAdminAppRange()) {
            List adminAppIds = adminAppResult.getAppIds();
            if (!CollectionUtils.isEmpty((Collection)adminAppIds)) {
                Set<String> adminAppNums = this.convertAppIdToAppNum(adminAppIds);
                this.appendSysApp(adminAppNums);
                QFilter adminFilter = new QFilter("job.taskclassname.appid", "in", adminAppNums);
                e.addCustomQFilter(adminFilter);
            } else {
                QFilter adminFilter = new QFilter("job.taskclassname.appid", "in", Collections.emptyList());
                e.addCustomQFilter(adminFilter);
            }
        } else {
            Set appids = ManageServiceHelper.getDisabledAppIds();
            HashSet<String> set = new HashSet<String>(appids.size());
            for (String appid : appids) {
                String appNum = BizAppServiceHelp.getAppNumByAppId((String)appid);
                set.add(appNum);
            }
            QFilter filter = new QFilter("job.taskclassname.appid", "not in", set);
            e.addCustomQFilter(filter);
        }
    }

    private void appendSysApp(Set<String> adminAppNums) {
        List sysAppNums = PermissionServiceHelper.queryAllSysApp((boolean)true, (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)sysAppNums)) {
            for (String sysAppNum : sysAppNums) {
                if (!adminAppNums.contains(sysAppNum)) continue;
                adminAppNums.add(DEFAULT_APPID);
                break;
            }
        }
    }

    private Set<String> convertAppIdToAppNum(List<String> appIds) {
        appIds.remove("");
        if (appIds.isEmpty()) {
            return Collections.emptySet();
        }
        String sql = String.format("SELECT FNUMBER FROM T_META_BIZAPP WHERE FID IN ('%s')", String.join((CharSequence)"','", appIds));
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            HashSet<String> appNums = new HashSet<String>(appIds.size());
            while (rs.next()) {
                appNums.add(rs.getString("FNUMBER"));
            }
            return appNums;
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent billListHyperLinkClickEvent;
        ListSelectedRow currentRow;
        if (args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent && (currentRow = (billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow()) != null) {
            args.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(SCH_SCHEDULE);
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setPkId(currentRow.getPrimaryKeyValue());
            String pageId = this.getView().getPageCache().get(String.valueOf(currentRow.getPrimaryKeyValue()));
            if (StringUtils.isNotBlank((CharSequence)pageId)) {
                billShowParameter.setPageId(pageId);
            }
            this.getView().showForm((FormShowParameter)billShowParameter);
            if (StringUtils.isBlank((CharSequence)pageId)) {
                this.getView().getPageCache().put(String.valueOf(currentRow.getPrimaryKeyValue()), billShowParameter.getPageId());
            }
        }
    }
}

