/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.IScheduleEntityInvoker;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.ScheduleTypeNextEnums;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.schedule.next.observable.model.ObservableScheduleInfo;
import kd.bos.schedule.server.next.ServerObservableUtils;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.KDDateUtils;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class ScheduleMonitorViewPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
SearchEnterListener {
    private static final String SCH_MONITOR_KRVM = "sch_monitor_krvm";
    private static final String EXECUTOR_ENTRY = "executorentry";
    private static final String THREAD_POOL_ENTRY = "threadpoolentry";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String MASTER_STATUS_ERROR = "masterstatuserror";
    private static final String MASTER_STATUS_RUN = "masterstatusrun";
    private static final String EXE_STATUS_ERROR = "exestatuserror";
    private static final String EXE_STATUS_RUN = "exestatusrun";
    private static final String SCH_NUMBER = "schNumber";
    private static final String SCH_STARTTIME = "schStartTime";
    private static final String SCH_ENDTIME = "schEndTime";
    private static final String SCH_PLAN = "schPlan";
    private static final String SCH_ACCOUNT_ID = "schAccountId";
    private static final String SCH_ACCOUNT_NAME = "schAccountName";
    private static final String SCH_TENANT_ID = "schTenantId";
    private static final String JOB_NUMBER = "jobNumber";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static final String SEARCH_AP = "searchap";
    private static final String LAST_CLICK_LABKEY = "lastClickLabKey";
    private static final String COLOR_RED = "#CC3333";
    private static final String COLOR_DEEP_RED = "#FB2323";
    private static final String COLOR_BLUE = "#1890FF";
    private static final String COLOR_YELLOW = "#FFA940";
    private static final String COLOR_GREEN = "#73d13d";
    private static final String EXECUTOR_IP = "executorip";
    private static final String ISSTARTED = "isstarted";
    private static final String INSTANCE_NAME = "instancename";
    private static final String LABEL_CLICK_BORDER = "1px_solid_#FB2323";
    private static final String EXEIP = "exeip";
    private static final String INSTANCEID = "instanceid";
    private static final String THROUGHPUTONEHOUR = "throughputonehour";
    private static final String INQUEUEONEMIN = "inqueueonemin";
    private static final String OUTQUEUEONEMIN = "outqueueonemin";
    private static final String MQMESSAGE = "mqmessage";
    private static final String MQFUNCTION = "mqfunction";
    private static final String LOCAL_READY_QUEUE_FLEX = "localreadyqueueflex";
    private static final String LOCAL_READY_QUEUE = "localreadyqueue";
    private static final Log logger = LogFactory.getLog(ScheduleMonitorViewPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"min1", "min2", "min3", "min4", "min5", "min6", "hour1", "hour2", "hour3", "hour4", "hour5", "hour6", "day1", "day2", "day3", "day4", "day5", "day6", "month1", "month2", "month3", "month4", "month5", "month6", "week1", "week2", "week3", "week4", "week5", "week6", "year1", "year2", "year3", "year4", "year5", "year6", "def1", "def2", "def3", "def4", "def5", "def6"});
        CardEntry executorEntry = (CardEntry)this.getView().getControl(EXECUTOR_ENTRY);
        executorEntry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getView().getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    public void afterBindData(EventObject e) {
        this.selectFirstExecutorIp();
    }

    private void selectFirstExecutorIp() {
        DynamicObjectCollection executorEntryEntity = this.getModel().getEntryEntity(EXECUTOR_ENTRY);
        if (!executorEntryEntity.isEmpty()) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(EXECUTOR_ENTRY);
            cardEntry.selectRows(0);
        }
    }

    private void loadData() {
        this.loadMasterServerData();
        this.loadExecuteCycleData();
        this.loadExeMachineIp();
        this.loadExecutorServerData();
    }

    private void loadExeMachineIp() {
        List executorServerInfos = null;
        try {
            executorServerInfos = ClientObservableUtils.queryExecutorServerStatus();
            this.fillExeeMachineIp(executorServerInfos);
        }
        catch (Throwable t) {
            logger.error("Schedule***ScheduleMonitorView getExecutorServerStatus fail", t);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6267\u884c\u673a\u6570\u636e\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ScheduleMonitorViewPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void fillExeeMachineIp(List<ExecutorServerInfo> executorServerInfos) {
        this.getModel().deleteEntryData(EXECUTOR_ENTRY);
        if (!CollectionUtils.isEmpty(executorServerInfos)) {
            LinkedList<ExecutorServerInfo> executorQueue = new LinkedList<ExecutorServerInfo>();
            for (ExecutorServerInfo executorServerInfo : executorServerInfos) {
                if (executorServerInfo.isStarted()) {
                    executorQueue.offerLast(executorServerInfo);
                    continue;
                }
                executorQueue.offerFirst(executorServerInfo);
            }
            this.getModel().batchCreateNewEntryRow(EXECUTOR_ENTRY, executorQueue.size());
            DynamicObjectCollection executorEntry = this.getModel().getEntryEntity(EXECUTOR_ENTRY);
            int i = 0;
            while (!executorQueue.isEmpty()) {
                ExecutorServerInfo executorServerInfo = (ExecutorServerInfo)executorQueue.pollFirst();
                DynamicObject dynamicObject = (DynamicObject)executorEntry.get(i);
                dynamicObject.set(EXECUTOR_IP, (Object)executorServerInfo.getName());
                dynamicObject.set(ISSTARTED, (Object)executorServerInfo.isStarted());
                Map detail = executorServerInfo.getDetail();
                if (!CollectionUtils.isEmpty((Map)detail)) {
                    dynamicObject.set(INSTANCE_NAME, detail.get(INSTANCEID));
                }
                if (!executorServerInfo.isStarted()) {
                    this.setExecutorIpErrorStyle(i);
                }
                ++i;
            }
            this.getView().updateView(EXECUTOR_ENTRY);
        }
    }

    private void setExecutorIpErrorStyle(int errorExe) {
        CardEntry executorEntry = (CardEntry)this.getView().getControl(EXECUTOR_ENTRY);
        HashMap<String, String> executorIpMap = new HashMap<String, String>(1);
        executorIpMap.put("fc", COLOR_RED);
        HashMap<String, String> dotPropMap = new HashMap<String, String>(1);
        dotPropMap.put("bc", COLOR_RED);
        HashMap<String, HashMap<String, String>> props = new HashMap<String, HashMap<String, String>>();
        props.put(EXECUTOR_IP, executorIpMap);
        props.put("dot", dotPropMap);
        executorEntry.setCustomProperties(EXECUTOR_ENTRY, errorExe, props);
    }

    private void loadExecutorServerData() {
        String executorIp = "";
        String isStarted = "";
        DynamicObjectCollection executorEntry = this.getModel().getEntryEntity(EXECUTOR_ENTRY);
        if (!CollectionUtils.isEmpty((Collection)executorEntry)) {
            executorIp = ((DynamicObject)executorEntry.get(0)).getString(EXECUTOR_IP);
            isStarted = ((DynamicObject)executorEntry.get(0)).getString(ISSTARTED);
        }
        if (StringUtils.isNotBlank((CharSequence)executorIp)) {
            this.fillExecutorServerData(executorIp, isStarted);
        } else {
            this.setDefaultExecutorEntryData();
        }
    }

    private void setDefaultExecutorEntryData() {
        this.setVisibleAndInVisible(EXE_STATUS_ERROR, EXE_STATUS_RUN);
        this.getModel().setValue(EXEIP, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"ScheduleMonitorViewPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(INSTANCEID, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"ScheduleMonitorViewPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(THROUGHPUTONEHOUR, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"ScheduleMonitorViewPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(INQUEUEONEMIN, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"ScheduleMonitorViewPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(OUTQUEUEONEMIN, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"ScheduleMonitorViewPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(MQMESSAGE, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"ScheduleMonitorViewPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(MQFUNCTION, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"ScheduleMonitorViewPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.setVisibleAndInVisible(LOCAL_READY_QUEUE_FLEX, LOCAL_READY_QUEUE);
        this.getModel().deleteEntryData(THREAD_POOL_ENTRY);
    }

    private void fillExecutorServerData(String executorIp, String isStarted) {
        JSONObject executorServerStatus = null;
        try {
            executorServerStatus = ClientObservableUtils.getExecutorServerStatus((String)executorIp);
        }
        catch (Throwable t) {
            logger.error("Schedule***ScheduleMonitorView getExecutorServerStatus fail", t);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6267\u884c\u673a\u6570\u636e\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ScheduleMonitorViewPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (executorServerStatus != null) {
            this.getModel().setValue(EXEIP, (Object)executorIp);
            if (StringUtils.equalsIgnoreCase((CharSequence)isStarted, (CharSequence)"true")) {
                this.setVisibleAndInVisible(EXE_STATUS_RUN, EXE_STATUS_ERROR);
            } else {
                this.setVisibleAndInVisible(EXE_STATUS_ERROR, EXE_STATUS_RUN);
            }
            this.getModel().setValue(INSTANCEID, executorServerStatus.get((Object)"instanceId"));
            this.getModel().setValue(THROUGHPUTONEHOUR, executorServerStatus.get((Object)"throughPutOneHour"));
            this.getModel().setValue(INQUEUEONEMIN, executorServerStatus.get((Object)"inQueueOneMin"));
            this.getModel().setValue(OUTQUEUEONEMIN, executorServerStatus.get((Object)"outQueueOneMin"));
            JSONObject middlewareStatus = ServerObservableUtils.getMiddlewareStatus();
            Integer mqStatus = middlewareStatus.getInteger("mq");
            this.getModel().setValue(MQMESSAGE, (Object)this.toHealthLevelText(mqStatus));
            this.setTextControlColor(MQMESSAGE, this.toHealthLevelColor(mqStatus));
            this.getModel().setValue(MQFUNCTION, (Object)(executorServerStatus.get((Object)"mqFunction") + "ms"));
            this.setReadyTaskData(executorServerStatus);
            this.setExeThreadPoolStatus(executorServerStatus);
            this.getView().updateView(THREAD_POOL_ENTRY);
        }
    }

    private void setReadyTaskData(JSONObject executorServerStatus) {
        Map exeMachineLocalQueueStatus = (Map)executorServerStatus.get((Object)"exeMachineLocalQueueStatus");
        if (exeMachineLocalQueueStatus != null) {
            MessageType messageType;
            Set messageTypesDataEntry = exeMachineLocalQueueStatus.entrySet();
            HistogramChart histogramChart = (HistogramChart)this.getView().getControl(LOCAL_READY_QUEUE);
            histogramChart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)"ScheduleMonitorViewPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), AxisType.category);
            Axis yaxis = histogramChart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"ScheduleMonitorViewPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), AxisType.value);
            HashMap<String, Object[]> nameTextStyle = new HashMap<String, Object[]>(4);
            nameTextStyle.put("padding", new Object[]{3, 4, 5, 100});
            yaxis.setPropValue("nameTextStyle", nameTextStyle);
            HashMap<MessageType, Integer> yDataMap = new HashMap<MessageType, Integer>(messageTypesDataEntry.size());
            for (Map.Entry entry : messageTypesDataEntry) {
                messageType = null;
                try {
                    messageType = MessageType.valueOf((String)((String)entry.getKey()));
                    if (messageType != MessageType.BIZJOB && messageType != MessageType.REALTIMEJOB && messageType != MessageType.WorkFlowJOB) continue;
                    String yAxisData = (String)entry.getValue();
                    Integer data = StringUtils.isNotBlank((CharSequence)yAxisData) ? Integer.parseInt(yAxisData) : 0;
                    yDataMap.put(messageType, data);
                }
                catch (Exception e) {
                    logger.error("Schedule***\u4e0d\u5b58\u5728\u8be5\u6d88\u606f\u7c7b\u578b\uff0cmessageType={}", entry.getKey(), (Object)e);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u201c%s\u201d\u6d88\u606f\u7c7b\u578b", (String)"", (String)"", (Object[])new Object[0]), entry.getKey()));
                }
            }
            for (Map.Entry entry : yDataMap.entrySet()) {
                messageType = (MessageType)entry.getKey();
                Number yData = (Number)entry.getValue();
                BarSeries series = histogramChart.createSeries(this.getMessageTypeName(messageType));
                series.setColor(this.getColorByMessageType(messageType));
                series.setData(new Number[]{yData});
            }
            histogramChart.setLegendAlign(XAlign.right, YAlign.top);
            histogramChart.bindData(null);
            this.setVisibleAndInVisible(LOCAL_READY_QUEUE, LOCAL_READY_QUEUE_FLEX);
        } else {
            this.setVisibleAndInVisible(LOCAL_READY_QUEUE_FLEX, LOCAL_READY_QUEUE);
        }
    }

    private void setExeThreadPoolStatus(JSONObject executorServerStatus) {
        this.getModel().deleteEntryData(THREAD_POOL_ENTRY);
        Map threadPoolStatusMap = (Map)executorServerStatus.get((Object)"threadPoolStatus");
        if (threadPoolStatusMap != null) {
            Set threadPoolStatusEntry = threadPoolStatusMap.entrySet();
            if (threadPoolStatusEntry.size() != 0) {
                this.getModel().batchCreateNewEntryRow(THREAD_POOL_ENTRY, threadPoolStatusEntry.size());
            }
            int i = 0;
            for (Map.Entry entry : threadPoolStatusEntry) {
                String messageTypeStr = (String)entry.getKey();
                MessageType messageType = null;
                try {
                    messageType = MessageType.valueOf((String)messageTypeStr);
                }
                catch (Exception e) {
                    logger.error("Schedule***\u4e0d\u5b58\u5728\u8be5\u6d88\u606f\u7c7b\u578b\uff0cmessageType={}", (Object)messageTypeStr, (Object)e);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u201c%s\u201d\u6d88\u606f\u7c7b\u578b", (String)"", (String)"", (Object[])new Object[0]), messageTypeStr));
                    continue;
                }
                String threadPoolName = "";
                switch (messageType) {
                    case BIZJOB: {
                        threadPoolName = ResManager.loadKDString((String)"\u5b9a\u65f6\u4efb\u52a1\u7ebf\u7a0b\u6c60", (String)"ScheduleMonitorViewPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                        break;
                    }
                    case WorkFlowJOB: {
                        threadPoolName = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u7ebf\u7a0b\u6c60", (String)"ScheduleMonitorViewPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                        break;
                    }
                    case REALTIMEJOB: {
                        threadPoolName = ResManager.loadKDString((String)"\u5b9e\u65f6\u4efb\u52a1\u7ebf\u7a0b\u6c60", (String)"ScheduleMonitorViewPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        logger.warn("Schedule***\u7ebf\u7a0b\u6c60\u53ea\u653e\u4e1a\u52a1\u3001\u5de5\u4f5c\u6d41\u3001\u5b9e\u65f6\u4efb\u52a1\u7ebf\u7a0b\u6c60\uff0cmessageType={}", (Object)messageType.name());
                    }
                }
                DynamicObject threadPool = this.getModel().getEntryRowEntity(THREAD_POOL_ENTRY, i);
                Map threadPoolStatus = (Map)entry.getValue();
                if (!CollectionUtils.isEmpty((Map)threadPoolStatus) && StringUtils.isNotBlank((CharSequence)threadPoolName)) {
                    threadPool.set("threadpool", (Object)threadPoolName);
                    threadPool.set("maxnum", threadPoolStatus.get("maxNum"));
                    threadPool.set("runningnum", threadPoolStatus.get("runningNum"));
                    threadPool.set("threaderror", threadPoolStatus.get("threadError"));
                    threadPool.set("tasksuccessnum", threadPoolStatus.get("threadTaskSuccess"));
                    StringBuilder threadTaskSuccessFunc = new StringBuilder();
                    threadTaskSuccessFunc.append(threadPoolStatus.get("threadTaskSuccessTime")).append("ms");
                    threadPool.set("threadtasksuccesstime", (Object)threadTaskSuccessFunc.toString());
                }
                ++i;
            }
        }
    }

    private String toHealthLevelColor(int i) {
        String color = i == -1 ? COLOR_RED : (i == 2 ? COLOR_YELLOW : (i == 3 ? COLOR_DEEP_RED : COLOR_BLUE));
        return color;
    }

    private String toHealthLevelText(int i) {
        String text = i == -1 ? ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ScheduleViewPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (i == 1 ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ScheduleViewPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (i == 2 ? ResManager.loadKDString((String)"\u6162", (String)"ScheduleViewPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (i == 3 ? ResManager.loadKDString((String)"\u8d85\u6162", (String)"ScheduleViewPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316", (String)"ScheduleViewPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]))));
        return text;
    }

    private String getMessageTypeName(MessageType messageType) {
        String name = "";
        switch (messageType) {
            case BIZJOB: {
                name = ResManager.loadKDString((String)"\u5b9a\u65f6\u4efb\u52a1", (String)"ScheduleMonitorViewPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case REALTIMEJOB: {
                name = ResManager.loadKDString((String)"\u5b9e\u65f6\u4efb\u52a1", (String)"ScheduleMonitorViewPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case WorkFlowJOB: {
                name = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u4efb\u52a1", (String)"ScheduleMonitorViewPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
        }
        return name;
    }

    private String getColorByMessageType(MessageType messageType) {
        String color;
        switch (messageType) {
            case BIZJOB: {
                color = COLOR_BLUE;
                break;
            }
            case REALTIMEJOB: {
                color = COLOR_YELLOW;
                break;
            }
            default: {
                color = COLOR_GREEN;
            }
        }
        return color;
    }

    private void loadMasterServerData() {
        Map masterServerStatus = null;
        try {
            masterServerStatus = ServerObservableUtils.getMasterServerStatus();
        }
        catch (Throwable t) {
            logger.error("Schedule***ScheduleMonitorView \u83b7\u53d6\u4e3b\u8282\u70b9\u72b6\u6001\u6570\u636e\u5931\u8d25", t);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u670d\u52a1\u5668\u6570\u636e\u5931\u8d25\uff0c\u8be6\u60c5\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ScheduleMonitorViewPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (masterServerStatus != null) {
            Object pushQueueCount = masterServerStatus.get("pushLocalQueue");
            this.getModel().setValue("inqueueeverymin", pushQueueCount == null ? Integer.valueOf(0) : pushQueueCount);
            Object popQueueCount = masterServerStatus.get("popLocalQueue");
            this.getModel().setValue("outqueueeverymin", popQueueCount == null ? Integer.valueOf(0) : popQueueCount);
            Object dispatchJobCount = masterServerStatus.get("dispatchJobSuccess");
            this.getModel().setValue("throughputeverymin", dispatchJobCount == null ? Integer.valueOf(0) : dispatchJobCount);
            Object scheduleFrequency = masterServerStatus.get("scheduleFrequency");
            this.getModel().setValue("schfrequency", scheduleFrequency == null ? Integer.valueOf(0) : scheduleFrequency);
            Object masterStartTime = masterServerStatus.get("masterStartTime");
            this.getModel().setValue("mastertime", masterStartTime);
            try {
                if (masterStartTime instanceof String) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                    Date date = dateFormat.parse((String)masterStartTime);
                    this.getModel().setValue("mastertime1", (Object)date);
                }
            }
            catch (ParseException dateFormat) {
                // empty catch block
            }
            Object masterServerIP = masterServerStatus.get("masterServerIP");
            this.getModel().setValue("masterip", masterServerIP);
            Boolean masterIsStarted = (Boolean)masterServerStatus.get("masterIsStarted");
            if (!masterIsStarted.booleanValue()) {
                this.setVisibleAndInVisible(MASTER_STATUS_ERROR, MASTER_STATUS_RUN);
            } else {
                this.setVisibleAndInVisible(MASTER_STATUS_RUN, MASTER_STATUS_ERROR);
            }
        } else {
            this.setVisibleAndInVisible(MASTER_STATUS_ERROR, MASTER_STATUS_RUN);
        }
    }

    private void setVisibleAndInVisible(String visibleKey, String inVisibleKey) {
        HashMap<String, Integer> inVisible = new HashMap<String, Integer>(1);
        inVisible.put("vi", 0);
        HashMap<String, Integer> visible = new HashMap<String, Integer>(1);
        visible.put("vi", 63);
        this.getView().updateControlMetadata(visibleKey, visible);
        this.getView().updateControlMetadata(inVisibleKey, inVisible);
    }

    private void loadExecuteCycleData() {
        Map allCycleDatas = null;
        try {
            allCycleDatas = ServerObservableUtils.getScheduleCycleData();
        }
        catch (Throwable t) {
            logger.error("Schedule***\u83b7\u53d6\u6267\u884c\u5468\u671f\u6570\u636e\u51fa\u73b0\u5f02\u5e38", t);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u8c03\u5ea6\u6267\u884c\u5468\u671f\u5206\u5e03\u56fe\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScheduleMonitorViewPlugin_15", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (CollectionUtils.isEmpty((Map)allCycleDatas)) {
            logger.info("Schedule***ScheduleMonitorViewPlugin no cycleDatas");
            return;
        }
        HashMap<String, Object> labKeyRelationValueMap = new HashMap<String, Object>();
        for (Map.Entry allCycleData : allCycleDatas.entrySet()) {
            String repeatMode = (String)allCycleData.getKey();
            ScheduleTypeNextEnums scheduleType = ScheduleTypeNextEnums.valueOf((String)repeatMode);
            switch (scheduleType) {
                case Seconds: {
                    break;
                }
                case Minutes: {
                    this.fillExecutorCycleData((Map)allCycleData.getValue(), "min", labKeyRelationValueMap);
                    break;
                }
                case Hours: {
                    this.fillExecutorCycleData((Map)allCycleData.getValue(), "hour", labKeyRelationValueMap);
                    break;
                }
                case Days: {
                    this.fillExecutorCycleData((Map)allCycleData.getValue(), "day", labKeyRelationValueMap);
                    break;
                }
                case Weeks: {
                    this.fillExecutorCycleData((Map)allCycleData.getValue(), "week", labKeyRelationValueMap);
                    break;
                }
                case Months: {
                    this.fillExecutorCycleData((Map)allCycleData.getValue(), "month", labKeyRelationValueMap);
                    break;
                }
                case Years: {
                    this.fillExecutorCycleData((Map)allCycleData.getValue(), "year", labKeyRelationValueMap);
                    break;
                }
                case Other: {
                    this.fillExecutorCycleData((Map)allCycleData.getValue(), "", labKeyRelationValueMap);
                    break;
                }
            }
        }
        if (!CollectionUtils.isEmpty(labKeyRelationValueMap)) {
            this.getView().getPageCache().put(SCH_MONITOR_KRVM, SerializationUtils.toJsonString(labKeyRelationValueMap));
        }
        this.fillDefaultPlanEntryEntity(allCycleDatas);
    }

    private void fillDefaultPlanEntryEntity(Map<String, Map<String, Integer>> allCycleDatas) {
        String repeatMode = "";
        String cron = "";
        if (allCycleDatas.get(ScheduleTypeNextEnums.Years.name()) != null) {
            repeatMode = ScheduleTypeNextEnums.Years.name();
        }
        if (allCycleDatas.get(ScheduleTypeNextEnums.Months.name()) != null) {
            repeatMode = ScheduleTypeNextEnums.Months.name();
        }
        if (allCycleDatas.get(ScheduleTypeNextEnums.Weeks.name()) != null) {
            repeatMode = ScheduleTypeNextEnums.Weeks.name();
        }
        if (allCycleDatas.get(ScheduleTypeNextEnums.Days.name()) != null) {
            repeatMode = ScheduleTypeNextEnums.Days.name();
        }
        if (allCycleDatas.get(ScheduleTypeNextEnums.Hours.name()) != null) {
            repeatMode = ScheduleTypeNextEnums.Hours.name();
        }
        if (allCycleDatas.get(ScheduleTypeNextEnums.Minutes.name()) != null) {
            repeatMode = ScheduleTypeNextEnums.Minutes.name();
        }
        if (StringUtils.isNotBlank((CharSequence)repeatMode)) {
            Map<String, Integer> firstCycleDatas = allCycleDatas.get(repeatMode);
            if (!CollectionUtils.isEmpty(firstCycleDatas)) {
                String cyclePeriod = "";
                Iterator<Map.Entry<String, Integer>> iterator = firstCycleDatas.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    cyclePeriod = (String)entry.getKey();
                }
                List scheduleDist = null;
                try {
                    scheduleDist = ServerObservableUtils.getScheduleDist((String)repeatMode, (String)cron, (String)cyclePeriod);
                }
                catch (Throwable t) {
                    logger.error("Schedule***ScheduleMonitorView getscheduleDist fail", t);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5bf9\u5e94\u8ba1\u5212\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ScheduleMonitorViewPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (!CollectionUtils.isEmpty((Collection)scheduleDist)) {
                    this.fillPlanEntryEntity(scheduleDist);
                }
            }
            String firstDisplayLabelKey = "";
            switch (repeatMode) {
                case "Minutes": {
                    firstDisplayLabelKey = "min1";
                    break;
                }
                case "Hours": {
                    firstDisplayLabelKey = "hour1";
                    break;
                }
                case "Days": {
                    firstDisplayLabelKey = "day1";
                    break;
                }
                case "Weeks": {
                    firstDisplayLabelKey = "week1";
                    break;
                }
                case "Months": {
                    firstDisplayLabelKey = "month1";
                    break;
                }
                case "Years": {
                    firstDisplayLabelKey = "year1";
                    break;
                }
            }
            this.getView().getPageCache().put(LAST_CLICK_LABKEY, firstDisplayLabelKey);
            this.setCycleLabelBorderStyle(firstDisplayLabelKey);
        }
    }

    private void fillExecutorCycleData(Map<String, Integer> cycleDatas, String cycleMode, Map<String, Object> labKeyRelationValueMap) {
        int i = 1;
        for (Map.Entry<String, Integer> cycleData : cycleDatas.entrySet()) {
            if (i > 6) continue;
            Label cycleLab = null;
            cycleLab = StringUtils.isNotBlank((CharSequence)cycleMode) ? (Label)this.getView().getControl(cycleMode + i) : (Label)this.getView().getControl("def" + i);
            if (cycleLab != null) {
                StringBuilder labText = new StringBuilder();
                if (cycleData.getValue() > 99) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("fc", COLOR_RED);
                    this.getView().updateControlMetadata(cycleLab.getKey(), props);
                }
                labText.append(cycleData.getKey()).append(cycleMode).append("(").append(cycleData.getValue()).append(")");
                cycleLab.setText(labText.toString());
                labKeyRelationValueMap.put(cycleLab.getKey(), cycleData.getKey());
            }
            ++i;
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Label) {
            try {
                this.executeCycleLabClick(evt);
            }
            catch (Exception e) {
                logger.error("Schedule***\u83b7\u53d6\u5bf9\u5e94\u8c03\u5ea6\u8ba1\u5212\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getSource() instanceof CardEntry) {
            int row = evt.getRow();
            DynamicObject executorEntry = this.getModel().getEntryRowEntity(EXECUTOR_ENTRY, row);
            String executorIp = executorEntry.getString(EXECUTOR_IP);
            String isStarted = executorEntry.getString(ISSTARTED);
            if (StringUtils.isNotBlank((CharSequence)executorIp)) {
                this.fillExecutorServerData(executorIp, isStarted);
            }
        }
    }

    private void executeCycleLabClick(EventObject evt) {
        Label label = (Label)evt.getSource();
        String labelKey = label.getKey();
        String lastClickLabkey = this.getPageCache().get(LAST_CLICK_LABKEY);
        if (StringUtils.isNotBlank((CharSequence)lastClickLabkey)) {
            this.setCycleLabelDefaultBorderStyle(lastClickLabkey);
        }
        this.setCycleLabelBorderStyle(labelKey);
        this.getPageCache().put(LAST_CLICK_LABKEY, labelKey);
        String krvmStr = this.getView().getPageCache().get(SCH_MONITOR_KRVM);
        Map labKeyRelationValueMap = null;
        if (StringUtils.isNotBlank((CharSequence)krvmStr)) {
            labKeyRelationValueMap = (Map)SerializationUtils.fromJsonString((String)krvmStr, Map.class);
        }
        String cyclePeriodOrCron = "";
        if (labKeyRelationValueMap != null) {
            cyclePeriodOrCron = (String)labKeyRelationValueMap.get(labelKey);
        }
        String repeat = labelKey.substring(0, labelKey.length() - 1);
        String repeatMode = "";
        switch (repeat) {
            case "min": {
                repeatMode = ScheduleTypeNextEnums.Minutes.name();
                break;
            }
            case "hour": {
                repeatMode = ScheduleTypeNextEnums.Hours.name();
                break;
            }
            case "day": {
                repeatMode = ScheduleTypeNextEnums.Days.name();
                break;
            }
            case "month": {
                repeatMode = ScheduleTypeNextEnums.Months.name();
                break;
            }
            case "week": {
                repeatMode = ScheduleTypeNextEnums.Weeks.name();
                break;
            }
            case "year": {
                repeatMode = ScheduleTypeNextEnums.Years.name();
                break;
            }
            case "def": {
                repeatMode = ScheduleTypeNextEnums.Other.name();
            }
        }
        String cron = "";
        String cyclePeriod = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)repeatMode, (CharSequence)"Other")) {
            cron = cyclePeriodOrCron;
        } else {
            cyclePeriod = StringUtils.isNotBlank((CharSequence)cyclePeriodOrCron) ? cyclePeriodOrCron : "0";
        }
        List scheduleDist = null;
        try {
            scheduleDist = ServerObservableUtils.getScheduleDist((String)repeatMode, (String)cron, (String)cyclePeriod);
        }
        catch (Throwable t) {
            logger.error("Schedule***ScheduleMonitorView getscheduleDist fail", t);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5bf9\u5e94\u8ba1\u5212\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ScheduleMonitorViewPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)scheduleDist)) {
            this.fillPlanEntryEntity(scheduleDist);
        }
    }

    private void setCycleLabelDefaultBorderStyle(String lastClickLabkey) {
        HashMap labelStyle = new HashMap(1);
        HashMap borderStyle = new HashMap(1);
        HashMap<String, String> border = new HashMap<String, String>(4);
        border.put("b", "");
        border.put("l", "");
        border.put("r", "");
        border.put("t", "");
        borderStyle.put("b", border);
        labelStyle.put("s", borderStyle);
        this.getView().updateControlMetadata(lastClickLabkey, labelStyle);
    }

    private void setCycleLabelBorderStyle(String key) {
        HashMap labelStyle = new HashMap(1);
        HashMap style = new HashMap(1);
        HashMap<String, String> border = new HashMap<String, String>(4);
        border.put("b", LABEL_CLICK_BORDER);
        border.put("l", LABEL_CLICK_BORDER);
        border.put("r", LABEL_CLICK_BORDER);
        border.put("t", LABEL_CLICK_BORDER);
        style.put("b", border);
        labelStyle.put("s", style);
        this.getView().updateControlMetadata(key, labelStyle);
    }

    private void setTextControlColor(String key, String color) {
        HashMap<String, String> colorStyle = new HashMap<String, String>(1);
        colorStyle.put("fc", color);
        this.getView().updateControlMetadata(key, colorStyle);
    }

    private void fillPlanEntryEntity(List<ObservableScheduleInfo> scheduleDist) {
        DynamicObject dynamicObject;
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, scheduleDist.size());
        List<Map<String, Object>> scheduleInfos = this.getScheduleNumber(scheduleDist);
        DynamicObjectCollection newSchEntry = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int i = 0;
        for (Map<String, Object> scheduleInfo : scheduleInfos) {
            dynamicObject = (DynamicObject)newSchEntry.get(i);
            dynamicObject.set("schedulenumber", scheduleInfo.get(SCH_NUMBER));
            dynamicObject.set("jobnumber", scheduleInfo.get(JOB_NUMBER));
            dynamicObject.set("cron", scheduleInfo.get(SCH_PLAN));
            dynamicObject.set("accountid", scheduleInfo.get(SCH_ACCOUNT_ID));
            dynamicObject.set("tenantid", scheduleInfo.get(SCH_TENANT_ID));
            dynamicObject.set("accountname", scheduleInfo.get(SCH_ACCOUNT_NAME));
            StringBuilder lastThreeExecuteTime = new StringBuilder();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
                cronTriggerImpl.setCronExpression(String.valueOf(scheduleInfo.get(SCH_PLAN)));
                Date startDate = (Date)scheduleInfo.get(SCH_STARTTIME);
                Calendar now = Calendar.getInstance();
                if (now.getTime().after(startDate)) {
                    startDate = now.getTime();
                }
                cronTriggerImpl.setStartTime(startDate);
                Date endTime = (Date)scheduleInfo.get(SCH_ENDTIME);
                if (startDate.after(endTime)) {
                    dynamicObject.set("lastthreeexetime", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u5ea6\u8ba1\u5212\u5df2\u5931\u6548", (String)"ScheduleMonitorViewPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    ++i;
                    continue;
                }
                cronTriggerImpl.setEndTime(endTime);
                List dateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)3);
                if (CollectionUtils.isEmpty((Collection)dateList)) {
                    dynamicObject.set("lastthreeexetime", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u5ea6\u8ba1\u5212\u5df2\u5931\u6548", (String)"ScheduleMonitorViewPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    ++i;
                    continue;
                }
                for (Date date : dateList) {
                    lastThreeExecuteTime.append(dateFormat.format(date)).append("\r\n");
                }
            }
            catch (ParseException e) {
                lastThreeExecuteTime.append(ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u9519\u8bef", (String)"ScheduleMonitorViewPlugin_14", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
            dynamicObject.set("lastthreeexetime", (Object)lastThreeExecuteTime.toString());
            ++i;
        }
        if (scheduleDist.size() > 0) {
            for (ObservableScheduleInfo observableScheduleInfo : scheduleDist) {
                if (i >= newSchEntry.size()) continue;
                dynamicObject = (DynamicObject)newSchEntry.get(i);
                dynamicObject.set("schedulenumber", (Object)observableScheduleInfo.getScheduleId());
                dynamicObject.set("jobnumber", (Object)observableScheduleInfo.getJobId());
                dynamicObject.set("accountid", (Object)observableScheduleInfo.getAccountId());
                dynamicObject.set("tenantid", (Object)observableScheduleInfo.getTenantId());
                dynamicObject.set("accountname", (Object)observableScheduleInfo.getAccountName());
                ++i;
            }
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private List<Map<String, Object>> getScheduleNumber(List<ObservableScheduleInfo> originObservableScheduleInfoList) {
        IScheduleEntityInvoker invoker = ScheduleDataEntityUtils.getInvoker();
        ArrayList<Map<String, Object>> scheduleInfos = new ArrayList<Map<String, Object>>(16);
        try {
            if (!CollectionUtils.isEmpty(originObservableScheduleInfoList)) {
                String accountId = RequestContext.get().getAccountId();
                String tenantId = RequestContext.get().getTenantId();
                ArrayList<ObservableScheduleInfo> currentAccountData = new ArrayList<ObservableScheduleInfo>();
                ArrayList<String> scheduleIdList = new ArrayList<String>(originObservableScheduleInfoList.size());
                ArrayList<String> jobIdList = new ArrayList<String>(originObservableScheduleInfoList.size());
                Iterator<ObservableScheduleInfo> iterator = originObservableScheduleInfoList.iterator();
                while (iterator.hasNext()) {
                    ObservableScheduleInfo observableScheduleInfo = iterator.next();
                    if (!StringUtils.equals((CharSequence)accountId, (CharSequence)observableScheduleInfo.getAccountId()) || !StringUtils.equals((CharSequence)tenantId, (CharSequence)observableScheduleInfo.getTenantId())) continue;
                    if (!scheduleIdList.contains(observableScheduleInfo.getScheduleId())) {
                        scheduleIdList.add(observableScheduleInfo.getScheduleId());
                    }
                    if (!jobIdList.contains(observableScheduleInfo.getJobId())) {
                        jobIdList.add(observableScheduleInfo.getJobId());
                    }
                    currentAccountData.add(observableScheduleInfo);
                    iterator.remove();
                }
                logger.debug("Schedule*** monitor view \u5f53\u524d\u79df\u6237\u8d26\u5957\u7684\u6570\u636e:{}\uff0c\u8ba1\u5212id\u5927\u5c0f = {}\uff0c\u4f5c\u4e1aid\u5927\u5c0f = {}", new Object[]{currentAccountData.size(), scheduleIdList.size(), jobIdList.size()});
                Object[] scheduleIds = scheduleIdList.toArray();
                Object[] jobIds = jobIdList.toArray();
                Map scheduleObjs = invoker.loadFromCache(SchEntityType.Schedule, scheduleIds, "number,starttime,endtime,plan");
                Map jobObjs = invoker.loadFromCache(SchEntityType.Job, jobIds, "number");
                if (!CollectionUtils.isEmpty((Map)scheduleObjs) && !CollectionUtils.isEmpty((Map)jobObjs)) {
                    logger.debug("Schedule***monitor view scheduleObjs size:{},jobObjs:{}", (Object)scheduleObjs.size(), (Object)jobObjs.size());
                    for (ObservableScheduleInfo observableScheduleInfo : currentAccountData) {
                        DynamicObject scheduleObj = (DynamicObject)scheduleObjs.get(observableScheduleInfo.getScheduleId());
                        DynamicObject jobObj = (DynamicObject)jobObjs.get(observableScheduleInfo.getJobId());
                        if (scheduleObj != null && jobObj != null) {
                            HashMap<String, Object> scheduleInfo = new HashMap<String, Object>(5);
                            scheduleInfo.put(SCH_NUMBER, scheduleObj.getString("number"));
                            scheduleInfo.put(SCH_STARTTIME, scheduleObj.getDate("starttime"));
                            scheduleInfo.put(SCH_ENDTIME, scheduleObj.getDate("endtime"));
                            scheduleInfo.put(SCH_PLAN, scheduleObj.getString("plan"));
                            scheduleInfo.put(SCH_ACCOUNT_ID, observableScheduleInfo.getAccountId());
                            scheduleInfo.put(SCH_TENANT_ID, observableScheduleInfo.getTenantId());
                            scheduleInfo.put(SCH_ACCOUNT_NAME, observableScheduleInfo.getAccountName());
                            scheduleInfo.put(JOB_NUMBER, jobObj.getString("number"));
                            scheduleInfos.add(scheduleInfo);
                            continue;
                        }
                        logger.debug("Schedule***monitor view \u6ca1\u6709\u67e5\u51fa\u5bf9\u5e94\u7684\u8ba1\u5212\uff1a{}", (Object)observableScheduleInfo);
                        originObservableScheduleInfoList.add(observableScheduleInfo);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Schedule***ScheduleMonitorView.getScheduleNumber\u6839\u636e\u8ba1\u5212id\u67e5\u8be2\u8ba1\u5212\u7f16\u7801\u9519\u8bef", t);
        }
        return scheduleInfos;
    }

    private void setYAxisData(BarSeries series, Map<String, String> exeMachineLocalQueueStatus, String messageTypeName, String color) {
        String yAxisData = exeMachineLocalQueueStatus.get(messageTypeName);
        Integer data = StringUtils.isNotBlank((CharSequence)yAxisData) ? Integer.parseInt(yAxisData) : 0;
        ItemValue itemValue = new ItemValue((Number)data, color);
        series.addData(itemValue);
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)source.getKey())) {
            List executorServerInfos;
            if (!ZkConfig.isMqAppSplit()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u7fa4\u4e0d\u662f\u5206\u5e94\u7528\u90e8\u7f72\u6a21\u5f0f\u6216\u8005\u5f53\u524d\u96c6\u7fa4\u8c03\u5ea6\u670d\u52a1\u672a\u5f00\u542fMQ\u5206\u5e94\u7528\u8def\u7531\uff0c\u65e0\u6cd5\u6309\u5e94\u7528\u641c\u7d22\u3002", (String)"ScheduleMonitorViewPlugin_17", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String searchAppId = evt.getText();
            try {
                executorServerInfos = StringUtils.isNotBlank((CharSequence)searchAppId) ? ClientObservableUtils.queryExecutorServerStatus((String)searchAppId) : ClientObservableUtils.queryExecutorServerStatus();
            }
            catch (Throwable t) {
                logger.error("Schedule***ScheduleMonitorView getExecutorServerStatus fail", t);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6267\u884c\u673a\u6570\u636e\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ScheduleMonitorViewPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.fillExeeMachineIp(executorServerInfos);
            this.loadExecutorServerData();
            this.selectFirstExecutorIp();
        }
    }
}

