/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.SchCheckResult;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.schedule.server.next.ServerObservableUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.schedule.ScheduleDataEntityInvoker;
import org.apache.commons.lang3.time.DateUtils;

public class ScheduleViewPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
ListboxClickListener {
    private static Log log = LogFactory.getLog(ScheduleViewPlugin.class);
    private static final String TAKENAME = "takename";
    private static final String SCHTASKNAME = "schtaskname";
    private static final String CACHE_SCHTASKNAME = "cache.schtaskname";
    private static final String CACHE_COST_TIME_TASKS = "cache.costTimeTasks";
    private static final String SCHRECENTNAME = "schrecentname";
    private static final String CACHE_RECENT_TASKS = "cache.recentTasks";
    private static final String CACHE_EXCEPTIONLOG = "cache.exceptionlog";
    private static final String ERRORNAME = "errorname";
    private static final String COLOR_BLUE = "#1890FF";
    private static final String COLOR_DEEP_RED = "#FB2323";
    private static final String COLOR_RED = "#F57582";
    private static final String COLOR_YELLOW = "#FFA940";
    private static final String COLOR_GREEN = "#73d13d";
    private static String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static String TASKSTATUSLISTBOX = "taskstatusListbox";
    private static String TAKELISTBOX = "takeListbox";
    private static String SCHTASKLISTBOX = "schtaskListbox";
    private static String EXCUTETASKNUMLISTBOX = "excutetasknumListbox";
    private static final String PAGETYPE_SCHMONITORVIEW = "pagetype_schmonitorview";
    private static final String PAGETYPE_SCHTASKORDERBYCOSTTIME = "pagetype_schtaskorderbycosttime";
    private static final String PAGETYPE_EXCEPTION_LOG = "pagetype_exceptionlog";
    private static final String PAGETYPE_SCH_TASK = "pagetype_schtask";
    private static final String PAGETYPE_SHOW_SCH_TASK_DETAIL = "pagetype_showschtaskdetail";
    private static final String PAGETYPE_SCHTASKNAME_CLICK = "pagetype_schtasknameclick";

    public void registerListener(EventObject e) {
        int i;
        String namekey = TAKENAME;
        for (i = 1; i < 6; ++i) {
            this.addClickListeners(new String[]{namekey + i});
        }
        namekey = SCHTASKNAME;
        for (i = 1; i < 6; ++i) {
            this.addClickListeners(new String[]{namekey + i});
        }
        namekey = SCHRECENTNAME;
        for (i = 1; i < 6; ++i) {
            this.addClickListeners(new String[]{namekey + i});
        }
        namekey = ERRORNAME;
        for (i = 1; i < 6; ++i) {
            this.addClickListeners(new String[]{namekey + i});
        }
        this.addClickListeners(new String[]{"refresh_willexcutetask"});
        this.addClickListeners(new String[]{"refresh_middleware"});
        this.addClickListeners(new String[]{"refresh_master"});
        this.addClickListeners(new String[]{"refresh_executor"});
        this.addClickListeners(new String[]{"refresh_recenttasks"});
        this.addClickListeners(new String[]{"refresh_exceptionlog"});
        this.addClickListeners(new String[]{"labelap", "excutesta"});
        this.addClickListeners(new String[]{"labelap4"});
    }

    public void initialize() {
        this.addClickListeners(new String[]{"schrecentbt", "errorbt"});
        Listbox taskstatusListbox = (Listbox)this.getControl(TASKSTATUSLISTBOX);
        taskstatusListbox.addListboxClickListener((ListboxClickListener)this);
        Listbox takeListbox = (Listbox)this.getControl(TAKELISTBOX);
        takeListbox.addListboxClickListener((ListboxClickListener)this);
        Listbox schtaskListbox = (Listbox)this.getControl(SCHTASKLISTBOX);
        schtaskListbox.addListboxClickListener((ListboxClickListener)this);
        Listbox excutetasknumListbox = (Listbox)this.getControl(EXCUTETASKNUMLISTBOX);
        excutetasknumListbox.addListboxClickListener((ListboxClickListener)this);
    }

    public void listboxClick(ListboxEvent event) {
        String itemId;
        switch (itemId = event.getItemId()) {
            case "taskstatusmonth": {
                this.bindTaskStatus(-30);
                break;
            }
            case "taskstatusweek": {
                this.bindTaskStatus(-7);
                break;
            }
            case "taskstatusday": {
                this.bindTaskStatus(-1);
                break;
            }
            case "takemonth": {
                this.bindSchCostTime(-30);
                break;
            }
            case "takeweek": {
                this.bindSchCostTime(-7);
                break;
            }
            case "takeday": {
                this.bindSchCostTime(-1);
                break;
            }
            case "schtaskmonth": {
                this.bindSchTaskNumber(-30);
                break;
            }
            case "schtaskweek": {
                this.bindSchTaskNumber(-7);
                break;
            }
            case "schtaskday": {
                this.bindSchTaskNumber(-1);
                break;
            }
            case "excutetasknummonth": {
                this.bindExcuteTaskNumber(-30);
                break;
            }
            case "excutetasknumweek": {
                this.bindExcuteTaskNumber(-7);
                break;
            }
            case "excutetasknumday": {
                this.bindExcuteTaskNumber(-1);
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("schrecentbt".equals(key)) {
            this.showPage_SchTask();
        } else if ("errorbt".equals(key)) {
            this.showPage_ExceptionLog();
        } else if (key.startsWith(TAKENAME)) {
            this.takenameClick(key);
        } else if (key.startsWith(SCHTASKNAME)) {
            this.schtasknameClick(key);
        } else if (key.startsWith(SCHRECENTNAME)) {
            this.schrecentnameClick(key);
        } else if (key.startsWith(ERRORNAME)) {
            this.errornameClick(key);
        } else if ("refresh_willexcutetask".equals(key)) {
            this.bindWillexcutetask();
        } else if ("refresh_middleware".equals(key)) {
            this.bindMiddleware();
        } else if ("refresh_master".equals(key)) {
            this.bindMaster();
        } else if ("refresh_executor".equals(key)) {
            this.bindExecutor();
        } else if ("refresh_recenttasks".equals(key)) {
            this.bindRecentTasks();
        } else if ("refresh_exceptionlog".equals(key)) {
            this.bindExceptionlog(-1);
        } else if ("labelap".equals(key) || "excutesta".equals(key)) {
            this.showPage_SchMonitorView();
        } else if ("labelap4".equals(key)) {
            this.showPage_SchTaskOrderByCostTime();
        }
    }

    private void showPage_SchTask() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("sch_task");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.showPageOneWindow((FormShowParameter)parameter, PAGETYPE_SCH_TASK);
    }

    private void showPage_ExceptionLog() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("sch_errorjob");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.showPageOneWindow((FormShowParameter)parameter, PAGETYPE_EXCEPTION_LOG);
    }

    private void showPage_SchTaskOrderByCostTime() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("sch_task");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setOrderBy("costtime desc");
        listFilterParameter.setFilter(new QFilter("costtime", "is not null", null));
        parameter.setListFilterParameter(listFilterParameter);
        this.showPageOneWindow((FormShowParameter)parameter, PAGETYPE_SCHTASKORDERBYCOSTTIME);
    }

    private void showPage_SchMonitorView() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("sch_monitor_view");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.showPageOneWindow(parameter, PAGETYPE_SCHMONITORVIEW);
    }

    private void takenameClick(String key) {
        String str = this.getPageCache().get(CACHE_COST_TIME_TASKS);
        if (StringUtils.isEmpty((CharSequence)str)) {
            log.warn("cache.costTimeTasks from pagecache is null");
            return;
        }
        List costTimeTasks = SerializationUtils.fromJsonStringToList((String)str, String.class);
        int index = Integer.parseInt(key.substring(TAKENAME.length()));
        if (costTimeTasks.size() + 1 < index) {
            log.warn("cache.costTimeTasks from pagecache size < index .size = {}, index = {}", (Object)costTimeTasks.size(), (Object)index);
            return;
        }
        String taskId = (String)costTimeTasks.get(index - 1);
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            log.warn("taskId is null and index is {}", (Object)index);
            return;
        }
        this.showSchTaskDetail(taskId);
    }

    private void showSchTaskDetail(String taskId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("sch_task");
        parameter.setPkId((Object)taskId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.showPageOneWindow((FormShowParameter)parameter, PAGETYPE_SHOW_SCH_TASK_DETAIL + taskId);
    }

    private void schtasknameClick(String key) {
        String str = this.getPageCache().get(CACHE_SCHTASKNAME);
        if (StringUtils.isEmpty((CharSequence)str)) {
            log.warn("cache.schtaskname from pagecache is null");
            return;
        }
        List list = SerializationUtils.fromJsonStringToList((String)str, String.class);
        int index = Integer.parseInt(key.substring(SCHTASKNAME.length()));
        if (list.size() + 1 < index) {
            log.warn("cache.schtaskname from pagecache size < index .size = {}, index = {}", (Object)list.size(), (Object)index);
            return;
        }
        String id = (String)list.get(index - 1);
        if (StringUtils.isEmpty((CharSequence)id)) {
            log.warn("id is null and index is {}", (Object)index);
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("sch_schedule");
        parameter.setPkId((Object)id);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.showPageOneWindow((FormShowParameter)parameter, PAGETYPE_SCHTASKNAME_CLICK + key);
    }

    private void schrecentnameClick(String key) {
        String str = this.getPageCache().get(CACHE_RECENT_TASKS);
        if (StringUtils.isEmpty((CharSequence)str)) {
            log.warn("cache.recentTasks from pagecache is null");
            return;
        }
        List list = SerializationUtils.fromJsonStringToList((String)str, String.class);
        int index = Integer.parseInt(key.substring(SCHRECENTNAME.length()));
        if (list.size() + 1 < index) {
            log.warn("cache.recentTasks from pagecache size < index .size = {}, index = {}", (Object)list.size(), (Object)index);
            return;
        }
        String id = (String)list.get(index - 1);
        if (StringUtils.isEmpty((CharSequence)id)) {
            log.warn("taskId is null and index is {}", (Object)index);
            return;
        }
        this.showSchTaskDetail(id);
    }

    private void errornameClick(String key) {
        String str = this.getPageCache().get(CACHE_EXCEPTIONLOG);
        if (StringUtils.isEmpty((CharSequence)str)) {
            log.warn("cache.exceptionlog from pagecache is null");
            return;
        }
        List list = SerializationUtils.fromJsonStringToList((String)str, String.class);
        int index = Integer.parseInt(key.substring(ERRORNAME.length()));
        if (list.size() + 1 < index) {
            log.warn("cache.exceptionlog from pagecache size < index .size = {}, index = {}", (Object)list.size(), (Object)index);
            return;
        }
        String id = (String)list.get(index - 1);
        if (StringUtils.isEmpty((CharSequence)id)) {
            log.warn("taskId is null and index is {}", (Object)index);
            return;
        }
        this.showSchTaskDetail(id);
    }

    public void afterCreateNewData(EventObject e) {
        try {
            this.bindTaskStatus(-1);
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        try {
            this.bindMainStatus();
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        try {
            this.bindSchTaskNumber(-1);
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        try {
            this.bindExcuteTaskNumber(-1);
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        try {
            this.bindSchCostTime(-1);
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        try {
            this.bindExceptionlog(-7);
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        try {
            this.bindRecentTasks();
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        try {
            this.bindWillexcutetask();
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
        Listbox taskstatusListbox = (Listbox)this.getControl(TASKSTATUSLISTBOX);
        ArrayList<ListboxItem> taskstatusListboxItems = new ArrayList<ListboxItem>();
        taskstatusListboxItems.add(new ListboxItem("taskstatusday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"ScheduleViewPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        taskstatusListboxItems.add(new ListboxItem("taskstatusweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"ScheduleViewPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        taskstatusListboxItems.add(new ListboxItem("taskstatusmonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"ScheduleViewPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        taskstatusListbox.addItems(taskstatusListboxItems);
        Listbox takeListbox = (Listbox)this.getControl(TAKELISTBOX);
        ArrayList<ListboxItem> takeListboxItems = new ArrayList<ListboxItem>();
        takeListboxItems.add(new ListboxItem("takeday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"ScheduleViewPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        takeListboxItems.add(new ListboxItem("takeweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"ScheduleViewPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        takeListboxItems.add(new ListboxItem("takemonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"ScheduleViewPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        takeListbox.addItems(takeListboxItems);
        Listbox schtaskListbox = (Listbox)this.getControl(SCHTASKLISTBOX);
        ArrayList<ListboxItem> schtaskListboxItems = new ArrayList<ListboxItem>();
        schtaskListboxItems.add(new ListboxItem("schtaskday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"ScheduleViewPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        schtaskListboxItems.add(new ListboxItem("schtaskweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"ScheduleViewPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        schtaskListboxItems.add(new ListboxItem("schtaskmonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"ScheduleViewPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        schtaskListbox.addItems(schtaskListboxItems);
        Listbox excutetasknumListbox = (Listbox)this.getControl(EXCUTETASKNUMLISTBOX);
        ArrayList<ListboxItem> excutetasknumListboxItems = new ArrayList<ListboxItem>();
        excutetasknumListboxItems.add(new ListboxItem("excutetasknumday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"ScheduleViewPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        excutetasknumListboxItems.add(new ListboxItem("excutetasknumweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"ScheduleViewPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        excutetasknumListboxItems.add(new ListboxItem("excutetasknummonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"ScheduleViewPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
        excutetasknumListbox.addItems(excutetasknumListboxItems);
        this.getView().updateView();
    }

    public void afterBindData(EventObject e) {
        if (!ZkConfig.isSupportZk()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap13"});
        }
    }

    private void bindTaskStatus(int day) {
        Map data = ClientObservableUtils.getTodayTaskStatusNum();
        if (day != -1) {
            String sql = "select sum(fcount) num, fstatus from T_SCH_TASKNUMSTATS where ftime >= ? and ftime <= ? and ftype = 'STATUSDAY' group by fstatus;";
            Object[] params = new SqlParameter[]{new SqlParameter(":ftime", 93, (Object)this.getStartTime(day)), new SqlParameter(":ftime", 93, (Object)this.getEndTime(day))};
            Map result = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, rs -> {
                HashMap<String, Integer> res = new HashMap<String, Integer>(8);
                while (rs.next()) {
                    int value = rs.getInt("num");
                    String status = rs.getString("fstatus");
                    res.put(status, value);
                }
                return res;
            });
            for (Map.Entry entry : result.entrySet()) {
                int val = data.containsKey(entry.getKey()) ? (Integer)data.get(entry.getKey()) + (Integer)entry.getValue() : (Integer)entry.getValue();
                data.put(entry.getKey(), val);
            }
        }
        this.bindTaskStatusChart(data);
    }

    private void bindTaskStatusChart(Map<String, Integer> result) {
        PieChart chart = (PieChart)this.getControl("taskstatus");
        PieSeries series = chart.createSeries(ResManager.loadKDString((String)"\u6570\u636e", (String)"ScheduleViewPlugin_2", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
        for (Map.Entry<String, Integer> entry : result.entrySet()) {
            int value = entry.getValue();
            String status = entry.getKey();
            String color = this.getTaskColor(status);
            String name = this.getStatusName(status);
            ItemValue itemValue = new ItemValue(name, (Number)value);
            if (!StringUtils.isEmpty((CharSequence)color)) {
                itemValue.setColor(color);
            }
            series.addData(itemValue);
        }
        int finishNum = result.get("COMPLETED") == null ? 0 : result.get("COMPLETED");
        chart.bindData(null);
        series.setRadius("40%", "50%");
        if (chart.isLegendVertical()) {
            chart.setLegendAlign(XAlign.right, YAlign.center);
        } else {
            chart.setLegendAlign(XAlign.center, YAlign.bottom);
        }
        chart.setShowTooltip(true);
        chart.setTitleAlign(XAlign.center, YAlign.center);
        String chartName = String.format(ResManager.loadKDString((String)"\u5b8c\u6210(%s)", (String)"ScheduleViewPlugin_33", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), finishNum);
        chart.setName(new LocaleString(chartName));
        this.getView().updateView("taskstatus");
    }

    private String getTaskColor(String status) {
        String color = "COMPLETED".equals(status) ? COLOR_BLUE : ("FAILED".equals(status) ? COLOR_RED : ("SKIP".equals(status) ? "#cccccc" : ("ABORTED".equals(status) ? COLOR_YELLOW : ("SCHEDULED".equals(status) ? "#45cdff" : ("READY".equals(status) ? "#ffd52e" : ("TIMEOUT".equals(status) ? "#ff5257" : ("BEGIN".equals(status) ? COLOR_GREEN : "#3987ed")))))));
        return color;
    }

    private Date getStartTime(int day) {
        if (day == -1) {
            return DateUtils.addDays((Date)this.getBaseToday(), (int)0);
        }
        if (day == -7) {
            return KDDateUtils.getTheWeekStart((int)0, (Date)this.getBaseToday(), (int)2);
        }
        return KDDateUtils.getTheMonthStart((int)0, (Date)this.getBaseToday());
    }

    private Date getEndTime(int day) {
        if (day == -1) {
            return DateUtils.addDays((Date)this.getBaseToday(), (int)1);
        }
        if (day == -7) {
            return KDDateUtils.getTheWeekEnd((int)0, (Date)this.getBaseToday(), (int)2);
        }
        return KDDateUtils.getTheMonthEnd((int)0, (Date)this.getBaseToday());
    }

    private Date getBaseToday() {
        return DateUtils.truncate((Date)new Date(), (int)5);
    }

    private String getStatusName(String status) {
        return TaskStatusConstant.getStatusName((String)status);
    }

    private void bindMainStatus() {
        this.bindMaster();
        this.bindExecutor();
        this.bindMiddleware();
    }

    private void bindExecutor() {
        List lst = ClientObservableUtils.queryExecutorServerStatus();
        Control pieChart = this.getControl("excutestatus");
        if (pieChart instanceof PieChart) {
            int fail = 0;
            int success = 0;
            PieChart chart = (PieChart)pieChart;
            PieSeries series = chart.createSeries(ResManager.loadKDString((String)"\u6570\u636e", (String)"ScheduleViewPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            series.setRadius("40%", "50%");
            if (lst != null) {
                for (ExecutorServerInfo info : lst) {
                    String group = info.getDetail().getOrDefault("curAppGroup", "defaultGroup");
                    String excutename = info.getName() + (StringUtils.isEmpty((CharSequence)group) || "defaultGroup".equals(group) ? "" : " (" + group + ")");
                    if (info.isStarted() && info.getStartTime() > 0L) {
                        ++success;
                    } else if (info.getStartTime() <= 0L) {
                        ++fail;
                    }
                    if (info.isStarted() || info.getDetail().isEmpty()) continue;
                    String exp = (String)info.getDetail().get("exception");
                    log.info("excutename : {} , Exception : {}", (Object)excutename, (Object)exp);
                }
                ItemValue finishValue = new ItemValue(String.format(ResManager.loadKDString((String)"\u6b63\u5e38(%s)", (String)"ScheduleViewPlugin_24", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), success), (Number)success);
                finishValue.setColor(COLOR_BLUE);
                series.addData(finishValue);
                ItemValue errorValue = new ItemValue(String.format(ResManager.loadKDString((String)"\u5f02\u5e38(%s)", (String)"ScheduleViewPlugin_25", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), fail), (Number)fail);
                errorValue.setColor(COLOR_RED);
                series.addData(errorValue);
            } else {
                ItemValue errorValue = new ItemValue(ResManager.loadKDString((String)"\u5f02\u5e38(\u5168\u90e8)", (String)"ScheduleViewPlugin_26", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), (Number)4);
                errorValue.setColor(COLOR_RED);
                series.addData(errorValue);
            }
            series.setRadius("40", "60");
            if (chart.isLegendVertical()) {
                chart.setLegendAlign(XAlign.right, YAlign.center);
            } else {
                chart.setLegendAlign(XAlign.center, YAlign.bottom);
            }
            chart.setShowTooltip(true);
            chart.setTitleAlign(XAlign.center, YAlign.center);
            String chartName = String.format(ResManager.loadKDString((String)"\u6b63\u5e38(%s)", (String)"ScheduleViewPlugin_24", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), success);
            chart.setName(new LocaleString(chartName));
            chart.bindData(null);
        }
    }

    private void bindMaster() {
        String color;
        Map serverInfo = ServerObservableUtils.getMasterServerInfo();
        Label mainip = (Label)this.getControl("mainip");
        Label mainStatus = (Label)this.getControl("mainstatus");
        mainip.setText((String)serverInfo.get("masterName"));
        if ("true".equals(serverInfo.get("isStarted").toString()) && ServerObservableUtils.isScheduleServiceStarted()) {
            mainStatus.setText(ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ScheduleViewPlugin_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
            color = COLOR_BLUE;
        } else {
            mainStatus.setText(ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ScheduleViewPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            color = COLOR_RED;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fc", color);
        this.getView().updateControlMetadata("mainstatus", paramMap);
    }

    private void bindMiddleware() {
        JSONObject jsonObject = ServerObservableUtils.getMiddlewareStatus();
        int mqResult = jsonObject.getInteger("mq");
        Label mqLabel = (Label)this.getControl("mqstatus");
        mqLabel.setText(this.toHealthLevelText(mqResult));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fc", this.toHealthLevelColor(mqResult));
        this.getView().updateControlMetadata("mqstatus", paramMap);
        if (ZkConfig.isSupportZk()) {
            SchCheckResult zkResult = ServerObservableUtils.checkZkConnected();
            int zkRes = zkResult.getCode() != null && zkResult.getCode() == 0 ? 1 : -1;
            Label zkLabel = (Label)this.getControl("zkstatus");
            zkLabel.setText(this.toHealthLevelText(zkRes));
            paramMap = new HashMap();
            paramMap.put("fc", this.toHealthLevelColor(zkRes));
            this.getView().updateControlMetadata("zkstatus", paramMap);
        }
        int redisResult = jsonObject.getInteger("redis");
        Label redisLabel = (Label)this.getControl("redistatus");
        redisLabel.setText(this.toHealthLevelText(redisResult));
        paramMap = new HashMap();
        paramMap.put("fc", this.toHealthLevelColor(redisResult));
        this.getView().updateControlMetadata("redistatus", paramMap);
    }

    private String toHealthLevelColor(int i) {
        String color = i == -1 ? COLOR_RED : (i == 2 ? COLOR_YELLOW : (i == 3 ? COLOR_DEEP_RED : COLOR_BLUE));
        return color;
    }

    private String toHealthLevelText(int i) {
        String text = i == -1 ? ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ScheduleViewPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (i == 1 ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ScheduleViewPlugin_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]) : (i == 2 ? ResManager.loadKDString((String)"\u6162", (String)"ScheduleViewPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (i == 3 ? ResManager.loadKDString((String)"\u8d85\u6162", (String)"ScheduleViewPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316", (String)"ScheduleViewPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]))));
        return text;
    }

    private void bindSchCostTime(int day) {
        String sql = "select top 5 a.fid, a.fjobid, a.fcosttime,b.fnumber  from t_sch_task a left join t_sch_job b on a.fjobid = b.fid where  fdispatchtime >= ? and fdispatchtime <= ? and fcosttime is not null order by fcosttime desc";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)this.getStartTime(day)), new SqlParameter(":fdispatchtime", 93, (Object)this.getEndTime(day))};
        List costTimeTasks = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, resultSet -> {
            String namekey = TAKENAME;
            String numkey = "taketime";
            int i = 1;
            ArrayList<String> result = new ArrayList<String>(10);
            while (resultSet.next()) {
                String fid = resultSet.getString("fid");
                result.add(fid);
                Label namelabel = (Label)this.getControl(namekey + i);
                String fnumber = resultSet.getString("fnumber");
                namelabel.setText(StringUtils.isEmpty((CharSequence)fnumber) ? fid : fnumber);
                Label numlabel = (Label)this.getControl(numkey + i);
                numlabel.setText(resultSet.getString("fcosttime") + "s");
                ++i;
            }
            return result;
        });
        this.getPageCache().put(CACHE_COST_TIME_TASKS, SerializationUtils.toJsonString((Object)costTimeTasks));
    }

    private void bindExcuteTaskNumber(int day) {
        Map map;
        int xendIndex;
        int xstartIndex;
        String xSuffix;
        ArrayList<String> xData = new ArrayList<String>(8);
        HashMap<String, List<Number>> yDatas = new HashMap<String, List<Number>>(8);
        int days = 0;
        Map todayMap = ClientObservableUtils.getTodayTaskJobTypeNum();
        if (day == -7 || day == -30) {
            int i;
            String type = "DAY";
            xSuffix = ResManager.loadKDString((String)"\u65e5", (String)"ScheduleViewPlugin_34", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
            Date startTime = this.getStartTime(day);
            Date endTime = this.getEndTime(day);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            xstartIndex = calendar.get(5);
            days = calendar.getActualMaximum(5);
            calendar.setTime(new Date());
            xendIndex = calendar.get(5);
            String sql = "select fjobtype jobtype,fvalue val, fcount num from T_SCH_TASKNUMSTATS where ftype = ? and ftime >= ? and ftime <= ? order by fvalue asc;";
            Object[] params = new SqlParameter[]{new SqlParameter(":ftype", 12, (Object)type), new SqlParameter(":ftime", 93, (Object)startTime), new SqlParameter(":ftime", 93, (Object)endTime)};
            map = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, resultSet -> {
                HashMap result = new HashMap(8);
                for (String jobtype : this.getJobTypes()) {
                    result.put(jobtype, new HashMap(8));
                }
                while (resultSet.next()) {
                    int value = resultSet.getInt("val");
                    int num = resultSet.getInt("num");
                    String jobtype = resultSet.getString("jobtype");
                    Map yMap = (Map)result.get(jobtype);
                    if (yMap == null) continue;
                    yMap.put(value, num);
                }
                return result;
            });
            for (Map.Entry entry : todayMap.entrySet()) {
                String jobType = (String)entry.getKey();
                Integer num = 0;
                for (Integer hourNum : ((Map)entry.getValue()).values()) {
                    if (hourNum == null) {
                        hourNum = 0;
                    }
                    num = num + hourNum;
                }
                if (map.get(jobType) == null) continue;
                ((Map)map.get(jobType)).put(xendIndex, num);
            }
            if (xendIndex < xstartIndex) {
                for (i = xstartIndex; i <= days; ++i) {
                    xData.add(i + xSuffix);
                }
                for (i = 1; i <= xendIndex; ++i) {
                    xData.add(i + xSuffix);
                }
            } else {
                for (i = xstartIndex; i <= xendIndex; ++i) {
                    xData.add(i + xSuffix);
                }
            }
        } else {
            xSuffix = "h";
            map = todayMap;
            Calendar calendar = Calendar.getInstance();
            int hourNow = calendar.get(11);
            xstartIndex = 0;
            xendIndex = hourNow;
            for (String jobType : this.getJobTypes()) {
                Map numMap = (Map)map.get(jobType);
                ArrayList<Integer> yList = new ArrayList<Integer>(24);
                for (int i = 0; i <= hourNow; ++i) {
                    Integer num;
                    Integer n = num = numMap == null ? null : (Integer)numMap.get(i);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
                yDatas.put(jobType, yList);
            }
            for (int i = xstartIndex; i <= xendIndex; ++i) {
                xData.add(i + xSuffix);
            }
        }
        for (String jobType : this.getJobTypes()) {
            Integer num;
            int i;
            Map numMap = (Map)map.get(jobType);
            ArrayList<Integer> yList = new ArrayList<Integer>(24);
            if (xendIndex < xstartIndex) {
                for (i = xstartIndex; i <= days; ++i) {
                    Integer n = num = numMap == null ? null : (Integer)numMap.get(i);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
                for (i = 1; i <= xendIndex; ++i) {
                    Integer n = num = numMap == null ? null : (Integer)numMap.get(i);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
            } else {
                for (i = xstartIndex; i <= xendIndex; ++i) {
                    Integer n = num = numMap == null ? null : (Integer)numMap.get(i);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
            }
            yDatas.put(jobType, yList);
        }
        this.bindExcuteTaskNumberChart(xData, yDatas);
    }

    private String[] getJobTypes() {
        return new String[]{"BIZ", "WORKFLOW", "REALTIME"};
    }

    private MessageType getMessageType(String jobType) {
        MessageType messageType;
        switch (jobType) {
            case "WORKFLOW": {
                messageType = MessageType.WorkFlowJOB;
                break;
            }
            case "REALTIME": {
                messageType = MessageType.REALTIMEJOB;
                break;
            }
            default: {
                messageType = MessageType.BIZJOB;
            }
        }
        return messageType;
    }

    private void bindExcuteTaskNumberChart(List<String> xData, Map<String, List<Number>> yDatas) {
        PointLineChart chart = (PointLineChart)this.getControl("excutetasknumber");
        Axis xAxis = chart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)"ScheduleViewPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), AxisType.category);
        xAxis.setCategorys(xData);
        Axis yaxis = chart.createYAxis(ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"ScheduleViewPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), AxisType.value);
        HashMap<String, Object[]> nameTextStyle = new HashMap<String, Object[]>(4);
        nameTextStyle.put("padding", new Object[]{3, 4, 5, 100});
        yaxis.setPropValue("nameTextStyle", nameTextStyle);
        for (Map.Entry<String, List<Number>> entry : yDatas.entrySet()) {
            String jobType = entry.getKey();
            LineSeries series = chart.createSeries(this.getJobTypeName(jobType));
            series.setData(entry.getValue().toArray(new Number[0]));
            series.setColor(this.getColorByJobType(jobType));
            series.setLineColor(this.getColorByJobType(jobType));
            series.setItemColor(this.getColorByJobType(jobType));
        }
        chart.setShowLegend(true);
        chart.setShowTooltip(true);
        chart.setShowTitle(true);
        chart.bindData(null);
    }

    private String getColorByJobType(String jobType) {
        String color = JobType.BIZ.toString().equals(jobType) ? COLOR_BLUE : (JobType.REALTIME.toString().equals(jobType) ? COLOR_YELLOW : COLOR_GREEN);
        return color;
    }

    private String getJobTypeName(String jobType) {
        String str = JobType.BIZ.toString().equals(jobType) ? ResManager.loadKDString((String)"\u4e1a\u52a1\u4efb\u52a1", (String)"ScheduleViewPlugin_27", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (JobType.REALTIME.toString().equals(jobType) ? ResManager.loadKDString((String)"\u5b9e\u65f6\u4efb\u52a1", (String)"ScheduleViewPlugin_28", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u4efb\u52a1", (String)"ScheduleViewPlugin_29", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        return str;
    }

    private void bindRecentTasks() {
        String sql = "select top 5 a.fid, a.fjobid, b.fnumber, a.fstatus  from t_sch_task a left join t_sch_job b on a.fjobid = b.fid  where a.fdispatchtime is not null order by a.fdispatchtime desc";
        List result = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, resultSet -> {
            ArrayList<String> list = new ArrayList<String>(10);
            String namekey = SCHRECENTNAME;
            String numkey = "recentstatus";
            int i = 1;
            while (resultSet.next()) {
                String fid = resultSet.getString("fid");
                list.add(fid);
                Label namelabel = (Label)this.getControl(namekey + i);
                String number = resultSet.getString("fnumber");
                namelabel.setText(StringUtils.isEmpty((CharSequence)number) ? fid : number);
                Label numlabel = (Label)this.getControl(numkey + i);
                String name = this.getStatusName(resultSet.getString("fstatus"));
                numlabel.setText(name);
                ++i;
            }
            return list;
        });
        this.getPageCache().put(CACHE_RECENT_TASKS, SerializationUtils.toJsonString((Object)result));
    }

    private void bindSchTaskNumber(int day) {
        this.resetSchTaskNumber();
        List<Object> list = ServerObservableUtils.getTop5SchTaskNumListToday();
        if (day != -1) {
            String sql = "select top 5 fscheduleid, sum(ftotalcount) totalcount from t_sch_schedulestats  where ftime >= ? and ftime <= ? and ftype = ? group by fscheduleid order by totalcount desc;";
            Object[] params = new SqlParameter[3];
            String type = "DAY";
            params[0] = new SqlParameter(":ftime", 93, (Object)this.getStartTime(day));
            params[1] = new SqlParameter(":ftime", 93, (Object)this.getEndTime(day));
            params[2] = new SqlParameter(":ftype", 12, (Object)type);
            List preTopList = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, resultSet -> {
                ArrayList<Tuple> res = new ArrayList<Tuple>(8);
                while (resultSet.next()) {
                    String fscheduleid = resultSet.getString("fscheduleid");
                    int totalcount = resultSet.getInt("totalcount");
                    res.add(new Tuple((Object)fscheduleid, (Object)totalcount));
                }
                return res;
            });
            LinkedHashMap<Object, Object> listMap = new LinkedHashMap<Object, Object>(list.size());
            for (Tuple tuple : list) {
                listMap.put(tuple.item1, tuple.item2);
            }
            if (listMap.isEmpty()) {
                list = preTopList;
            } else {
                SqlBuilder sb = new SqlBuilder();
                sb.append("select top 5 fscheduleid, sum(ftotalcount) totalcount from t_sch_schedulestats where ", new Object[0]);
                sb.appendIn(" fscheduleid", listMap.keySet().toArray());
                sb.append(" and ftype = ? ", new Object[]{type});
                sb.append(" group by fscheduleid order by totalcount desc;", new Object[0]);
                DataSet rs = DB.queryDataSet((String)"ScheduleViewPlugin.bindSchTaskNumber", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
                Iterator iterator = null;
                try {
                    if (rs != null) {
                        while (rs.hasNext()) {
                            Row row = rs.next();
                            String fscheduleid = row.getString("fscheduleid");
                            int totalcount = row.getInteger("totalcount");
                            listMap.put(fscheduleid, (Integer)listMap.get(fscheduleid) + totalcount);
                        }
                    }
                }
                catch (Throwable row) {
                    iterator = row;
                    throw row;
                }
                finally {
                    if (rs != null) {
                        if (iterator != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable row) {
                                ((Throwable)((Object)iterator)).addSuppressed(row);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                LinkedHashMap<Object, Tuple> mergeMap = new LinkedHashMap<Object, Tuple>(8);
                for (Tuple tuple : preTopList) {
                    mergeMap.put(tuple.item1, tuple);
                }
                for (Map.Entry entry : listMap.entrySet()) {
                    mergeMap.put(entry.getKey(), new Tuple(entry.getKey(), entry.getValue()));
                }
                list = new ArrayList(mergeMap.values());
                Collections.sort(list, (o1, o2) -> (Integer)o2.item2 - (Integer)o1.item2);
                list = list.subList(0, list.size() > 5 ? 5 : list.size());
            }
        }
        ArrayList<String> ids = new ArrayList<String>(10);
        String namekey = SCHTASKNAME;
        String numkey = "schtasknum";
        ScheduleDataEntityInvoker invoker = new ScheduleDataEntityInvoker();
        int i = 1;
        for (Tuple info : list) {
            String id = (String)info.item1;
            ids.add(id);
            DynamicObject dObj = invoker.loadSingleFromCache(SchEntityType.Schedule, (Object)id, "number");
            String number = dObj == null ? id : dObj.getString("number");
            Label namelabel = (Label)this.getControl(namekey + i);
            namelabel.setText(number);
            Label numlabel = (Label)this.getControl(numkey + i);
            numlabel.setText(String.format(ResManager.loadKDString((String)"%s\u4e2a", (String)"ScheduleViewPlugin_30", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), info.item2));
            ++i;
        }
        this.getPageCache().put(CACHE_SCHTASKNAME, SerializationUtils.toJsonString(ids));
    }

    private void resetSchTaskNumber() {
        String namekey = SCHTASKNAME;
        String numkey = "schtasknum";
        for (int i = 1; i < 6; ++i) {
            Label namelabel = (Label)this.getControl(namekey + i);
            namelabel.setText(null);
            Label numlabel = (Label)this.getControl(numkey + i);
            numlabel.setText(null);
        }
    }

    private void bindWillexcutetask() {
        BarChart chart = (BarChart)this.getControl("willexcutetask");
        ArrayList<String> ipList = new ArrayList<String>();
        HashMap<String, ArrayList<Integer>> yLists = new HashMap<String, ArrayList<Integer>>(6);
        List executorServerInfos = ClientObservableUtils.queryExecutorServerStatus();
        if (executorServerInfos != null) {
            for (ExecutorServerInfo executorServerInfo : executorServerInfos) {
                JSONObject jSONObject;
                Object jsonObject;
                String ip = executorServerInfo.getName();
                ipList.add(ip);
                try {
                    jsonObject = ClientObservableUtils.getExecutorServerStatus((String)ip);
                }
                catch (Exception exception) {
                    log.error("Schedule*** getExecutorServerStatus error , ip {}", (Object)ip, (Object)exception);
                    jsonObject = JSONObject.parseObject((String)"{\"threadPoolStatus\":{\"BIZJOB\":{\"threadTaskSuccessTime\":0,\"runningNum\":0,\"maxNum\":8,\"threadError\":0,\"threadTaskSuccess\":0},\"WorkFlowJOB\":{\"threadTaskSuccessTime\":0,\"runningNum\":0,\"maxNum\":20,\"threadError\":0,\"threadTaskSuccess\":0},\"REALTIMEJOB\":{\"threadTaskSuccessTime\":0,\"runningNum\":0,\"maxNum\":8,\"threadError\":0,\"threadTaskSuccess\":0}}}");
                }
                if (jsonObject == null || (jSONObject = jsonObject.getJSONObject("threadPoolStatus")) == null) continue;
                for (String jobType : this.getJobTypes()) {
                    ArrayList<Integer> ylist;
                    JSONObject jsonObject1 = jSONObject.getJSONObject(this.getMessageType(jobType).name());
                    int num = 0;
                    if (jsonObject1 != null && jsonObject1.containsKey((Object)"runningNum")) {
                        num = jsonObject1.getInteger("runningNum");
                    }
                    if ((ylist = (ArrayList<Integer>)yLists.get(jobType)) == null) {
                        ylist = new ArrayList<Integer>(8);
                        yLists.put(jobType, ylist);
                    }
                    ylist.add(num);
                }
            }
        }
        Axis xaxis = chart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)"ScheduleViewPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), AxisType.category);
        xaxis.setCategorys(ipList);
        Axis yaxis = chart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"ScheduleViewPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), AxisType.value);
        HashMap<String, Object[]> nameTextStyle = new HashMap<String, Object[]>(4);
        nameTextStyle.put("padding", new Object[]{3, 4, 5, 100});
        yaxis.setPropValue("nameTextStyle", nameTextStyle);
        for (Map.Entry entry : yLists.entrySet()) {
            String jobType = (String)entry.getKey();
            List yList = (List)entry.getValue();
            BarSeries series = chart.createSeries(this.getJobTypeName(jobType));
            series.setData(yList.toArray(new Number[0]));
            series.setBarWidth("20");
            series.setColor(this.getColorByJobType(jobType));
        }
        if (ipList.size() > 5) {
            ArrayList dataZoomList = new ArrayList(8);
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(8);
            linkedHashMap.put("type", "slider");
            linkedHashMap.put("show", true);
            linkedHashMap.put("start", 0);
            linkedHashMap.put("end", 4);
            linkedHashMap.put("minValueSpan", 4);
            linkedHashMap.put("maxValueSpan", 4);
            linkedHashMap.put("height", 7);
            dataZoomList.add(linkedHashMap);
            chart.addProperty("dataZoom", dataZoomList);
            HashMap<String, Integer> xaxisMap = new HashMap<String, Integer>(3);
            xaxisMap.put("interval", 0);
            xaxis.setPropValue("axisLabel", xaxisMap);
        }
        chart.setShowLegend(true);
        chart.setShowTooltip(true);
        chart.setShowTitle(true);
        chart.bindData(null);
    }

    private void bindExceptionlog(int day) {
        String sql = "select top 5 a.ftaskid,a.fjobid,b.fnumber,a.fexecutetime  from t_sch_errorjob a left join t_sch_job b on a.fjobid = b.fid  order by fexecutetime  desc";
        List result = (List)DB.query((DBRoute)DBRoute.base, (String)sql, resultSet -> {
            ArrayList<String> list = new ArrayList<String>(10);
            String namekey = ERRORNAME;
            String numkey = "errortime";
            int i = 1;
            long newTime = new Date().getTime();
            while (resultSet.next()) {
                String taskid = resultSet.getString("ftaskid");
                list.add(taskid);
                Label namelabel = (Label)this.getControl(namekey + i);
                String fnumber = resultSet.getString("fnumber");
                namelabel.setText(StringUtils.isEmpty((CharSequence)fnumber) ? taskid : fnumber);
                Label numlabel = (Label)this.getControl(numkey + i);
                Timestamp executetime = resultSet.getTimestamp("fexecutetime");
                long time = newTime - executetime.getTime();
                int hour = (int)time / 3600000;
                if (hour < 1) {
                    numlabel.setText(String.format(ResManager.loadKDString((String)"%s\u5206\u949f\u524d", (String)"ScheduleViewPlugin_31", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), (time / 1000L - (long)(hour * 60 * 60)) / 60L));
                } else {
                    namelabel.setText(String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6\u524d", (String)"ScheduleViewPlugin_32", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), hour));
                }
                ++i;
            }
            return list;
        });
        this.getPageCache().put(CACHE_EXCEPTIONLOG, SerializationUtils.toJsonString((Object)result));
    }

    private void showPageOneWindow(FormShowParameter parameter, String pageType) {
        String cacheKey = pageType;
        String pageId = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)pageId)) {
            parameter.setPageId(pageId);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, pageType);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            this.getPageCache().put(cacheKey, parameter.getPageId());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (PAGETYPE_SCHMONITORVIEW.equals(closedCallBackEvent.getActionId())) {
            this.getPageCache().remove(PAGETYPE_SCHMONITORVIEW);
        } else if (PAGETYPE_SCHTASKORDERBYCOSTTIME.equals(closedCallBackEvent.getActionId())) {
            this.getPageCache().remove(PAGETYPE_SCHTASKORDERBYCOSTTIME);
        } else if (PAGETYPE_EXCEPTION_LOG.equals(closedCallBackEvent.getActionId())) {
            this.getPageCache().remove(PAGETYPE_EXCEPTION_LOG);
        } else if (PAGETYPE_SCH_TASK.equals(closedCallBackEvent.getActionId())) {
            this.getPageCache().remove(PAGETYPE_SCH_TASK);
        } else if (closedCallBackEvent.getActionId().startsWith("schtasknameClick")) {
            this.getPageCache().remove(closedCallBackEvent.getActionId());
        } else if (closedCallBackEvent.getActionId().startsWith(PAGETYPE_SHOW_SCH_TASK_DETAIL)) {
            this.getPageCache().remove(closedCallBackEvent.getActionId());
        }
    }
}

