/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Timeline;
import kd.bos.form.control.TimelineContentOption;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineOptionClickArg;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TimelineEvent;
import kd.bos.form.control.events.TimelineListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.analyse.AbstractTaskAnalyse;
import kd.bos.schedule.analyse.OtherTaskAnalyse;
import kd.bos.schedule.analyse.ReadyTaskAnalyse;
import kd.bos.schedule.analyse.RunningTaskAnalyse;
import kd.bos.schedule.analyse.ScheduleTaskAnalyse;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class TaskAnalysePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(TaskAnalysePlugin.class);
    public static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static final String OTHER_TASK = "othertask";
    private static final String TASK_STATUS = "taskStatus";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener(new ProgresssListener(){

            public void onProgress(ProgressEvent evt) {
                TaskAnalysePlugin.this.progressAnalyse();
            }
        });
        this.registerTimelineListener();
    }

    private void registerTimelineListener() {
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        String status = taskInfo.getStatus();
        final AbstractTaskAnalyse analyzer = this.getAnalyzer(status);
        Timeline timeline = (Timeline)this.getView().getControl(analyzer.getAnalyseTimelineKey());
        if (timeline != null) {
            timeline.addTimelineListener(new TimelineListener(){

                public void update(TimelineEvent e) {
                }

                public void optionClick(TimelineOptionClickArg e) {
                    analyzer.optionClick(e.getOptionKey());
                }
            });
        }
    }

    private void progressAnalyse() {
        String taskStatus = this.getView().getPageCache().get(TASK_STATUS);
        if (StringUtils.isNotBlank((CharSequence)taskStatus)) {
            try {
                this.getAnalyzer(taskStatus).analyse();
            }
            catch (Throwable t) {
                String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
                log.error("Schedule***\u4efb\u52a1\u8bca\u65ad\u5f02\u5e38\uff0ctaskId = {}", (Object)taskId, (Object)t);
                this.stopProgressBar();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8bca\u65ad\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskAnalysePlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else {
            this.stopProgressBar();
        }
    }

    private void stopProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.stop();
        this.getView().getPageCache().put("analyseStep", "end");
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"analyseresultflex"});
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        String status = taskInfo.getStatus();
        if (StringUtils.isNotBlank((CharSequence)status)) {
            this.getView().getPageCache().put(TASK_STATUS, status);
            try {
                AbstractTaskAnalyse taskAnalyse = this.getAnalyzer(status);
                taskAnalyse.analyse();
            }
            catch (Throwable t) {
                log.error("Schedule***\u4efb\u52a1\u8bca\u65ad\u5f02\u5e38\uff0ctaskId = {}", (Object)taskId, (Object)t);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8bca\u65ad\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskAnalysePlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{OTHER_TASK});
            ArrayList<TimelineOption> timelineOptions = new ArrayList<TimelineOption>();
            TimelineOption timelineOption = new TimelineOption();
            String contentTitle = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001", (String)"TaskAnalysePlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
            String contentDesc = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1", (String)"TaskAnalysePlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
            timelineOption.setContent(new TimelineContentOption(new LocaleString(contentTitle), new LocaleString(contentDesc)));
            timelineOptions.add(timelineOption);
            Timeline otherTask = (Timeline)this.getView().getControl(OTHER_TASK);
            otherTask.setClientTimelineOptions(timelineOptions);
        }
    }

    private AbstractTaskAnalyse getAnalyzer(String status) {
        AbstractTaskAnalyse taskAnalyse = null;
        switch (status) {
            case "SCHEDULED": {
                taskAnalyse = new ScheduleTaskAnalyse(this.getView());
                break;
            }
            case "READY": {
                taskAnalyse = new ReadyTaskAnalyse(this.getView());
                break;
            }
            case "BEGIN": {
                taskAnalyse = new RunningTaskAnalyse(this.getView());
                break;
            }
            default: {
                taskAnalyse = new OtherTaskAnalyse(this.getView());
            }
        }
        return taskAnalyse;
    }
}

