/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.AppGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskType;
import kd.bos.schedule.formplugin.ParamTypeEnum;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaskDefinePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskDefinePlugin.class);
    private static final String DEFAULT_APPID = "bos";
    private static final String APPID = "appid";
    private static final String RESCHEDULEDCONFIRMATION = "rescheduledconfirmation";
    private static final String PARAMVALUE = "paramvalue";
    private static final String PARAMENTRY = "paramentry";
    private static final String PARAMTYPE = "paramtype";
    private static final String PARAM_NAME = "paramname";
    private static final String VALUE = "value";
    private static final String VISIBLE = "visible";
    private static final String BASEDATAINFO = "basedatainfo";
    private static final String BASEDATAVALUE = "basedatavalue";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static final String PARAMDEFCALLBACK = "paramdefcallback";
    private static final String CLASSNAME = "classname";
    private static final String NUMBER = "number";
    private static final String SCH_TASK_DEFINE = "sch_taskdefine";
    private static Set bampMoveAppList = new HashSet(10);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARAMVALUE});
    }

    public void afterBindData(EventObject e) {
        List<ComboItem> allAppInfo = this.getAllAppInfo();
        ComboItem systemApp = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7cfb\u7edf\u5e94\u7528", (String)"TaskDefinePlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])), DEFAULT_APPID);
        allAppInfo.add(systemApp);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(APPID);
        comboEdit.setComboItems(allAppInfo);
        this.handleReschedule(false);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(APPID, (Object)DEFAULT_APPID);
    }

    private List<ComboItem> getAllAppInfo() {
        ArrayList<ComboItem> appInfos = new ArrayList<ComboItem>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_devportal_bizapp");
        if (dt == null) {
            return appInfos;
        }
        Map appObjs = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dt, null);
        if (appObjs == null) {
            return appInfos;
        }
        HashMap<String, ComboItem> appItems = new HashMap<String, ComboItem>(10);
        for (Map.Entry appObj : appObjs.entrySet()) {
            DynamicObject bizappObj = (DynamicObject)appObj.getValue();
            DynamicObject cloudObj = (DynamicObject)bizappObj.get("bizcloud");
            if (cloudObj == null) continue;
            LocaleString localeString = null;
            String type = bizappObj.getString("type");
            if (StringUtils.equals((CharSequence)"2", (CharSequence)type)) continue;
            String appId = bizappObj.getString(NUMBER);
            ILocaleString name = bizappObj.getLocaleString("name");
            localeString = LocaleString.fromMap((Map)name);
            appItems.put(appId, new ComboItem(localeString, appId));
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        log.debug(String.format("\u52a0\u8f7d\u7070\u5ea6\u4fe1\u606f,userid: %s", RequestContext.get().getUserId()));
        if (AppGroup.isGrayUpgrade()) {
            List appInfoStrList = metadataService.loadGrayAppInfoList();
            log.info(String.format("\u7070\u5ea6\u4fe1\u606f,userid: %s", appInfoStrList));
            ArrayList<AppInfo> appInfoList = new ArrayList<AppInfo>(8);
            for (String infoStr : appInfoStrList) {
                AppInfo appInfo = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
                appInfoList.add(appInfo);
            }
            for (AppInfo appInfo : appInfoList) {
                String appName = appInfo.getName().toString();
                String appNum = appInfo.getNumber();
                appItems.put(appNum, new ComboItem(new LocaleString(appName), appNum));
            }
        }
        appInfos.addAll(appItems.values());
        return appInfos;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (StringUtils.equals((CharSequence)key, (CharSequence)PARAMVALUE)) {
            FormShowParameter parameter = new FormShowParameter();
            int entryRowIndex = this.getModel().getEntryCurrentRowIndex(PARAMENTRY);
            String paramType = (String)this.getModel().getValue(PARAMTYPE, entryRowIndex);
            parameter.setCustomParam(PARAMTYPE, (Object)PARAMVALUE);
            if (StringUtils.equals((CharSequence)ParamTypeEnum.BOOLEAN.getParamType(), (CharSequence)paramType)) {
                parameter.setCustomParam(VALUE, (Object)(StringUtils.equals((CharSequence)"true", (CharSequence)((String)this.getModel().getValue(PARAMVALUE))) ? "1" : "0"));
            } else {
                parameter.setCustomParam(VALUE, this.getModel().getValue(PARAMVALUE));
            }
            ParamTypeEnum paramTypeEnum = ParamTypeEnum.getParamType(paramType);
            if (paramTypeEnum == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\u3002", (String)"JobPlugin_33", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            switch (paramTypeEnum) {
                case TEXT: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("texttype")));
                    break;
                }
                case INTEGER: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("integertype")));
                    break;
                }
                case LONG: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("biginttype")));
                    break;
                }
                case DECIMAL: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("decimaltype")));
                    break;
                }
                case DATE: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("datetype")));
                    break;
                }
                case DATETIME: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("datetimetype")));
                    break;
                }
                case TIME: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("timetype")));
                    break;
                }
                case BOOLEAN: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("booleantype")));
                    break;
                }
                case BASEDATA: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Arrays.asList("basedatatype", BASEDATAVALUE)));
                    String basedatainfo = (String)this.getModel().getValue(BASEDATAINFO);
                    parameter.setCustomParam(BASEDATAINFO, (Object)basedatainfo);
                    break;
                }
                default: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\u3002", (String)"JobPlugin_33", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("sch_job_param");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PARAMDEFCALLBACK));
            this.getView().showForm(parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            boolean paramValid;
            QFilter numberEqFilter;
            FormOperate operate;
            String appId = (String)this.getModel().getValue(APPID);
            if (StringUtils.isBlank((CharSequence)appId)) {
                this.getModel().setValue(APPID, (Object)DEFAULT_APPID);
            }
            if (RESCHEDULEDCONFIRMATION.equals((operate = (FormOperate)args.getSource()).getParameter().get("sourceName"))) {
                return;
            }
            Object id = this.getModel().getValue("id");
            Object number = this.getModel().getValue(NUMBER);
            if (StringUtils.isBlank((Object)id)) {
                numberEqFilter = new QFilter(NUMBER, "=", number);
                QFilter[] qFilters = new QFilter[]{numberEqFilter};
                boolean existThisNumber = QueryServiceHelper.exists((String)SCH_TASK_DEFINE, (QFilter[])qFilters);
                if (existThisNumber) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u7ecf\u5b58\u5728\u3002", (String)"TaskDefinePlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.cancel = true;
                    return;
                }
            } else {
                numberEqFilter = new QFilter(NUMBER, "=", number);
                QFilter idNotFilter = new QFilter("id", "!=", id);
                QFilter[] qFilters = new QFilter[]{numberEqFilter, idNotFilter};
                boolean existThisNumber = QueryServiceHelper.exists((String)SCH_TASK_DEFINE, (QFilter[])qFilters);
                if (existThisNumber) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u7ecf\u5b58\u5728\u3002", (String)"TaskDefinePlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.cancel = true;
                    return;
                }
            }
            if (!(paramValid = this.validParam())) {
                args.cancel = true;
                return;
            }
        }
    }

    private boolean validParam() {
        DynamicObjectCollection paramEntry = this.getModel().getEntryEntity(PARAMENTRY);
        if (!CollectionUtils.isEmpty((Collection)paramEntry)) {
            HashSet<String> paramNames = new HashSet<String>(paramEntry.size());
            for (DynamicObject paramObj : paramEntry) {
                String paramName = paramObj.getString(PARAM_NAME);
                if (StringUtils.isBlank((CharSequence)paramName)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u540d\u79f0\u201d\u3002", (String)"JobPlugin_22", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)paramName) && paramNames.contains(paramName)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c\u53c2\u6570%s\u201d\u540d\u79f0\u91cd\u590d", (String)"TaskDefinePlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramName));
                    return false;
                }
                paramNames.add(paramName);
                boolean isMust = paramObj.getBoolean("must");
                if (!isMust) continue;
                if ("8".equals(paramObj.get(PARAMTYPE))) {
                    String baseDataInfoStr = paramObj.getString(BASEDATAINFO);
                    if (StringUtils.isBlank((CharSequence)baseDataInfoStr)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570%s\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"JobPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramObj.getString(PARAM_NAME)));
                        return false;
                    }
                    Map basedataInfoMap = (Map)SerializationUtils.fromJsonString((String)paramObj.getString(BASEDATAINFO), Map.class);
                    Map basedataDefMap = (Map)basedataInfoMap.get(BASEDATAVALUE);
                    if (basedataDefMap == null || basedataDefMap.get("id") != null) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570%s\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"JobPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramObj.getString(PARAM_NAME)));
                    return false;
                }
                if (!StringUtils.isBlank((CharSequence)paramObj.getString(PARAMVALUE))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570%s\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"JobPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramObj.getString(PARAM_NAME)));
                return false;
            }
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(RESCHEDULEDCONFIRMATION) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("sourceName", RESCHEDULEDCONFIRMATION);
            option.setVariableValue("sourceEvent", "Operation");
            this.getView().invokeOperation("save", option);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map dataMap;
        Object returnDataMap;
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)PARAMDEFCALLBACK) && returnData != null && (returnDataMap = (dataMap = (Map)returnData).get("returnData")) instanceof Map) {
            Map param = (Map)returnDataMap;
            String type = (String)param.get("type");
            String paramValue = (String)param.get(PARAMVALUE);
            if ("basedata".equals(type)) {
                param.remove(PARAMVALUE);
                param.remove("type");
                this.getModel().setValue(BASEDATAINFO, (Object)JSONObject.toJSONString((Object)param));
                this.getModel().setValue(PARAMVALUE, (Object)paramValue);
            } else {
                this.getModel().setValue(PARAMVALUE, (Object)paramValue);
                if (StringUtils.isBlank((Object)this.getModel().getValue(PARAMVALUE))) {
                    this.getModel().setValue(PARAMVALUE, (Object)paramValue);
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (CLASSNAME.equals(proName)) {
            this.handleReschedule(true);
        } else if (APPID.equals(proName)) {
            this.handleReschedule(true);
        }
    }

    private void handleReschedule(boolean resetValue) {
        String appId = this.getModel().getDataEntity().getString(APPID);
        String className = this.getModel().getDataEntity().getString(CLASSNAME);
        boolean isEnabled = false;
        if (StringUtils.isNotEmpty((CharSequence)appId) && StringUtils.isNotEmpty((CharSequence)className)) {
            TaskType taskType = this.getTaskType(appId, className);
            boolean isReSch = taskType.isSupportReschedule();
            if (resetValue) {
                this.getModel().setValue("rescheduled", (Object)isReSch);
            }
            isEnabled = isReSch;
        }
        this.getView().setEnable(Boolean.valueOf(isEnabled), new String[]{"rescheduled"});
    }

    private TaskType getTaskType(String appId, String className) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528id\u4e3a\u7a7a", (String)"JobPlugin_32", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DEFAULT_APPID, (CharSequence)appId) || this.isBOSApp(appId)) {
            appId = DEFAULT_APPID;
        }
        TaskType taskType = (TaskType)DispatchServiceHelper.invokeBOSService((String)appId, (String)"SchTaskFormService", (String)"getTaskType", (Object[])new Object[]{className});
        return taskType;
    }

    private boolean isBOSApp(String appId) {
        try {
            return this.isBAMPMoveApp(appId) || BOSRuntime.isBOSApp((String)appId);
        }
        catch (Exception e) {
            log.warn("appId:" + appId + e.getMessage());
            return false;
        }
    }

    private boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    static {
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

