/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.notify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobNotifyEvent;
import kd.bos.schedule.api.JobNotifyListener;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class JobProcessorNotify
implements JobNotifyListener {
    private static Log log = LogFactory.getLog(kd.bos.servicehelper.jobnotify.JobProcessorNotify.class);
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("schNotify", new DistributeCacheHAPolicy(true, true));
    private static final String SELECT_PROPERTIES_SCH = "number,name,starttime,endtime,status,txtdesc,sfailnotify,ssuccessnotify,snotifytype,entryentity,jobnumber_id,schprincipal";
    private static final String SELECT_PROPERTIES_JOB = "number,name,jobtype,params,classname,runbylang,failnotify,successnotify,aborted,notifytype,status,runmode,timeout,retrytime,runorder,strategy,runconcurrent,overtime,appid";
    private static final String JOB_NUMBER = "job_number";
    private static final String JOB_NAME = "job_name";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static List fieldList = Arrays.asList("number", "name", "starttime", "endtime", "sfailnotify", "ssuccessnotify", "snotifytype", "job_number", "job_name", "schprincipal");
    private static List statusList = Arrays.asList("COMPLETED", "FAILED", "TIMEOUT", "ABORTED");
    private static final String SCHEDULED = "SCHEDULED";
    private static final String BEGIN = "BEGIN";
    private static final String COMPLETED = "COMPLETED";
    private static final String FAILED = "FAILED";
    private static final String TIMEOUT = "TIMEOUT";
    private static final String ABORTED = "ABORTED";
    private static final String NONEED = "NONEED";
    private static final String msgtype = "{msgtype}";
    private static final String SCH = "SCH_";
    private static final String JOB = "JOB_";
    private static final int OUTTIME = 1800;

    public void sendMessage(JobNotifyEvent jobNotifyEvent) {
        try {
            kd.bos.schedule.api.MessageInfo msgInfo = jobNotifyEvent.getMessageInfo();
            JobInfo jobInfo = msgInfo.fetchJobInfo();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sch_task", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobInfo.getTaskId())});
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return;
            }
            DynamicObject dynamicObject = dynamicObjects[0];
            String status = dynamicObject.getString("status");
            if (!statusList.contains(status)) {
                return;
            }
            this.executeSendJobMessage(status, jobInfo);
            this.executeSendScheduleMessage(status, jobInfo);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25: ", (Throwable)e);
        }
    }

    private void executeSendJobMessage(String status, JobInfo jobInfo) {
        MessageInfo sendJobMesByOldNotify;
        String jobCaption = String.format(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u901a\u77e5\uff08\u4efb\u52a1\uff1a%s\uff09", (String)"JobProcessorNotify_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), jobInfo.getTaskId());
        String jobTag = ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u901a\u77e5", (String)"JobProcessorNotify_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
        DynamicObject dynamicObject = ScheduleDataEntityUtils.getInvoker().loadSingleFromCache(SchEntityType.Job, (Object)jobInfo.getId(), "msgnotifyentity.fmulmsgreceiver,msgnotifyentity.fmsgtype,msgnotifyentity.fsnotifytype,msgnotifyentity.fsmsgcontent");
        DynamicObjectCollection msgObjects = dynamicObject.getDynamicObjectCollection("msgnotifyentity");
        if (!CollectionUtils.isEmpty((Collection)msgObjects)) {
            messageInfoList.addAll(this.getSendJobMessListByNotifyList(msgObjects, status, jobCaption, jobTag, jobInfo));
        } else if (this.needSendMessageNotifyForOldNotify(status, jobInfo, true) && (sendJobMesByOldNotify = this.getSendJobMesByOldNotify(status, jobCaption, jobTag, jobInfo)) != null) {
            messageInfoList.add(sendJobMesByOldNotify);
        }
        this.sendMessageNotify(messageInfoList, jobInfo, true);
    }

    private void executeSendScheduleMessage(String status, JobInfo jobInfo) {
        MessageInfo sendMesByOldNotify;
        ScheduleMsgInfo scheduleMsgInfo = jobInfo.getScheduleMsgInfo();
        if (scheduleMsgInfo == null) {
            return;
        }
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
        String scheduleId = jobInfo.getScheduleId();
        if (StringUtils.isEmpty((CharSequence)scheduleId)) {
            log.debug("scheduleId\u4e3a\u7a7a; ##taskId\uff1a" + jobInfo.getTaskId());
            return;
        }
        DynamicObject dynamicObject = ScheduleDataEntityUtils.getInvoker().loadSingleFromCache(SchEntityType.Schedule, (Object)scheduleId, "msgnotifyentity.fmulmsgreceiver,msgnotifyentity.fmsgtype,msgnotifyentity.fsnotifytype,msgnotifyentity.fsmsgcontent");
        String schCaption = String.format(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\u901a\u77e5\uff08\u4efb\u52a1\uff1a%s\uff09", (String)"JobProcessorNotify_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), jobInfo.getTaskId());
        String schTag = ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\u901a\u77e5", (String)"JobProcessorNotify_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
        DynamicObjectCollection msgObjects = dynamicObject.getDynamicObjectCollection("msgnotifyentity");
        if (!CollectionUtils.isEmpty((Collection)msgObjects)) {
            messageInfoList.addAll(this.getSendMessListByNotifyList(msgObjects, status, schCaption, schTag, jobInfo));
        } else if (this.needSendMessageNotifyForOldNotify(status, jobInfo, false) && (sendMesByOldNotify = this.getSendMesByOldNotify(status, schCaption, schTag, jobInfo)) != null) {
            messageInfoList.add(sendMesByOldNotify);
        }
        this.sendMessageNotify(messageInfoList, jobInfo, false);
    }

    private boolean needSendMessageNotifyForOldNotify(String status, JobInfo jobInfo, boolean isJob) {
        if (isJob) {
            return COMPLETED.equals(status) && jobInfo.isSuccessNotify() || FAILED.equals(status) && jobInfo.isFailNotify() || TIMEOUT.equals(status) && jobInfo.isOverTime();
        }
        ScheduleMsgInfo scheduleMsgInfo = jobInfo.getScheduleMsgInfo();
        if (scheduleMsgInfo != null) {
            return COMPLETED.equals(status) && scheduleMsgInfo.isSuccessNotify() || FAILED.equals(status) && scheduleMsgInfo.isFailNotify() || TIMEOUT.equals(status) && scheduleMsgInfo.isTimeOut();
        }
        return false;
    }

    private void sendMessageNotify(List<MessageInfo> messageInfoList, JobInfo jobInfo, boolean isJob) {
        if (CollectionUtils.isEmpty(messageInfoList)) {
            log.debug("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        if (RouteMode.SHARDINGBROADCAST == jobInfo.getRouteMode() || RouteMode.SHARDINGTASK == jobInfo.getRouteMode()) {
            String groupId = String.valueOf(jobInfo.getGroupId());
            String shardingResult = this.computeShardingResult(jobInfo);
            if (shardingResult == null || StringUtils.equals((CharSequence)NONEED, (CharSequence)shardingResult)) {
                log.info("\u5206\u7247\u4efb\u52a1\u672a\u7ed3\u675f\u6216\u8df3\u8fc7\u3001\u7ec8\u6b62");
                return;
            }
            StringBuilder lockKey = new StringBuilder();
            if (isJob) {
                lockKey.append(JOB);
            } else {
                lockKey.append(SCH);
            }
            lockKey.append(jobInfo.getGroupId());
            try (DLock lock = DLock.create((String)lockKey.toString());){
                String taskId;
                if (!lock.tryLock(0L)) {
                    log.info("\u5206\u7247\u4efb\u52a1\u672a\u83b7\u53d6\u5230lock");
                    return;
                }
                if (isJob) {
                    taskId = (String)this.cache.get(JOB, groupId);
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        return;
                    }
                } else {
                    taskId = (String)this.cache.get(SCH, groupId);
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        return;
                    }
                }
                this.putGroupIdCache(jobInfo.getTaskId(), groupId, isJob);
                for (MessageInfo messageInfo : messageInfoList) {
                    MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
                }
                log.debug("\u53d1\u9001\u901a\u77e5\u6210\u529f:" + jobInfo.getTaskId());
            }
        } else {
            for (MessageInfo messageInfo : messageInfoList) {
                MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            }
            log.debug("\u53d1\u9001\u901a\u77e5\u6210\u529f:" + jobInfo.getTaskId());
        }
    }

    private List<MessageInfo> getSendMessListByNotifyList(DynamicObjectCollection msgObjects, String status, String caption, String tag, JobInfo jobInfo) {
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
        ScheduleMsgInfo smi = jobInfo.getScheduleMsgInfo();
        long schPrincipal = smi.getSchPrincipal();
        HashSet<Long> receiverIds = new HashSet<Long>(2);
        for (DynamicObject msgDynamicObject : msgObjects) {
            String msgType = (String)msgDynamicObject.get("fmsgtype");
            if (StringUtils.isEmpty((CharSequence)msgType) || !msgType.contains(status)) continue;
            String notifyTypes = (String)msgDynamicObject.get("fsnotifytype");
            if (StringUtils.isBlank((CharSequence)notifyTypes)) {
                log.debug("\u6ca1\u6709\u914d\u7f6e\u6d88\u606f\u6e20\u9053notifyTypes");
                continue;
            }
            Object[] notifyTypeArray = notifyTypes.split(",");
            String channels = StringUtils.join((Object[])notifyTypeArray, (String)",");
            String msgContent = this.replaceMsgContent(status, (String)msgDynamicObject.get("fsmsgcontent"));
            if (StringUtils.isBlank((CharSequence)msgContent)) {
                log.debug("\u6d88\u606f\u5185\u5bb9msgContent is null");
                continue;
            }
            String compileMsgContent = this.schExpressionResolution(msgContent, jobInfo);
            DynamicObjectCollection msgrs = (DynamicObjectCollection)msgDynamicObject.get("fmulmsgreceiver");
            if (msgrs != null && msgrs.size() > 0) {
                for (DynamicObject msg : msgrs) {
                    Object userObj = msg.get("fbasedataid");
                    if (userObj == null) continue;
                    receiverIds.add((Long)((DynamicObject)userObj).getPkValue());
                }
            }
            if (schPrincipal != 0L) {
                receiverIds.add(schPrincipal);
            }
            if (receiverIds.size() == 0) {
                log.debug("\u6ca1\u6709\u6307\u5b9a\u6267\u884c\u4f5c\u4e1a\u7684\u7528\u6237\u6216\u8005\u6d88\u606f\u63a5\u6536\u4eba");
                continue;
            }
            messageInfoList.add(this.buildMsgInfo(tag, new ArrayList<Long>(receiverIds), compileMsgContent, caption, channels));
            receiverIds.clear();
        }
        return messageInfoList;
    }

    private MessageInfo getSendMesByOldNotify(String status, String caption, String tag, JobInfo jobInfo) {
        ScheduleMsgInfo smi = jobInfo.getScheduleMsgInfo();
        String msgContent = this.replaceMsgContent(status, smi.getMsgContent());
        long msgreceiver = smi.getMsgreceiver();
        long schPrincipal = smi.getSchPrincipal();
        String notifyTypes = smi.getNotifyType();
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            log.debug("\u6ca1\u6709\u6307\u5b9a\u6d88\u606f\u6e20\u9053");
            return null;
        }
        Object[] notifyTypeArray = notifyTypes.split(",");
        String channels = StringUtils.join((Object[])notifyTypeArray, (String)",");
        String compileMsgContent = this.schExpressionResolution(msgContent, jobInfo);
        HashSet<Long> receiverIds = new HashSet<Long>(2);
        if (msgreceiver != 0L) {
            receiverIds.add(msgreceiver);
        }
        if (schPrincipal != 0L) {
            receiverIds.add(schPrincipal);
        }
        if (receiverIds.size() == 0) {
            log.debug("\u6ca1\u6709\u6307\u5b9a\u6267\u884c\u4f5c\u4e1a\u7684\u7528\u6237\u6216\u8005\u6d88\u606f\u63a5\u6536\u4eba");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)notifyTypes)) {
            log.debug("\u6ca1\u6709\u914d\u7f6e\u6d88\u606f\u6e20\u9053notifyTypes");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)msgContent)) {
            log.debug("\u6d88\u606f\u5185\u5bb9msgContent is null");
            return null;
        }
        return this.buildMsgInfo(tag, new ArrayList<Long>(receiverIds), compileMsgContent, caption, channels);
    }

    private List<MessageInfo> getSendJobMessListByNotifyList(DynamicObjectCollection msgObjects, String status, String caption, String tag, JobInfo jobInfo) {
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
        long jobPrincipal = jobInfo.getJobPrincipal();
        HashSet<Long> receiverIds = new HashSet<Long>(2);
        for (DynamicObject msgDynamicObject : msgObjects) {
            String msgType = (String)msgDynamicObject.get("fmsgtype");
            if (StringUtils.isEmpty((CharSequence)msgType) || !msgType.contains(status)) continue;
            String notifyTypes = (String)msgDynamicObject.get("fsnotifytype");
            if (StringUtils.isBlank((CharSequence)notifyTypes)) {
                log.debug("\u4f5c\u4e1a\u6ca1\u6709\u914d\u7f6e\u6d88\u606f\u6e20\u9053notifyTypes");
                continue;
            }
            Object[] notifyTypeArray = notifyTypes.split(",");
            String channels = StringUtils.join((Object[])notifyTypeArray, (String)",");
            String msgContent = this.replaceMsgContent(status, (String)msgDynamicObject.get("fsmsgcontent"));
            if (StringUtils.isBlank((CharSequence)msgContent)) {
                log.debug("\u4f5c\u4e1a\u6d88\u606f\u5185\u5bb9msgContent is null");
                continue;
            }
            String compileMsgContent = this.jobExpressionResolution(msgContent, jobInfo.getId());
            DynamicObjectCollection msgrs = (DynamicObjectCollection)msgDynamicObject.get("fmulmsgreceiver");
            if (msgrs != null && msgrs.size() > 0) {
                for (DynamicObject msg : msgrs) {
                    Object userObj = msg.get("fbasedataid");
                    if (userObj == null) continue;
                    receiverIds.add((Long)((DynamicObject)userObj).getPkValue());
                }
            }
            if (jobPrincipal != 0L) {
                receiverIds.add(jobPrincipal);
            }
            if (receiverIds.size() == 0) {
                log.debug("\u6ca1\u6709\u4f5c\u4e1a\u6307\u5b9a\u6267\u884c\u4f5c\u4e1a\u7684\u7528\u6237\u6216\u8005\u6d88\u606f\u63a5\u6536\u4eba");
                continue;
            }
            messageInfoList.add(this.buildMsgInfo(tag, new ArrayList<Long>(receiverIds), compileMsgContent, caption, channels));
            receiverIds.clear();
        }
        return messageInfoList;
    }

    private MessageInfo getSendJobMesByOldNotify(String status, String caption, String tag, JobInfo jobInfo) {
        String msgContent = this.replaceMsgContent(status, jobInfo.getMsgContent());
        long msgreceiver = jobInfo.getJobMsgReceiver();
        long jobPrincipal = jobInfo.getJobPrincipal();
        String notifyTypes = jobInfo.getNotifyType();
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            log.debug("\u6ca1\u6709\u6307\u5b9a\u6d88\u606f\u6e20\u9053");
            return null;
        }
        Object[] notifyTypeArray = notifyTypes.split(",");
        String channels = StringUtils.join((Object[])notifyTypeArray, (String)",");
        String compileMsgContent = this.jobExpressionResolution(msgContent, jobInfo.getId());
        HashSet<Long> receiverIds = new HashSet<Long>(2);
        if (msgreceiver != 0L) {
            receiverIds.add(msgreceiver);
        }
        if (jobPrincipal != 0L) {
            receiverIds.add(jobPrincipal);
        }
        if (receiverIds.size() == 0) {
            log.debug("\u6ca1\u6709\u6307\u5b9a\u6267\u884c\u4f5c\u4e1a\u7684\u7528\u6237\u6216\u8005\u6d88\u606f\u63a5\u6536\u4eba");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)notifyTypes)) {
            log.debug("\u6ca1\u6709\u914d\u7f6e\u6d88\u606f\u6e20\u9053notifyTypes");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)msgContent)) {
            log.debug("\u6d88\u606f\u5185\u5bb9msgContent is null");
            return null;
        }
        return this.buildMsgInfo(tag, new ArrayList<Long>(receiverIds), compileMsgContent, caption, channels);
    }

    private String replaceMsgContent(String type, String msgContent) {
        if (msgContent == null) {
            return "";
        }
        switch (type) {
            case "COMPLETED": {
                msgContent = msgContent.replace(msgtype, ResManager.loadKDString((String)"\u6210\u529f", (String)"JobProcessorNotify_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "FAILED": {
                msgContent = msgContent.replace(msgtype, ResManager.loadKDString((String)"\u5931\u8d25", (String)"JobProcessorNotify_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "TIMEOUT": {
                msgContent = msgContent.replace(msgtype, ResManager.loadKDString((String)"\u8d85\u65f6", (String)"JobProcessorNotify_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "ABORTED": {
                msgContent = msgContent.replace(msgtype, ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"JobProcessorNotify_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        return msgContent;
    }

    private String computeShardingResult(JobInfo jobInfo) {
        String shardingRunResult = null;
        String strSQL = "SELECT FSTATUS FROM T_SCH_TASK  WHERE FGROUPID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FGROUPID", 12, (Object)jobInfo.getGroupId())};
        List resultList = (List)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])params, rs -> {
            ArrayList<String> results = new ArrayList<String>(10);
            while (rs.next()) {
                String fstatus = rs.getString("FSTATUS");
                results.add(fstatus);
            }
            return results;
        });
        if (!resultList.contains(SCHEDULED) && !resultList.contains(BEGIN)) {
            Map map = resultList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            shardingRunResult = map.get(COMPLETED) != null && map.get(COMPLETED) == (long)jobInfo.getExecuteTime() ? COMPLETED : (resultList.contains(FAILED) ? FAILED : (resultList.contains(TIMEOUT) && !resultList.contains(FAILED) ? TIMEOUT : (resultList.contains(ABORTED) ? ABORTED : NONEED)));
        }
        return shardingRunResult;
    }

    private MessageInfo buildMsgInfo(String tag, List<Long> receiverIds, String msgContent, String caption, String channels) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setContent(msgContent);
        messageInfo.setUserIds(receiverIds);
        String title = caption;
        messageInfo.setTitle(title);
        messageInfo.setTag(tag);
        messageInfo.setNotifyType(channels);
        return messageInfo;
    }

    private String schExpressionResolution(String msgcontent, JobInfo jobInfo) {
        String regex = "\\{([^}]*)\\}";
        try {
            Pattern compile = Pattern.compile(regex);
            Matcher matcher = compile.matcher(msgcontent);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sch_schedule", (String)SELECT_PROPERTIES_SCH, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobInfo.getScheduleId())});
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                DynamicObject dynamicObject = dynamicObjects[0];
                ArrayList<String> jobFieldList = new ArrayList<String>();
                while (matcher.find()) {
                    DateTimeProp dateTimeProp;
                    DateTimeColumnDesc colDesc;
                    Object result;
                    String group = matcher.group();
                    String fieldName = group.substring(1, group.length() - 1);
                    if (StringUtils.isBlank((CharSequence)fieldName)) {
                        msgcontent = msgcontent.replace(group, "");
                        continue;
                    }
                    if (!fieldList.contains(fieldName)) continue;
                    if (JOB_NUMBER.equals(fieldName) || JOB_NAME.equals(fieldName)) {
                        jobFieldList.add(fieldName);
                        continue;
                    }
                    if ("schprincipal".equals(fieldName)) {
                        DynamicObject dyo = (DynamicObject)dynamicObject.get("schprincipal");
                        String schprincipal = dyo != null ? dyo.getString("name") : "";
                        msgcontent = msgcontent.replace(group, StringUtils.isBlank((CharSequence)schprincipal) ? "" : schprincipal);
                        continue;
                    }
                    String value = String.valueOf(dynamicObject.get(fieldName));
                    DynamicProperty property = dynamicObject.getDynamicObjectType().getProperty(fieldName);
                    if (property instanceof DateTimeProp && (result = (colDesc = new DateTimeColumnDesc(fieldName, dateTimeProp = (DateTimeProp)property, (IDataEntityProperty)dateTimeProp)).getValue(dynamicObject)) instanceof Object[]) {
                        Object[] val = (Object[])result;
                        value = val[0].toString();
                    }
                    msgcontent = msgcontent.replace(group, StringUtils.isBlank((CharSequence)value) ? "" : value);
                }
                if (jobFieldList.size() > 0) {
                    msgcontent = this.handleJobField(msgcontent, jobInfo, dynamicObject);
                }
            }
        }
        catch (Exception e) {
            log.error("build msgcontent exception: ", (Throwable)e);
        }
        return msgcontent;
    }

    private String handleJobField(String msgcontent, JobInfo jobInfo, DynamicObject dynamicObject) {
        DynamicObjectCollection doCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyo : doCollection) {
            DynamicObject[] jobInfoDyo;
            String jobId = dyo.getString("jobnumber_id");
            if (!StringUtils.equals((CharSequence)jobInfo.getId(), (CharSequence)jobId) || (jobInfoDyo = BusinessDataServiceHelper.load((String)"sch_job", (String)SELECT_PROPERTIES_JOB, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobId)})) == null || jobInfoDyo.length <= 0) continue;
            if (fieldList.contains(JOB_NUMBER)) {
                String number = jobInfoDyo[0].getString("number");
                msgcontent = msgcontent.replace("{job_number}", StringUtils.isBlank((CharSequence)number) ? "" : number);
            }
            if (!fieldList.contains(JOB_NAME)) continue;
            String name = jobInfoDyo[0].getString("name");
            msgcontent = msgcontent.replace("{job_name}", StringUtils.isBlank((CharSequence)name) ? "" : name);
        }
        return msgcontent;
    }

    private String jobExpressionResolution(String msgcontent, String jobId) {
        block7: {
            String regex = "\\{([^}]*)\\}";
            try {
                Pattern compile = Pattern.compile(regex);
                Matcher matcher = compile.matcher(msgcontent);
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sch_job", (String)SELECT_PROPERTIES_JOB, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobId)});
                if (dynamicObjects == null || dynamicObjects.length <= 0) break block7;
                DynamicObject dynamicObject = dynamicObjects[0];
                while (matcher.find()) {
                    String group = matcher.group();
                    String fieldName = group.substring(1, group.length() - 1);
                    if (StringUtils.isBlank((CharSequence)fieldName)) {
                        msgcontent = msgcontent.replace(group, "");
                        continue;
                    }
                    String value = null;
                    try {
                        value = String.valueOf(dynamicObject.get(fieldName));
                    }
                    catch (Exception e) {
                        log.info(fieldName + "\u5c5e\u6027\u4e0d\u5b58\u5728\uff1a" + e.getMessage());
                        continue;
                    }
                    if ("runmode".equalsIgnoreCase(fieldName)) {
                        value = StringUtils.equals((CharSequence)"1", (CharSequence)value) ? ResManager.loadKDString((String)"\u5e7f\u64ad\u5206\u7247", (String)"JobProcessorNotify_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)"2", (CharSequence)value) ? ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7247", (String)"JobProcessorNotify_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u673a\u6267\u884c", (String)"JobProcessorNotify_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    msgcontent = msgcontent.replace(group, StringUtils.isBlank((CharSequence)value) ? "" : value);
                }
            }
            catch (Exception e) {
                log.error("build msgcontent exception: ", (Throwable)e);
            }
        }
        return msgcontent;
    }

    private void putGroupIdCache(String taskId, String groupId, boolean isJob) {
        if (isJob) {
            this.cache.put(JOB, groupId, taskId, 1800);
        } else {
            this.cache.put(SCH, groupId, taskId, 1800);
        }
    }
}

