/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClick;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.schedule.form.event.ItemClickEventArgs;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AbstractTaskClick
implements TaskClick {
    private IFormView mainView;
    private JobFormInfo JobFormInfo;
    private String taskId;

    public IFormView getMainView() {
        return this.mainView;
    }

    public IFormView getParentView() {
        if (this.getJobFormInfo() == null || StringUtils.isBlank((CharSequence)this.getJobFormInfo().getParentPageId())) {
            return null;
        }
        IFormView view = SessionManager.getCurrent().getView(this.getJobFormInfo().getParentPageId());
        return view;
    }

    public JobFormInfo getJobFormInfo() {
        return this.JobFormInfo;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskInfo queryTask() {
        return ScheduleServiceHelper.queryTask((String)this.getTaskId());
    }

    public boolean isExistProgressForm() {
        IFormView progressView;
        String progressPageId = TaskClientProxy.getProgressPageId(this.getTaskId());
        return StringUtils.isNotBlank((CharSequence)progressPageId) && (progressView = this.getMainView().getViewNoPlugin(progressPageId)) != null;
    }

    public void setProgressPageId(String pageId) {
        TaskClientProxy.setProgressPageId(this.getTaskId(), pageId);
    }

    @Override
    public void setContext(IFormView mainView, JobFormInfo jobFormInfo, String taskId) {
        this.mainView = mainView;
        this.JobFormInfo = jobFormInfo;
        this.taskId = taskId;
    }

    @Override
    public void click(ClickEventArgs e) {
    }

    @Override
    public void itemClick(ItemClickEventArgs e) {
    }

    @Override
    public boolean release() {
        return true;
    }
}

