/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.mvc.cache.RootPageCache;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientCache;

class TaskNoticeAction {
    private static final String ACTION_ADD_TASK = "addTask";
    private static final String ACTION_DEL_TASK = "delTask";
    private static final String ACTION_UPDATE_TASK = "updateTask";

    TaskNoticeAction() {
    }

    public static void addTask(JobFormInfo jobFormInfo, TaskInfo taskInfo, List<Map<String, Object>> formActions) {
        List<Map<String, Object>> paraList = TaskNoticeAction.buildAddTaskParams(jobFormInfo, taskInfo);
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("p", paraList);
        action.put("a", ACTION_ADD_TASK);
        ArrayList<Map<String, Object>> actions = new ArrayList<Map<String, Object>>();
        actions.add(action);
        if (formActions != null) {
            actions.addAll(formActions);
        }
        TaskNoticeAction.sendMessage(jobFormInfo.getRootPageId(), SerializationUtils.toJsonString(actions), taskInfo.getId());
    }

    public static void addTask(IFormView view, JobFormInfo jobFormInfo, TaskInfo taskInfo) {
        if (view == null) {
            TaskNoticeAction.addTask(jobFormInfo, taskInfo, null);
            return;
        }
        List<Map<String, Object>> paraList = TaskNoticeAction.buildAddTaskParams(jobFormInfo, taskInfo);
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.addAction(ACTION_ADD_TASK, paraList);
    }

    private static List<Map<String, Object>> buildAddTaskParams(JobFormInfo jobFormInfo, TaskInfo taskInfo) {
        ArrayList<Map<String, Object>> paraList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        JobInfo jobInfo = jobFormInfo.getJobInfo();
        paraMap.put("appid", jobFormInfo.getJobInfo().getAppId());
        paraMap.put("taskid", taskInfo.getId());
        paraMap.put("title", jobInfo.getlName() == null ? "" : jobInfo.getlName().toString());
        paraMap.put("status", taskInfo.getStatus());
        paraMap.put("progress", taskInfo.getProgress());
        paraMap.put("desc", taskInfo.getDesc());
        if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getTaskIcon())) {
            paraMap.put("icon", jobFormInfo.getTaskIcon());
        }
        paraList.add(paraMap);
        return paraList;
    }

    public static void feedbackProgress(JobFormInfo jobFormInfo, TaskInfo taskInfo, List<Map<String, Object>> formActions) {
        HashMap<String, Object> action = new HashMap<String, Object>();
        List<Map<String, Object>> paraList = TaskNoticeAction.buildUpdateTaskParams(jobFormInfo, taskInfo);
        action.put("p", paraList);
        action.put("a", ACTION_UPDATE_TASK);
        ArrayList<Map<String, Object>> actions = new ArrayList<Map<String, Object>>();
        actions.add(action);
        if (formActions != null) {
            actions.addAll(formActions);
        }
        TaskNoticeAction.sendMessage(jobFormInfo.getRootPageId(), SerializationUtils.toJsonString(actions), taskInfo.getId());
    }

    public static void feedbackProgress(IFormView view, JobFormInfo jobFormInfo, TaskInfo taskInfo) {
        if (view == null) {
            TaskNoticeAction.feedbackProgress(jobFormInfo, taskInfo, null);
            return;
        }
        List<Map<String, Object>> paraList = TaskNoticeAction.buildUpdateTaskParams(jobFormInfo, taskInfo);
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.addAction(ACTION_UPDATE_TASK, paraList);
    }

    private static List<Map<String, Object>> buildUpdateTaskParams(JobFormInfo jobFormInfo, TaskInfo taskInfo) {
        String name = null;
        if (jobFormInfo.getJobInfo().getlName() != null) {
            name = jobFormInfo.getJobInfo().getlName().toString();
        }
        ArrayList<Map<String, Object>> paraList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("taskid", taskInfo.getId());
        paraMap.put("title", name);
        paraMap.put("status", taskInfo.getStatus());
        paraMap.put("progress", taskInfo.getProgress());
        paraMap.put("desc", taskInfo.getDesc());
        paraList.add(paraMap);
        return paraList;
    }

    public static void delTask(JobFormInfo jobFormInfo, String taskId, List<Map<String, Object>> formActions) {
        String rootPageId = jobFormInfo == null ? null : jobFormInfo.getRootPageId();
        HashMap<String, Object> action = new HashMap<String, Object>();
        ArrayList paraList = new ArrayList();
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("taskid", taskId);
        paraList.add(paraMap);
        action.put("p", paraList);
        action.put("a", ACTION_DEL_TASK);
        ArrayList<Map<String, Object>> actions = new ArrayList<Map<String, Object>>();
        actions.add(action);
        if (formActions != null) {
            actions.addAll(formActions);
        }
        TaskNoticeAction.sendMessage(rootPageId, SerializationUtils.toJsonString(actions), taskId);
    }

    public static void delTask(IFormView mainView, String taskId) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("taskid", taskId);
        IClientViewProxy clientViewProxy = (IClientViewProxy)mainView.getService(IClientViewProxy.class);
        clientViewProxy.addAction(ACTION_DEL_TASK, paraMap);
    }

    private static void sendMessage(String rootPageId, String actions, String taskId) {
        JobFormInfo jobFormInfo = TaskClientCache.getJobInfo(taskId);
        List<String> webSocketIds = TaskNoticeAction.getWebStockId(rootPageId, jobFormInfo);
        for (String webSocketId : webSocketIds) {
            MsgSendFactory.getSender().send(webSocketId, actions);
        }
    }

    private static List<String> getWebStockId(String rootPageId, JobFormInfo jobFormInfo) {
        RequestContext rc = RequestContext.get();
        String curSessionId = rc.getGlobalSessionId();
        Set<Object> sessionIds = jobFormInfo == null ? new HashSet(3) : jobFormInfo.getSessionIds();
        List webSocketIds = WebSocketIdReader.getWebSocketIds((String)rc.getAccountId(), (String)curSessionId);
        HashSet set = new HashSet(webSocketIds);
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)rootPageId) && set.contains(rootPageId) && sessionIds.isEmpty()) {
            list.add(rootPageId);
            return list;
        }
        sessionIds.add(curSessionId);
        if (jobFormInfo != null && StringUtils.isNotEmpty((CharSequence)jobFormInfo.getOriginSessionid()) && !sessionIds.contains(jobFormInfo.getOriginSessionid())) {
            sessionIds.add(jobFormInfo.getOriginSessionid());
        }
        for (String string : sessionIds) {
            if (StringUtils.isEmpty((CharSequence)string)) continue;
            List rootPageIds = RootPageCache.getRootPageIds((String)string);
            list.addAll(rootPageIds);
        }
        return list;
    }

    private static List<String> getRootPageIds(List<String> sessionIds) {
        ArrayList<String> result = new ArrayList<String>(6);
        for (String sessionid : sessionIds) {
            result.addAll(RootPageCache.getRootPageIds((String)sessionid));
        }
        return result;
    }
}

