/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form.sample;

import java.lang.constant.Constable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;

public class JobDispatchFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_JOBDISPATCH = "btnjobdispatch";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_JOBDISPATCH});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_JOBDISPATCH, (CharSequence)source.getKey())) {
            this.dispatch();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void dispatch() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setlName(ResManager.getLocaleString((String)"\u6d4b\u8bd5\u4f5c\u4e1a", (String)"JobDispatchFormPlugin_1", (String)"bos-schedule-form"));
        jobInfo.setNumber("testjobnumber");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.schedule.form.sample.MyTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        int time = 40;
        DataEntityPropertyCollection props = this.getModel().getDataEntity().getDataEntityType().getProperties();
        if (props.get((Object)"time") instanceof IntegerProp) {
            time = this.getModel().getDataEntity().getInt("time");
        }
        boolean isSuccess = true;
        if (props.get((Object)"isscuccess") instanceof BooleanProp) {
            isSuccess = this.getModel().getDataEntity().getBoolean("isscuccess");
        }
        params.put("time", Integer.valueOf(time));
        params.put("issuccess", Boolean.valueOf(isSuccess));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u6d4b\u8bd5\u4efb\u52a1\u7684\u6267\u884c", (String)"JobDispatchFormPlugin_0", (String)"bos-schedule-form", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.bos.schedule.form.sample.MyTaskClick");
        JobForm.dispatch(jobFormInfo, this.getView());
    }

    private void taskCallBack(Object returnData) {
        String data;
        TaskInfo taskInfo;
        Map result;
        String taskInfoStr;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData()))) {
            this.getView().showMessage(data);
        }
    }
}

