/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.next.observable.IObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.threads.ThreadPools;

public class ObservableLogHandler
implements Runnable {
    private static final Log logger = LogFactory.getLog(ObservableLogHandler.class);
    private static ConcurrentHashMap<String, IObservableDataFilter> filterList = new ConcurrentHashMap();
    private static ExecutorService executor = ThreadPools.newCachedExecutorService((String)"BOSSchedule-TraceLogHandler", (int)1, (int)1);
    private static LinkedBlockingQueue observableQueue = new LinkedBlockingQueue();

    @Override
    public void run() {
        this.execute();
    }

    public void execute() {
        while (true) {
            try {
                block5: while (true) {
                    ObservableModel model = (ObservableModel)observableQueue.take();
                    Iterator<Map.Entry<String, IObservableDataFilter>> iterator = filterList.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        Map.Entry<String, IObservableDataFilter> entry = iterator.next();
                        try {
                            entry.getValue().handle(model);
                        }
                        catch (Throwable t) {
                            logger.error("Schedule***observableFilter error,filterName : {}", (Object)entry.getKey(), (Object)t);
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error:Schedule***ObservableLogHandler execute error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public static ConcurrentHashMap<String, IObservableDataFilter> getFilters() {
        return filterList;
    }

    public static IObservableDataFilter getFilters(String classz) {
        if (filterList.containsKey(classz)) {
            return filterList.get(classz);
        }
        return null;
    }

    public static List<IObservableDataFilter> getFiltersByType(String filterType) {
        if (StringUtils.isEmpty((CharSequence)filterType)) {
            return Collections.emptyList();
        }
        ArrayList<IObservableDataFilter> list = new ArrayList<IObservableDataFilter>(filterList.size());
        for (IObservableDataFilter filter : filterList.values()) {
            if (!filterType.equals(filter.getFilterType())) continue;
            list.add(filter);
        }
        return list;
    }

    public static void removeFilter(String classz) {
        if (filterList.containsKey(classz)) {
            filterList.remove(classz);
        }
    }

    public static void addFilter(String classz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ObservableLogHandler.addFilter(classz, true);
    }

    public static void addFilter(String classz, boolean isInit) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            IObservableDataFilter filter = (IObservableDataFilter)Class.forName(classz).newInstance();
            long startTime = System.currentTimeMillis();
            if (isInit) {
                filter.init();
            }
            logger.info("Schedule***init time:" + classz + ",cost:" + (System.currentTimeMillis() - startTime) + " ms");
            filterList.put(classz, filter);
        }
        catch (Exception e) {
            logger.error("Error:Schedule***ObservableLogHandler addFilter error", (Throwable)e);
        }
    }

    public static void collectData(ObservableModel model) {
        try {
            if (model != null) {
                observableQueue.put(model);
            }
        }
        catch (InterruptedException e) {
            logger.error("Error:Schedule***TraceLogHandler", (Throwable)e);
        }
    }

    static {
        try {
            if (Boolean.getBoolean("Schedule.disableToWork")) {
                logger.info("Schedule***\u5f53\u524d\u8282\u70b9\u7981\u7528\u6240\u6709\u8c03\u5ea6\u670d\u52a1");
            } else {
                ObservableLogHandler.addFilter("kd.bos.schedule.next.observable.filter.SchTaskStatusNumFilter");
                ObservableLogHandler.addFilter("kd.bos.schedule.next.observable.filter.Top5ScheduleTaskNumFilter", false);
                ObservableLogHandler.addFilter("kd.bos.schedule.next.observable.filter.SchTaskJobTypeNumFilter");
                ObservableLogHandler.addFilter("kd.bos.schedule.next.observable.filter.DetectTaskDataFilter");
                ObservableLogHandler.addFilter("kd.bos.schedule.next.observable.filter.TaskTraceFilter");
                executor.submit(new ObservableLogHandler());
            }
        }
        catch (Throwable t) {
            logger.error("Error:Schedule***ObservableLogHandler init", t);
        }
    }
}

