/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable.filter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.next.observable.IObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.next.observable.model.TaskTraceInfo;
import kd.bos.schedule.next.observable.model.TaskTraceStatusEnum;
import kd.bos.schedule.next.observable.model.TimerPulse;
import kd.bos.threads.ThreadPools;

public class TaskTraceFilter
implements IObservableDataFilter {
    private static final Log logger = LogFactory.getLog(TaskTraceFilter.class);
    private static final String TASK_TRACE_TABLE = "t_sch_tasktrace";
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final Integer CACHE_TASK_RECORD_MAXSIZE = 50000;
    private static final Integer BATCH_EXECUTE_SQL_NUMBER = 500;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:sss");
    private Map<String, Map<String, List<String>>> serverBeforeSendMQTaskStatus = new ConcurrentHashMap<String, Map<String, List<String>>>(16);
    private Map<String, LinkedBlockingQueue<TaskTraceInfo>> serverBeforeSendMQTaskTraceQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<TaskTraceInfo>>(16);
    private Map<String, LinkedBlockingQueue<TaskTraceInfo>> serverAfterSendMQTaskTraceQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<TaskTraceInfo>>(16);
    private Map<String, LinkedBlockingQueue<TaskTraceInfo>> executorPushReadyTaskTraceQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<TaskTraceInfo>>(16);
    private Map<String, Map<String, List<String>>> executorBeforeCompleteTaskStatus = new ConcurrentHashMap<String, Map<String, List<String>>>(16);
    private Map<String, LinkedBlockingQueue<TaskTraceInfo>> executorCompleteTaskTraceQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<TaskTraceInfo>>(16);
    private Thread taskTraceFilterThread = new Thread(() -> {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    List<Account> accounts = TaskTraceFilter.getAllAccountsOfCurrentEnv();
                    long startTime = System.currentTimeMillis();
                    for (Account account : accounts) {
                        try {
                            LinkedBlockingQueue<TaskTraceInfo> executorCompleteTaskTrace;
                            LinkedBlockingQueue<TaskTraceInfo> executorPushReadyTaskTrace;
                            LinkedBlockingQueue<TaskTraceInfo> serverAfterSendMQTaskTrace;
                            RequestContextCreator.createBatch((String)account.getTenantId(), (String)account.getAccountId(), null);
                            LinkedBlockingQueue<TaskTraceInfo> serverBeforeSendMQTaskTrace = this.serverBeforeSendMQTaskTraceQueue.get(account.getAccountId());
                            if (serverBeforeSendMQTaskTrace != null && !serverBeforeSendMQTaskTrace.isEmpty()) {
                                try {
                                    this.insertTaskTraceInfo(serverBeforeSendMQTaskTrace);
                                }
                                catch (Throwable t) {
                                    logger.error("Schedule***TaskTraceFilter serverBeforeSendMQTaskTrace insert error", t);
                                }
                            }
                            if ((serverAfterSendMQTaskTrace = this.serverAfterSendMQTaskTraceQueue.get(account.getAccountId())) != null && !serverAfterSendMQTaskTrace.isEmpty()) {
                                try {
                                    this.updateTaskTraceInfo(serverAfterSendMQTaskTrace);
                                }
                                catch (Throwable t) {
                                    logger.error("Schedule***TaskTraceFilter serverAfterSendMQTaskTrace update error", t);
                                }
                            }
                            if ((executorPushReadyTaskTrace = this.executorPushReadyTaskTraceQueue.get(account.getAccountId())) != null && !executorPushReadyTaskTrace.isEmpty()) {
                                try {
                                    this.updateExecutorTaskTraceInfo(executorPushReadyTaskTrace);
                                }
                                catch (Throwable t) {
                                    logger.error("Schedule***TaskTraceFilter executorPushReadyTaskTrace update error", t);
                                }
                            }
                            if ((executorCompleteTaskTrace = this.executorCompleteTaskTraceQueue.get(account.getAccountId())) == null || executorCompleteTaskTrace.isEmpty()) continue;
                            try {
                                this.updateTaskTraceInfo(executorCompleteTaskTrace);
                            }
                            catch (Throwable t) {
                                logger.error("Schedule***TaskTraceFilter executorCompleteTaskTrace update error", t);
                            }
                        }
                        catch (Throwable t) {
                            logger.error("Schedule***TaskTraceFilter account error,accountId:{}", (Object)account.getAccountId(), (Object)t);
                        }
                    }
                    logger.debug("Schedule***TaskTraceFilter task trace costTime : {}", (Object)(System.currentTimeMillis() - startTime));
                }
            }
            catch (Throwable t) {
                logger.error("Schedule***TaskTraceFilter task trace filter error", t);
                continue;
            }
            break;
        }
    });

    @Override
    public void handle(ObservableModel model) {
        if (model.getData() instanceof TimerPulse) {
            TimerPulse timerPulse = (TimerPulse)model.getData();
            if (!this.isSupportTaskTrace(timerPulse)) {
                return;
            }
            switch (model.getClassfiy()) {
                case "generateTime": {
                    this.addGenerateTimeTaskTraceStatus(timerPulse, model.getAccountId(), model.getTenantId());
                    break;
                }
                case "accountNotExist": {
                    this.addTaskNotAllowedFire(timerPulse, model.getAccountId(), model.getTenantId(), TaskTraceStatusEnum.SERVER_ACCOUNT_NOT_EXIST);
                    break;
                }
                case "scheduleVisitorPaused": {
                    this.addTaskNotAllowedFire(timerPulse, model.getAccountId(), model.getTenantId(), TaskTraceStatusEnum.SERVER_SCHEDULE_VISITOR_PAUSED);
                    break;
                }
                case "pushLocalQueue": {
                    this.addTaskTraceStatusBeforeSendMQ(timerPulse, model.getAccountId(), model.getTenantId(), TaskTraceStatusEnum.SERVER_PUSH_LOCAL_QUEUE);
                    break;
                }
                case "popLocalQueue": {
                    this.addTaskTraceStatusBeforeSendMQ(timerPulse, model.getAccountId(), model.getTenantId(), TaskTraceStatusEnum.SERVER_POP_LOCAL_QUEUE);
                    break;
                }
            }
        } else if (model.getData() instanceof MessageInfo) {
            MessageInfo messageInfo = (MessageInfo)model.getData();
            JobInfo jobInfo = messageInfo.fetchJobInfo();
            if (!this.isSupportTaskTrace(jobInfo)) {
                return;
            }
            if ((messageInfo.getMessageType() == MessageType.BIZJOB || messageInfo.getMessageType() == MessageType.BROADCASTJOB) && jobInfo != null && jobInfo.isFromScheduler()) {
                switch (model.getClassfiy()) {
                    case "beginSendMQ": {
                        this.addTaskTraceStatusSendMQ(messageInfo);
                        break;
                    }
                    case "sendMQSuccess": {
                        this.addTaskTraceStatusAfterSendMQ(messageInfo, TaskTraceStatusEnum.SERVER_SEND_MQ_SUCCESS);
                        break;
                    }
                    case "sendMQERROR": {
                        this.addTaskTraceStatusAfterSendMQ(messageInfo, TaskTraceStatusEnum.SERVER_ERROR);
                        break;
                    }
                    case "pushLocalReadyQueue": {
                        this.addTaskTraceStatusPushReady(messageInfo);
                        break;
                    }
                    case "popLocalReadyQueue": {
                        this.addTaskTraceStatusBeforeComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_POP_READY);
                        break;
                    }
                    case "receiveBroadcastTask": {
                        this.addTaskTraceStatusForBroadcast(messageInfo);
                        break;
                    }
                    case "submitThreadPool": {
                        this.addTaskTraceStatusBeforeComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_SUBMIT_THREAD_POOL);
                        break;
                    }
                    case "beginExecuteTask": {
                        this.addTaskTraceStatusBeforeComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_BEGIN_TASK);
                        break;
                    }
                    case "completeTaskSuccess": {
                        this.addTaskTraceStatusComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_COMPLETE_TASK);
                        break;
                    }
                    case "haveNoMessageHandlers": {
                        this.addTaskTraceStatusComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_HAVE_NO_MESSAGE_HANDLE);
                        break;
                    }
                    case "threadPoolError": {
                        this.addTaskTraceStatusComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_ERROR);
                        break;
                    }
                    case "abortTaskByUser": {
                        this.addTaskTraceStatusComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_TASK_ABORTED);
                        break;
                    }
                    case "skipTask": {
                        this.addTaskTraceStatusComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_TASK_SKIP);
                        break;
                    }
                    case "timeoutTask": {
                        this.addTaskTraceStatusComplete(messageInfo, TaskTraceStatusEnum.EXECUTOR_TASK_TIMEOUT);
                        break;
                    }
                }
            }
        } else if (model.getData() instanceof TaskInfo && "abortTaskByReboot".equalsIgnoreCase(model.getClassfiy())) {
            this.abortTaskTraceInfo(model);
        }
    }

    private boolean isSupportTaskTrace(TimerPulse timerPulse) {
        ScheduleInfo scheduleInfo = timerPulse.getInfo();
        if (scheduleInfo != null) {
            return this.isSupportTaskTrace(scheduleInfo.getJobInfo());
        }
        return false;
    }

    private boolean isSupportTaskTrace(JobInfo jobInfo) {
        return jobInfo != null && jobInfo.isTaskTrace();
    }

    private void addGenerateTimeTaskTraceStatus(TimerPulse timerPulse, String accountId, String tenantId) {
        ScheduleInfo scheduleInfo = timerPulse.getInfo();
        Map beforeSendMQTaskStatus = this.serverBeforeSendMQTaskStatus.computeIfAbsent(accountId, k -> new ConcurrentHashMap());
        if (beforeSendMQTaskStatus.size() > CACHE_TASK_RECORD_MAXSIZE) {
            return;
        }
        List<String> taskStatuses = Collections.synchronizedList(new ArrayList());
        StringBuilder statusBuilder = new StringBuilder();
        statusBuilder.append(sdf.format(new Date())).append("#").append(TaskTraceStatusEnum.SERVER_GENERATE_TIME.getStatusCode()).append("#").append(sdf.format(Date.from(scheduleInfo.getLastExecuteTime().toInstant()))).append(":").append(Instance.getInstanceId()).append("\r\n");
        taskStatuses.add(statusBuilder.toString());
        beforeSendMQTaskStatus.put(timerPulse.getTaskId(), taskStatuses);
    }

    private void addTaskNotAllowedFire(TimerPulse timerPulse, String accountId, String tenantId, TaskTraceStatusEnum taskTraceStatusEnum) {
        Map<String, List<String>> taskIdTaskTrace = this.serverBeforeSendMQTaskStatus.get(accountId);
        LinkedBlockingQueue taskTraceInfoQueue = this.serverBeforeSendMQTaskTraceQueue.computeIfAbsent(accountId, k -> new LinkedBlockingQueue());
        List<String> taskTraces = taskIdTaskTrace.get(timerPulse.getTaskId());
        TaskTraceInfo taskTraceInfo = this.mergeTaskTraceLog(taskTraces, taskTraceStatusEnum, timerPulse);
        try {
            if (taskTraceInfoQueue.size() > CACHE_TASK_RECORD_MAXSIZE) {
                return;
            }
            taskTraceInfoQueue.put(taskTraceInfo);
            taskIdTaskTrace.remove(timerPulse.getTaskId());
        }
        catch (InterruptedException e) {
            logger.error("Schedule***TaskTraceFilter BEFORE_SEND_MQ_TASK_TRACE_QUEUE IS INTERRUPTED, taskId : {}", (Object)timerPulse.getTaskId(), (Object)e);
        }
    }

    private TaskTraceInfo mergeTaskTraceLog(List<String> taskTraces, TaskTraceStatusEnum currentTaskTraceStatus, TimerPulse timerPulse) {
        ScheduleInfo info = timerPulse.getInfo();
        TaskTraceInfo taskTraceInfo = new TaskTraceInfo();
        taskTraceInfo.setTaskId(timerPulse.getTaskId());
        taskTraceInfo.setScheduleId(info.getId());
        taskTraceInfo.setJobId(info.getJobId());
        taskTraceInfo.setStatus(currentTaskTraceStatus.getStatusCode());
        JobInfo jobInfo = info.getJobInfo();
        if (jobInfo != null) {
            taskTraceInfo.setGroupId(jobInfo.getGroupId());
            if (jobInfo.getRouteMode() == RouteMode.SHARDINGBROADCAST) {
                taskTraceInfo.setMessageType(MessageType.BROADCASTJOB);
            } else {
                taskTraceInfo.setMessageType(MessageType.BIZJOB);
            }
        }
        StringBuilder statusRecordBuilder = new StringBuilder();
        for (String taskTrace : taskTraces) {
            statusRecordBuilder.append(taskTrace);
        }
        statusRecordBuilder.append(sdf.format(new Date())).append("#").append(currentTaskTraceStatus.getStatusCode());
        taskTraceInfo.setTaskRecord(statusRecordBuilder.toString());
        return taskTraceInfo;
    }

    private TaskTraceInfo mergeTaskTraceLog(List<String> taskTraces, TaskTraceStatusEnum currentTaskTraceStatus, MessageInfo messageInfo) {
        JobInfo jobInfo = messageInfo.fetchJobInfo();
        TaskTraceInfo taskTraceInfo = new TaskTraceInfo();
        taskTraceInfo.setTaskId(messageInfo.getTaskId());
        taskTraceInfo.setScheduleId(jobInfo.getScheduleId());
        taskTraceInfo.setJobId(jobInfo.getId());
        taskTraceInfo.setStatus(currentTaskTraceStatus.getStatusCode());
        taskTraceInfo.setGroupId(jobInfo.getGroupId());
        taskTraceInfo.setMessageType(messageInfo.getMessageType());
        StringBuilder statusRecordBuilder = new StringBuilder();
        for (String taskTrace : taskTraces) {
            statusRecordBuilder.append(taskTrace);
        }
        statusRecordBuilder.append(sdf.format(new Date())).append("#").append(currentTaskTraceStatus.getStatusCode()).append("\r\n");
        taskTraceInfo.setTaskRecord(statusRecordBuilder.toString());
        return taskTraceInfo;
    }

    private void addTaskTraceStatusBeforeSendMQ(TimerPulse timerPulse, String accountId, String tenantId, TaskTraceStatusEnum taskTraceStatusEnum) {
        Map taskIdTaskTrace = this.serverBeforeSendMQTaskStatus.computeIfAbsent(accountId, k -> new ConcurrentHashMap());
        if (taskIdTaskTrace.size() > CACHE_TASK_RECORD_MAXSIZE) {
            return;
        }
        List taskTraces = taskIdTaskTrace.computeIfAbsent(timerPulse.getTaskId(), k -> Collections.synchronizedList(new ArrayList()));
        taskTraces.add(this.generateTaskTraceRecord(taskTraceStatusEnum, sdf));
    }

    private void addTaskTraceStatusSendMQ(MessageInfo messageInfo) {
        Map taskIdTaskTrace = this.serverBeforeSendMQTaskStatus.computeIfAbsent(messageInfo.getAccountId(), k -> new ConcurrentHashMap());
        if (taskIdTaskTrace.size() > CACHE_TASK_RECORD_MAXSIZE) {
            return;
        }
        List taskTraces = taskIdTaskTrace.computeIfAbsent(messageInfo.getTaskId(), k -> Collections.synchronizedList(new ArrayList()));
        TaskTraceInfo taskTraceInfo = this.mergeTaskTraceLog((List<String>)taskTraces, TaskTraceStatusEnum.SERVER_BEGIN_SEND_MQ, messageInfo);
        LinkedBlockingQueue taskTraceInfoQueue = this.serverBeforeSendMQTaskTraceQueue.computeIfAbsent(messageInfo.getAccountId(), k -> new LinkedBlockingQueue());
        try {
            if (taskTraceInfoQueue.size() > CACHE_TASK_RECORD_MAXSIZE) {
                return;
            }
            taskTraceInfoQueue.put(taskTraceInfo);
            taskIdTaskTrace.remove(messageInfo.getTaskId());
        }
        catch (InterruptedException e) {
            logger.error("Schedule***TaskTraceFilter BEFORE_SEND_MQ_TASK_TRACE_QUEUE IS INTERRUPTED, taskId : {}", (Object)messageInfo.getTaskId(), (Object)e);
        }
    }

    private void addTaskTraceStatusAfterSendMQ(MessageInfo messageInfo, TaskTraceStatusEnum sendMQStatusEnum) {
        TaskTraceInfo taskTraceInfo = this.mergeTaskTraceLog((List<String>)Collections.EMPTY_LIST, sendMQStatusEnum, messageInfo);
        LinkedBlockingQueue taskTraceInfoQueue = this.serverAfterSendMQTaskTraceQueue.computeIfAbsent(messageInfo.getAccountId(), k -> new LinkedBlockingQueue());
        try {
            if (taskTraceInfoQueue.size() > CACHE_TASK_RECORD_MAXSIZE) {
                return;
            }
            taskTraceInfoQueue.put(taskTraceInfo);
        }
        catch (InterruptedException e) {
            logger.error("Schedule***TaskTraceFilter AFTER_SEND_MQ_TASK_TRACE_QUEUE IS INTERRUPTED, taskId : {}", (Object)messageInfo.getTaskId(), (Object)e);
        }
    }

    private void addTaskTraceStatusPushReady(MessageInfo messageInfo) {
        LinkedBlockingQueue taskTraceInfos = this.executorPushReadyTaskTraceQueue.computeIfAbsent(messageInfo.getAccountId(), k -> new LinkedBlockingQueue());
        TaskTraceInfo taskTraceInfo = this.mergeTaskTraceLog((List<String>)Collections.EMPTY_LIST, TaskTraceStatusEnum.EXECUTOR_PUSH_READY, messageInfo);
        try {
            if (taskTraceInfos.size() > CACHE_TASK_RECORD_MAXSIZE) {
                return;
            }
            taskTraceInfos.put(taskTraceInfo);
        }
        catch (InterruptedException e) {
            logger.error("Schedule***TaskTraceFilter PUSH_READY_TASK_TRACE_QUEUE IS INTERRUPTED, taskId : {}", (Object)messageInfo.getTaskId(), (Object)e);
        }
    }

    private void addTaskTraceStatusForBroadcast(MessageInfo messageInfo) {
        LinkedBlockingQueue taskTraceInfos = this.executorPushReadyTaskTraceQueue.computeIfAbsent(messageInfo.getAccountId(), k -> new LinkedBlockingQueue());
        TaskTraceInfo taskTraceInfo = this.mergeTaskTraceLog((List<String>)Collections.EMPTY_LIST, TaskTraceStatusEnum.EXECUTOR_REVEICE_BROADCAST_TASK, messageInfo);
        try {
            if (taskTraceInfos.size() > CACHE_TASK_RECORD_MAXSIZE) {
                return;
            }
            taskTraceInfos.put(taskTraceInfo);
        }
        catch (InterruptedException e) {
            logger.error("Schedule***TaskTraceFilter PUSH_READY_TASK_TRACE_QUEUE IS INTERRUPTED, taskId : {}", (Object)messageInfo.getTaskId(), (Object)e);
        }
    }

    private void addTaskTraceStatusBeforeComplete(MessageInfo messageInfo, TaskTraceStatusEnum currentTaskTraceStatusEnum) {
        Map taskIdTaskTrace = this.executorBeforeCompleteTaskStatus.computeIfAbsent(messageInfo.getAccountId(), k -> new ConcurrentHashMap());
        if (taskIdTaskTrace.size() > CACHE_TASK_RECORD_MAXSIZE) {
            return;
        }
        List taskStatuses = taskIdTaskTrace.computeIfAbsent(messageInfo.getTaskId(), k -> Collections.synchronizedList(new ArrayList()));
        taskStatuses.add(this.generateTaskTraceRecord(currentTaskTraceStatusEnum, sdf));
    }

    private void addTaskTraceStatusComplete(MessageInfo messageInfo, TaskTraceStatusEnum currentTaskTraceStatusEnum) {
        Map<String, List<String>> taskIdTaskTrace = this.executorBeforeCompleteTaskStatus.get(messageInfo.getAccountId());
        if (taskIdTaskTrace.size() > CACHE_TASK_RECORD_MAXSIZE) {
            return;
        }
        List taskTraces = taskIdTaskTrace.computeIfAbsent(messageInfo.getTaskId(), k -> Collections.synchronizedList(new ArrayList()));
        TaskTraceInfo taskTraceInfo = this.mergeTaskTraceLog((List<String>)taskTraces, currentTaskTraceStatusEnum, messageInfo);
        LinkedBlockingQueue taskTraceInfos = this.executorCompleteTaskTraceQueue.computeIfAbsent(messageInfo.getAccountId(), k -> new LinkedBlockingQueue());
        try {
            if (taskTraceInfos.size() > CACHE_TASK_RECORD_MAXSIZE) {
                return;
            }
            taskTraceInfos.put(taskTraceInfo);
            taskIdTaskTrace.remove(messageInfo.getTaskId());
        }
        catch (InterruptedException e) {
            logger.error("Schedule***TaskTraceFilter COMPLETE_TASK_TRACE_QUEUE IS INTERRUPTED, taskId : {}", (Object)messageInfo.getTaskId(), (Object)e);
        }
    }

    private String generateTaskTraceRecord(TaskTraceStatusEnum taskTraceStatusEnum, SimpleDateFormat sdf) {
        StringBuilder recordBuilder = new StringBuilder();
        recordBuilder.append(sdf.format(new Date())).append("#").append(taskTraceStatusEnum.getStatusCode()).append("\r\n");
        return recordBuilder.toString();
    }

    private void abortTaskTraceInfo(ObservableModel model) {
        TaskInfo taskInfo;
        if (model.getData() instanceof TaskInfo && (taskInfo = (TaskInfo)model.getData()).getJobType() == JobType.BIZ) {
            RequestContextCreator.createBatch((String)model.getTenantId(), (String)model.getAccountId(), null);
            boolean existTaskTraceInfo = this.existTaskTraceInfo(taskInfo.getId());
            if (existTaskTraceInfo) {
                String updateSQL = "update t_sch_tasktrace SET FTASKRECORD = CONCAT(FTASKRECORD, ?), FMODIFYTIME = ?, FSTATUS = ? WHERE FTASKID = ?";
                Object[] params = new SqlParameter[4];
                StringBuilder statusDesc = new StringBuilder();
                statusDesc.append(sdf.format(new Date())).append("#").append(TaskTraceStatusEnum.EXECUTOR_TASK_ABORTED.getStatusCode());
                params[0] = new SqlParameter(":ftaskrecord", 12, (Object)statusDesc.toString());
                params[1] = new SqlParameter(":fmodifytime", 93, (Object)new Timestamp(System.currentTimeMillis()));
                params[2] = new SqlParameter(":fstatus", 12, (Object)TaskTraceStatusEnum.EXECUTOR_TASK_ABORTED.getStatusCode());
                params[3] = new SqlParameter(":ftaskid", 12, (Object)taskInfo.getId());
                try (TXHandle txHandle = TX.required((String)"abortTaskTraceInfo");){
                    try {
                        DB.execute((DBRoute)Sch_Route, (String)updateSQL, (Object[])params);
                    }
                    catch (Exception e) {
                        logger.error("Schedule***TaskTraceFilter abortTaskTraceInfo error", (Throwable)e);
                        txHandle.markRollback();
                    }
                }
            } else {
                String insertSQL = "INSERT INTO t_sch_tasktrace (FID,FTASKID,FTASKRECORD,FMODIFYTIME,FSCHEDULEID,FJOBID,FSTATUS) values(?,?,?,?,?,?,?)";
                Object[] params = new SqlParameter[7];
                params[0] = new SqlParameter(":FID", -5, (Object)ID.genLongId());
                params[1] = new SqlParameter(":FTASKID", 93, (Object)taskInfo.getId());
                StringBuilder statusDesc = new StringBuilder();
                statusDesc.append(sdf.format(new Date())).append("#").append(TaskTraceStatusEnum.EXECUTOR_TASK_ABORTED.getStatusCode());
                params[2] = new SqlParameter(":FTASKRECORD", 12, (Object)statusDesc.toString());
                params[3] = new SqlParameter(":FMODIFYTIME", 93, (Object)new Timestamp(System.currentTimeMillis()));
                params[4] = new SqlParameter(":FSCHEDULEID", 12, (Object)taskInfo.getScheduleId());
                params[5] = new SqlParameter(":FJOBID", 12, (Object)taskInfo.getJobId());
                params[6] = new SqlParameter(":FSTATUS", 12, (Object)TaskTraceStatusEnum.EXECUTOR_TASK_ABORTED.getStatusCode());
                try (TXHandle txHandle = TX.required((String)"taskTraceFilterInsert");){
                    try {
                        DB.execute((DBRoute)Sch_Route, (String)insertSQL, (Object[])params);
                    }
                    catch (Exception e) {
                        logger.error("Schedule***TaskTraceFilter taskTraceFilterInsert error", (Throwable)e);
                        txHandle.markRollback();
                    }
                }
            }
        }
    }

    private boolean existTaskTraceInfo(String taskId) {
        QFilter[] filters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId)};
        return ORM.create().exists("sch_tasktracerecord", filters);
    }

    private void insertTaskTraceInfo(LinkedBlockingQueue<TaskTraceInfo> taskTraceInfos) {
        ArrayList<TaskTraceInfo> tempInfo = new ArrayList<TaskTraceInfo>();
        while (!taskTraceInfos.isEmpty()) {
            try {
                TaskTraceInfo taskTraceInfo = taskTraceInfos.take();
                tempInfo.add(taskTraceInfo);
            }
            catch (InterruptedException e) {
                logger.error("Schedule***TaskTraceFilter insertTaskTraceInfo Queue is interrupted", (Throwable)e);
            }
            if (tempInfo.size() != BATCH_EXECUTE_SQL_NUMBER.intValue()) continue;
            this.batchInsertTaskTraceInfo(tempInfo);
            tempInfo.clear();
        }
        if (!tempInfo.isEmpty()) {
            this.batchInsertTaskTraceInfo(tempInfo);
        }
    }

    private void batchInsertTaskTraceInfo(List<TaskTraceInfo> batchInsertTaskTraceInfos) {
        String insertSQL = "INSERT INTO t_sch_tasktrace (FID,FTASKID,FTASKRECORD,FMODIFYTIME,FSCHEDULEID,FJOBID,FSTATUS,FGROUPID) VALUES(?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(batchInsertTaskTraceInfos.size());
        for (TaskTraceInfo taskTraceInfo : batchInsertTaskTraceInfos) {
            String scheduleId = taskTraceInfo.getScheduleId() != null ? taskTraceInfo.getScheduleId() : " ";
            String jobId = taskTraceInfo.getJobId() != null ? taskTraceInfo.getJobId() : " ";
            Object[] params = new Object[]{ID.genLongId(), taskTraceInfo.getTaskId(), taskTraceInfo.getTaskRecord(), new Timestamp(System.currentTimeMillis()), scheduleId, jobId, taskTraceInfo.getStatus(), taskTraceInfo.getGroupId()};
            paramsList.add(params);
        }
        try (TXHandle txHandle = TX.required((String)"taskTraceFilterInsert");){
            try {
                int[] rows = DB.executeBatch((DBRoute)Sch_Route, (String)insertSQL, paramsList);
                for (int i = 0; i < rows.length; ++i) {
                    if (rows[i] != 0 || batchInsertTaskTraceInfos.size() <= i) continue;
                    logger.error("Schedule***TaskTraceFilter insert task trace info error,taskId={}", (Object)batchInsertTaskTraceInfos.get(i).getTaskId());
                }
            }
            catch (Exception e) {
                logger.error("Schedule***TaskTraceFilter taskTraceFilterInsert error", (Throwable)e);
            }
        }
    }

    private void updateTaskTraceInfo(LinkedBlockingQueue<TaskTraceInfo> updateTaskTraceInfos) {
        ArrayList<TaskTraceInfo> failUpdateInfos = new ArrayList<TaskTraceInfo>();
        while (!updateTaskTraceInfos.isEmpty()) {
            try {
                TaskTraceInfo taskTraceInfo = updateTaskTraceInfos.take();
                this.updateTaskTraceInfoStatus(taskTraceInfo, failUpdateInfos);
            }
            catch (InterruptedException e) {
                logger.error("Schedule***TaskTraceFilter updateTaskTraceInfo Queue is interrupted", (Throwable)e);
            }
        }
        if (!failUpdateInfos.isEmpty()) {
            StringBuilder failTaskId = new StringBuilder();
            for (TaskTraceInfo failUpdateInfo : failUpdateInfos) {
                try {
                    updateTaskTraceInfos.put(failUpdateInfo);
                    failTaskId.append(failUpdateInfo.getTaskId()).append(",");
                }
                catch (InterruptedException e) {
                    logger.error("Schedule***TaskTraceFilter updateTaskTraceInfo putFailUpdateTraceInfo is interrupted, taskId : {}", (Object)failUpdateInfo.getTaskId());
                }
            }
            logger.info("Schedule***TaskTraceFilter failUpdateTraceInfo taskIds : {}", (Object)failTaskId.toString());
        }
    }

    private void updateExecutorTaskTraceInfo(LinkedBlockingQueue<TaskTraceInfo> updateTaskTraceInfos) {
        ArrayList<TaskTraceInfo> failUpdateInfos = new ArrayList<TaskTraceInfo>();
        LinkedBlockingQueue<TaskTraceInfo> broadcastJob = new LinkedBlockingQueue<TaskTraceInfo>();
        while (!updateTaskTraceInfos.isEmpty()) {
            try {
                TaskTraceInfo taskTraceInfo = updateTaskTraceInfos.take();
                if (taskTraceInfo.getMessageType() == MessageType.BROADCASTJOB) {
                    broadcastJob.put(taskTraceInfo);
                    continue;
                }
                this.updateTaskTraceInfoStatus(taskTraceInfo, failUpdateInfos);
            }
            catch (InterruptedException e) {
                logger.error("Schedule***TaskTraceFilter updateTaskTraceInfo Queue is interrupted", (Throwable)e);
            }
        }
        if (!broadcastJob.isEmpty()) {
            this.insertTaskTraceInfo(broadcastJob);
        }
        if (!failUpdateInfos.isEmpty()) {
            StringBuilder failTaskId = new StringBuilder();
            for (TaskTraceInfo failUpdateInfo : failUpdateInfos) {
                try {
                    updateTaskTraceInfos.put(failUpdateInfo);
                    failTaskId.append(failUpdateInfo.getTaskId()).append(",");
                }
                catch (InterruptedException e) {
                    logger.error("Schedule***TaskTraceFilter updateTaskTraceInfo putFailUpdateTraceInfo is interrupted, taskId : {}", (Object)failUpdateInfo.getTaskId());
                }
            }
            logger.info("Schedule***TaskTraceFilter failUpdateTraceInfo taskIds : {}", (Object)failTaskId.toString());
        }
    }

    private void updateTaskTraceInfoStatus(TaskTraceInfo taskTraceInfo, List<TaskTraceInfo> failUpdateInfos) {
        String updateSQL = "UPDATE t_sch_tasktrace SET FTASKRECORD = CONCAT(FTASKRECORD, ?), FMODIFYTIME = ?, FSTATUS = ? WHERE FTASKID = ?";
        boolean success = false;
        try (TXHandle txHandle = TX.required((String)"taskTraceFilterUpdate");){
            try {
                success = DB.execute((DBRoute)Sch_Route, (String)updateSQL, (Object[])new Object[]{taskTraceInfo.getTaskRecord(), new Timestamp(System.currentTimeMillis()), taskTraceInfo.getStatus(), taskTraceInfo.getTaskId()});
            }
            catch (Throwable t) {
                logger.error("Schedule***TaskTraceFilter taskTraceFilterUpdate error", t);
            }
        }
        if (!success) {
            failUpdateInfos.add(taskTraceInfo);
        }
    }

    private static List<Account> getAllAccountsOfCurrentEnv() {
        return AccountUtils.getAllAccountsOfCurrentEnv();
    }

    @Override
    public void handle(Object data) {
    }

    @Override
    public void init() {
        ThreadPools.executeOnce((String)"BOSSchedule-ObservableDataFilter-TaskTrace-Thread", (Runnable)this.taskTraceFilterThread);
    }
}

