/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class JobDispatchBatchResult {
    private final List<String> taskIds;
    private final List<Integer> failTaskIndexs;

    public JobDispatchBatchResult(List<String> taskIds, List<Integer> failTaskIndexs) {
        this.taskIds = taskIds;
        this.failTaskIndexs = failTaskIndexs;
    }

    public boolean isSuccess() {
        return this.getFailTaskIndexs().isEmpty();
    }

    public List<String> getFailTasks() {
        if (this.isSuccess()) {
            return Collections.emptyList();
        }
        List<String> taskIds = this.getTaskIds();
        List<Integer> failTaskIndexs = this.getFailTaskIndexs();
        ArrayList<String> errTaskIds = new ArrayList<String>(failTaskIndexs.size());
        for (Integer index : failTaskIndexs) {
            errTaskIds.add(taskIds.get(index));
        }
        return errTaskIds;
    }

    public List<String> getSuccessTasks() {
        List<String> taskIds = this.getTaskIds();
        if (this.isSuccess()) {
            return taskIds;
        }
        List<Integer> failTaskIndexs = this.getFailTaskIndexs();
        ArrayList<String> successTaskIds = new ArrayList<String>(taskIds.size() - failTaskIndexs.size());
        HashSet<String> errSets = new HashSet<String>(this.getFailTasks());
        for (String taskId : taskIds) {
            if (errSets.contains(taskId)) continue;
            successTaskIds.add(taskId);
        }
        return successTaskIds;
    }

    public List<String> getTaskIds() {
        if (this.taskIds == null) {
            return Collections.emptyList();
        }
        return this.taskIds;
    }

    public List<Integer> getFailTaskIndexs() {
        if (this.failTaskIndexs == null) {
            return Collections.emptyList();
        }
        return this.failTaskIndexs;
    }
}

