/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.api;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class JobInfo
implements Serializable {
    private static final long serialVersionUID = 6831719149496826697L;
    private static final Log log = LogFactory.getLog(JobInfo.class);
    private String id;
    private LocaleString lName;
    private String number;
    private String taskClassname;
    private Map<String, Object> params = null;
    private String scheduleId;
    private String taskId;
    private String tenantId;
    private JobType jobType = JobType.BIZ;
    private long runByUserId = 0L;
    private String appId;
    private String taskDefineId;
    private boolean enable = true;
    private int timeout;
    private int retryTime;
    private int RetryCode;
    private long groupId = 0L;
    private int executeTime;
    private int retryRecord;
    private Boolean canStop = false;
    private long runByOrgId;
    private Lang runByLang = this.getDefaultLang();
    private boolean runConcurrently = false;
    private boolean failNotify = false;
    private boolean successNotify = false;
    private boolean overTime = false;
    private boolean aborted = false;
    private long jobPrincipal;
    private String notifyType;
    private String msgContent;
    private String caption;
    private String strategy;
    private RouteMode routeMode = RouteMode.RAMDOM;
    private ScheduleMsgInfo scheduleMsgInfo;
    private int shareIndex;
    private long jobMsgReceiver;
    private boolean fromScheduler;
    private ShardingParam shardingParam;
    private boolean taskTrace;
    private long scheduleTime;

    public boolean isRunConcurrently() {
        return this.runConcurrently;
    }

    public void setRunConcurrently(boolean enableRunConcurrently) {
        this.runConcurrently = enableRunConcurrently;
    }

    public long getRunByOrgId() {
        return this.runByOrgId;
    }

    public void setRunByOrgId(long orgId) {
        this.runByOrgId = orgId;
    }

    public Lang getRunByLang() {
        return this.runByLang;
    }

    public void setRunByLang(Lang lang) {
        this.runByLang = lang;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetryCode() {
        return this.RetryCode;
    }

    public void setRetryCode(int retryCode) {
        this.RetryCode = retryCode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public long getRunByUserId() {
        return this.runByUserId;
    }

    public void setRunByUserId(long runByUserId) {
        this.runByUserId = runByUserId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Deprecated
    public String getName() {
        LocaleString lName = this.getlName();
        String name = null;
        if (lName != null) {
            name = lName.toString();
        }
        return name;
    }

    @Deprecated
    public void setName(String name) {
        LocaleString lName = this.getlName();
        if (lName == null) {
            lName = new LocaleString();
            this.setlName(lName);
        }
        lName.setLocaleValue(name);
    }

    public String getTaskClassname() {
        return this.taskClassname;
    }

    public void setTaskClassname(String taskClassname) {
        this.taskClassname = taskClassname;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public int getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(int executeTime) {
        this.executeTime = executeTime;
    }

    public void setRetryRecord(int retryRecord) {
        this.retryRecord = retryRecord;
    }

    public int getRetryRecord() {
        return this.retryRecord;
    }

    public String getTaskDefineId() {
        return this.taskDefineId;
    }

    public void setTaskDefineId(String taskDefineId) {
        this.taskDefineId = taskDefineId;
    }

    @Deprecated
    public String getTenantId() {
        return this.tenantId;
    }

    @Deprecated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isFailNotify() {
        return this.failNotify;
    }

    public void setFailNotify(boolean failNotify) {
        this.failNotify = failNotify;
    }

    public boolean isSuccessNotify() {
        return this.successNotify;
    }

    public void setSuccessNotify(boolean successNotify) {
        this.successNotify = successNotify;
    }

    public long getJobPrincipal() {
        return this.jobPrincipal;
    }

    public void setJobPrincipal(long jobPrincipal) {
        this.jobPrincipal = jobPrincipal;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public RouteMode getRouteMode() {
        return this.routeMode;
    }

    public void setRouteMode(RouteMode routeMode) {
        this.routeMode = routeMode;
    }

    public ScheduleMsgInfo getScheduleMsgInfo() {
        return this.scheduleMsgInfo;
    }

    public void setScheduleMsgInfo(ScheduleMsgInfo scheduleMsgInfo) {
        this.scheduleMsgInfo = scheduleMsgInfo;
    }

    public int getShareIndex() {
        return this.shareIndex;
    }

    public void setShareIndex(int shareIndex) {
        this.shareIndex = shareIndex;
    }

    public boolean isOverTime() {
        return this.overTime;
    }

    public void setOverTime(boolean overTime) {
        this.overTime = overTime;
    }

    public long getJobMsgReceiver() {
        return this.jobMsgReceiver;
    }

    public void setJobMsgReceiver(long jobMsgReceiver) {
        this.jobMsgReceiver = jobMsgReceiver;
    }

    public ShardingParam getShardingParam() {
        return this.shardingParam;
    }

    public void setShardingParam(ShardingParam shardingParam) {
        this.shardingParam = shardingParam;
    }

    public Boolean getCanStop() {
        return this.canStop;
    }

    public void setCanStop(Boolean canStop) {
        this.canStop = canStop;
    }

    public boolean isFromScheduler() {
        return this.fromScheduler;
    }

    public void setFromScheduler(boolean fromScheduler) {
        this.fromScheduler = fromScheduler;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isTaskTrace() {
        return this.taskTrace;
    }

    public void setTaskTrace(boolean taskTrace) {
        this.taskTrace = taskTrace;
    }

    public long getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(long scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public LocaleString getlName() {
        return this.lName;
    }

    public void setlName(LocaleString lName) {
        this.lName = lName;
    }

    private Lang getDefaultLang() {
        try {
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            List enabledLang = inteService.getEnabledLang();
            for (EnabledLang lang : enabledLang) {
                if (!lang.getIsDefault().booleanValue()) continue;
                return Lang.from((String)lang.getNumber());
            }
            return Lang.zh_CN;
        }
        catch (Exception e) {
            log.info("Schedule***getDefaultLang", (Object)e);
            return Lang.zh_CN;
        }
    }

    public String toString() {
        return String.format("jobId=%s, jobNumber=%s, schId=%s, appId=%s", this.id, this.number, this.scheduleId, this.appId);
    }
}

