/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.api;

public class SchCheckResult {
    private Integer code;
    private String message;

    public SchCheckResult() {
    }

    public SchCheckResult(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static SchCheckResult create() {
        return new SchCheckResult();
    }

    public static SchCheckResult create(Integer code, String message) {
        return new SchCheckResult(code, message);
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static SchCheckResult success() {
        return new SchCheckResult(Status.OK.getCode(), "OK");
    }

    public static enum Status {
        OK("OK", 0),
        ZKEXCEPTION("Zookeeper connection exception:", 1),
        MQEXCEPTION("MQ connection exception:", 2),
        SCHEDULESERVCIEEXCEPTION("ScheduleService start exception:", 3),
        EXECUTORSERVICEEXCEPTION("ExecutorService start exception:", 4),
        REDISEXCEPTION("Redis connection exception:", 5);

        private int code;
        private String status;

        private Status(String status, int code) {
            this.code = code;
            this.status = status;
        }

        public static String getStatus(int code) {
            for (Status status : Status.values()) {
                if (status.getCode() != code) continue;
                return status.status;
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

