/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.AbstractJobHandler;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ShardingTask;
import kd.bos.schedule.api.Task;

public class BizJobHandler
extends AbstractJobHandler {
    public void execute(RequestContext rc, MessageInfo message, JobInfo job) {
        String taskClassName = job.getTaskClassname();
        if (taskClassName == null) {
            ErrorCode ec = new ErrorCode("TASK_NAME_EMPTY", job.getlName() == null ? "" : job.getlName().toString());
            throw new KDException(ec, new Object[0]);
        }
        Class taskClass = null;
        try {
            taskClass = TypesContainer.getOrRegister((String)taskClassName.trim());
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("TASK_NAME_EMPTY", taskClassName);
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        Task task = null;
        try {
            task = (Task)taskClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ErrorCode ec = new ErrorCode("TASK_CLASS_INIT_FAILED", taskClassName);
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        task.setTaskId(message.getTaskId());
        task.setMessageHandle((MessageHandler)this);
        if (RouteMode.SHARDINGTASK == job.getRouteMode() && task instanceof ShardingTask) {
            ((ShardingTask)task).execute(rc, job.getParams(), job.getShardingParam());
            return;
        }
        task.execute(rc, job.getParams());
    }
}

