/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import java.io.IOException;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.server.broadcast.BroadcastObjectFactory;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkStore;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;

public class BroadcastMessageCustomer
extends ZkStore {
    private static final Log log = LogFactory.getLog(BroadcastMessageCustomer.class);
    private static final String BROADCAST = "BROADCAST";
    private static String waitTime = System.getProperty("schedule.executor.initwaittime", "5000");

    public void addBroadcastListener(String path) throws IOException {
        this.write(path, BROADCAST);
        CuratorFramework curatorFramework = this.getCuratorFramework();
        NodeCache nodeCache = new NodeCache(curatorFramework, path);
        nodeCache.getListenable().addListener(() -> {
            byte[] curr = nodeCache.getCurrentData().getData();
            String message = new String(curr, ActiveKeyValueStore.CHARSET);
            if (log.isDebugEnabled()) {
                log.debug("Schedule***\u63a5\u6536\u5230\u5e7f\u64ad\u6d88\u606f\uff1a\uff1aZookeeper received broadcast message: " + message);
            }
            if (!message.equals(BROADCAST) && StringUtils.isNotBlank((CharSequence)message)) {
                MessageInfo messageInfo = (MessageInfo)SerializationUtils.fromJsonString((String)message, MessageInfo.class);
                log.info("Schedule***\u63a5\u6536\u5230\u5e7f\u64ad\u6d88\u606f\uff1a\uff1aZookeeper received broadcast message: {}", (Object)messageInfo);
                BroadcastObjectFactory objectFactory = new BroadcastObjectFactory();
                objectFactory.init();
                objectFactory.getExecutor().processMessage(messageInfo, null);
            }
        });
        try {
            nodeCache.start();
        }
        catch (Exception e) {
            nodeCache.close();
        }
    }
}

