/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.MessageAcker;
import kd.bos.schedule.api.Executor;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.MessageWatcher;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleDeployMode;
import kd.bos.schedule.executor.BizJobHandler;
import kd.bos.schedule.executor.BroadcastMessageCustomer;
import kd.bos.schedule.executor.ExecutorServiceWrapper;
import kd.bos.schedule.executor.redis.RedisExecutorServiceWrapper;
import kd.bos.schedule.executor.zk.ZkExecutorServiceWrapper;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.JobProcessor;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.message.SchThreadPoolWrapper;
import kd.bos.schedule.message.mq.MQObjectFactory;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.server.ExecutorServerStatistic;
import kd.bos.schedule.server.broadcast.BroadcastJobHandler;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ExecutorService
extends AbstractService
implements Executor {
    public static final String SCHEDULE_EXECUTOR_NUMOFWORKTHREAD_KEY = "Schedule.Executor.NumOfWorkThread";
    private static final String DEFAULT_APPID = "bos";
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.executor.ExecutorService");
    private static Method getInstanceHostIpPort = null;
    @Deprecated
    protected Map<MessageType, List<MessageHandler>> messageHandlePool = new EnumMap<MessageType, List<MessageHandler>>(MessageType.class);
    @Deprecated
    protected Map<MessageType, List<Class<? extends MessageHandler>>> messageHandleClassPool = new EnumMap<MessageType, List<Class<? extends MessageHandler>>>(MessageType.class);
    private Map<MessageType, MessageHandler> messageHandles = new EnumMap<MessageType, MessageHandler>(MessageType.class);
    private Map<MessageType, Class<? extends MessageHandler>> messageHandleClasss = new EnumMap<MessageType, Class<? extends MessageHandler>>(MessageType.class);
    protected ReentrantLock lock = new ReentrantLock();
    private static String SEPARATOR = "/";
    private static ExecutorService instance = null;
    private static ExecutorServiceWrapper serviceWrapper = null;
    private AtomicBoolean registered = new AtomicBoolean(false);
    private AtomicBoolean startService = new AtomicBoolean(false);
    private static final Counter activeComsumer = MetricSystem.counter((String)"kd.metrics.schedule.consumer.activeThreads");

    private static Method getInstanceHostIpPort() {
        if (getInstanceHostIpPort != null) {
            return getInstanceHostIpPort;
        }
        try {
            Class<?> requestContextCls = Class.forName("kd.bos.monitor.service.LivingServiceUtils");
            getInstanceHostIpPort = requestContextCls.getMethod("getInstanceHostIpPort", String.class);
        }
        catch (Throwable e) {
            log.error("Schedule***ClearUpTask error", e);
        }
        return getInstanceHostIpPort;
    }

    public static ExecutorService getInstance() {
        return instance;
    }

    public ExecutorService() {
        serviceWrapper = ZkConfig.isSupportZk() ? new ZkExecutorServiceWrapper(this) : new RedisExecutorServiceWrapper(this);
        log.info("Schedule***ExecutorService create ! classname : {}", (Object)serviceWrapper.getName());
    }

    public String getName() {
        return "executor service";
    }

    protected ObjectFactory createObjectFactory(String messageMode) {
        if (messageMode.equalsIgnoreCase("ZooKeeper")) {
            log.error("Schedule***\u73b0\u5728\u5df2\u7ecf\u4e0d\u652f\u6301\u6d88\u606f\u6a21\u5f0f\u4e3aZooKeeper!!!!!!!!");
            MQObjectFactory mqObjectFactory = new MQObjectFactory();
            mqObjectFactory.setExecutor((Executor)this);
            return mqObjectFactory;
        }
        if (messageMode.equalsIgnoreCase("MQ")) {
            MQObjectFactory mqObjectFactory = new MQObjectFactory();
            mqObjectFactory.setExecutor((Executor)this);
            return mqObjectFactory;
        }
        return null;
    }

    public void start() {
        instance = this;
        super.start();
        this.startService.set(true);
        if (this.startExecutorNode()) {
            this.registerWorkConsumer();
        }
        this.startDaemonThread();
    }

    private void registerWorkConsumer() {
        String executorServerName = "";
        executorServerName = AbstractService.getRunServerName();
        log.info("Schedule***Executor server name is " + executorServerName);
        MessageWatcher mw = this.objectFactory.getMessageWatcher();
        mw.setRunAt(executorServerName);
        try {
            mw.start();
            this.register();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        this.registered.set(true);
        this.isStart = true;
    }

    private void startDaemonThread() {
        Thread loadThread = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> {
            while (this.startService.get()) {
                long sleepTime = (long)ZkConfig.getSelfCheck() * 1000000000L;
                LockSupport.parkNanos(sleepTime);
                if (this.registered.get() || !this.startExecutorNode()) continue;
                this.registerWorkConsumer();
            }
        }));
        loadThread.setDaemon(true);
        loadThread.setName("BOSSchedule-ExecutorServiceDaemo");
        loadThread.setUncaughtExceptionHandler((t, e) -> log.error("Schedule***executorservice.daemon thread error ", e));
        loadThread.start();
    }

    private void registerBroadcastConsumer(String executorServerName) throws IOException {
        String[] appIds = Instance.isAppSplit() ? Instance.getAppIds() : new String[]{DEFAULT_APPID};
        ArrayList<String> paths = new ArrayList<String>();
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        String serverName = ZkConfig.getExecutorServerName();
        for (Account account : accounts) {
            String accountId = account.getAccountId();
            for (String appId : appIds) {
                if (!StringUtils.isNotBlank((CharSequence)accountId) || !StringUtils.isNotBlank((CharSequence)appId)) continue;
                String broadcastPath = ZkConfig.getJobRootPath() + SEPARATOR + accountId + SEPARATOR + appId + SEPARATOR + serverName;
                paths.add(broadcastPath);
                BroadcastMessageCustomer broadcastMessageCustomer = new BroadcastMessageCustomer();
                broadcastMessageCustomer.addBroadcastListener(broadcastPath);
            }
        }
        log.info("Schedule***Executor server: " + executorServerName + "\u6ce8\u518c\u76d1\u542c\uff1a" + StringUtils.join((Object[])paths.toArray(), (String)","));
    }

    private boolean startExecutorNode() {
        if (ZkConfig.getDeployMode() == ScheduleDeployMode.DISABLE || ZkConfig.getDeployMode() == ScheduleDeployMode.SCHEDULE_NODE) {
            log.info("Schedule***\u5f53\u524d\u8282\u70b9\u4e0d\u542f\u7528worker\uff0cdeploymode = " + ZkConfig.getDeployMode());
            return false;
        }
        if (Boolean.getBoolean("Schedule.disableToWork")) {
            log.info("Schedule***\u5f53\u524d\u8282\u70b9\u7981\u7528\u6240\u6709\u8c03\u5ea6\u670d\u52a1");
            return false;
        }
        Boolean qingNodeStart = Boolean.parseBoolean(System.getProperty("Schedule.executor.qingnode.defaultstart", "false"));
        String[] appIds = Instance.getAppIds();
        if (!qingNodeStart.booleanValue() && appIds != null && appIds.length == 1 && "qing".equalsIgnoreCase(appIds[0])) {
            log.info("Schedule***\u8f7b\u5206\u6790\u8282\u70b9\u9ed8\u8ba4\u4e0d\u542f\u7528\u8c03\u5ea6");
            return false;
        }
        return true;
    }

    public void stop() {
        this.startService.set(false);
        if (this.registered.get()) {
            this.objectFactory.getMessageWatcher().stop();
            this.zkStore.delete(ZkConfig.getExecutorServerPath() + "/" + ZkConfig.getExecutorServerName());
            this.registered.set(false);
        }
        super.stop();
    }

    private void register() {
        ArrayList<String> expMessages = new ArrayList<String>(8);
        try {
            this.registHandler(MessageType.REALTIMEJOB, BizJobHandler.class);
        }
        catch (Throwable t) {
            expMessages.add(t.getMessage());
            log.error("Schedule***Executor regiestExp \u542f\u52a8\u5931\u8d25", t);
        }
        try {
            this.registHandler(MessageType.BIZJOB, BizJobHandler.class);
        }
        catch (Throwable t) {
            expMessages.add(t.getMessage());
            log.error("Schedule***Executor regiestExp \u542f\u52a8\u5931\u8d25", t);
        }
        try {
            this.registHandler(MessageType.BROADCASTJOB, BroadcastJobHandler.class);
            if ("ZooKeeper".equalsIgnoreCase(ZkConfig.getMessageMode())) {
                this.registerBroadcastConsumer(AbstractService.getRunServerName());
            }
        }
        catch (Throwable t) {
            expMessages.add(t.getMessage());
            log.error("Schedule***Executor regiestExp \u542f\u52a8\u5931\u8d25", t);
        }
        try {
            Class<?> jobHandlerClazz = Class.forName("kd.bos.workflow.engine.impl.asyncexecutor.schedule.WfJobHandler");
            MessageHandler handler = (MessageHandler)jobHandlerClazz.newInstance();
            this.registHandler(MessageType.WorkFlowJOB, handler);
        }
        catch (Throwable t) {
            expMessages.add(t.getMessage());
            log.error("Schedule***Executor regiestExp \u542f\u52a8\u5931\u8d25", t);
        }
        ExecutorServerInfo executorServerInfo = this.getExeServerInfo(expMessages).toExecutorServerInfo();
        serviceWrapper.register(executorServerInfo);
        log.info("Schedule***executor Server [{}] register is successful!", (Object)serviceWrapper.getName());
    }

    private ExecutorServerStatistic getExeServerInfo(List<String> expMessages) {
        String serverName = ZkConfig.getExecutorServerName();
        ExecutorServerStatistic exeServerInfo = new ExecutorServerStatistic();
        exeServerInfo.setId(UUID.randomUUID().toString());
        exeServerInfo.setName(serverName);
        exeServerInfo.setStartTime(System.currentTimeMillis());
        HashMap<String, String> detail = new HashMap<String, String>();
        String[] appIds = Instance.getAppIds();
        detail.put("host", ZkConfig.getHostIpAddress());
        detail.put("instanceid", Instance.getInstanceId());
        try {
            String masterRpcIpPort = (String)ExecutorService.getInstanceHostIpPort().invoke(null, Instance.getInstanceId());
            if (!StringUtils.isEmpty((CharSequence)masterRpcIpPort)) {
                detail.put("rpcIpPort", (String)ExecutorService.getInstanceHostIpPort().invoke(null, Instance.getInstanceId()));
            }
        }
        catch (Throwable t) {
            log.warn("Schedule***getInstanceHostIpPort error", t);
            detail.put("rpcIpPort", ZkConfig.getHostIpAddress());
        }
        if (appIds == null) {
            detail.put("appids", SerializationUtils.toJsonString((Object)Collections.EMPTY_LIST));
        } else {
            detail.put("appids", SerializationUtils.toJsonString(Arrays.asList(appIds)));
        }
        detail.put("appsplit", String.valueOf(Instance.isAppSplit()));
        detail.put("electionserver", ZkConfig.getHosts());
        detail.put("curAppGroup", AppGroup.getCurAppGroup());
        detail.put("AccessJobMsgType", SerializationUtils.toJsonString((Object)ZkConfig.getAccessJobMsgType()));
        if (!expMessages.isEmpty()) {
            exeServerInfo.setStarted(false);
            detail.put("exception", String.valueOf(Collections.singletonList(expMessages)));
        }
        exeServerInfo.setDetail(detail);
        return exeServerInfo;
    }

    private void prepareToCustomerMessage(MessageType messageType) {
        try {
            this.lock.lock();
            log.info("Schedule***\u5f00\u59cb\u6ce8\u518c\u6d88\u8d39");
            if (ZkConfig.getAccessJobMsgType().contains(messageType)) {
                log.info("Schedule***\u521b\u5efa\u6d88\u606f\u7c7b\u578b\uff1a" + messageType.name() + "\u7684\u6d88\u8d39\u8005\u548c\u5bf9\u5e94\u7684\u7ebf\u7a0b\u6c60");
                this.objectFactory.getMessageWatcher().startToWatchMessage(messageType);
                this.getThreadPool(messageType);
            } else {
                log.warn("Schedule***\u914d\u7f6e\u4e2d\u4e0d\u652f\u6301\u8fd9\u79cd\u7c7b\u578b\u7684\u6d88\u606f,\u8bf7\u68c0\u67e5");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void registHandler(MessageType messageType, MessageHandler handler) {
        log.info("Schedule***handler\u5728\u6267\u884c\u4e2d\u6ce8\u518c\uff1a" + handler.getClass().getSimpleName());
        if (!this.startExecutorNode()) {
            log.info("Schedule***\u5f53\u524d\u8282\u70b9\u4e0d\u542f\u7528\u8c03\u5ea6\uff0c\u7981\u6b62\u6ce8\u518chandler");
            return;
        }
        handler.setObjectFactory(this.objectFactory);
        if (!this.messageHandles.containsKey(messageType)) {
            this.messageHandles.put(messageType, handler);
            this.prepareToCustomerMessage(messageType);
        }
    }

    public void unRegistHandler(MessageType messageType, MessageHandler handler) {
        this.messageHandles.remove(messageType);
    }

    public void registHandler(MessageType messageType, Class<? extends MessageHandler> handlerClass) {
        log.info("Schedule***handler\u5728\u6267\u884c\u4e2d\u6ce8\u518c\uff1a" + handlerClass.getSimpleName());
        if (!this.startExecutorNode()) {
            log.info("Schedule***\u5f53\u524d\u8282\u70b9\u4e0d\u542f\u7528\u8c03\u5ea6\uff0c\u7981\u6b62\u6ce8\u518chandler");
            return;
        }
        if (!this.messageHandleClasss.containsKey(messageType)) {
            this.messageHandleClasss.put(messageType, handlerClass);
            this.prepareToCustomerMessage(messageType);
        }
    }

    public void unRegistHandler(MessageType messageType, Class<? extends MessageHandler> handlerClass) {
        this.messageHandleClasss.remove(messageType);
    }

    public List<MessageHandler> getMessageHandler(MessageType messageType) {
        ArrayList<MessageHandler> handlerList = new ArrayList<MessageHandler>();
        Class<? extends MessageHandler> clazz = this.messageHandleClasss.get(messageType);
        if (clazz != null) {
            try {
                handlerList.add((MessageHandler)TypesContainer.createInstance(clazz));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (this.messageHandles.get(messageType) != null) {
            handlerList.add(this.messageHandles.get(messageType));
        }
        return handlerList;
    }

    private static Counter getActiveComsumer() {
        return activeComsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(MessageInfo message, MessageAcker acker) {
        try {
            ExecutorService.getActiveComsumer().inc();
            JobProcessor jobProc = new JobProcessor();
            jobProc.setObjectFactory(this.getObjectFactory());
            List<MessageHandler> messageHandlers = this.getMessageHandler(message.getMessageType());
            if (messageHandlers.isEmpty()) {
                log.error("Schedule***\u6ca1\u6709\u6ce8\u518c\u5bf9\u5e94\u7684handler,\u65e0\u6cd5\u5904\u7406\u8fd9\u4e2a\u7c7b\u578b\u7684\u6d88\u606f:{}", (Object)message);
                if (acker != null) {
                    acker.deny(message.getMessageMQId());
                    SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Client", (String)"haveNoMessageHandlers", (Object)message);
                }
                return;
            }
            for (MessageHandler handler : messageHandlers) {
                jobProc.setHandler(handler);
                jobProc.setMessage(message);
                jobProc.setAcker(acker);
                if (message.getMessageType() == MessageType.BROADCASTJOB) {
                    message.setTaskId(this.genenateTaskId(message.fetchJobInfo()));
                }
                SchThreadPoolWrapper executorPool = this.getThreadPool(message.getMessageType());
                executorPool.execute(jobProc);
            }
        }
        finally {
            ExecutorService.getActiveComsumer().dec();
        }
    }

    private void MessageTimeout(MessageInfo message) {
        MessageInfo messageTimeout = MessageCreator.createStatusMessage((MessageInfo)message, (String)"TIMEOUT", null);
        messageTimeout.setTarget(ZkConfig.getExecutorServerName());
        ExecutorService.getInstance().getObjectFactory().getMessageSender().send(messageTimeout);
    }

    private String genenateTaskId(JobInfo jobInfo) {
        boolean isBroadcast;
        boolean bl = isBroadcast = jobInfo.getRouteMode() == RouteMode.SHARDINGBROADCAST;
        if (jobInfo.getTaskId() == null && !isBroadcast || isBroadcast) {
            jobInfo.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_TASK")));
        }
        return jobInfo.getTaskId();
    }

    public ActiveKeyValueStore getStore() {
        return this.zkStore;
    }
}

