/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.schedule.api.AsynCallback;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.Subscriber;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.JobCallbackHandler;
import kd.bos.schedule.message.mq.MQHelper;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.utils.ErrorProcessUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class JobClient {
    private static final Log log = LogFactory.getLog(JobClient.class);
    private static final String DEFAULT_SYSTEM_JOB_EXECUTOR = "100";

    private static MessagePublisher getMessagePublisher() {
        return MQHelper.getJobDispaterPulisher();
    }

    @SdkInternal
    public static String dispatchToMaster(JobInfo jobInfo) {
        String taskId = "";
        try {
            JobClient.checkJobInfo(jobInfo, null);
            taskId = JobClient.fillJobInfo(jobInfo);
            String msg = JSON.toJSONString((Object)jobInfo);
            RPCHelper.dispatchToJobDispatch((String)msg);
        }
        catch (Exception e) {
            if (jobInfo != null) {
                if (StringUtils.isBlank((CharSequence)jobInfo.getTaskId())) {
                    JobClient.fillJobInfo(jobInfo);
                }
                ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo((JobInfo)jobInfo, (Throwable)e);
                JobDao jobDao = ExecutorService.getInstance().getObjectFactory().getJobDao();
                jobDao.writeErrorJobInfo(errorJobInfo);
            }
            throw e;
        }
        return taskId;
    }

    @Deprecated
    @SdkInternal
    public static String dispatch(JobInfo jobInfo, AsynCallback callback) {
        String taskId;
        block5: {
            taskId = "";
            try {
                JobClient.checkJobInfo(jobInfo, callback);
                taskId = JobClient.fillJobInfo(jobInfo);
                JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
                jobDispatcher.dispatch(jobInfo);
                if (callback == null) break block5;
                if (ZkConfig.isStartAsynCallBack()) {
                    Subscriber subScriber = ExecutorService.getInstance().getObjectFactory().getSubScriber();
                    JobCallbackHandler jobCallbackHandler = new JobCallbackHandler();
                    jobCallbackHandler.setObjectFactory(ExecutorService.getInstance().getObjectFactory());
                    jobCallbackHandler.setCb(callback);
                    subScriber.subscribe(taskId, (MessageHandler)jobCallbackHandler);
                    break block5;
                }
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5df2\u4e0d\u652f\u6301\u5f02\u6b65\u56de\u8c03\uff0c\u8bf7\u4f7f\u7528 dispatch(String) \u65b9\u6cd5\uff01\uff01\uff01\uff01", (String)"JobClient_0", (String)"bos-schedule-executor", (Object[])new Object[0]));
            }
            catch (Exception e) {
                if (jobInfo != null) {
                    if (StringUtils.isBlank((CharSequence)jobInfo.getTaskId())) {
                        JobClient.fillJobInfo(jobInfo);
                    }
                    ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo((JobInfo)jobInfo, (Throwable)e);
                    JobDao jobDao = ExecutorService.getInstance().getObjectFactory().getJobDao();
                    jobDao.writeErrorJobInfo(errorJobInfo);
                }
                throw e;
            }
        }
        return taskId;
    }

    private static String fillJobInfo(JobInfo jobInfo) {
        String taskId = String.valueOf(DB.genLongId((String)"T_SCH_TASK"));
        jobInfo.setTaskId(taskId);
        jobInfo.setTenantId(RequestContext.get().getTenantId());
        if (StringUtils.isBlank((CharSequence)jobInfo.getId())) {
            long jobId = DB.genLongId((String)"T_SCH_JOB");
            jobInfo.setId(String.valueOf(jobId));
        }
        if (jobInfo.getJobType() != JobType.WORKFLOW && StringUtils.isBlank((CharSequence)jobInfo.getAppId()) && Instance.isAppSplit() && Instance.getAppIds() != null && Instance.getAppIds().length > 0) {
            jobInfo.setAppId(Instance.getAppIds()[0]);
        }
        return taskId;
    }

    public static String dispatch(JobInfo jobInfo) {
        return JobClient.dispatch(jobInfo, null);
    }

    @SdkInternal
    public static List<String> dispatchByPlanNumber(String planNumber) {
        JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
        return jobDispatcher.dispatchByPlanNumber(planNumber);
    }

    public static void stopTask(String taskId) {
        JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
        jobDispatcher.stopTask(taskId);
    }

    public static TaskInfo queryTask(String taskId) {
        JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
        return jobDispatcher.queryTask(taskId);
    }

    private static void checkJobInfo(JobInfo jobInfo, AsynCallback callback) {
        if (jobInfo == null) {
            ErrorCode ec = new ErrorCode("JOB_DEFINE_NULL", "job define is null");
            throw new KDException(ec, new Object[0]);
        }
        if (jobInfo.getRunByUserId() == 0L) {
            RequestContext rc = RequestContext.getOrCreate();
            jobInfo.setRunByUserId(Long.parseLong(StringUtils.isNotBlank((CharSequence)rc.getUserId()) ? rc.getUserId() : DEFAULT_SYSTEM_JOB_EXECUTOR));
        }
        if (callback != null && !ZkConfig.isStartAsynCallBack()) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f02\u6b65\u56de\u8c03\uff0c\u8bf7\u4f7f\u7528 dispatch(String) \u65b9\u6cd5\uff01\uff01\uff01\uff01", (String)"JobClient_1", (String)"bos-schedule-executor", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)jobInfo.getId()) && jobInfo.getId().length() > 36) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"jobInfo \u7684 id \u4e0d\u80fd\u957f\u4e8e 36\u4e2a\u5b57\u7b26", (String)"JobClient_2", (String)"bos-schedule-executor", (Object[])new Object[0]));
        }
    }

    private static TaskInfo createTaskInfo(String taskId, JobInfo jobInfo, MessageInfo message) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(taskId);
        taskInfo.setData(null);
        taskInfo.setDispachTime(System.currentTimeMillis());
        taskInfo.setEndTime(0L);
        taskInfo.setJobId(jobInfo.getId());
        taskInfo.setScheduleId(jobInfo.getScheduleId());
        taskInfo.setProgress(0);
        taskInfo.setRunAt(message.getTarget());
        taskInfo.setRunTime(0L);
        taskInfo.setStatus("SCHEDULED");
        taskInfo.setAppid(jobInfo.getAppId());
        taskInfo.setJobType(jobInfo.getJobType());
        taskInfo.setMessageId(message.getId());
        return taskInfo;
    }
}

