/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.resource.balancer.ResourceBalanceErrorCode;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageWatcher;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleTypeNextEnums;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.utils.RequestContextUtils;

class SchPigeonExecutorMessageCustomer {
    private static final Log log = LogFactory.getLog(SchPigeonExecutorMessageCustomer.class);
    private static AtomicReference<MessageWatcher> customer = new AtomicReference<Object>(null);
    private static String waitTime = System.getProperty("schedule.executor.initwaittime", "5000");

    SchPigeonExecutorMessageCustomer() {
    }

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        block10: {
            long beginReceiveMessageTime = System.currentTimeMillis();
            if (this.ensureReadyToCustom()) {
                MessageInfo message;
                try {
                    message = (MessageInfo)JSON.parseObject((String)((String)body), MessageInfo.class);
                    message.setMessageMQId(messageId);
                    log.info("Schedule***\u4eceMQ\u4e2d\u63a5\u6536\u5230\u6d88\u606f\uff1a{},resend\uff1a{},mqmessageId:{},", new Object[]{message, resend, messageId});
                }
                catch (Exception e) {
                    log.error("Schedule***\u5904\u7406MQ\u6d88\u606f\uff1a\u5e8f\u5217\u5316\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                    acker.ack(messageId);
                    long endReceiveMessage = System.currentTimeMillis();
                    long receiveMessageTime = endReceiveMessage - beginReceiveMessageTime;
                    HashMap<String, Long> observableModelData = new HashMap<String, Long>(2);
                    observableModelData.put("receiveMessageTime", receiveMessageTime);
                    SchObservableCollectData.collectData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getTenantId(), (String)"Client", (String)"receiveMessageError", observableModelData);
                    return;
                }
                try {
                    RequestContextUtils.fillContext((MessageInfo)message, (RequestContext)RequestContext.get());
                    long endReceiveMessage = System.currentTimeMillis();
                    long receiveMessageTime = endReceiveMessage - beginReceiveMessageTime;
                    HashMap<String, Long> observableModelData = new HashMap<String, Long>(2);
                    observableModelData.put("receiveMessageTime", receiveMessageTime);
                    observableModelData.put("receiveMessageInfo", (Long)message);
                    SchObservableCollectData.collectData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"Client", (String)"receiveMessage", observableModelData);
                    JobInfo jobInfo = message.fetchJobInfo();
                    if (jobInfo.getJobType() == JobType.DETECT) {
                        ScheduleInfo scheduleInfo = new ScheduleInfo();
                        scheduleInfo.setTenantId(message.getTenantId());
                        scheduleInfo.setAccountId(message.getAccountId());
                        scheduleInfo.setScheduleType(ScheduleTypeNextEnums.Detect);
                        scheduleInfo.setJobInfo(jobInfo);
                        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Client", (String)"receiveTaskSuccess", (Object)scheduleInfo);
                    }
                    try {
                        customer.get().getObjectFactory().getTaskDao().updateStatus(message.getTaskId(), "READY");
                        customer.get().dispatch(message, null);
                        acker.ack(messageId);
                    }
                    catch (Exception e) {
                        customer.get().getObjectFactory().getTaskDao().updateStatus(message.getTaskId(), "SCHEDULED");
                        if (e instanceof KDException) {
                            if (ResourceBalanceErrorCode.rejectedException.equals((Object)((KDException)e).getErrorCode())) {
                                log.error("Schedule***\u79df\u6237\u7ebf\u7a0b\u6c60\u5df2\u6ee1,message:{}", (Object)message, (Object)e);
                                this.handeleRejectExp(messageId, acker, message);
                            }
                            break block10;
                        }
                        throw e;
                    }
                }
                catch (Throwable e) {
                    log.error("Schedule***\u5904\u7406MQ\u6d88\u606f, \u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)message, (Object)e);
                    acker.deny(messageId);
                }
            }
        }
    }

    protected void handeleRejectExp(String messageId, MessageAcker acker, MessageInfo message) {
        acker.deny(messageId);
    }

    private boolean ensureReadyToCustom() {
        boolean result;
        if (customer.get() == null && ExecutorService.getInstance() != null && ExecutorService.getInstance().isStarted()) {
            customer.compareAndSet(null, ExecutorService.getInstance().getObjectFactory().getMessageWatcher());
        }
        boolean bl = result = customer.get() != null;
        if (!result) {
            try {
                Thread.sleep(Integer.parseInt(waitTime));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    static AtomicReference<MessageWatcher> getCustomer() {
        return customer;
    }
}

