/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor.redis;

import java.lang.reflect.Method;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.ExecutorServiceWrapper;
import kd.bos.schedule.redis.RedisConfig;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.thread.ThreadLifeCycleManager;

public class RedisExecutorServiceWrapper
implements ExecutorServiceWrapper {
    private static Log log = LogFactory.getLog(RedisExecutorServiceWrapper.class);
    private final ExecutorService executorService;
    private ExecutorServerInfo executorServerInfo = null;
    private Thread keepAliveThread = null;
    private static Method getInstanceHostIpPort = null;

    public RedisExecutorServiceWrapper(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getName() {
        return "redis executor service";
    }

    @Override
    public void register(ExecutorServerInfo executorServerInfo) {
        String serverName = RedisConfig.getExecutorServerName();
        String path = RedisConfig.getExecutorServerPath() + "/" + serverName;
        Boolean stat = (Boolean)this.getStore().exists(path);
        if (stat.booleanValue()) {
            this.getStore().delete(path);
            log.info("Schedule***Redis Executor Server\u542f\u52a8\u65f6\uff0c\u524d\u9762\u7684session\u6ca1\u6709\u6765\u7684\u53ca\u91ca\u653e\uff0c\u81ea\u52a8\u5220\u9664\u3002");
        }
        executorServerInfo.setLastUpdateTime(System.currentTimeMillis());
        this.getStore().writeChildren(RedisConfig.getExecutorServerPath(), RedisConfig.getExecutorServerName(), SerializationUtils.toJsonString((Object)executorServerInfo), null);
        this.setExecutorServerInfo(executorServerInfo);
        if (this.keepAliveThread != null && !this.keepAliveThread.isInterrupted()) {
            this.keepAliveThread.interrupt();
        }
        this.keepAliveThread = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(RedisConfig.getSelfCheck() * 1000);
                    ExecutorServerInfo executorServerInfo1 = this.getExecutorServerInfo();
                    if (executorServerInfo1 == null) continue;
                    executorServerInfo1.setLastUpdateTime(System.currentTimeMillis());
                    this.getStore().writeChildren(RedisConfig.getExecutorServerPath(), RedisConfig.getExecutorServerName(), SerializationUtils.toJsonString((Object)executorServerInfo1), null);
                }
                catch (Throwable t) {
                    log.error("Schedule***Redis Executor keepAliveThread register in master error!", t);
                    try {
                        Thread.sleep(180000L);
                    }
                    catch (InterruptedException e) {
                        log.error("Schedule***Redis Executor keepAliveThread sleep 3min error!", t);
                    }
                }
            }
        }));
        this.keepAliveThread.setDaemon(true);
        this.keepAliveThread.setName("BOSSchedule-Redis ExecutorService keepAlive");
        this.keepAliveThread.start();
    }

    private ActiveKeyValueStore getStore() {
        return this.executorService.getStore();
    }

    ExecutorServerInfo getExecutorServerInfo() {
        return this.executorServerInfo;
    }

    void setExecutorServerInfo(ExecutorServerInfo executorServerInfo) {
        this.executorServerInfo = executorServerInfo;
    }

    static {
        try {
            Class<?> requestContextCls = Class.forName("kd.bos.monitor.service.LivingServiceUtils");
            getInstanceHostIpPort = requestContextCls.getMethod("getInstanceHostIpPort", String.class);
        }
        catch (Throwable e) {
            log.error("Schedule***ClearUpTask error", e);
        }
    }
}

