/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dao.dbImpl;

import java.sql.Timestamp;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerDao;
import kd.bos.schedule.api.ExecutorServerInfo;

public class DbExecutorServerDao
implements ExecutorServerDao {
    private static final Log log = LogFactory.getLog(DbExecutorServerDao.class);
    private static final DBRoute Sch_Route = DBRoute.basedata;

    public void insert(ExecutorServerInfo info) {
        String strSQL = "INSERT INTO T_SCH_EXESERVER (FID,FName,FStartTime,FLastUpdateTime,FNumOfScheduled,FNumOfRunning,FNumOfCompleted,FNumOfAborted,FNumOfFailed) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?) ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)info.getId()), new SqlParameter(":FName", 12, (Object)info.getName()), new SqlParameter(":FStartTime", 93, (Object)new Timestamp(info.getStartTime())), new SqlParameter(":FLastUpdateTime", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FNumOfScheduled", 4, (Object)info.getScheduled()), new SqlParameter(":FNumOfRunning", 4, (Object)info.getRunning()), new SqlParameter(":FNumOfCompleted", 4, (Object)info.getCompleted()), new SqlParameter(":FNumOfAborted", 4, (Object)info.getAborted()), new SqlParameter(":FNumOfFailed", 4, (Object)info.getFailed())};
        try (TXHandle handle = TX.beginNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    public void update(ExecutorServerInfo info) {
        String strSQL = "UPDATE T_SCH_EXESERVER SET FNumOfScheduled = ?,FNumOfRunning = ?,FNumOfCompleted = ?,FNumOfAborted = ?,FNumOfFailed = ?,FLastUpdateTime = ? WHERE FID = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNumOfScheduled", 4, (Object)info.getScheduled()), new SqlParameter(":FNumOfRunning", 4, (Object)info.getRunning()), new SqlParameter(":FNumOfCompleted", 4, (Object)info.getCompleted()), new SqlParameter(":FNumOfAborted", 4, (Object)info.getAborted()), new SqlParameter(":FNumOfFailed", 4, (Object)info.getFailed()), new SqlParameter(":FLastUpdateTime", 93, (Object)new Timestamp(info.getLastUpdateTime())), new SqlParameter(":FID", 12, (Object)info.getId())};
        try (TXHandle handle = TX.beginNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    public ExecutorServerInfo get(String id) {
        String strSQL = "select FID,FName,FStartTime,FLastUpdateTime,FNumOfScheduled,FNumOfRunning,FNumOfCompleted,FNumOfAborted,FNumOfFailed FROM T_SCH_EXESERVER WHERE FID= ? ";
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        return this.getValue(strSQL, params);
    }

    public ExecutorServerInfo getLast(String name) {
        String strSQL = "select top 1 FID,FName,FStartTime,FLastUpdateTime,FNumOfScheduled,FNumOfRunning,FNumOfCompleted,FNumOfAborted,FNumOfFailed FROM T_SCH_EXESERVER WHERE FName= ?  order by FStartTime desc";
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FName", 12, (Object)name)};
        return this.getValue(strSQL, params);
    }

    private ExecutorServerInfo getValue(String strSQL, SqlParameter[] params) {
        return (ExecutorServerInfo)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            ExecutorServerInfo info = new ExecutorServerInfo();
            if (rs.next()) {
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setStartTime(rs.getTimestamp("FStartTime").getTime());
                info.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime").getTime());
                info.setScheduled(rs.getInt("FNumOfScheduled"));
                info.setRunning(rs.getInt("FNumOfRunning"));
                info.setCompleted(rs.getInt("FNumOfCompleted"));
                info.setAborted(rs.getInt("FNumOfAborted"));
                info.setFailed(rs.getInt("FNumOfFailed"));
            }
            return info;
        });
    }
}

