/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dao.dbImpl;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.schedule.api.TaskInfo;

public class TaskCache {
    public static final String CACHE_DISTRIBUTESESSION = "bos_schedule_dao";
    public static final String CACHE_SCHEDULEJOB = "bos_schedule_job";
    public static final String CACHE_TYPE = "task";
    public static final String CACHEKEY_ISSTOP = "isstop";
    public static final String CACHEKEY_TASKINFO = "taskinfo";
    public static final String CACHEKEY_TASKID = "taskid";
    public static final String TASKINFO_STATUS = "status";
    public static final String TASKINFO_PROGRESS = "progress";
    public static final String TASKINFO_DESC = "desc";
    public static final String TASKINFO_RUNTIME = "runTime";
    public static final String TASKINFO_ENDTIME = "endTime";
    public static final String TASKINFO_DATA = "data";
    public static final String TASKINFO_RUNAT = "runAt";
    public static final String TASKINFO_INSTANCEID = "instanceId";
    public static final String TASKINFO_STATUSDESC = "statusDesc";
    public static final String TASKINFO_COSTTIME = "costTime";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_schedule_dao", new DistributeCacheHAPolicy(true, true));
    private static DistributeSessionlessCache schJobCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_schedule_job", new DistributeCacheHAPolicy(true, true));

    private static String buildCacheType(String taskId) {
        return String.format("%s.%s.%s", RequestContext.get().getAccountId(), CACHE_TYPE, taskId);
    }

    public static void clearCache(String taskId) {
        String type = TaskCache.buildCacheType(taskId);
        cache.remove(type);
    }

    public static TaskInfo getTaskInfo(String taskId) {
        String type = TaskCache.buildCacheType(taskId);
        String str = (String)cache.get(type, CACHEKEY_TASKINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (TaskInfo)SerializationUtils.fromJsonString((String)str, TaskInfo.class);
    }

    public static void putTaskInfo(TaskInfo taskInfo) {
        String str = SerializationUtils.toJsonString((Object)taskInfo);
        String type = TaskCache.buildCacheType(taskInfo.getId());
        cache.put(type, CACHEKEY_TASKINFO, (Object)str);
    }

    public static Map<String, Object> getTaskMap(String taskId) {
        String type = TaskCache.buildCacheType(taskId);
        String str = (String)cache.get(type, CACHEKEY_TASKINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    public static void putTaskMap(String taskId, Map<String, Object> status) {
        Map<String, Object> taskInfo = TaskCache.getTaskMap(taskId);
        if (taskInfo == null) {
            return;
        }
        taskInfo.putAll(status);
        String str = SerializationUtils.toJsonString(taskInfo);
        String type = TaskCache.buildCacheType(taskId);
        cache.put(type, CACHEKEY_TASKINFO, (Object)str);
    }

    public static void putStopStatus(String taskId, boolean isStop) {
        String type = TaskCache.buildCacheType(taskId);
        if (!isStop) {
            cache.remove(type, CACHEKEY_ISSTOP);
        } else {
            cache.put(type, CACHEKEY_ISSTOP, (Object)String.valueOf(isStop));
        }
    }

    public static boolean getStopStatus(String taskId) {
        String type = TaskCache.buildCacheType(taskId);
        String str = (String)cache.get(type, CACHEKEY_ISSTOP);
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return Boolean.parseBoolean(str);
    }

    public static void clearTaskIdCache(String schJobId) {
        String type = TaskCache.buildCacheType(schJobId);
        schJobCache.remove(type);
    }

    public static String getTaskId(String jobLockKey) {
        String str = (String)cache.get(CACHEKEY_TASKID, jobLockKey);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return str;
    }

    public static void putTaskId(String jobLockKey, String taskId) {
        cache.put(CACHEKEY_TASKID, jobLockKey, (Object)taskId);
    }
}

