/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dataentity.dao;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.schedule.dataentity.JobMainEntity;
import kd.bos.schedule.dataentity.JobMainEntityL;
import kd.bos.schedule.dataentity.JobNotifyEntryEntity;
import kd.bos.schedule.dataentity.JobNotifyReceiverEntity;
import kd.bos.schedule.dataentity.ScheduleMainEntity;
import kd.bos.schedule.dataentity.ScheduleMainEntityL;
import kd.bos.schedule.dataentity.ScheduleNotifyEntryEntity;
import kd.bos.schedule.dataentity.ScheduleNotifyReceiverEntity;
import kd.bos.schedule.dataentity.TaskDefineMainEntity;
import kd.bos.schedule.dataentity.TaskDefineMainEntityL;

public class ScheduleEntityWriter {
    private static Method businessDataWrite_save;
    private static Method businessDataWrite_delete;
    public static Class<?> businessDataWriter;

    public static void saveSchedule(List<ScheduleMainEntity> schMainEntityList) {
        ArrayList<String> schMainEntityIds = new ArrayList<String>(schMainEntityList.size());
        HashMap oldLocaleFids = new HashMap(3);
        ArrayList<Object> localePks = new ArrayList<Object>(schMainEntityIds.size());
        ArrayList<String> notifyMsgEntryPkIds = new ArrayList<String>(3);
        ArrayList<String> receiverEntryPkIds = new ArrayList<String>(3);
        for (ScheduleMainEntity it : schMainEntityList) {
            schMainEntityIds.add(it.getId());
            for (ScheduleMainEntityL locale : it.getLocaleCollection()) {
                oldLocaleFids.putIfAbsent(locale.getLocaleId(), new HashSet());
                ((Set)oldLocaleFids.get(locale.getLocaleId())).add(locale.getId());
                localePks.add(locale.getPkId());
            }
            for (ScheduleNotifyEntryEntity notifyEntry : it.getNotifyEntry()) {
                notifyMsgEntryPkIds.add(notifyEntry.getEntryId());
                for (ScheduleNotifyReceiverEntity receiver : notifyEntry.getReceivers()) {
                    receiverEntryPkIds.add(receiver.getPkId());
                }
            }
        }
        IDataEntityType mainDt = OrmUtils.getDataEntityType(ScheduleMainEntity.class);
        IDataEntityType localeDt = OrmUtils.getDataEntityType(ScheduleMainEntityL.class);
        IDataEntityType notifyEntryDt = OrmUtils.getDataEntityType(ScheduleNotifyEntryEntity.class);
        IDataEntityType receiverEntryDt = OrmUtils.getDataEntityType(ScheduleNotifyReceiverEntity.class);
        for (Map.Entry it : oldLocaleFids.entrySet()) {
            localePks.addAll(ScheduleEntityWriter.queryLocalePk(mainDt, localeDt, ((Set)it.getValue()).toArray(new Object[((Set)it.getValue()).size()]), (String)it.getKey()));
        }
        try (TXHandle tx = TX.required();){
            try {
                ScheduleEntityWriter.delete(mainDt, schMainEntityIds.toArray(new Object[schMainEntityIds.size()]));
                ScheduleEntityWriter.delete(localeDt, localePks.toArray(new Object[localePks.size()]));
                ScheduleEntityWriter.delete(notifyEntryDt, notifyMsgEntryPkIds.toArray());
                ScheduleEntityWriter.delete(receiverEntryDt, receiverEntryPkIds.toArray());
                ScheduleEntityWriter.save(mainDt, schMainEntityList.toArray(new ScheduleMainEntity[schMainEntityList.size()]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    private static List<Object> queryLocalePk(IDataEntityType mainDt, IDataEntityType localeDt, Object[] fids, String langTag) {
        SqlBuilder localeQuerySql = new SqlBuilder();
        ArrayList<Object> pkIds = new ArrayList<Object>(fids.length);
        localeQuerySql.append("select fpkid from ", new Object[0]).append(localeDt.getAlias(), new Object[0]).append(" where ", new Object[0]).appendIn("fid", fids).append(" and ", new Object[0]).appendIn("flocaleid", new Object[]{langTag});
        ResultSetHandler<Set<Object>> handler = new ResultSetHandler<Set<Object>>(){

            public Set<Object> handle(ResultSet resultSet) throws Exception {
                HashSet<Object> ids = new HashSet<Object>(10);
                while (resultSet.next()) {
                    ids.add(resultSet.getObject("fpkid"));
                }
                return ids;
            }
        };
        pkIds.addAll((Collection)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)localeQuerySql, (ResultSetHandler)handler));
        return pkIds;
    }

    public static void saveJob(List<JobMainEntity> jobMainEntityList) {
        ArrayList<String> jobMainEntityIds = new ArrayList<String>(jobMainEntityList.size());
        HashMap oldLocaleFids = new HashMap(3);
        ArrayList<Object> localePks = new ArrayList<Object>(jobMainEntityList.size());
        ArrayList<String> notifyMsgEntryPkIds = new ArrayList<String>(3);
        ArrayList<String> receiverEntryPkIds = new ArrayList<String>(3);
        for (JobMainEntity it : jobMainEntityList) {
            jobMainEntityIds.add(it.getId());
            for (JobMainEntityL locale : it.getLocaleCollection()) {
                oldLocaleFids.putIfAbsent(locale.getLocaleId(), new HashSet());
                ((Set)oldLocaleFids.get(locale.getLocaleId())).add(locale.getId());
                localePks.add(locale.getPkId());
            }
            for (JobNotifyEntryEntity notifyEntry : it.getNotifyEntry()) {
                notifyMsgEntryPkIds.add(notifyEntry.getEntryId());
                for (JobNotifyReceiverEntity receiver : notifyEntry.getReceivers()) {
                    receiverEntryPkIds.add(receiver.getPkId());
                }
            }
        }
        IDataEntityType mainDt = OrmUtils.getDataEntityType(JobMainEntity.class);
        IDataEntityType localeDt = OrmUtils.getDataEntityType(JobMainEntityL.class);
        IDataEntityType notifyEntryDt = OrmUtils.getDataEntityType(ScheduleNotifyEntryEntity.class);
        IDataEntityType receiverEntryDt = OrmUtils.getDataEntityType(ScheduleNotifyReceiverEntity.class);
        for (Map.Entry it : oldLocaleFids.entrySet()) {
            localePks.addAll(ScheduleEntityWriter.queryLocalePk(mainDt, localeDt, ((Set)it.getValue()).toArray(new Object[((Set)it.getValue()).size()]), (String)it.getKey()));
        }
        try (TXHandle tx = TX.required();){
            try {
                ScheduleEntityWriter.delete(mainDt, jobMainEntityIds.toArray(new Object[jobMainEntityIds.size()]));
                ScheduleEntityWriter.delete(localeDt, localePks.toArray(new Object[localePks.size()]));
                ScheduleEntityWriter.delete(notifyEntryDt, notifyMsgEntryPkIds.toArray());
                ScheduleEntityWriter.delete(receiverEntryDt, receiverEntryPkIds.toArray());
                ScheduleEntityWriter.save(mainDt, jobMainEntityList.toArray(new JobMainEntity[jobMainEntityList.size()]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    public static void saveTaskDefine(List<TaskDefineMainEntity> taskMainEntityList) {
        ArrayList<String> taskMainEntityIds = new ArrayList<String>(taskMainEntityList.size());
        HashMap oldLocaleFids = new HashMap(3);
        ArrayList<Object> localePks = new ArrayList<Object>(taskMainEntityList.size());
        for (TaskDefineMainEntity it : taskMainEntityList) {
            taskMainEntityIds.add(it.getId());
            for (TaskDefineMainEntityL locale : it.getLocaleCollection()) {
                oldLocaleFids.putIfAbsent(locale.getLocaleId(), new HashSet());
                ((Set)oldLocaleFids.get(locale.getLocaleId())).add(locale.getId());
                localePks.add(locale.getPkId());
            }
        }
        IDataEntityType mainDt = OrmUtils.getDataEntityType(TaskDefineMainEntity.class);
        IDataEntityType localeDt = OrmUtils.getDataEntityType(TaskDefineMainEntityL.class);
        for (Map.Entry it : oldLocaleFids.entrySet()) {
            localePks.addAll(ScheduleEntityWriter.queryLocalePk(mainDt, localeDt, ((Set)it.getValue()).toArray(new Object[((Set)it.getValue()).size()]), (String)it.getKey()));
        }
        try (TXHandle tx = TX.required();){
            try {
                ScheduleEntityWriter.delete(mainDt, taskMainEntityIds.toArray(new Object[taskMainEntityIds.size()]));
                ScheduleEntityWriter.delete(localeDt, localePks.toArray(new Object[localePks.size()]));
                ScheduleEntityWriter.save(mainDt, taskMainEntityList.toArray(new Object[taskMainEntityList.size()]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    private static void delete(IDataEntityType dt, Object[] pks) {
        if (pks.length == 0) {
            return;
        }
        try {
            ScheduleEntityWriter.getDeleteMethod().invoke(businessDataWriter, dt, pks);
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object[] save(IDataEntityType dt, Object[] pks) {
        try {
            return (Object[])ScheduleEntityWriter.getSaveMethod().invoke(businessDataWriter, dt, pks);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getSaveMethod() throws ClassNotFoundException, NoSuchMethodException {
        if (businessDataWriter == null) {
            businessDataWriter = Class.forName("kd.bos.data.BusinessDataWriter");
        }
        if (businessDataWrite_save == null) {
            businessDataWrite_save = businessDataWriter.getMethod("save", IDataEntityType.class, Object[].class);
        }
        return businessDataWrite_save;
    }

    private static Method getDeleteMethod() throws ClassNotFoundException, NoSuchMethodException {
        if (businessDataWriter == null) {
            businessDataWriter = Class.forName("kd.bos.data.BusinessDataWriter");
        }
        if (businessDataWrite_delete == null) {
            businessDataWrite_delete = businessDataWriter.getMethod("delete", IDataEntityType.class, Object[].class);
        }
        return businessDataWrite_delete;
    }
}

