/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobNotifyListener;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageSender;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.TaskResult;

public abstract class AbstractMessageSender
implements MessageSender {
    private static Log log = LogFactory.getLog(AbstractMessageSender.class);
    protected ObjectFactory objectFactory = null;

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public boolean udpateStorage(MessageInfo message) {
        TaskResult taskResult = message.fectchTaskResult();
        boolean ret = true;
        try {
            if (TaskResult.ResultTypeEnum.STATUS == taskResult.getResultType()) {
                ret = this.getObjectFactory().getTaskDao().updateStatus(message.getTaskId(), taskResult.getStatus(), taskResult.getStatusDesc());
                if ("COMPLETED".equals(taskResult.getStatus()) || "FAILED".equals(taskResult.getStatus()) || "TIMEOUT".equals(taskResult.getStatus())) {
                    this.sendNotify(message);
                }
                if (ret && "BEGIN".equals(taskResult.getStatus())) {
                    this.getObjectFactory().getTaskDao().updateRunAt(message.getTaskId(), message.getTarget(), message.getInstanceId(), message.getTraceId());
                }
            } else if (TaskResult.ResultTypeEnum.PROGRESS == taskResult.getResultType()) {
                Date now = new Date();
                String key = "SCH_TASK_PROGRESS_" + message.getTaskId();
                Date lastUpdateTime = (Date)ThreadCache.get((Object)key);
                if (taskResult.getProgress() >= 100 || lastUpdateTime == null || now.getTime() - lastUpdateTime.getTime() >= 1000L) {
                    ThreadCache.put((Object)key, (Object)now);
                    this.getObjectFactory().getTaskDao().updateProgress(message.getTaskId(), taskResult.getProgress(), taskResult.getDesc(), taskResult.getCustomData());
                }
            } else if (TaskResult.ResultTypeEnum.CUSTOMDATA == taskResult.getResultType()) {
                this.getObjectFactory().getTaskDao().updateCustomData(message.getTaskId(), taskResult.getCustomData());
            }
        }
        catch (Exception e) {
            String error = String.format(ResManager.loadKDString((String)"\u540e\u53f0\u4e8b\u52a1\u5f02\u5e38,AppName: %1$s,InstanceId: %2$s,taskId: %3$s ,errorInfo: %4$s", (String)"MQMessageSender_0", (String)"bos-schedule-message", (Object[])new Object[0]), Instance.getAppName(), Instance.getInstanceId(), message.getTaskId(), e.getMessage());
            log.error("Schedule***\u540e\u53f0\u4e8b\u52a1\u66f4\u65b0\u5b58\u50a8\u4fe1\u606f\u5f02\u5e38: " + error, (Throwable)e);
        }
        return ret;
    }

    public void sendNotify(MessageInfo message) {
        if (message.getMessageType() == MessageType.WorkFlowJOB) {
            return;
        }
        JobInfo jobInfo = message.fetchJobInfo();
        if (jobInfo != null) {
            this.jobProcessNotify(message);
        }
    }

    private void jobProcessNotify(MessageInfo message) {
        try {
            Class<?> notifyListener = Class.forName("kd.bos.schedule.notify.JobProcessorNotify");
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setNotifyListener((JobNotifyListener)notifyListener.getConstructor(new Class[0]).newInstance(new Object[0]));
            messageInfo.send(message);
        }
        catch (ClassNotFoundException e) {
            log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Throwable)e);
        }
    }
}

