/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.schedule.api.Executor;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.MessageWatcher;
import kd.bos.schedule.api.ObjectFactory;

public abstract class AbstractMessageWatcher
implements MessageWatcher {
    protected boolean isStop = false;
    protected String jobExecutorServerName = null;
    protected ObjectFactory objectFactory = null;
    private static final Log log = LogFactory.getLog(AbstractMessageWatcher.class);

    public void start() {
    }

    public void stop() {
        this.isStop = true;
    }

    public void dispatch(MessageInfo message, MessageAcker acker) {
        Executor executor = this.objectFactory.getExecutor();
        executor.processMessage(message, acker);
    }

    public synchronized void registHandler(MessageType messageType, MessageHandler handler) {
        this.objectFactory.getExecutor().registHandler(messageType, handler);
    }

    public synchronized void unRegistHandler(MessageType messageType, MessageHandler handler) {
        this.objectFactory.getExecutor().unRegistHandler(messageType, handler);
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void registHandler(MessageType messageType, Class<? extends MessageHandler> handlerClass) {
        this.objectFactory.getExecutor().registHandler(messageType, handlerClass);
    }

    public void unRegistHandler(MessageType messageType, Class<? extends MessageHandler> handlerClass) {
        this.objectFactory.getExecutor().unRegistHandler(messageType, handlerClass);
    }
}

