/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskResult;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MessageCreator {
    public static MessageInfo createStatusMessage(String taskId, String status, String desc) {
        return MessageCreator.createStatusMessage(taskId, status, null, desc);
    }

    public static MessageInfo createStatusMessage(String taskId, String status, String StatusDesc, String desc) {
        MessageInfo message = new MessageInfo();
        message.setTenantId(RequestContext.get().getTenantId());
        message.setAccountId(RequestContext.get().getAccountId());
        message.setId(UUID.randomUUID().toString());
        message.setTaskId(taskId);
        message.setMessageType(MessageType.BIZ_TASK_FEEDBACK);
        message.setTitle("TASK_STATUS");
        TaskResult taskResult = new TaskResult();
        taskResult.setResultType(TaskResult.ResultTypeEnum.STATUS);
        taskResult.setStatus(status);
        taskResult.setStatusDesc(StatusDesc);
        if (desc != null) {
            taskResult.setDesc(desc);
        }
        message.setTaskResult(taskResult);
        return message;
    }

    public static MessageInfo createStatusMessage(MessageInfo msg, String status, String desc) {
        MessageInfo message = new MessageInfo();
        message.setTenantId(RequestContext.get().getTenantId());
        message.setAccountId(RequestContext.get().getAccountId());
        message.setId(UUID.randomUUID().toString());
        message.setTaskId(msg.getTaskId());
        message.setMessageType(MessageType.BIZ_TASK_FEEDBACK);
        message.setTitle("TASK_STATUS");
        message.setJobInfo(msg.fetchJobInfo());
        TaskResult taskResult = new TaskResult();
        taskResult.setResultType(TaskResult.ResultTypeEnum.STATUS);
        taskResult.setStatus(status);
        if (desc != null) {
            taskResult.setDesc(desc);
        }
        message.setTaskResult(taskResult);
        return message;
    }

    public static MessageInfo createStatusMessage(TaskInfo task) {
        MessageInfo message = new MessageInfo();
        message.setTenantId(RequestContext.get().getTenantId());
        message.setAccountId(RequestContext.get().getAccountId());
        message.setId(UUID.randomUUID().toString());
        message.setTaskId(task.getId());
        message.setMessageType(MessageType.BIZ_TASK_FEEDBACK);
        message.setTitle("TASK_STATUS");
        TaskResult taskResult = new TaskResult();
        taskResult.setResultType(TaskResult.ResultTypeEnum.STATUS);
        taskResult.setStatus(task.getStatus());
        if (StringUtils.isNotBlank((CharSequence)task.getData())) {
            taskResult.setCustomData((Map)SerializationUtils.fromJsonString((String)task.getData(), Map.class));
        }
        taskResult.setProgress(task.getProgress());
        message.setTaskResult(taskResult);
        return message;
    }

    public static MessageInfo createProgressMessage(String taskId, int progress) {
        MessageInfo message = new MessageInfo();
        message.setTenantId(RequestContext.get().getTenantId());
        message.setAccountId(RequestContext.get().getAccountId());
        message.setId(UUID.randomUUID().toString());
        message.setTaskId(taskId);
        message.setMessageType(MessageType.BIZ_TASK_FEEDBACK);
        message.setTitle("TASK_PROGRESS");
        TaskResult taskResult = new TaskResult();
        taskResult.setResultType(TaskResult.ResultTypeEnum.PROGRESS);
        taskResult.setStatus("BEGIN");
        taskResult.setProgress(progress);
        message.setTaskResult(taskResult);
        return message;
    }

    public static MessageInfo createProgressMessage(String taskId, int progress, String desc, Map<String, Object> customData) {
        MessageInfo message = new MessageInfo();
        message.setTenantId(RequestContext.get().getTenantId());
        message.setAccountId(RequestContext.get().getAccountId());
        message.setId(UUID.randomUUID().toString());
        message.setTaskId(taskId);
        message.setMessageType(MessageType.BIZ_TASK_FEEDBACK);
        message.setTitle("TASK_PROGRESS");
        TaskResult taskResult = new TaskResult();
        taskResult.setResultType(TaskResult.ResultTypeEnum.PROGRESS);
        taskResult.setStatus("BEGIN");
        taskResult.setProgress(progress);
        taskResult.setDesc(desc);
        taskResult.setCustomData(customData);
        message.setTaskResult(taskResult);
        return message;
    }

    public static MessageInfo createCustomdataMessage(String taskId, Map<String, Object> customData) {
        MessageInfo message = new MessageInfo();
        message.setTenantId(RequestContext.get().getTenantId());
        message.setAccountId(RequestContext.get().getAccountId());
        message.setId(Uuid16.create().toString());
        message.setTaskId(taskId);
        message.setMessageType(MessageType.BIZ_TASK_FEEDBACK);
        message.setTitle("TASK_CUSTOMDATA");
        TaskResult taskResult = new TaskResult();
        taskResult.setResultType(TaskResult.ResultTypeEnum.CUSTOMDATA);
        taskResult.setStatus("BEGIN");
        taskResult.setCustomData(customData);
        message.setTaskResult(taskResult);
        return message;
    }

    public static MessageInfo createJobMessage(JobInfo jobInfo) {
        MessageInfo message = new MessageInfo();
        message.setId(UUID.randomUUID().toString());
        message.setTitle("JOB");
        if (jobInfo.getJobType() == JobType.BIZ || jobInfo.getJobType() == JobType.DETECT) {
            message.setMessageType(MessageType.BIZJOB);
        } else if (jobInfo.getJobType() == JobType.WORKFLOW) {
            message.setMessageType(MessageType.WorkFlowJOB);
        } else if (jobInfo.getJobType() == JobType.REALTIME) {
            message.setMessageType(MessageType.REALTIMEJOB);
        } else {
            ErrorCode ec = new ErrorCode("Schedule_0001", "not support job type.");
            throw new KDException(ec, new Object[0]);
        }
        message.setTenantId(RequestContext.get().getTenantId());
        message.setAccountId(RequestContext.get().getAccountId());
        message.setJobInfo(jobInfo);
        message.setTimeout(jobInfo.getTimeout());
        return message;
    }

    public static ScheduleMsgInfo buildScheduleMsgInfo(String scheduleId) {
        DynamicObject dynamicObject = ScheduleDataEntityUtils.getInvoker().loadSingleFromCache(SchEntityType.Schedule, (Object)scheduleId, "schprincipal,sfailnotify,ssuccessnotify,snotifytype,msgreceiver,smsgcontent,stimeout,saborted");
        ScheduleMsgInfo msgInfo = new ScheduleMsgInfo();
        if (dynamicObject != null) {
            Object schprincipal = dynamicObject.get("schprincipal");
            if (schprincipal == null) {
                msgInfo.setSchPrincipal(0L);
            } else {
                DynamicObject schp = (DynamicObject)schprincipal;
                msgInfo.setSchPrincipal(((Long)schp.getPkValue()).longValue());
            }
            Object msgreceiver = dynamicObject.get("msgreceiver");
            if (msgreceiver == null) {
                msgInfo.setMsgreceiver(0L);
            } else {
                DynamicObject msgr = (DynamicObject)msgreceiver;
                msgInfo.setMsgreceiver(((Long)msgr.getPkValue()).longValue());
            }
            msgInfo.setFailNotify(dynamicObject.getBoolean("sfailnotify"));
            msgInfo.setSuccessNotify(dynamicObject.getBoolean("ssuccessnotify"));
            msgInfo.setNotifyType(dynamicObject.getString("snotifytype"));
            msgInfo.setMsgContent(dynamicObject.getString("smsgcontent"));
            msgInfo.setTimeOut(dynamicObject.getBoolean("stimeout"));
            msgInfo.setAborted(dynamicObject.getBoolean("saborted"));
        }
        return msgInfo;
    }
}

