/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message.mq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.instance.MainGroupChangeListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.ConfigForInitConsumer;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.MQGrayManager;
import kd.bos.mq.support.QueueManager;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.utils.AppUtils;
import kd.bos.schedule.utils.ScheduleGrayGroup;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import org.apache.zookeeper.CreateMode;

public class MQHelper {
    public static final String EXECUTOR_CUSTOMER_CLASS = "kd.bos.schedule.executor.SchExecutorMessageCustomer";
    private static final Log log = LogFactory.getLog(MQHelper.class);
    public static final String SCHEDULE_MQ_REGION = "schedule";
    public static final String SCHEDULE_MQ_TASK = "schedule_task";
    public static final String SCHEDULE_MQ_STATUS = "schedule_status";
    public static final String SCHEDULE_MQ_JOBDISPATCH = "schedule_job_dispatch";
    private static final Map<String, MultiLangEnumBridge> sampleParamMap = new HashMap<String, MultiLangEnumBridge>();
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static Map<MessageType, String> registedGrayJobConsumers = new EnumMap<MessageType, String>(MessageType.class);
    private static String SCHEDULE_FINISHEDSTDQUEUE_CACHEKEY = "schedule_gray_finishedstdqueue";

    public static void startJobMessageConsumer(MessageType jobMessageType, String consumerClazz) {
        MQHelper.registerJobConsumer(jobMessageType, consumerClazz, true);
    }

    private static void registerJobConsumer(MessageType jobMessageType, String consumerClazz, boolean enableGrayModel) {
        String queueName = MQHelper.buildQueueName("schedule_task_" + jobMessageType.name());
        try {
            MQHelper.checkMq();
            if (ZkConfig.isMqAppSplit()) {
                CharSequence[] appIds = Instance.getAppIds();
                log.info("Schedule***" + String.format(sampleParamMap.get("MqTips").loadKDString(), jobMessageType.name(), appIds == null ? "" : String.join((CharSequence)",", appIds)));
                QueueDef queueDef = MQHelper.buildQueueDef(queueName, consumerClazz, jobMessageType, enableGrayModel);
                QueueManager.addWithAppidTags((String)SCHEDULE_MQ_REGION, (QueueDef)queueDef);
                if (enableGrayModel) {
                    registedGrayJobConsumers.put(jobMessageType, consumerClazz);
                }
                log.info("/*ScheduleQueueTagName*/ " + queueDef.getName());
            } else {
                QueueManager.add((String)SCHEDULE_MQ_REGION, (QueueDef)MQHelper.buildQueueDef(queueName, consumerClazz, jobMessageType, false), (boolean)Boolean.TRUE);
            }
        }
        catch (Throwable t) {
            log.error("Schedule***startJobMessageConsumer error, queueName:" + queueName, t);
            throw new RuntimeException(String.format("mq registerJobConsumer fail,messageType:%s", jobMessageType.name()), t);
        }
    }

    public static void startTaskStatusConsumer(String consumerClazz) {
        QueueManager.add((String)SCHEDULE_MQ_REGION, (QueueDef)MQHelper.buildQueueDef(MQHelper.buildQueueName(SCHEDULE_MQ_STATUS), consumerClazz, false), (boolean)Boolean.TRUE);
    }

    public static void startJobDispatchComsumer(String consumerClazz) {
        QueueManager.add((String)SCHEDULE_MQ_REGION, (QueueDef)MQHelper.buildQueueDef(MQHelper.buildQueueName(SCHEDULE_MQ_JOBDISPATCH), consumerClazz, false), (boolean)Boolean.TRUE);
    }

    public static MessagePublisher getJobMessagePulisher(MessageInfo message) {
        MessagePublisher publisher = null;
        String queueName = MQHelper.buildQueueName("schedule_task_" + message.getMessageType().name());
        if (ZkConfig.isMqAppSplit()) {
            JobInfo jobInfo = message.fetchJobInfo();
            String appId = AppUtils.getRealRouteAppIdByAppId(jobInfo.getAppId(), message.getMessageType());
            if (!StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)jobInfo.getAppId()) && jobInfo.isTaskTrace()) {
                log.info("Schedule***message send appId is update,source appId = {}, target appId = {}", (Object)jobInfo.getAppId(), (Object)appId);
            }
            QueueDef queueDef = MQHelper.buildQueueDef(queueName, EXECUTOR_CUSTOMER_CLASS, null, false, appId);
            String group = ScheduleGrayGroup.getJobAppGourp(jobInfo, message.getMessageType());
            if (StringUtils.isNotBlank((CharSequence)group)) {
                String groupQueueName = QueueManager.getGroupQueueName((String)queueName, (String)group);
                queueDef.setName(groupQueueName);
                ScheduleGrayGroup.logInfo("Schedule***schedule-gray-route:" + group + ",jobinfo:" + SerializationUtils.toJsonString((Object)jobInfo));
            }
            publisher = MQFactory.get().$createPublisherWithAppid(SCHEDULE_MQ_REGION, queueDef, appId);
            if (log.isDebugEnabled()) {
                log.debug("Schedule***taskId:{} => queueDefName:{},appId:{}", new Object[]{message.getTaskId(), queueDef.getName(), appId});
            }
        } else {
            QueueManager.add((String)SCHEDULE_MQ_REGION, (QueueDef)MQHelper.buildQueueDef(queueName, EXECUTOR_CUSTOMER_CLASS, false), (boolean)false);
            publisher = MQFactory.get().createSimplePublisher(SCHEDULE_MQ_REGION, queueName);
        }
        return publisher;
    }

    public static List<MessagePublisher> getJobMessagePulisherList(MessageInfo message) {
        ArrayList<MessagePublisher> publisherList = new ArrayList<MessagePublisher>(4);
        MessagePublisher publisher = MQHelper.getJobMessagePulisher(message);
        if (publisher != null) {
            publisherList.add(publisher);
        }
        return publisherList;
    }

    private static String buildQueueName(String queueName) {
        String zkPath = System.getProperty("Schedule.zk.path", ZkConfig.getScheduleRootPath());
        if (zkPath == null) {
            throw new KDException(BosErrorCode.configZookeepConfig, new Object[]{"schedule Schedule.zk.path not configured."});
        }
        String envQueue = null;
        if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
            String ipAddress = AbstractService.getHostIpAddress();
            envQueue = String.format("%s_%s_%s", zkPath, queueName, ipAddress);
        } else {
            envQueue = String.format("%s_%s", zkPath, queueName);
        }
        return envQueue.replaceAll("[./]", "_");
    }

    public static MessagePublisher getTaskStausPulisher() {
        QueueManager.add((String)SCHEDULE_MQ_REGION, (QueueDef)MQHelper.buildQueueDef(MQHelper.buildQueueName(SCHEDULE_MQ_STATUS), "kd.bos.schedule.server.messagecustomer.TaskStatusMessageCustomer", false), (boolean)false);
        return MQFactory.get().createSimplePublisher(SCHEDULE_MQ_REGION, MQHelper.buildQueueName(SCHEDULE_MQ_STATUS));
    }

    public static MessagePublisher getJobDispaterPulisher() {
        QueueManager.add((String)SCHEDULE_MQ_REGION, (QueueDef)MQHelper.buildQueueDef(MQHelper.buildQueueName(SCHEDULE_MQ_JOBDISPATCH), "kd.bos.schedule.server.messagecustomer.AsynJobMessageDispatcher", false), (boolean)false);
        return MQFactory.get().createSimplePublisher(SCHEDULE_MQ_REGION, MQHelper.buildQueueName(SCHEDULE_MQ_JOBDISPATCH));
    }

    private static QueueDef buildQueueDef(String queueName, String className, boolean supportGrayQueue) {
        return MQHelper.buildQueueDef(queueName, className, null, supportGrayQueue);
    }

    private static QueueDef buildQueueDef(String queueName, String className, MessageType type, boolean supportGrayQueue) {
        return MQHelper.buildQueueDef(queueName, className, type, supportGrayQueue, null);
    }

    private static QueueDef buildQueueDef(String queueName, String className, MessageType type, boolean supportGrayQueue, String appid) {
        ConsumerDef consumerDef = new ConsumerDef();
        consumerDef.setClassName(className);
        consumerDef.setAutoAck(false);
        int concurrency = ZkConfig.getMqConsumeConcurrency();
        consumerDef.setConcurrency(concurrency);
        QueueDef queueDef = new QueueDef();
        queueDef.setDuration(true);
        queueDef.setName(queueName);
        if (StringUtils.isNotEmpty((CharSequence)appid)) {
            queueDef.setAppid(appid);
        }
        String curGrop = AppGroup.getCurAppGroup();
        String[] appids = Instance.getAppIds();
        if (supportGrayQueue && StringUtils.isNotBlank((CharSequence)curGrop) && Instance.isAppSplit() && appids != null && appids.length > 0) {
            for (String appId : appids) {
                if (!AppGroup.isCurrentGrayNode((String)appId)) continue;
                String groupQueueName = QueueManager.getGroupQueueName((String)queueName, (String)curGrop);
                ScheduleGrayGroup.logInfo(String.format("Schedule***schedule.queue.groupinfo ,  curGroup=%s,groupname=%s ", curGrop, groupQueueName));
                queueDef.setName(groupQueueName);
                break;
            }
        }
        queueDef.setTransactional(false);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            queueDef.setConsumers(Arrays.asList(consumerDef));
        }
        return queueDef;
    }

    private static Set<String> getRegistedAppids() {
        Set<String> appIdSet;
        String strAppIds = System.getProperty("registedAppIds");
        if (strAppIds != null) {
            String[] arrayAppids = strAppIds.split(",");
            appIdSet = new HashSet<String>(Arrays.asList(arrayAppids));
        } else {
            appIdSet = Collections.emptySet();
        }
        return appIdSet;
    }

    private static void checkMq() throws Exception {
        if (!ConfigForInitConsumer.isConsumerEnable()) {
            throw new Exception("Schedule***mq server is not running,this node is not scheduled");
        }
    }

    static {
        sampleParamMap.put("MqTips", new MultiLangEnumBridge("\u521b\u5efa-\u6309\u5e94\u7528\u5212\u5206\u7684MQ\u961f\u5217--\u5f53\u524d\u88ab\u521b\u5efa\u7684\u6d88\u606f\u7c7b\u578b\u4e3a:%1$s,\u5f53\u524d\u5e94\u7528\u8282\u70b9\u5982\u4e0b\uff1a%2$s", "MQHelper_0", "bos-schedule-message"));
        ScheduleGrayGroup.registGroupListener(new ScheduleMQGroupChangeListener(MessageType.BIZJOB));
        ScheduleGrayGroup.registGroupListener(new ScheduleMQGroupChangeListener(MessageType.WorkFlowJOB));
        ScheduleGrayGroup.registGroupListener(new ScheduleMQGroupChangeListener(MessageType.REALTIMEJOB));
    }

    static class ScheduleMQGroupChangeListener
    implements MainGroupChangeListener {
        private MessageType type;
        private AtomicBoolean isGrayNodeChanging = new AtomicBoolean(false);
        private AtomicBoolean isGrayNodeChanged = new AtomicBoolean(false);
        private AtomicBoolean isProNodeChanging = new AtomicBoolean(false);
        private AtomicBoolean isProNodeChanged = new AtomicBoolean(false);

        public ScheduleMQGroupChangeListener(MessageType type) {
            this.type = type;
        }

        public void productionToEliminateNode(String appId, String group) {
            ThreadPools.executeOnce((String)"BOSSchedule-productionToEliminateNode", () -> {
                boolean locked = false;
                try {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    log.info("\u6b63\u5f0f\u8f6c\u5e9f\u5f03\u8282\u70b9   begin");
                    if (this.isProNodeChanging.getAndSet(true)) {
                        log.info("Schedule***\u5f53\u524d\u8282\u70b9\u6b63\u5728\u5904\u7406\u6b63\u5f0f\u8f6c\u5e9f\u5f03\u8282\u70b9\uff0c\u4e0d\u91cd\u590d\u5904\u7406");
                        return;
                    }
                    locked = true;
                    if (this.isProNodeChanged.get()) {
                        log.info("Schedule***\u6b63\u5f0f\u8f6c\u5e9f\u5f03\u8282\u70b9\u5df2\u5b8c\u6210\uff0c\u4e0d\u91cd\u590d\u5904\u7406");
                        return;
                    }
                    if (!ConsumerSupport.isNeedDeploy((String)appId)) {
                        log.info(String.format("Schedule***\u5f53\u524d\u8282\u70b9\u672a\u90e8\u7f72\u8be5\u5e94\u7528,\u975e\u7070\u5ea6\u8282\u70b9\u8f6c\u6b63\u5f0f\u8282\u70b9,\u5f53\u524dgroup=%s,\u6536\u5230\u4fe1\u53f7  app=%s,group=%s", AppGroup.getCurAppGroup(), appId, group));
                        return;
                    }
                    Map consumers = QueueManager.getConsumers();
                    ArrayList<Object> noFinished = new ArrayList<Object>(consumers.values());
                    List<Consumer> needStopConsumers = this.waitForSchConsumeFinish(noFinished, false);
                    for (Consumer needStopConsumer : needStopConsumers) {
                        try {
                            log.info("Schedule***\u5f00\u59cb\u53cd\u6ce8\u518cconsumer, queue is " + needStopConsumer.getQueueName());
                            needStopConsumer.$$stop();
                        }
                        catch (Exception e) {
                            log.error("Schedule***\u53cd\u6ce8\u518c err,queue is " + needStopConsumer.getQueueName(), (Throwable)e);
                        }
                    }
                    this.isProNodeChanged.set(true);
                }
                finally {
                    if (locked) {
                        this.isProNodeChanging.set(false);
                    }
                }
            });
        }

        public void grayToProductionNode(String app, String group) {
            ThreadPools.executeOnce((String)"Sch_grayToProductionNode", () -> {
                boolean registedZknode = false;
                String zkPath = ZkConfig.getGrayInstanceChangingPath() + "/" + this.type.name() + "/" + Instance.getInstanceId();
                boolean locked = false;
                try {
                    log.info("Schedule***\u7070\u5ea6\u8f6c\u6b63\u5f0f\u8282\u70b9   begin");
                    if (this.isGrayNodeChanging.getAndSet(true)) {
                        log.info("Schedule***\u5f53\u524d\u8282\u70b9\u6b63\u5728\u5904\u7406\u7070\u5ea6\u8f6c\u6b63\u5f0f\u8282\u70b9\uff0c\u4e0d\u91cd\u590d\u5904\u7406");
                        return;
                    }
                    locked = true;
                    if (this.isGrayNodeChanged.get()) {
                        log.info("Schedule***\u7070\u5ea6\u8f6c\u6b63\u5f0f\u8282\u70b9\u5df2\u5b8c\u6210\uff0c\u4e0d\u91cd\u590d\u5904\u7406");
                        return;
                    }
                    if (!ConsumerSupport.isNeedDeploy((String)app)) {
                        log.info(String.format("Schedule***\u5f53\u524d\u8282\u70b9\u672a\u90e8\u7f72\u8be5\u5e94\u7528,\u975e\u7070\u5ea6\u8282\u70b9\u8f6c\u6b63\u5f0f\u8282\u70b9,\u5f53\u524dgroup=%s,\u6536\u5230\u4fe1\u53f7  app=%s,group=%s", AppGroup.getCurAppGroup(), app, group));
                        return;
                    }
                    String[] appIds = Instance.getAppIds();
                    if (appIds == null || appIds.length == 0) {
                        return;
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HashMap<String, String> cacheData = new HashMap<String, String>(appIds.length);
                    for (String it : appIds) {
                        cacheData.put(it, group);
                    }
                    if (ZkConfig.isSupportZk()) {
                        ActiveKeyValueStore.create().write(zkPath, SerializationUtils.toJsonString(cacheData), CreateMode.EPHEMERAL);
                        registedZknode = true;
                    } else {
                        String masterRpcIp = RPCHelper.getMasterRpcIp();
                        EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)"kd.bos.schedule.server.ScheduleService", (String)"grayInstanceChanged", (Object[])new Object[]{SerializationUtils.toJsonString(cacheData)});
                    }
                    log.info("Sch_grayToProductionNode wait app = " + SerializationUtils.toJsonString(cacheData));
                    if (registedGrayJobConsumers.get(this.type) == null) {
                        this.isGrayNodeChanged.set(true);
                        return;
                    }
                    this.waitForOldStdQueueFinished();
                    log.info("Schedule***\u7070\u5ea6\u8f6c\u6b63\u5f0f\u8282\u70b9\uff0c\u91cd\u65b0\u6ce8\u518cschedule consumer");
                    try {
                        MQHelper.registerJobConsumer(this.type, (String)registedGrayJobConsumers.get(this.type), false);
                    }
                    catch (Throwable e) {
                        log.error("Schedule***startJobMessageConsumer error, msg:" + e.getMessage());
                    }
                    if (registedZknode) {
                        ActiveKeyValueStore.create().delete(zkPath);
                        registedZknode = false;
                    }
                    Map consumers = QueueManager.getConsumers();
                    ArrayList<Object> noFinished = new ArrayList<Object>(consumers.values());
                    List<Consumer> needStopConsumers = this.waitForSchConsumeFinish(noFinished, true);
                    for (Consumer needStopConsumer : needStopConsumers) {
                        try {
                            log.info("Schedule***\u5f00\u59cb\u53cd\u6ce8\u518cconsumer, queue is " + needStopConsumer.getQueueName());
                            needStopConsumer.$$stop();
                        }
                        catch (Exception e) {
                            log.error("Schedule***\u53cd\u6ce8\u518c err,queue is " + needStopConsumer.getQueueName(), (Throwable)e);
                        }
                    }
                    this.releaseGrayQueueWhenFinished();
                    registedGrayJobConsumers.remove(this.type);
                    this.isGrayNodeChanged.set(true);
                }
                catch (Exception e) {
                    log.error("Schedule***schedule\u7070\u5ea6\u8f6c\u6b63\u5f0f\u5f02\u5e38\uff0cmsg:" + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (locked) {
                        this.isGrayNodeChanging.set(false);
                    }
                    log.info("Schedule***\u7070\u5ea6\u8f6c\u6b63\u5f0f\u8282\u70b9   end");
                    if (registedZknode) {
                        ActiveKeyValueStore.create().delete(zkPath);
                    }
                }
            });
        }

        private List<Consumer> waitForSchConsumeFinish(List<Object> consumers, boolean gray) {
            ArrayList<Consumer> needStopConsumers;
            block14: {
                needStopConsumers = new ArrayList<Consumer>(16);
                int times = 0;
                ArrayList<Consumer> scheduleConsumers = new ArrayList<Consumer>(16);
                String possibleGroup = AppGroup.getCurAppGroup();
                if (StringUtils.isBlank((CharSequence)possibleGroup) && StringUtils.equals((CharSequence)"defaultGroup", (CharSequence)possibleGroup)) {
                    possibleGroup = null;
                }
                for (Object it : consumers) {
                    Consumer consumer = (Consumer)it;
                    if (!StringUtils.equals((CharSequence)MQHelper.SCHEDULE_MQ_REGION, (CharSequence)consumer.getRegion()) || !consumer.isStarted() || !StringUtils.containsIgnoreCase((CharSequence)consumer.getQueueName(), (CharSequence)this.type.name())) continue;
                    if (!gray && AppGroup.isGrayUpgrade() && !ScheduleGrayGroup.isGrayUpgrade()) {
                        scheduleConsumers.add(consumer);
                        continue;
                    }
                    if (gray && StringUtils.isNotBlank((CharSequence)possibleGroup) && StringUtils.contains((CharSequence)consumer.getQueueName(), (CharSequence)possibleGroup)) {
                        log.info("Schedule***need check gray consumer " + consumer.getQueueName());
                        scheduleConsumers.add(consumer);
                        continue;
                    }
                    if (gray || !StringUtils.isBlank((CharSequence)possibleGroup) && StringUtils.contains((CharSequence)consumer.getQueueName(), (CharSequence)possibleGroup)) continue;
                    log.info("Schedule***need check std consumer " + consumer.getQueueName());
                    scheduleConsumers.add(consumer);
                }
                MQGrayManager mqGrayManager = MQGrayManager.get((String)MQHelper.SCHEDULE_MQ_REGION);
                do {
                    int size = scheduleConsumers.size();
                    for (int i = size - 1; i >= 0; --i) {
                        Consumer consumer = (Consumer)scheduleConsumers.get(i);
                        String region = consumer.getRegion();
                        String queueName = consumer.getQueueName();
                        try {
                            if (!gray && AppGroup.isGrayUpgrade() && !ScheduleGrayGroup.isGrayUpgrade()) {
                                scheduleConsumers.remove(i);
                                needStopConsumers.add(consumer);
                                continue;
                            }
                            try {
                                long messageCount = mqGrayManager.messageCount(region, queueName);
                                log.info(String.format("Schedule***queue is %s , count = %s", queueName, messageCount));
                                if (messageCount != 0L) continue;
                                scheduleConsumers.remove(i);
                                needStopConsumers.add(consumer);
                            }
                            catch (Exception e) {
                                if (!gray) {
                                    scheduleConsumers.remove(i);
                                    needStopConsumers.add(consumer);
                                }
                                log.error(String.format("Schedule***sch_messagecount error, queue=%s,region=%s", queueName, region), (Throwable)e);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            log.error("Schedule***schedule_productionToEliminateNode, queue: " + queueName, (Throwable)e);
                        }
                    }
                    if (scheduleConsumers.isEmpty()) break block14;
                    try {
                        TimeUnit.SECONDS.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (times++ <= Integer.getInteger("schedule.upgrade.wait.oldqueuetofinish", 3600));
                log.info("Schedule***sch_messagecount timeout, unregister all queue");
                needStopConsumers.addAll(scheduleConsumers);
            }
            return needStopConsumers;
        }

        private long getConsumerCount(MQGrayManager manager, String region, String queueName) throws KDException {
            try {
                return manager.consumerCount(MQHelper.SCHEDULE_MQ_REGION, queueName);
            }
            catch (Exception e) {
                log.error(String.format("Schedule***getConsumerCount.err,region=%s,queue=%s", region, queueName), (Throwable)e);
                throw new KDException(BosErrorCode.bOS, String.format("getConsumerCount.err,region=%s,queue=%s", region, queueName), (Throwable)e);
            }
        }

        private void waitForOldStdQueueFinished() {
            int maxTimeout = Integer.getInteger("schedule.upgrade.wait.oldqueuetofinish", 900);
            MQGrayManager mqGrayManager = MQGrayManager.get((String)MQHelper.SCHEDULE_MQ_REGION);
            String[] appIds = Instance.getAppIds();
            String curAppGroup = AppGroup.getCurAppGroup();
            ArrayList todoStdAppIds = new ArrayList(appIds.length);
            Collections.addAll(todoStdAppIds, appIds);
            int size = appIds.length;
            int times = 0;
            while (size > 0) {
                Iterator appIterator = todoStdAppIds.iterator();
                while (appIterator.hasNext()) {
                    String appId = (String)appIterator.next();
                    String standardDefName = MQHelper.buildQueueName("schedule_task_" + this.type.name());
                    String stdQueueNameWithAppId = QueueManager.getRealQueueNameWithAppid((String)MQHelper.SCHEDULE_MQ_REGION, (String)standardDefName, (String)appId);
                    try {
                        log.debug(String.format("Schedule***\u83b7\u53d6\u6807\u51c6\u961f\u5217consumer,region=%s ,queue=%s", MQHelper.SCHEDULE_MQ_REGION, stdQueueNameWithAppId));
                        long consumerCount = this.getConsumerCount(mqGrayManager, MQHelper.SCHEDULE_MQ_REGION, stdQueueNameWithAppId);
                        log.info(String.format("Schedule***queue=%s,consumer_count=%s", stdQueueNameWithAppId, consumerCount));
                        String data = (String)cache.get(SCHEDULE_FINISHEDSTDQUEUE_CACHEKEY, stdQueueNameWithAppId);
                        if (StringUtils.equals((CharSequence)data, (CharSequence)curAppGroup)) {
                            --size;
                            appIterator.remove();
                            continue;
                        }
                        if (consumerCount <= 0L) {
                            --size;
                            appIterator.remove();
                            ScheduleGrayGroup.logInfo(String.format("Schedule***standard queue consumer==0,region=%s ,queue=%s", MQHelper.SCHEDULE_MQ_REGION, stdQueueNameWithAppId));
                            cache.put(SCHEDULE_FINISHEDSTDQUEUE_CACHEKEY, stdQueueNameWithAppId, String.valueOf(curAppGroup), maxTimeout);
                            continue;
                        }
                        LockSupport.parkNanos(5000000000L);
                    }
                    catch (Exception e) {
                        log.error("Schedule***sch_getConsumerCount error", (Throwable)e);
                        --size;
                        appIterator.remove();
                        LockSupport.parkNanos(5000000000L);
                    }
                }
                if (times++ <= maxTimeout) continue;
                log.info("Schedule***wait oldqueuetofinish timeout");
                break;
            }
        }

        private void releaseGrayQueueWhenFinished() {
            int maxTimeout = Integer.getInteger("schedule.upgrade.wait.grayqueuetofinish", 900);
            String[] appIds = Instance.getAppIds();
            ArrayList todoAppIds = new ArrayList(appIds.length);
            String curGrop = AppGroup.getCurAppGroup();
            MQGrayManager mqGrayManager = MQGrayManager.get((String)MQHelper.SCHEDULE_MQ_REGION);
            Collections.addAll(todoAppIds, appIds);
            int size = appIds.length;
            int times = 0;
            while (size > 0) {
                Iterator appIterator = todoAppIds.iterator();
                while (appIterator.hasNext()) {
                    String appId = (String)appIterator.next();
                    String standardDefName = MQHelper.buildQueueName("schedule_task_" + this.type.name());
                    String groupQueueDefName = QueueManager.getGroupQueueName((String)standardDefName, (String)curGrop);
                    String queueName = QueueManager.getRealQueueNameWithAppid((String)MQHelper.SCHEDULE_MQ_REGION, (String)groupQueueDefName, (String)appId);
                    try {
                        log.info(String.format("Schedule***\u83b7\u53d6\u7070\u5ea6\u961f\u5217consumer,region=%s ,queue=%s", MQHelper.SCHEDULE_MQ_REGION, queueName));
                        long consumerCount = mqGrayManager.consumerCount(MQHelper.SCHEDULE_MQ_REGION, queueName);
                        ScheduleGrayGroup.logInfo(String.format("Schedule***queue=%s,consumer_count=%s", queueName, consumerCount));
                        if (consumerCount <= 0L) {
                            --size;
                            appIterator.remove();
                            mqGrayManager.deleteQueue(MQHelper.SCHEDULE_MQ_REGION, queueName);
                            continue;
                        }
                        LockSupport.parkNanos(5000000000L);
                    }
                    catch (Throwable e) {
                        log.error(String.format("Schedule***\u83b7\u53d6\u7070\u5ea6\u961f\u5217consumer error,region=%s ,queue=%s", MQHelper.SCHEDULE_MQ_REGION, queueName), (Throwable)new RuntimeException(e));
                        --size;
                        appIterator.remove();
                    }
                }
                if (times++ <= maxTimeout) continue;
                break;
            }
        }
    }
}

