/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message.rpc;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ServerManager;
import kd.bos.schedule.next.observable.filter.ExecutorServerStatusFilter;
import kd.bos.service.ServiceFactory;

public class RPCHelper {
    private static ServerManager sm = (ServerManager)ServiceFactory.getService(ServerManager.class);
    private static final String TASKSTATUS_CUSTOMER_CLASS = "kd.bos.schedule.server.messagecustomer.TaskStatusMessageCustomer";
    private static final String ASYNJOBMESSAGEDISPATCHER_CUSTOMER_CLASS = "kd.bos.schedule.server.messagecustomer.AsynJobMessageDispatcher";
    private static final String RUNNING_TASKS_CLASS = "kd.bos.schedule.message.RunningTasks";
    private static final String ABSTRACT_TASK_ANALYSE_CLASS = "kd.bos.schedule.analyse.AbstractTaskAnalyse";
    private static final String MasterServerStatusFilter = "kd.bos.schedule.server.next.observable.filter.MasterServerStatusFilter";

    public static void dispatchToJobDispatch(String msg) {
        String masterRpcIp = RPCHelper.getMasterRpcIp();
        EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)ASYNJOBMESSAGEDISPATCHER_CUSTOMER_CLASS, (String)"onMessage", (Object[])new Object[]{msg});
    }

    public static void dispatchToTaskStatus(String msg) {
        String masterRpcIp = RPCHelper.getMasterRpcIp();
        EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)TASKSTATUS_CUSTOMER_CLASS, (String)"onMessage", (Object[])new Object[]{msg});
    }

    public static Object remoteGetRunningTaskThreadDump(String ip, MessageType messageType, String accountId, String messageId) {
        return EndPointDispatchServiceHelper.invoke((String)ip, (String)RUNNING_TASKS_CLASS, (String)"getThreadDump", (Object[])new Object[]{messageType, accountId, messageId});
    }

    public static Object remoteGetAllRunningTaskThreadDump(String ip, MessageType messageType) {
        return EndPointDispatchServiceHelper.invoke((String)ip, (String)RUNNING_TASKS_CLASS, (String)"getAllThreadDump", (Object[])new Object[]{messageType});
    }

    public static Object remoteGetExecutorServerData(String ip, MessageType messageType) {
        return EndPointDispatchServiceHelper.invoke((String)ip, (String)ABSTRACT_TASK_ANALYSE_CLASS, (String)"remoteGetExecutorServerData", (Object[])new Object[]{messageType});
    }

    public static Object remoteGetExecutorServerStatus(String ip, Object ... params) {
        return EndPointDispatchServiceHelper.invoke((String)ip, (String)ExecutorServerStatusFilter.class.getName(), (String)"getExecutorServerStatus", (Object[])params);
    }

    public static Object remoteGetScheduleMasterTimeWheel(String ip, Object ... params) {
        return EndPointDispatchServiceHelper.invoke((String)ip, (String)MasterServerStatusFilter, (String)"getScheduleCycleData", (Object[])params);
    }

    public static Object remoteGetScheduleMasterScheduleDist(String ip, Object ... params) {
        return EndPointDispatchServiceHelper.invoke((String)ip, (String)MasterServerStatusFilter, (String)"getScheduleDist", (Object[])params);
    }

    public static Object remoteGetScheduleMasterStatus(String ip, Object ... params) {
        return EndPointDispatchServiceHelper.invoke((String)ip, (String)MasterServerStatusFilter, (String)"getMasterServerStatus", (Object[])params);
    }

    public static String getMasterRpcIp() {
        String masterRpcIp = null;
        Map serverInfo = sm.getMasterServerInfo();
        if (serverInfo != null) {
            masterRpcIp = (String)serverInfo.get("masterName");
        }
        if (StringUtils.isEmpty(masterRpcIp)) {
            ErrorCode ec = new ErrorCode("SCHEDULE_SERVER_HAS_ALREADY_STARTED", "masterRpcIp is null");
            throw new KDException(ec, new Object[0]);
        }
        return masterRpcIp;
    }
}

