/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message.zk;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.message.AbstractMessageWatcher;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ListGroupForever;
import kd.bos.schedule.zk.ZkConfig;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class ZkMessageWatcher
extends AbstractMessageWatcher {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.message.zk.ZkMessageWatcher");
    protected static int EXPIRED_TIME = 0x6DDD00;
    protected ActiveKeyValueStore zkStore = null;
    private ListGroupForever jobMonitor = null;
    private String executorJobRootPath = null;
    private String runAt = null;

    @Override
    public void start() {
        this.zkStore = ActiveKeyValueStore.create();
        super.start();
        this.executorJobRootPath = ZkConfig.getJobRootPath() + "/" + this.runAt;
        this.zkStore.write(this.executorJobRootPath, String.valueOf(System.currentTimeMillis()));
        this.releaseDirtyJob();
        this.startMonitor();
    }

    private void releaseDirtyJob() {
        try {
            List<String> children = this.zkStore.getChildren(this.executorJobRootPath);
            for (String node : children) {
                List<String> taskWatcher;
                String msgStr;
                MessageInfo message;
                String jobPath = this.executorJobRootPath + "/" + node;
                Stat nodeStat = (Stat)this.zkStore.exists(jobPath);
                if (nodeStat == null || !"HOLDING".equals((message = (MessageInfo)JSON.parseObject((String)(msgStr = this.zkStore.read(jobPath, null)), MessageInfo.class)).getFlag()) && !"SCHEDULE".equals(message.getFlag()) || !(taskWatcher = this.zkStore.getChildren(ZkConfig.getTaskStatusPath(node))).isEmpty()) continue;
                this.zkStore.delete(ZkConfig.getTaskStatusPath(node));
                this.zkStore.delete(jobPath);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void startMonitor() {
        this.jobMonitor = new ListGroupForever(this.executorJobRootPath, (childrenName, type) -> {
            log.info("Event Type:" + type);
            if (type == Watcher.Event.EventType.NodeChildrenChanged) {
                this.processMsg(childrenName);
            }
        });
        this.jobMonitor.start();
    }

    private void processMsg(List<String> childrenName) {
        log.debug("get message");
        for (String npath : childrenName) {
            String msgStr;
            MessageInfo message;
            String queuePath = this.executorJobRootPath + "/" + npath;
            Stat nodeStat = (Stat)this.zkStore.exists(queuePath);
            if (nodeStat == null || (message = (MessageInfo)JSON.parseObject((String)(msgStr = this.zkStore.read(queuePath, null)), MessageInfo.class)).getFlag() != null && !message.getFlag().equals("SCHEDULE")) continue;
            message.setFlag("HOLDING");
            this.zkStore.write(queuePath, JSON.toJSONString((Object)message));
            this.dispatch(message, null);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.jobMonitor.stop();
    }

    public void setRunAt(String runAt) {
        this.runAt = runAt;
    }

    public String getRunAt() {
        return this.runAt;
    }

    public void startToWatchMessage(MessageType messageType) {
    }
}

