/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message.zk;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.Subscriber;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.WatchDataForever;
import kd.bos.schedule.zk.ZkConfig;
import org.apache.zookeeper.CreateMode;

public class ZkSubscriber
implements Subscriber {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.message.zk.ZkSubscriber");
    private ObjectFactory objectFactory = null;
    protected Map<String, WatchDataForever> watcherMap = new HashMap<String, WatchDataForever>();
    protected ActiveKeyValueStore zkStore = null;

    public void setZooKeeper() {
        this.zkStore = ActiveKeyValueStore.create();
    }

    public void subscribe(String taskId, MessageHandler cb) throws KDException {
        cb.setObjectFactory(this.getObjectFactory());
        String taskStatusPath = ZkConfig.getTaskStatusPath(taskId);
        this.zkStore.ensureExisted(taskStatusPath, "{}");
        WatchDataForever watcher = new WatchDataForever(taskStatusPath, cb);
        this.watcherMap.put(taskId, watcher);
        String watchNodePath = taskStatusPath + "/watcher";
        CreateMode createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        this.zkStore.write(watchNodePath, String.valueOf(System.currentTimeMillis()), createMode);
        watcher.start();
    }

    public void unSubscribe(String taskId) throws KDException {
        if (this.watcherMap.containsKey(taskId)) {
            WatchDataForever watcher = this.watcherMap.get(taskId);
            watcher.stop();
            String taskStatusPath = ZkConfig.getTaskStatusPath(taskId);
            List<String> watcherList = this.zkStore.getChildren(taskStatusPath);
            if (!watcherList.isEmpty()) {
                this.zkStore.delete(taskStatusPath + "/" + watcherList.get(0));
            }
            if ((watcherList = this.zkStore.getChildren(taskStatusPath)) == null || watcherList.isEmpty()) {
                String msgStr = this.zkStore.read(taskStatusPath, null);
                this.zkStore.delete(taskStatusPath);
                log.info("\u6210\u529f\u5220\u9664\u4efb\u52a1\u72b6\u6001\u8282\u70b9" + taskStatusPath);
                MessageInfo msg = (MessageInfo)JSON.parseObject((String)msgStr, MessageInfo.class);
                String jobPath = ZkConfig.getJobPath(msg);
                this.zkStore.delete(jobPath);
                log.info("\u6210\u529f\u5220\u9664Job\u8282\u70b9" + jobPath);
            }
            this.watcherMap.remove(taskId);
        }
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

