/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable.filter;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.next.observable.ExeMachineObservableInfo;
import kd.bos.schedule.next.observable.filter.AbstractObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.utils.ScheduleSortUtils;
import kd.bos.schedule.zk.ZkConfig;
import org.joda.time.DateTime;

public class ExecutorServerStatusFilter
extends AbstractObservableDataFilter {
    private static final Log logger = LogFactory.getLog(ExecutorServerStatusFilter.class);
    private static final String THREAD_TASK_SUCCESS = "threadTaskSuccess";
    private static final String THREAD_TASK_ERROR = "threadError";
    private DateTime hourTaskSuccessStartTime;
    private DateTime minPushQueueStartTime;
    private DateTime minPopQueueStartTime;
    private DateTime hourReceiveMessageStartTime;
    private Long receiveTimes = 0L;
    private Long receiveAllTime = 0L;
    private Map<MessageType, ThreadTaskSuccessFuncItem> threadTaskSuccessFuncMap;
    private Map<MessageType, ThreadSuccessOrThreadErrorOneHourItem> threadSuccessOrThreadErrorOneHour;

    public void handle(ObservableModel model) {
        try {
            switch (model.getClassfiy()) {
                case "taskSuccess": {
                    Object data = model.getData();
                    if (!(data instanceof MessageType)) break;
                    MessageType messageType = (MessageType)data;
                    if (messageType == MessageType.BIZJOB || messageType == MessageType.REALTIMEJOB || messageType == MessageType.WorkFlowJOB) {
                        this.countIncTaskSuccess();
                        this.countIncThreadDataTaskSuccessOneHour(messageType);
                    }
                    break;
                }
                case "pushLocalReadyQueue": {
                    this.countIncPushQueue();
                    break;
                }
                case "popLocalReadyQueue": {
                    this.countIncPopQueue();
                    break;
                }
                case "receiveMessage": {
                    this.mqFunctionCount(model.getData());
                    break;
                }
                case "receiveMessageError": {
                    this.mqFunctionCount(model.getData());
                }
                case "threadPoolError": {
                    this.countIncThreadDataTaskThreadErrorOneHour(model.getData());
                    break;
                }
                case "taskSuccessTime": {
                    this.countIncThreadTaskSuccessFuncOneHour(model.getData());
                }
            }
        }
        catch (Throwable t) {
            logger.error("ERROR schedule***ExecutorServerStatusFilter error", t);
        }
    }

    private void countIncThreadDataTaskThreadErrorOneHour(Object data) {
        MessageInfo messageInfo;
        MessageType messageType;
        if (data instanceof MessageInfo && ((messageType = (messageInfo = (MessageInfo)data).getMessageType()) == MessageType.BIZJOB || messageType == MessageType.REALTIMEJOB || messageType == MessageType.WorkFlowJOB)) {
            DateTime hourStartTime;
            boolean isSameHour;
            ThreadSuccessOrThreadErrorOneHourItem hourStartTimeMap;
            ExeMachineObservableInfo.ThreadPoolStatusItem threadPoolStatus = ExeMachineObservableInfo.getThreadPoolStatus().get(messageType);
            if (threadPoolStatus == null) {
                threadPoolStatus = new ExeMachineObservableInfo.ThreadPoolStatusItem();
                threadPoolStatus.setRunningNum(0);
                threadPoolStatus.setThreadError(new AtomicInteger(0));
                threadPoolStatus.setThreadTaskSuccess(new AtomicInteger(0));
                threadPoolStatus.setThreadTaskSuccessFunc(0L);
                threadPoolStatus.setMaxNum(ZkConfig.getMaxNumOfWorkThread(messageType));
                ExeMachineObservableInfo.getThreadPoolStatus().put(messageType, threadPoolStatus);
            }
            if ((hourStartTimeMap = this.threadSuccessOrThreadErrorOneHour.get(messageType)) == null) {
                hourStartTimeMap = new ThreadSuccessOrThreadErrorOneHourItem();
                hourStartTimeMap.setThreadTaskSuccessTime(DateTime.now());
                hourStartTimeMap.setThreadTaskErrorTime(DateTime.now());
            }
            if (isSameHour = ScheduleSortUtils.isSameHour(hourStartTime = hourStartTimeMap.getThreadTaskErrorTime())) {
                AtomicInteger threadDataCount = threadPoolStatus.getThreadError();
                threadDataCount.incrementAndGet();
                threadPoolStatus.setThreadError(threadDataCount);
            } else {
                threadPoolStatus.setThreadError(new AtomicInteger(1));
                hourStartTimeMap.setThreadTaskErrorTime(DateTime.now());
                this.threadSuccessOrThreadErrorOneHour.put(messageType, hourStartTimeMap);
                logger.info("Schedule***executor thread messageType = {},countType = {}, reset,time = {}", new Object[]{messageType, THREAD_TASK_ERROR, DateTime.now()});
            }
        }
    }

    private void countIncThreadDataTaskSuccessOneHour(MessageType messageType) {
        DateTime hourStartTime;
        boolean isSameHour;
        ThreadSuccessOrThreadErrorOneHourItem hourStartTimeMap;
        ExeMachineObservableInfo.ThreadPoolStatusItem threadPoolStatus = ExeMachineObservableInfo.getThreadPoolStatus().get(messageType);
        if (threadPoolStatus == null) {
            threadPoolStatus = new ExeMachineObservableInfo.ThreadPoolStatusItem();
            threadPoolStatus.setRunningNum(0);
            threadPoolStatus.setThreadError(new AtomicInteger(0));
            threadPoolStatus.setThreadTaskSuccess(new AtomicInteger(0));
            threadPoolStatus.setThreadTaskSuccessFunc(0L);
            threadPoolStatus.setMaxNum(ZkConfig.getMaxNumOfWorkThread(messageType));
            ExeMachineObservableInfo.getThreadPoolStatus().put(messageType, threadPoolStatus);
        }
        if ((hourStartTimeMap = this.threadSuccessOrThreadErrorOneHour.get(messageType)) == null) {
            hourStartTimeMap = new ThreadSuccessOrThreadErrorOneHourItem();
            hourStartTimeMap.setThreadTaskSuccessTime(DateTime.now());
            hourStartTimeMap.setThreadTaskErrorTime(DateTime.now());
        }
        if (isSameHour = ScheduleSortUtils.isSameHour(hourStartTime = hourStartTimeMap.getThreadTaskSuccessTime())) {
            AtomicInteger threadDataCount = threadPoolStatus.getThreadTaskSuccess();
            threadDataCount.incrementAndGet();
            threadPoolStatus.setThreadTaskSuccess(threadDataCount);
        } else {
            threadPoolStatus.setThreadTaskSuccess(new AtomicInteger(1));
            hourStartTimeMap.setThreadTaskSuccessTime(DateTime.now());
            this.threadSuccessOrThreadErrorOneHour.put(messageType, hourStartTimeMap);
            logger.info("Schedule***executor thread messageType = {},countType = {}, reset,time = {}", new Object[]{messageType, THREAD_TASK_SUCCESS, DateTime.now()});
        }
    }

    private void countIncThreadTaskSuccessFuncOneHour(Object data) {
        if (data instanceof Map) {
            Map taskSuccessMap = (Map)data;
            MessageType messageType = (MessageType)taskSuccessMap.get("messageType");
            Long taskSuccessTime = (Long)taskSuccessMap.get("time");
            if (messageType == MessageType.BIZJOB || messageType == MessageType.REALTIMEJOB || messageType == MessageType.WorkFlowJOB) {
                ThreadTaskSuccessFuncItem typeThreadTaskSuccessTime = this.threadTaskSuccessFuncMap.get(messageType);
                if (typeThreadTaskSuccessTime == null) {
                    typeThreadTaskSuccessTime = new ThreadTaskSuccessFuncItem();
                    typeThreadTaskSuccessTime.setStartTime(DateTime.now());
                    typeThreadTaskSuccessTime.setAllTime(new AtomicLong(0L));
                    typeThreadTaskSuccessTime.setCount(new AtomicInteger(0));
                    this.threadTaskSuccessFuncMap.put(messageType, typeThreadTaskSuccessTime);
                }
                DateTime typeThreadTSTStartTime = typeThreadTaskSuccessTime.getStartTime();
                ExeMachineObservableInfo.ThreadPoolStatusItem threadPoolStatus = ExeMachineObservableInfo.getThreadPoolStatus().get(messageType);
                if (threadPoolStatus == null) {
                    threadPoolStatus = new ExeMachineObservableInfo.ThreadPoolStatusItem();
                    threadPoolStatus.setMaxNum(ZkConfig.getMaxNumOfWorkThread(messageType));
                    threadPoolStatus.setRunningNum(0);
                    threadPoolStatus.setThreadError(new AtomicInteger(0));
                    threadPoolStatus.setThreadTaskSuccess(new AtomicInteger(0));
                    threadPoolStatus.setThreadTaskSuccessFunc(0L);
                    ExeMachineObservableInfo.getThreadPoolStatus().put(messageType, threadPoolStatus);
                }
                if (ScheduleSortUtils.isSameHour(typeThreadTSTStartTime)) {
                    AtomicLong typeThreadTSTAllTime = typeThreadTaskSuccessTime.getAllTime();
                    AtomicInteger typeThreadTSTCount = typeThreadTaskSuccessTime.getCount();
                    typeThreadTSTAllTime.getAndAdd(taskSuccessTime);
                    typeThreadTSTCount.incrementAndGet();
                    long threadTaskSuccessFunc = typeThreadTSTAllTime.get() / (long)typeThreadTSTCount.get();
                    threadPoolStatus.setThreadTaskSuccessFunc(threadTaskSuccessFunc);
                    ExeMachineObservableInfo.getThreadPoolStatus().put(messageType, threadPoolStatus);
                    typeThreadTaskSuccessTime.setAllTime(typeThreadTSTAllTime);
                    typeThreadTaskSuccessTime.setCount(typeThreadTSTCount);
                } else {
                    threadPoolStatus.setThreadTaskSuccessFunc(0L);
                    typeThreadTaskSuccessTime.setAllTime(new AtomicLong(0L));
                    typeThreadTaskSuccessTime.setCount(new AtomicInteger(0));
                    typeThreadTaskSuccessTime.setStartTime(DateTime.now());
                    logger.info("Schedule***executor threadTaskSuccessFunc, messageType = {}, reset, time = {}", (Object)messageType.name(), (Object)DateTime.now());
                }
            }
        }
    }

    private void mqFunctionCount(Object data) {
        if (data instanceof Map) {
            Map observableData = (Map)data;
            Long receiveMessageTime = (Long)observableData.get("receiveMessageTime");
            if (ScheduleSortUtils.isSameHour(this.hourReceiveMessageStartTime)) {
                this.receiveAllTime = this.receiveAllTime + receiveMessageTime;
                Long l = this.receiveTimes;
                Long l2 = this.receiveTimes = Long.valueOf(this.receiveTimes + 1L);
                long mqFunction = this.receiveAllTime / this.receiveTimes;
                ExeMachineObservableInfo.mqFunction = new AtomicLong((long)Math.floor(mqFunction));
            } else {
                this.receiveAllTime = 0L;
                this.receiveTimes = 0L;
                this.hourReceiveMessageStartTime = DateTime.now();
                ExeMachineObservableInfo.mqFunction = new AtomicLong(0L);
                logger.info("Schedule***executor mqFunctionCount reset,time = {}", (Object)this.hourReceiveMessageStartTime);
            }
        }
    }

    private void countIncTaskSuccess() {
        if (ScheduleSortUtils.isSameHour(this.hourTaskSuccessStartTime)) {
            ExeMachineObservableInfo.throughPutOneHour.incrementAndGet();
        } else {
            ExeMachineObservableInfo.throughPutOneHour = new AtomicLong(1L);
            this.hourTaskSuccessStartTime = DateTime.now();
            logger.info("Schedule***executor taskSuccessCount reset,time = {}", (Object)this.hourTaskSuccessStartTime);
        }
    }

    private void countIncPushQueue() {
        if (ScheduleSortUtils.isSameMinute(this.minPushQueueStartTime)) {
            ExeMachineObservableInfo.inQueueOneMin.incrementAndGet();
        } else {
            ExeMachineObservableInfo.inQueueOneMin = new AtomicLong(1L);
            this.minPushQueueStartTime = DateTime.now();
        }
    }

    private void countIncPopQueue() {
        if (ScheduleSortUtils.isSameMinute(this.minPopQueueStartTime)) {
            ExeMachineObservableInfo.outQueueOneMin.incrementAndGet();
        } else {
            ExeMachineObservableInfo.outQueueOneMin = new AtomicLong(1L);
            this.minPopQueueStartTime = DateTime.now();
        }
    }

    @Override
    public void handle(Object data) {
    }

    public void init() {
        try {
            this.hourTaskSuccessStartTime = DateTime.now();
            this.minPopQueueStartTime = DateTime.now();
            this.minPushQueueStartTime = DateTime.now();
            this.hourReceiveMessageStartTime = DateTime.now();
            List<MessageType> accessJobMsgType = ZkConfig.getAccessJobMsgType();
            this.threadTaskSuccessFuncMap = new HashMap<MessageType, ThreadTaskSuccessFuncItem>(accessJobMsgType.size());
            this.threadSuccessOrThreadErrorOneHour = new HashMap<MessageType, ThreadSuccessOrThreadErrorOneHourItem>(accessJobMsgType.size());
            for (MessageType messageType : accessJobMsgType) {
                ThreadTaskSuccessFuncItem threadTaskSuccessFuncItem = new ThreadTaskSuccessFuncItem();
                threadTaskSuccessFuncItem.setStartTime(DateTime.now());
                threadTaskSuccessFuncItem.setAllTime(new AtomicLong(0L));
                threadTaskSuccessFuncItem.setCount(new AtomicInteger(0));
                this.threadTaskSuccessFuncMap.put(messageType, threadTaskSuccessFuncItem);
                ThreadSuccessOrThreadErrorOneHourItem threadSuccessOrThreadErrorOneHourItem = new ThreadSuccessOrThreadErrorOneHourItem();
                threadSuccessOrThreadErrorOneHourItem.setThreadTaskSuccessTime(DateTime.now());
                threadSuccessOrThreadErrorOneHourItem.setThreadTaskErrorTime(DateTime.now());
                this.threadSuccessOrThreadErrorOneHour.put(messageType, threadSuccessOrThreadErrorOneHourItem);
            }
            ExeMachineObservableInfo.instanceId = Instance.getInstanceId();
            logger.info("Schedule***ExecutorServerStatusFilter init success");
        }
        catch (Throwable t) {
            logger.error("Schedule***ExecutorServerStatusFilter init error", t);
        }
    }

    @Override
    void submitData() {
        try {
            Map<MessageType, ExeMachineObservableInfo.ThreadPoolStatusItem> threadPoolStatus = ExeMachineObservableInfo.getThreadPoolStatus();
            Set<MessageType> messageTypes = threadPoolStatus.keySet();
            if (!CollectionUtils.isEmpty(messageTypes)) {
                for (MessageType messageType : messageTypes) {
                    this.checkThreadPoolErrorCount(messageType);
                    this.checkThreadPoolSuccessCount(messageType);
                    this.checkThreadPoolTaskTime(messageType);
                }
            }
            this.checkLocalData();
        }
        catch (Throwable t) {
            logger.error("Schedule***checkLocalData error!", t);
        }
        logger.debug("Schedule***exeMachineReportTime = {}", (Object)DateTime.now());
    }

    private void checkThreadPoolSuccessCount(MessageType messageType) {
        DateTime hourStartTime;
        boolean isSameHour;
        ExeMachineObservableInfo.ThreadPoolStatusItem threadPoolStatus = ExeMachineObservableInfo.getThreadPoolStatus().get(messageType);
        ThreadSuccessOrThreadErrorOneHourItem hourStartTimeMap = this.threadSuccessOrThreadErrorOneHour.get(messageType);
        if (hourStartTimeMap != null && !(isSameHour = ScheduleSortUtils.isSameHour(hourStartTime = hourStartTimeMap.getThreadTaskSuccessTime()))) {
            threadPoolStatus.setThreadTaskSuccess(new AtomicInteger(0));
            hourStartTimeMap.setThreadTaskSuccessTime(DateTime.now());
            this.threadSuccessOrThreadErrorOneHour.put(messageType, hourStartTimeMap);
            logger.debug("Schedule***executor thread messageType = {},countType = {}, reset,time = {}", new Object[]{messageType.name(), THREAD_TASK_SUCCESS, DateTime.now()});
        }
    }

    private void checkThreadPoolErrorCount(MessageType messageType) {
        DateTime hourStartTime;
        boolean isSameHour;
        ExeMachineObservableInfo.ThreadPoolStatusItem threadPoolStatus = ExeMachineObservableInfo.getThreadPoolStatus().get(messageType);
        ThreadSuccessOrThreadErrorOneHourItem hourStartTimeMap = this.threadSuccessOrThreadErrorOneHour.get(messageType);
        if (hourStartTimeMap != null && !(isSameHour = ScheduleSortUtils.isSameHour(hourStartTime = hourStartTimeMap.getThreadTaskErrorTime()))) {
            threadPoolStatus.setThreadError(new AtomicInteger(0));
            hourStartTimeMap.setThreadTaskErrorTime(DateTime.now());
            this.threadSuccessOrThreadErrorOneHour.put(messageType, hourStartTimeMap);
            logger.debug("Schedule***executor thread messageType = {},countType = {}, reset,time = {}", new Object[]{messageType.name(), THREAD_TASK_ERROR, DateTime.now()});
        }
    }

    private void checkThreadPoolTaskTime(MessageType messageType) {
        DateTime typeThreadTSTStartTime;
        ThreadTaskSuccessFuncItem typeThreadTaskSuccessTime = this.threadTaskSuccessFuncMap.get(messageType);
        if (typeThreadTaskSuccessTime != null && !ScheduleSortUtils.isSameHour(typeThreadTSTStartTime = typeThreadTaskSuccessTime.getStartTime())) {
            ExeMachineObservableInfo.ThreadPoolStatusItem threadPoolStatus = ExeMachineObservableInfo.getThreadPoolStatus().get(messageType);
            threadPoolStatus.setThreadTaskSuccessFunc(0L);
            typeThreadTaskSuccessTime.setAllTime(new AtomicLong(0L));
            typeThreadTaskSuccessTime.setCount(new AtomicInteger(0));
            typeThreadTaskSuccessTime.setStartTime(DateTime.now());
            logger.debug("Schedule***executor threadTaskSuccessFunc, messageType = {}, reset, time = {}", (Object)messageType.name(), (Object)DateTime.now());
        }
    }

    private void checkLocalData() {
        if (!ScheduleSortUtils.isSameHour(this.hourTaskSuccessStartTime)) {
            ExeMachineObservableInfo.throughPutOneHour = new AtomicLong(0L);
            this.hourTaskSuccessStartTime = DateTime.now();
            logger.info("Schedule***executor taskSuccessCount reset,time = {}", (Object)this.hourTaskSuccessStartTime);
        }
        if (!ScheduleSortUtils.isSameMinute(this.minPushQueueStartTime)) {
            ExeMachineObservableInfo.inQueueOneMin = new AtomicLong(0L);
            this.minPushQueueStartTime = DateTime.now();
        }
        if (!ScheduleSortUtils.isSameMinute(this.minPopQueueStartTime)) {
            ExeMachineObservableInfo.outQueueOneMin = new AtomicLong(0L);
            this.minPopQueueStartTime = DateTime.now();
        }
        if (!ScheduleSortUtils.isSameHour(this.hourReceiveMessageStartTime)) {
            ExeMachineObservableInfo.mqFunction = new AtomicLong(0L);
            this.hourReceiveMessageStartTime = DateTime.now();
            logger.info("Schedule***executor mqFunctionCount reset,time = {}", (Object)this.hourReceiveMessageStartTime);
        }
    }

    public static JSONObject getExecutorServerStatus(String ip) {
        String serverStatusContent = ExeMachineObservableInfo.buildStatusJson();
        return (JSONObject)SerializationUtils.fromJsonString((String)serverStatusContent, JSONObject.class);
    }

    @Deprecated
    public static Map<String, JSONObject> getExecutorServerStatus() {
        return Collections.EMPTY_MAP;
    }

    private static class ThreadSuccessOrThreadErrorOneHourItem {
        private DateTime threadTaskSuccessTime;
        private DateTime threadTaskErrorTime;

        private ThreadSuccessOrThreadErrorOneHourItem() {
        }

        public DateTime getThreadTaskSuccessTime() {
            return this.threadTaskSuccessTime;
        }

        public void setThreadTaskSuccessTime(DateTime threadTaskSuccessTime) {
            this.threadTaskSuccessTime = threadTaskSuccessTime;
        }

        public DateTime getThreadTaskErrorTime() {
            return this.threadTaskErrorTime;
        }

        public void setThreadTaskErrorTime(DateTime threadTaskErrorTime) {
            this.threadTaskErrorTime = threadTaskErrorTime;
        }
    }

    private static class ThreadTaskSuccessFuncItem {
        private DateTime startTime;
        private AtomicLong allTime;
        private AtomicInteger count;

        private ThreadTaskSuccessFuncItem() {
        }

        public DateTime getStartTime() {
            return this.startTime;
        }

        public void setStartTime(DateTime startTime) {
            this.startTime = startTime;
        }

        public AtomicLong getAllTime() {
            return this.allTime;
        }

        public void setAllTime(AtomicLong allTime) {
            this.allTime = allTime;
        }

        public AtomicInteger getCount() {
            return this.count;
        }

        public void setCount(AtomicInteger count) {
            this.count = count;
        }
    }
}

