/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.redis;

import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.redis.RedisConfig;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;

public class RedisStore
implements ActiveKeyValueStore {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.redis.ActiveKeyValueStore");
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private ConcurrentHashMap<String, ConcurrentHashMap<ExecutorServerInfo, Integer>> appIdExeServerMap = new ConcurrentHashMap();
    private TreeMap<String, Integer> exeServerMap = new TreeMap();
    private static final DistributeSessionlessCache serverRedisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("Schedule.redis.server", new DistributeCacheHAPolicy(true, true));

    public static RedisStore create() {
        return new RedisStore();
    }

    @Override
    public CuratorFramework getCuratorFramework() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureExisted(String path, String value) {
        if (log.isDebugEnabled()) {
            log.debug("ensureExisted RedisConfig host:{}, patch:{} ", (Object)RedisConfig.getHosts(), (Object)path);
        }
        try {
            Object v = serverRedisCache.get(path);
            if (v == null) {
                this.setData(path, value);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "ensureExisted path:%s -value:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value});
        }
    }

    @Override
    public void setData(String path, String value) {
        try {
            serverRedisCache.put(path, value.getBytes(CHARSET));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "setData path:%s -value:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value});
        }
    }

    @Override
    public void write(String path, String value) {
        this.setData(path, value);
    }

    @Override
    public String create(String path, String value, Object createMode) {
        try {
            this.setData(path, value);
            return value;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "create path:%s -value:%s -createMode:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value});
        }
    }

    @Override
    public String create(String path, Object createMode) {
        return null;
    }

    @Override
    public void write(String path, String value, Object createMode) {
        this.setData(path, value);
    }

    @Override
    public String read(String path, Object watcher) {
        byte[] data = this.readByte(path, null);
        if (data != null) {
            return new String(data, CHARSET);
        }
        return null;
    }

    @Override
    public byte[] readByte(String path, Object watcher) {
        if (this.exists(path).booleanValue()) {
            return serverRedisCache.getByteValue(path);
        }
        return null;
    }

    @Override
    public void delete(String path) {
        try {
            if (this.exists(path).booleanValue()) {
                serverRedisCache.remove(path);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "delete path:%s ");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public List<String> getChildren(String path) {
        return this.getChildren(path, null);
    }

    @Override
    public List<String> getChildren(String path, Object watcher) {
        try {
            Map map = serverRedisCache.hgetAll(path);
            Iterator iterator = map.keySet().iterator();
            ArrayList<String> result = new ArrayList<String>();
            while (iterator.hasNext()) {
                byte[] data = (byte[])iterator.next();
                if (data == null) continue;
                String v = new String(data, CHARSET);
                result.add(v);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "getChildren path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public byte[] getData(String path, Object watcher, Object stat) {
        try {
            return this.readByte(path, null);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "getData path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public Boolean exists(String path) {
        return this.exists(path, null);
    }

    @Override
    public Boolean exists(String path, Object watcher) {
        try {
            return serverRedisCache.contains(path);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "exists path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public void initAppIdExeServerMap() {
        List<ExecutorServerInfo> serverInfoList = this.queryExecutorServerStatus();
        if (CollectionUtils.isEmpty(serverInfoList)) {
            log.info("executorServer is empty");
            return;
        }
        for (ExecutorServerInfo executorServerInfo : serverInfoList) {
            Set appIds = executorServerInfo.getAppIds();
            for (String appId : appIds) {
                ConcurrentHashMap<Object, Object> executorServerIndex;
                if (this.appIdExeServerMap.containsKey(appId)) {
                    executorServerIndex = this.appIdExeServerMap.get(appId);
                    executorServerIndex.put(executorServerInfo, executorServerIndex.size() + 1);
                    continue;
                }
                executorServerIndex = new ConcurrentHashMap<ExecutorServerInfo, Integer>();
                executorServerIndex.put(executorServerInfo, 0);
                this.appIdExeServerMap.put(appId, executorServerIndex);
            }
        }
        log.info("appId and executorServer: " + JSON.toJSONString(this.appIdExeServerMap));
    }

    @Override
    public void initAppIdExeServerMap(String appId) {
        boolean exists;
        List<ExecutorServerInfo> serverInfoList = this.queryExecutorServerStatus();
        if (CollectionUtils.isEmpty(serverInfoList)) {
            log.info("executorServer is empty");
            return;
        }
        boolean isMasterHost = false;
        String masterHost = "";
        if ("MQ".equalsIgnoreCase(RedisConfig.getMessageMode()) && (exists = this.exists(RedisConfig.getMasterServerPath()).booleanValue())) {
            masterHost = this.read(RedisConfig.getMasterServerPath(), null);
        }
        int index = 0;
        if (serverInfoList != null) {
            for (int i = 0; i < serverInfoList.size(); ++i) {
                ExecutorServerInfo executorServerInfo = serverInfoList.get(i);
                Set appIds = executorServerInfo.getAppIds();
                boolean bl = isMasterHost = StringUtils.isBlank((CharSequence)masterHost) ? false : masterHost.equals(executorServerInfo.getName());
                if (!appIds.contains(appId) || isMasterHost) continue;
                this.exeServerMap.put(executorServerInfo.getName(), index);
                ++index;
            }
        }
        log.info("appId and executorServer: " + appId + "-" + JSON.toJSONString(this.exeServerMap));
    }

    @Override
    public void publishBroadcastMsg(String path, String data) {
        this.write(path, data);
    }

    private List<ExecutorServerInfo> queryExecutorServerStatus() {
        Map<String, String> exeServerList = this.getChildrenData(RedisConfig.getExecutorServerPath(), null);
        if (exeServerList == null || exeServerList.isEmpty()) {
            return null;
        }
        ArrayList<ExecutorServerInfo> serverInfoList = new ArrayList<ExecutorServerInfo>();
        for (Map.Entry<String, String> exeServerNode : exeServerList.entrySet()) {
            String dataStr = exeServerNode.getValue();
            ExecutorServerInfo serverInfo = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)dataStr, ExecutorServerInfo.class);
            if (serverInfo == null) continue;
            serverInfoList.add(serverInfo);
        }
        return serverInfoList;
    }

    @Override
    public ConcurrentHashMap<String, ConcurrentHashMap<ExecutorServerInfo, Integer>> getAppIdExeServerMap() {
        return this.appIdExeServerMap;
    }

    @Override
    public TreeMap<String, Integer> getExeServerMap() {
        return this.exeServerMap;
    }

    @Override
    public void writeChildren(String path, String childKey, String value, Object createMode) {
        try {
            serverRedisCache.hset(path, childKey.getBytes(CHARSET), value.getBytes(CHARSET));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "writeChildren path:%s -childKey:%s -value:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, childKey, value});
        }
    }

    @Override
    public Map<String, String> getChildrenData(String path, Object watcher) {
        try {
            Map map = serverRedisCache.hgetAll(path);
            Iterator iterator = map.entrySet().iterator();
            HashMap<String, String> result = new HashMap<String, String>();
            while (iterator.hasNext()) {
                Map.Entry data = iterator.next();
                if (data.getValue() == null) continue;
                String k = new String((byte[])data.getKey(), CHARSET);
                String v = new String((byte[])data.getValue(), CHARSET);
                result.put(k, v);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "getChildren path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public void deleteChildren(String path, String childKey) {
        try {
            serverRedisCache.remove(path, childKey);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_REDIS_FAILED", "getChildren path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }
}

