/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorNodeInfo;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;

@Deprecated
public class ExecutorServerStatistic {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.server.ExecutorServerStatistic");
    private String id = null;
    private String name = null;
    private long startTime = 0L;
    private long lastUpdateTime = 0L;
    private boolean isStarted = true;
    private AtomicInteger numOfScheduledInt = new AtomicInteger(0);
    private AtomicInteger numOfRunningInt = new AtomicInteger(0);
    private AtomicInteger numOfCompletedInt = new AtomicInteger(0);
    private AtomicInteger numOfAbortedInt = new AtomicInteger(0);
    private AtomicInteger numOfFailedInt = new AtomicInteger(0);
    private Map<String, String> detail = new HashMap<String, String>();
    private Map<String, ExecutionCount> allAccountInfo = new ConcurrentHashMap<String, ExecutionCount>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean started) {
        this.isStarted = started;
    }

    public int getFailed() {
        return this.numOfFailedInt.get();
    }

    public void setFailed(int val) {
        this.updateLastTime();
        this.numOfFailedInt.set(val);
        this.getCountByAccount().getNumOfFailedInt().set(val);
    }

    public int incrFailed() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfFailedInt().incrementAndGet();
        return this.numOfFailedInt.incrementAndGet();
    }

    public int decrFailed() {
        this.updateLastTime();
        this.getCountByAccount().numOfFailedInt.decrementAndGet();
        return this.numOfFailedInt.decrementAndGet();
    }

    public int getScheduled() {
        return this.numOfScheduledInt.get();
    }

    public void setScheduled(int val) {
        this.updateLastTime();
        this.numOfScheduledInt.set(val);
        this.getCountByAccount().getNumOfScheduledInt().set(val);
    }

    public int incrScheduled() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfScheduledInt().incrementAndGet();
        return this.numOfScheduledInt.incrementAndGet();
    }

    public int decrScheduled() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfScheduledInt().decrementAndGet();
        return this.numOfScheduledInt.decrementAndGet();
    }

    public int getRunning() {
        return this.numOfRunningInt.get();
    }

    public void setRunning(int val) {
        this.updateLastTime();
        this.getCountByAccount().getNumOfRunningInt().set(val);
        this.numOfRunningInt.set(val);
    }

    public int incrRunning() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfRunningInt().incrementAndGet();
        return this.numOfRunningInt.incrementAndGet();
    }

    public int decrRunning() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfRunningInt().decrementAndGet();
        return this.numOfRunningInt.decrementAndGet();
    }

    public int getCompleted() {
        return this.numOfCompletedInt.get();
    }

    public void setCompleted(int val) {
        this.updateLastTime();
        this.numOfCompletedInt.set(val);
        this.getCountByAccount().getNumOfCompletedInt().set(val);
    }

    public int incrCompleted() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfCompletedInt().incrementAndGet();
        return this.numOfCompletedInt.incrementAndGet();
    }

    public int decrCompleted() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfCompletedInt().decrementAndGet();
        return this.numOfCompletedInt.decrementAndGet();
    }

    public int getAborted() {
        return this.numOfAbortedInt.get();
    }

    public void setAborted(int val) {
        this.updateLastTime();
        this.numOfAbortedInt.set(val);
        this.getCountByAccount().getNumOfAbortedInt().set(val);
    }

    public int incrAborted() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfAbortedInt().incrementAndGet();
        return this.numOfAbortedInt.incrementAndGet();
    }

    public int decrAborted() {
        this.updateLastTime();
        this.getCountByAccount().getNumOfAbortedInt().decrementAndGet();
        return this.numOfAbortedInt.decrementAndGet();
    }

    private void updateLastTime() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public ExecutorServerInfo toExecutorServerInfo() {
        ExecutorServerInfo info = new ExecutorServerInfo();
        info.setId(this.id);
        info.setName(this.name);
        info.setStartTime(this.startTime);
        info.setLastUpdateTime(this.lastUpdateTime);
        info.setScheduled(this.getScheduled());
        info.setRunning(this.getRunning());
        info.setAborted(this.getAborted());
        info.setCompleted(this.getCompleted());
        info.setFailed(this.getFailed());
        String[] appIds = Instance.getAppIds();
        if (appIds != null) {
            info.setAppIds(new HashSet<String>(Arrays.asList(appIds)));
        }
        ArrayList<ExecutorNodeInfo> list = new ArrayList<ExecutorNodeInfo>(this.allAccountInfo.size());
        for (Map.Entry<String, ExecutionCount> row : this.allAccountInfo.entrySet()) {
            ExecutorNodeInfo nodeInfo = new ExecutorNodeInfo();
            nodeInfo.setScheduledTaskNum(row.getValue().getNumOfScheduledInt().get());
            nodeInfo.setRunningTaskNum(row.getValue().getNumOfRunningInt().get());
            nodeInfo.setCompletedTaskNum(row.getValue().getNumOfCompletedInt().get());
            nodeInfo.setFailedTaskNum(row.getValue().getNumOfFailedInt().get());
            nodeInfo.setAccountId(row.getValue().getAccountId());
            nodeInfo.setTenantId(row.getValue().getTenantId());
            list.add(nodeInfo);
        }
        info.setNodeInfo(list);
        info.setDetail(this.getDetail());
        info.setStarted(this.isStarted());
        return info;
    }

    public Map<String, String> getDetail() {
        return this.detail;
    }

    public void setDetail(Map<String, String> detail) {
        this.detail = detail;
    }

    private ActiveKeyValueStore getZkStore() {
        return ActiveKeyValueStore.create();
    }

    public boolean writeZk() {
        String path;
        ActiveKeyValueStore zkStore = this.getZkStore();
        if (zkStore.exists(path = ZkConfig.getExecutorServerPath() + "/" + this.name) != null) {
            String data = SerializationUtils.toJsonString((Object)this.toExecutorServerInfo());
            log.debug("executor server statics data: " + data);
            this.getZkStore().setData(path, data);
            return true;
        }
        return false;
    }

    public boolean writeZkExeJoin() {
        String path;
        ActiveKeyValueStore zkStore = this.getZkStore();
        if (zkStore.exists(path = ZkConfig.getExecutorServerPath() + "/" + this.name) != null) {
            ExecutorServerInfo executorServerInfo = this.toExecutorServerInfo();
            String exeServerInfoStr = zkStore.read(path, null);
            if (StringUtils.isNotBlank((CharSequence)exeServerInfoStr)) {
                ExecutorServerInfo exeServerInfo = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)exeServerInfoStr, ExecutorServerInfo.class);
                executorServerInfo.setDetail(exeServerInfo.getDetail());
                executorServerInfo.setAppIds(exeServerInfo.getAppIds());
            }
            String data = SerializationUtils.toJsonString((Object)executorServerInfo);
            log.debug("executor server statics data when join: " + data);
            this.getZkStore().setData(path, data);
            return true;
        }
        return false;
    }

    private ExecutionCount getCountByAccount() {
        ExecutionCount count;
        RequestContext rs = RequestContext.get();
        if (rs == null) {
            return new ExecutionCount();
        }
        String accountId = rs.getAccountId();
        ExecutionCount obj = this.allAccountInfo.putIfAbsent(accountId, count = new ExecutionCount(accountId, rs.getTenantId()));
        if (obj == null) {
            obj = count;
        }
        return obj;
    }

    public static ExecutorServerStatistic fromServerInfo(ExecutorServerInfo serverInfo) {
        ExecutorServerStatistic serverStatistic = new ExecutorServerStatistic();
        serverStatistic.setDetail(serverInfo.getDetail());
        serverStatistic.setName(serverInfo.getName());
        serverStatistic.setId(serverInfo.getId());
        serverStatistic.setStarted(serverInfo.isStarted());
        serverStatistic.setAborted(serverInfo.getAborted());
        serverStatistic.setCompleted(serverInfo.getCompleted());
        serverStatistic.setFailed(serverInfo.getFailed());
        serverStatistic.setStartTime(serverInfo.getStartTime());
        serverStatistic.setRunning(serverInfo.getRunning());
        serverStatistic.setScheduled(serverInfo.getScheduled());
        serverStatistic.setLastUpdateTime(serverInfo.getLastUpdateTime());
        return serverStatistic;
    }

    class ExecutionCount {
        private String accountId;
        private String tenantId;
        private AtomicInteger numOfScheduledInt = new AtomicInteger(0);
        private AtomicInteger numOfRunningInt = new AtomicInteger(0);
        private AtomicInteger numOfCompletedInt = new AtomicInteger(0);
        private AtomicInteger numOfAbortedInt = new AtomicInteger(0);
        private AtomicInteger numOfFailedInt = new AtomicInteger(0);

        public ExecutionCount() {
        }

        public ExecutionCount(String accountId, String tenantId) {
            this.accountId = accountId;
            this.tenantId = tenantId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public AtomicInteger getNumOfScheduledInt() {
            return this.numOfScheduledInt;
        }

        public void setNumOfScheduledInt(AtomicInteger numOfScheduledInt) {
            this.numOfScheduledInt = numOfScheduledInt;
        }

        public AtomicInteger getNumOfRunningInt() {
            return this.numOfRunningInt;
        }

        public void setNumOfRunningInt(AtomicInteger numOfRunningInt) {
            this.numOfRunningInt = numOfRunningInt;
        }

        public AtomicInteger getNumOfCompletedInt() {
            return this.numOfCompletedInt;
        }

        public void setNumOfCompletedInt(AtomicInteger numOfCompletedInt) {
            this.numOfCompletedInt = numOfCompletedInt;
        }

        public AtomicInteger getNumOfAbortedInt() {
            return this.numOfAbortedInt;
        }

        public void setNumOfAbortedInt(AtomicInteger numOfAbortedInt) {
            this.numOfAbortedInt = numOfAbortedInt;
        }

        public AtomicInteger getNumOfFailedInt() {
            return this.numOfFailedInt;
        }

        public void setNumOfFailedInt(AtomicInteger numOfFailedInt) {
            this.numOfFailedInt = numOfFailedInt;
        }
    }
}

