/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BOSRuntime;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.lookup.ServiceLookup;

public class AppUtils {
    private static final Log log = LogFactory.getLog(AppUtils.class);
    private static Map<String, String> appPkIdToAppId = new HashMap<String, String>();
    private static Set bampMoveAppList = new HashSet(10);

    private static void loadAll() {
        String strSQL = "select fid,fnumber,fbizcloudid from t_meta_bizapp";
        Map appInfo = (Map)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, null, rs -> {
            HashMap<String, String> tmpAppPkIdToAppId = new HashMap<String, String>(16);
            while (rs.next()) {
                String appPkId = rs.getString("fid");
                String appId = rs.getString("fnumber");
                String bizCloudId = rs.getString("fbizcloudid");
                if (AppUtils.isBOSCloud(bizCloudId)) {
                    appId = "bos";
                }
                tmpAppPkIdToAppId.put(appPkId, appId);
            }
            return tmpAppPkIdToAppId;
        });
        if (appInfo != null) {
            appPkIdToAppId = appInfo;
        }
    }

    public static String getAppIdByAppPkId(String pkId) {
        String appid;
        if (appPkIdToAppId.isEmpty()) {
            AppUtils.loadAll();
        }
        if (StringUtils.isBlank((CharSequence)(appid = appPkIdToAppId.get(pkId)))) {
            AppUtils.loadAll();
            appid = appPkIdToAppId.get(pkId);
            if (StringUtils.isBlank((CharSequence)appid)) {
                log.error("\u65e0\u6cd5\u83b7\u53d6\u5e94\u7528\u5185\u7801:" + pkId + " \u5bf9\u5e94\u7684\u5e94\u7528\u7f16\u7801\uff0c\u9ed8\u8ba4\u5176\u4e3abos!!!");
                appid = "bos";
            }
        }
        return appid;
    }

    public static boolean isBOSCloud(String cloudId) {
        return "83bfebc8000008ac".equals(cloudId) || "83bfebc800000bac".equals(cloudId) || "18Y30L1D2HS4".equals(cloudId);
    }

    public static boolean isBOSApp(String appId) {
        try {
            return AppUtils.isBAMPMoveApp(appId) || AppUtils.BOSRuntime_isBOSApp(appId);
        }
        catch (Exception e) {
            log.info("appId:" + appId + e.getMessage());
            return false;
        }
    }

    private static boolean BOSRuntime_isBOSApp(String appId) {
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appId);
        if (appInfo != null) {
            return BOSRuntime.isBOSCloud((String)appInfo.getCloudId());
        }
        return false;
    }

    public static String getRealRouteAppIdByAppId(String appId, MessageType messageType) {
        String realRouteAppId = "";
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            String[] leafAppIds = appId.split("\\.");
            for (int i = leafAppIds.length - 1; i >= 0; --i) {
                String leafAppId = AppUtils._getRealRouteAppIdByAppId(leafAppIds[i]);
                if (leafAppId == null) continue;
                realRouteAppId = leafAppId;
                break;
            }
            if (StringUtils.isBlank((CharSequence)realRouteAppId)) {
                boolean hasDeployedCustom = ServiceLookup.hasDeployedAppId((String)"custom");
                realRouteAppId = hasDeployedCustom ? "custom" : appId;
            }
        }
        return realRouteAppId;
    }

    private static String _getRealRouteAppIdByAppId(String appId) {
        String realRouteAppId = null;
        Set systemAppIds = ServiceLookup.getSystemAppIds();
        if (systemAppIds.contains(appId)) {
            realRouteAppId = appId;
        } else {
            boolean hasDeployedAppId = ServiceLookup.hasDeployedAppId((String)appId);
            if (hasDeployedAppId) {
                realRouteAppId = appId;
            }
        }
        return realRouteAppId;
    }

    private static String getRealRouteAppIdByAppDeploy(String appId, MessageType messageType) {
        String realRouteAppId = "";
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        realRouteAppId = ZkConfig.isRouteToCustom() ? serviceAppId : (messageType == MessageType.REALTIMEJOB ? serviceAppId : ("custom".equals(serviceAppId) && !appId.equalsIgnoreCase(serviceAppId) && !AppUtils.getRegistedAppids().contains("custom") ? appId : serviceAppId));
        if (log.isDebugEnabled() && !appId.equals(serviceAppId)) {
            log.debug("Schedule***getRealRouteAppIdByAppId,jobAppId:{},serviceAppId:{}", (Object)appId, (Object)serviceAppId);
        }
        return realRouteAppId;
    }

    private static Set<String> getRegistedAppids() {
        Set<String> appIdSet;
        String strAppIds = System.getProperty("registedAppIds");
        if (strAppIds != null) {
            String[] arrayAppids = strAppIds.split(",");
            appIdSet = new HashSet<String>(Arrays.asList(arrayAppids));
        } else {
            appIdSet = Collections.emptySet();
        }
        return appIdSet;
    }

    private static boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    static {
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

