/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.session.SessionManager;
import kd.bos.trace.util.TraceIdUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RequestContextUtils {
    private static final Log log = LogFactory.getLog(RequestContextUtils.class);
    private static final long DEFAULT_RUN_USERID = 100L;
    private static final Map<String, Date> localSessionMap = new HashMap<String, Date>(16);

    public static void createRequestContext(String tenantId, String accountId, String userId) {
        RequestContextCreator.createBatch((String)tenantId, (String)accountId, (String)userId);
    }

    public static void fillContext(MessageInfo messageInfo, RequestContext rc) {
        JobInfo jobInfo = messageInfo.fetchJobInfo();
        if (jobInfo.getJobType() == JobType.REALTIME && messageInfo.getRequestContext() == null && RequestContext.get() != null && jobInfo.getRunByUserId() == rc.getCurrUserId() && jobInfo.getRunByLang() == rc.getLang()) {
            rc = RequestContext.copy((RequestContext)rc);
            String userAgent = "Schedule";
            String client = "batch";
            rc.setUserAgent(userAgent);
            rc.setClient(client);
            messageInfo.setRequestContext(rc);
        }
    }

    public static void createRequestContext(MessageInfo message) {
        OperationContext oc = new OperationContext();
        oc.setAppId("bos");
        OperationContext.set((OperationContext)oc);
        String accountId = message.getAccountId();
        String tenantId = message.getTenantId();
        String userId = null;
        Lang lang = null;
        long orgId = 0L;
        JobInfo jobInfo = message.fetchJobInfo();
        if (jobInfo == null) {
            return;
        }
        RequestContext requestContext = message.getRequestContext();
        if (requestContext != null) {
            String traceId = TraceIdUtil.getCurrentTraceIdString();
            requestContext.setTraceId(traceId);
            RequestContext.copyAndSet((RequestContext)requestContext);
        } else {
            userId = jobInfo.getRunByUserId() == 0L ? String.valueOf(100L) : String.valueOf(jobInfo.getRunByUserId());
            lang = jobInfo.getRunByLang() == null ? Lang.defaultLang() : jobInfo.getRunByLang();
            orgId = jobInfo.getRunByOrgId();
            RequestContextCreator.createBatch((String)tenantId, (String)accountId, (String)userId, (long)orgId, (Lang)lang, (boolean)false);
            String userName = "";
            String userOpenId = "";
            try {
                ORM orm = ORM.create();
                String selectField = "id,name,useropenid";
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(userId))};
                DynamicObject user = orm.queryOne("bos_user", selectField, filters);
                if (user != null) {
                    String useropenid;
                    String name = user.getString("name");
                    if (name != null) {
                        userName = name;
                    }
                    if ((useropenid = user.getString("useropenid")) != null) {
                        userOpenId = useropenid;
                    }
                }
            }
            catch (Exception e) {
                log.error("\u540e\u53f0\u4efb\u52a1\u767b\u5f55\uff0c\u8bbe\u7f6e\u7528\u6237\u540d\u5f02\u5e38\uff1a" + e);
            }
            if (JobType.WORKFLOW == jobInfo.getJobType()) {
                RequestContext rc = RequestContext.get();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String localSessionId = tenantId + "_" + accountId + "_" + userId + "_" + orgId + "_" + lang;
                if (localSessionMap.get(localSessionId) == null || (new Date().getTime() - localSessionMap.get(localSessionId).getTime()) / 1000L > (long)(Integer.getInteger("schedule.session.timeout", 1800) - 60)) {
                    localSessionMap.put(localSessionId, new Date());
                    HashMap<String, String> sessionInfo = new HashMap<String, String>(16);
                    String client = "batch";
                    sessionInfo.put("accountId", accountId);
                    sessionInfo.put("tenantId", tenantId);
                    sessionInfo.put("userId", userId);
                    sessionInfo.put("loginTime", df.format(new Date()));
                    sessionInfo.put("loginIP", ZkConfig.getExecutorServerName());
                    sessionInfo.put("userName", userName);
                    sessionInfo.put("userOpenId", userOpenId);
                    sessionInfo.put("client", client);
                    rc.setGlobalSessionId(SessionManager.newSession(sessionInfo, (int)Integer.getInteger("schedule.session.timeout", 1800)));
                    RequestContext.copyAndSet((RequestContext)rc);
                }
            }
            RequestContext rs = RequestContext.get();
            rs.setUserName(userName);
            rs.setUserOpenId(userOpenId);
            RequestContext.copyAndSet((RequestContext)rs);
        }
    }
}

