/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.utils;

import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ScheduleSortUtils {
    public static void quickSort(String[] cycleTop, int left, int right, Map<String, Integer> cycleMap) {
        if (left < right) {
            int partitionIndex = ScheduleSortUtils.partition(cycleTop, left, right, cycleMap);
            ScheduleSortUtils.quickSort(cycleTop, left, partitionIndex - 1, cycleMap);
            ScheduleSortUtils.quickSort(cycleTop, partitionIndex + 1, right, cycleMap);
        }
    }

    public static void quickSort(String[] array, int left, int right) {
        if (left < right) {
            int partitionIndex = ScheduleSortUtils.partition(array, left, right);
            ScheduleSortUtils.quickSort(array, left, partitionIndex - 1);
            ScheduleSortUtils.quickSort(array, partitionIndex + 1, right);
        }
    }

    private static int partition(String[] array, int left, int right) {
        int index;
        int pivot = left;
        for (int j = index = pivot + 1; j <= right; ++j) {
            int arrayPivot;
            int arrayJ = Integer.parseInt(array[j]);
            if (arrayJ >= (arrayPivot = Integer.parseInt(array[pivot]))) continue;
            ScheduleSortUtils.swap(array, j, index);
            ++index;
        }
        ScheduleSortUtils.swap(array, pivot, index - 1);
        return index - 1;
    }

    private static int partition(String[] cycleTop, int left, int right, Map<String, Integer> cycleMap) {
        int index;
        int pivot = left;
        for (int j = index = pivot + 1; j <= right; ++j) {
            Integer scheduleSizeJ = cycleMap.get(cycleTop[j]);
            Integer scheduleSizePivot = cycleMap.get(cycleTop[pivot]);
            if (scheduleSizeJ <= scheduleSizePivot) continue;
            ScheduleSortUtils.swap(cycleTop, j, index);
            ++index;
        }
        ScheduleSortUtils.swap(cycleTop, pivot, index - 1);
        return index - 1;
    }

    private static void swap(String[] array, int i, int j) {
        String temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    public static boolean isSameMinute(DateTime startTime) {
        if (startTime == null) {
            return false;
        }
        DateTime now = DateTime.now();
        return startTime.getYear() == now.getYear() && startTime.getDayOfYear() == now.getDayOfYear() && startTime.getHourOfDay() == now.getHourOfDay() && startTime.getMinuteOfHour() == now.getMinuteOfHour();
    }

    public static boolean isSameHour(DateTime startTime) {
        if (startTime == null) {
            return false;
        }
        DateTime now = DateTime.now();
        return startTime.getYear() == now.getYear() && startTime.getDayOfYear() == now.getDayOfYear() && startTime.getHourOfDay() == now.getHourOfDay();
    }

    public static boolean isSameDay(DateTime startTime) {
        if (startTime == null) {
            return false;
        }
        DateTime now = DateTime.now();
        return startTime.getYear() == now.getYear() && startTime.getDayOfYear() == now.getDayOfYear();
    }

    public static boolean isAfterSomeMinutes(int i, DateTime startTime) {
        if (startTime == null) {
            return false;
        }
        DateTime now = DateTime.now();
        DateTime nowSomeMinutesBefore = now.minusMinutes(i);
        return nowSomeMinutesBefore.isAfter((ReadableInstant)startTime);
    }
}

