/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.server.SchLockInfo;
import kd.bos.schedule.zk.ZkConfig;

public class DBElectionHelper {
    private static final Log logger = LogFactory.getLog(DBElectionHelper.class);
    private static final DBRoute DB_Route = DBRoute.basedata;
    private static final Long TIMEOUT = (long)ZkConfig.getSelfCheck() * 2L;
    private static final String FUNLOCK_TIME = ":funlocktime";
    private static final String FUPFATE_TIME = ":fupdatetime";
    private static final String FTIMEOUT = ":ftimeout";
    private static final String FENABLE = ":fenable";

    private static void clearAllLockData() {
        String sql = "update T_SCH_LOCK set funlocktime=?,fenable=? ";
        Object[] params = new SqlParameter[]{new SqlParameter(FUNLOCK_TIME, 91, (Object)new Date()), new SqlParameter(FENABLE, 1, (Object)"0")};
        DB.execute((DBRoute)DB_Route, (String)sql, (Object[])params);
    }

    private static boolean insertLockData(String clusterName) {
        boolean locked = false;
        String fid = Long.toString(DB.genGlobalLongId());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("instanceid", Instance.getInstanceId());
        data.put("ip", ZkConfig.getHostIpAddress());
        String fdata = SerializationUtils.toJsonString(data);
        String sql = "insert into T_SCH_LOCK (fid, fclustername, flocktime, fupdatetime, ftimeout, fdata, fenable) values (?, ?, ?, ?, ?, ?, '1')";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)fid), new SqlParameter(":fclustername", 12, (Object)clusterName), new SqlParameter(":flocktime", 91, (Object)new Date()), new SqlParameter(FUPFATE_TIME, 91, (Object)new Date()), new SqlParameter(FTIMEOUT, 4, (Object)TIMEOUT.intValue()), new SqlParameter(":fdata", 12, (Object)fdata)};
        int rows = DB.update((DBRoute)DB_Route, (String)sql, (Object[])params);
        if (rows > 0) {
            locked = true;
            logger.info("Schedule***Schedule***cluster[" + clusterName + "]apply db account lock[" + fid + "]success.");
        } else {
            locked = false;
            logger.error("Schedule***Schedule***cluster[" + clusterName + "]apply db account lock[" + fid + "]fail,insert record fail.");
        }
        return locked;
    }

    public static boolean tryLock(String clusterName) {
        try {
            boolean locked = true;
            DBElectionHelper.autoReleaseDisabledLock();
            List<SchLockInfo> lockList = DBElectionHelper.getEnabledLock();
            if (lockList == null || lockList.isEmpty()) {
                locked = DBElectionHelper.insertLockData(clusterName);
            } else if (lockList.size() == 1) {
                String str;
                String fid = lockList.get(0).getId();
                if (clusterName.equals(lockList.get(0).getClusterName())) {
                    String sql = "update T_SCH_LOCK set fupdatetime = ?,ftimeout = ? where fid = ?";
                    Object[] params = new SqlParameter[]{new SqlParameter(FUPFATE_TIME, 91, (Object)new Date()), new SqlParameter(FTIMEOUT, 4, (Object)TIMEOUT.intValue()), new SqlParameter(":fid", 12, (Object)fid)};
                    DB.update((DBRoute)DB_Route, (String)sql, (Object[])params);
                    str = "Schedule***cluster[" + clusterName + "]occupied the db account lock[" + fid + "],no need to reapply.";
                } else {
                    locked = false;
                    str = "Schedule***cluster[" + clusterName + "]apply db account lock fail,because cluster[" + lockList.get(0).getClusterName() + "]occupied the db account lock[" + fid + "].";
                }
                logger.info(str);
            } else {
                DBElectionHelper.clearAllLockData();
                locked = DBElectionHelper.insertLockData(clusterName);
            }
            return locked;
        }
        catch (Exception e) {
            logger.error("Schedule***cluster[" + clusterName + "]apply db account lock fail", (Throwable)e);
            return false;
        }
    }

    public static boolean tryLock() {
        String clusterName = Instance.getClusterName();
        return DBElectionHelper.tryLock(clusterName);
    }

    private static boolean releaseLock(String clusterName) {
        boolean release = true;
        DBElectionHelper.autoReleaseDisabledLock();
        List<SchLockInfo> lockList = DBElectionHelper.getEnabledLock();
        if (lockList != null && !lockList.isEmpty()) {
            Object[] params;
            String sql;
            int rows;
            SchLockInfo lockInfo = lockList.get(0);
            String fid = lockInfo.getId();
            if (clusterName.equals(lockInfo.getClusterName()) && (rows = DB.update((DBRoute)DB_Route, (String)(sql = "update T_SCH_LOCK set funlocktime = ?, fupdatetime = ?, fenable=?, funlocktype=? where fid = ?"), (Object[])(params = new SqlParameter[]{new SqlParameter(FUNLOCK_TIME, 91, (Object)new Date()), new SqlParameter(FUPFATE_TIME, 91, (Object)new Date()), new SqlParameter(FENABLE, 1, (Object)"0"), new SqlParameter(":funlocktype", 1, (Object)"0"), new SqlParameter(":fid", 12, (Object)fid)}))) > 0) {
                logger.info("Schedule***cluster[" + clusterName + "]release the db account lock[" + fid + "]");
            }
        }
        return release;
    }

    public static boolean releaseLock() {
        String clusterName = Instance.getClusterName();
        return DBElectionHelper.releaseLock(clusterName);
    }

    private static void heartbeatLock(String clusterName) {
        if (!DB.exitsTable((DBRoute)DBRoute.basedata, (String)"t_sch_lock")) {
            logger.debug("Schedule***background schedule lock table: t_sch_lock is not exist,neet to update.");
            return;
        }
        try {
            String sql = "update T_SCH_LOCK set fupdatetime= ?, ftimeout = ?  where fclustername = ? and funlocktime is null  and fenable = ?";
            Object[] params = new SqlParameter[]{new SqlParameter(FUPFATE_TIME, 91, (Object)new Date()), new SqlParameter(FTIMEOUT, 4, (Object)TIMEOUT.intValue()), new SqlParameter(":fclustername", 12, (Object)clusterName), new SqlParameter(FENABLE, 1, (Object)"1")};
            DB.update((DBRoute)DB_Route, (String)sql, (Object[])params);
            logger.info("Schedule***cluster[" + clusterName + "]send a heartbeat to the db");
        }
        catch (Exception e) {
            logger.error("Schedule***background schedule account lock apply fail,msg:", (Throwable)e);
        }
    }

    public static void heartbeatLock() {
        String clusterName = Instance.getClusterName();
        DBElectionHelper.heartbeatLock(clusterName);
    }

    private static void autoReleaseDisabledLock() {
        List<SchLockInfo> list = DBElectionHelper.getEnabledLock();
        ArrayList<String> release = new ArrayList<String>();
        for (SchLockInfo info : list) {
            Date lastUpdate = info.getLastUpdateTime();
            Date lockTime = info.getLockTime();
            if (lastUpdate == null && DBElectionHelper.isTimeOut(lockTime, info.getMaxTimeOut())) {
                release.add(info.getId());
                continue;
            }
            if (lastUpdate == null || !DBElectionHelper.isTimeOut(lastUpdate, info.getMaxTimeOut())) continue;
            release.add(info.getId());
        }
        if (!release.isEmpty()) {
            ArrayList<SqlParameter[]> params = new ArrayList<SqlParameter[]>(release.size());
            String sql = "update T_SCH_LOCK set fenable=?,funlocktime=?,funlocktype=? where fid = ? ";
            for (String id : release) {
                SqlParameter[] param = new SqlParameter[]{new SqlParameter(FENABLE, 1, (Object)"0"), new SqlParameter(FUNLOCK_TIME, 91, (Object)new Date()), new SqlParameter(":funlocktype", 1, (Object)"1"), new SqlParameter(":fid", 12, (Object)id)};
                params.add(param);
            }
            DB.executeBatch((DBRoute)DB_Route, (String)sql, params);
        }
    }

    private static boolean isTimeOut(Date lastDate, long maxTimeOutSecond) {
        if (lastDate == null) {
            return true;
        }
        return new Date().getTime() - lastDate.getTime() > maxTimeOutSecond * 1000L;
    }

    private static List<SchLockInfo> getEnabledLock() {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select fid, fclustername, flocktime, funlocktime, ftimeout, fdata, fupdatetime ");
        sqlSb.append("from T_SCH_LOCK ");
        sqlSb.append("where funlocktime is null and fenable = '1'");
        return (List)DB.query((DBRoute)DB_Route, (String)sqlSb.toString(), rs -> {
            ArrayList<SchLockInfo> list = new ArrayList<SchLockInfo>(16);
            while (rs.next()) {
                SchLockInfo data = new SchLockInfo();
                data.setId(rs.getString("fid"));
                data.setClusterName(rs.getString("fclustername"));
                data.setLockTime(rs.getTimestamp("flocktime"));
                data.setUnLockTime(rs.getTimestamp("funlocktime"));
                data.setMaxTimeOut(rs.getLong("ftimeout"));
                data.setData(rs.getString("fdata"));
                data.setEnable(true);
                data.setLastUpdateTime(rs.getTimestamp("fupdatetime"));
                list.add(data);
            }
            return list;
        });
    }
}

