/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.TaskResult;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.server.ExecutorServerStatistic;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.schedule.utils.ScheduleGrayGroup;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;

public class ExecutorResourceManager {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.server.ExecutorResourceManager");
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";
    private static ExecutorResourceManager instance = null;
    private PathChildrenCache executorListener;
    protected ActiveKeyValueStore zkStore = null;
    private static volatile AtomicBoolean isDoClearUping = new AtomicBoolean(false);
    @Deprecated
    protected Map<String, ExecutorServerStatistic> executorServerMap = new ConcurrentHashMap<String, ExecutorServerStatistic>();
    private ObjectFactory objectFactory = null;
    protected Map<String, Map<String, List<String>>> workerAppGroupInfo = new ConcurrentHashMap<String, Map<String, List<String>>>();
    private Map<String, Set<String>> workedAppGroupMapping = new ConcurrentHashMap<String, Set<String>>();

    public static ExecutorResourceManager getInstance() {
        return instance;
    }

    public static void setInstance(ExecutorResourceManager instance) {
        ExecutorResourceManager.instance = instance;
    }

    @Deprecated
    public Collection<ExecutorServerStatistic> getExecutorServers() {
        return this.executorServerMap.values();
    }

    public void setZooKeeper() {
        this.zkStore = ActiveKeyValueStore.create();
    }

    public void start() {
        try {
            this.executorListener = new PathChildrenCache(this.zkStore.getCuratorFramework(), ZkConfig.getExecutorServerPath(), true);
            this.executorListener.getListenable().addListener((client, event) -> {
                String path = event.getData() == null ? "" : event.getData().getPath();
                log.info(String.format("Schedule***Executor Resource Manager error. eventType : %s , path : %s ", event.getType(), path));
                OperationContext oc = new OperationContext();
                oc.setAppId("bos");
                OperationContext.set((OperationContext)oc);
                if (ScheduleService.getInstance().isLeader() && (event.getType() == PathChildrenCacheEvent.Type.CHILD_ADDED || event.getType() == PathChildrenCacheEvent.Type.CHILD_REMOVED)) {
                    this.initServerList();
                    if (event.getType() == PathChildrenCacheEvent.Type.CHILD_REMOVED && AbstractService.RunMode.Dev != ZkConfig.getRunMode()) {
                        this.doClearUp();
                    }
                }
            });
        }
        catch (Throwable e) {
            log.error("Schedule***Executor Resource Manager error", e);
            throw e;
        }
        try {
            this.executorListener.start();
            this.initServerList();
            this.doClearUp();
        }
        catch (Exception e) {
            log.error("Schedule***Executor Resource Manager error", (Throwable)e);
        }
        log.info("Schedule***Executor Resource Manager is started.");
    }

    private void doClearUp() {
        if (isDoClearUping.get()) {
            log.debug("Schedule***Executor Resource Manager isDoClearUping");
            return;
        }
        isDoClearUping.set(true);
        this._doClearUp();
    }

    private void _doClearUp() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ExecutorResourceManager.this.doClearUpJob();
            }
        };
        Timer timer = new Timer("BOSSchedule-ExecutorResourceManager-doClearUp-Timer");
        timer.schedule(task, 180000L);
    }

    protected void doClearUpJob() {
        ThreadPools.executeOnce((String)"BOSSchedule-ExecutorResourceManager-doClearUp", (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
                    for (Account account : ScheduleService.getInstance().getTrigger().getElectedAccountsOfCluster().values()) {
                        RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                        log.info("Schedule***Executor Resource Manager doClearUp");
                        JobInfo job = new JobInfo();
                        job.setRunByUserId(100L);
                        job.setAppId("bos");
                        job.setJobType(JobType.REALTIME);
                        job.setId("1485581737441402880");
                        job.setName("Schedule ClearUpTask");
                        job.setNumber("BOS_SCHEDULE_CLEARUPTASK");
                        job.setTaskClassname("kd.bos.schedule.server.clearlogtask.ClearUpTask");
                        jobDispatcher.dispatch(job);
                    }
                }
                catch (Exception e) {
                    log.error("Schedule***Executor Resource Manager doClearUp error", (Throwable)e);
                }
                finally {
                    isDoClearUping.set(false);
                }
            }
        });
    }

    public void initServerList() {
        try {
            List serverList = this.zkStore.getChildren(ZkConfig.getExecutorServerPath());
            this.serverChanged(serverList);
        }
        catch (Exception e) {
            log.error("Schedule***Executor Resource Manager error", (Throwable)e);
            throw e;
        }
    }

    private void serverChanged(List<String> serverList) {
        if (this.executorServerMap.size() == 0) {
            for (String serverName : serverList) {
                this.newServerJoin(serverName);
            }
        } else {
            for (String serverName : serverList) {
                if (this.executorServerMap.containsKey(serverName)) continue;
                this.newServerJoin(serverName);
            }
            ArrayList<String> existedServerList = new ArrayList<String>();
            for (String serverName : this.executorServerMap.keySet()) {
                if (serverList.contains(serverName)) continue;
                existedServerList.add(serverName);
            }
            this.executorServersExisted(existedServerList);
        }
        this.buildWorkedAppGroup();
    }

    private ExecutorServerInfo readFormZk(String serviceName) {
        String path = ZkConfig.getExecutorServerPath() + "/" + serviceName;
        if (this.zkStore.exists(path) != null) {
            String str = null;
            try {
                str = new String(this.zkStore.getData(path, null, null), StandardCharsets.UTF_8);
                ExecutorServerInfo data = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)str, ExecutorServerInfo.class);
                return data;
            }
            catch (Throwable t) {
                log.error(String.format("Schedule***Executor Resource Manager error. serviceName %s, data %s", serviceName, str), t);
                throw t;
            }
        }
        return null;
    }

    private void newServerJoin(String serverName) {
        try {
            ExecutorServerInfo zkData = this.readFormZk(serverName);
            if (zkData != null) {
                String group = (String)zkData.getDetail().get("curAppGroup");
                String appids = (String)zkData.getDetail().get("appids");
                this.workerAppGroupInfo.putIfAbsent(serverName, new HashMap());
                Map<String, List<String>> workerGroup = this.workerAppGroupInfo.get(serverName);
                if (group != null && appids != null) {
                    List appList = SerializationUtils.fromJsonStringToList((String)appids, String.class);
                    workerGroup.put(group, appList);
                }
                this.executorServerMap.put(serverName, ExecutorServerStatistic.fromServerInfo((ExecutorServerInfo)zkData));
            }
        }
        catch (Throwable t) {
            log.error(String.format("Schedule***Executor Resource Manager newServerJoin error. serverName %s ", serverName), t);
        }
    }

    private void executorServersExisted(List<String> existedServerList) {
        for (String serverName : existedServerList) {
            this.executorServerMap.remove(serverName);
            this.workerAppGroupInfo.remove(serverName);
            log.info("Schedule***\u6267\u884c\u673a" + serverName + "\u9000\u51fa\u4e86");
        }
    }

    protected void buildWorkedAppGroup() {
        ScheduleGrayGroup.init();
        this.workedAppGroupMapping.clear();
        for (Map.Entry<String, Map<String, List<String>>> it : this.workerAppGroupInfo.entrySet()) {
            for (Map.Entry<String, List<String>> row : it.getValue().entrySet()) {
                for (String appid : row.getValue()) {
                    this.workedAppGroupMapping.putIfAbsent(appid, new HashSet());
                    Set<String> vers = this.workedAppGroupMapping.get(appid);
                    vers.add(row.getKey());
                }
            }
        }
        ScheduleGrayGroup.grayNodeStatu = this.workedAppGroupMapping;
        ScheduleGrayGroup.endInit();
    }

    @Deprecated
    public ExecutorServerStatistic getInfoByName(String serverName) {
        return this.executorServerMap.get(serverName);
    }

    private void adjustTask(ExecutorServerStatistic exeServerInfo) {
        ExecutorServerStatistic replaceServerInfo = this.getReplaceServerInfo(exeServerInfo);
        String exeServerPath = ZkConfig.getJobRootPath() + "/" + exeServerInfo.getName();
        List jobPaths = this.zkStore.getChildren(exeServerPath);
        for (String taskId : jobPaths) {
            String taskStatusPath = ZkConfig.getTaskStatusPath((String)taskId);
            String msgStr = this.zkStore.read(taskStatusPath, null);
            MessageInfo statusMsg = (MessageInfo)SerializationUtils.fromJsonString((String)msgStr, MessageInfo.class);
            TaskResult taskResult = statusMsg.fectchTaskResult();
            if (taskResult != null && taskResult.getStatus().equals("SCHEDULED")) {
                if (replaceServerInfo != null) {
                    this.moveJob(statusMsg, exeServerInfo, replaceServerInfo);
                    continue;
                }
                this.disconnectedNotify(statusMsg, exeServerInfo);
                continue;
            }
            this.disconnectedNotify(statusMsg, exeServerInfo);
        }
    }

    private void disconnectedNotify(MessageInfo statusMsg, ExecutorServerStatistic exeServerInfo) {
        RequestContext rc = RequestContext.create();
        rc.setTenantId(statusMsg.getTenantId());
        rc.setAccountId(statusMsg.getAccountId());
        MessageInfo failedMsg = MessageCreator.createStatusMessage((String)statusMsg.getTaskId(), (String)"DISCONNECTED", (String)ResManager.loadKDString((String)"\u6267\u884c\u670d\u52a1\u5668\u8fde\u63a5\u4e2d\u65ad", (String)"ExecutorResourceManager_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        failedMsg.setTarget(exeServerInfo.getName());
        String msgStr = SerializationUtils.toJsonString((Object)failedMsg);
        String taskStatusPath = ZkConfig.getTaskStatusPath((String)statusMsg.getTaskId());
        this.zkStore.write(taskStatusPath, msgStr);
    }

    private void moveJob(MessageInfo statusMsg, ExecutorServerStatistic fromServer, ExecutorServerStatistic toServer) {
        String oldJobPath = ZkConfig.getJobPath((MessageInfo)statusMsg);
        String oldJobStatusPath = ZkConfig.getTaskStatusPath((String)statusMsg.getTaskId());
        statusMsg.setTarget(toServer.getName());
        this.zkStore.write(oldJobStatusPath, SerializationUtils.toJsonString((Object)statusMsg));
        String jobStr = this.zkStore.read(oldJobPath, null);
        MessageInfo jobMsg = (MessageInfo)SerializationUtils.fromJsonString((String)jobStr, MessageInfo.class);
        jobMsg.setFlag("SCHEDULE");
        jobMsg.setTarget(toServer.getName());
        jobStr = SerializationUtils.toJsonString((Object)jobMsg);
        this.zkStore.delete(oldJobPath);
        String newJobPath = ZkConfig.getJobPath((MessageInfo)statusMsg);
        this.zkStore.write(newJobPath, jobStr);
    }

    private ExecutorServerStatistic getReplaceServerInfo(ExecutorServerStatistic exeServerInfo) {
        ExecutorServerStatistic target = null;
        if (this.executorServerMap.size() > 0) {
            int min = Integer.MAX_VALUE;
            for (Map.Entry<String, ExecutorServerStatistic> s1 : this.executorServerMap.entrySet()) {
                ExecutorServerStatistic executorServerInfo;
                if (exeServerInfo != null && s1.getKey().equals(exeServerInfo.getName()) || (executorServerInfo = s1.getValue()).getRunning() >= min) continue;
                min = executorServerInfo.getRunning();
                target = executorServerInfo;
            }
        }
        return target;
    }

    public void stop() {
        try {
            this.executorListener.close();
        }
        catch (Throwable t) {
            log.error("Schedule***executor resource manager stop error", t);
        }
        log.info("Schedule***Executor Resource Manager is stopped.");
    }

    @Deprecated
    public ExecutorServerStatistic sheduleJob(MessageInfo message) {
        return this.getReplaceServerInfo(null);
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

