/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.broadcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.schedule.api.Executor;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.JobProcessor;
import kd.bos.schedule.message.SchThreadPoolWrapper;
import kd.bos.schedule.message.mq.MQObjectFactory;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.server.broadcast.BroadcastJobHandler;

public class BroadcastExecutor
extends AbstractService
implements Executor {
    private static Log log = LogFactory.getLog(BroadcastExecutor.class);
    protected Map<MessageType, List<MessageHandler>> messageHandlePool = new EnumMap<MessageType, List<MessageHandler>>(MessageType.class);
    protected Map<MessageType, List<Class<? extends MessageHandler>>> messageHandleClassPool = new EnumMap<MessageType, List<Class<? extends MessageHandler>>>(MessageType.class);

    public BroadcastExecutor() {
        this.registHandler(MessageType.BROADCASTJOB, BroadcastJobHandler.class);
    }

    public void registHandler(MessageType messageType, MessageHandler handler) {
        log.info("Schedule***handler\u5728\u6267\u884c\u4e2d\u6ce8\u518c\uff1a" + handler.getClass().getSimpleName());
        handler.setObjectFactory(this.objectFactory);
        List<MessageHandler> messageHandlers = this.messageHandlePool.get(messageType);
        if (messageHandlers != null) {
            if (!messageHandlers.contains(handler)) {
                messageHandlers.add(handler);
            }
        } else {
            messageHandlers = new ArrayList<MessageHandler>();
            messageHandlers.add(handler);
            this.messageHandlePool.put(messageType, messageHandlers);
        }
    }

    public void unRegistHandler(MessageType messageType, MessageHandler handler) {
        List<MessageHandler> messageHandlers = this.messageHandlePool.get(messageType);
        if (messageHandlers != null) {
            messageHandlers.remove(handler);
        }
    }

    public void registHandler(MessageType messageType, Class<? extends MessageHandler> handlerClass) {
        log.info("Schedule***handler\u5728\u6267\u884c\u4e2d\u6ce8\u518c\uff1a" + handlerClass.getSimpleName());
        List<Class<? extends MessageHandler>> handlerList = this.messageHandleClassPool.get(messageType);
        if (handlerList != null) {
            if (!handlerList.contains(handlerClass)) {
                handlerList.add(handlerClass);
            }
        } else {
            handlerList = new ArrayList<Class<? extends MessageHandler>>();
            handlerList.add(handlerClass);
            this.messageHandleClassPool.put(messageType, handlerList);
        }
    }

    public void unRegistHandler(MessageType messageType, Class<? extends MessageHandler> handlerClass) {
        List<Class<? extends MessageHandler>> handlerList = this.messageHandleClassPool.get(messageType);
        if (handlerList != null) {
            handlerList.remove(handlerClass);
        }
    }

    public List<MessageHandler> getMessageHandler(MessageType messageType) {
        ArrayList<MessageHandler> handlerList = new ArrayList<MessageHandler>();
        List<Class<? extends MessageHandler>> messageHanderClasses = this.messageHandleClassPool.get(messageType);
        if (messageHanderClasses != null) {
            for (Class<? extends MessageHandler> clazz : messageHanderClasses) {
                try {
                    handlerList.add((MessageHandler)TypesContainer.createInstance(clazz));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        if (this.messageHandlePool.get(messageType) != null) {
            handlerList.addAll((Collection<MessageHandler>)this.messageHandlePool.get(messageType));
        }
        return handlerList;
    }

    public void processMessage(MessageInfo message, MessageAcker acker) {
        JobProcessor jobProc = new JobProcessor();
        jobProc.setObjectFactory(this.objectFactory);
        List<MessageHandler> messageHandlers = this.getMessageHandler(message.getMessageType());
        if (messageHandlers.isEmpty()) {
            log.error("Schedule***\u6ca1\u6709\u6ce8\u518c\u5bf9\u5e94\u7684handler,\u65e0\u6cd5\u5904\u7406\u8fd9\u4e2a\u7c7b\u578b\u7684\u6d88\u606f:" + message);
            SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Client", (String)"haveNoMessageHandlers", (Object)message);
            return;
        }
        for (MessageHandler handler : messageHandlers) {
            handler.setObjectFactory(this.getObjectFactory());
            jobProc.setHandler(handler);
            jobProc.setMessage(message);
            SchThreadPoolWrapper executorPool = this.getThreadPool(message.getMessageType());
            executorPool.execute(jobProc);
        }
    }

    protected ObjectFactory createObjectFactory(String messageMode) {
        if (messageMode.equalsIgnoreCase("MQ")) {
            MQObjectFactory mqObjectFactory = new MQObjectFactory();
            mqObjectFactory.setExecutor((Executor)this);
            return mqObjectFactory;
        }
        return null;
    }

    public String getName() {
        return "BroadcastExecutor service";
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

