/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.broadcast;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.message.AbstractMessageSender;
import kd.bos.schedule.message.zk.ZkMessageSender;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.zk.ZkConfig;

public class BroadcastMessageSender
extends AbstractMessageSender {
    public static final String BROADCAST_RABBITMQ_CUSTOMER = "kd.bos.schedule.executor.BroadcastRabbitmqCustomer";
    private static Log log = LogFactory.getLog(BroadcastMessageSender.class);
    public static final String BROADCAST_DEBUG_KEY = "is_schedule_debug_broadcast";

    public void send(MessageInfo message) throws KDException {
        String msgStr = SerializationUtils.toJsonString((Object)message);
        MessageType msgType = message.getMessageType();
        if (msgType == MessageType.BIZ_TASK_FEEDBACK || msgType == MessageType.WorkFlow_TASK_FEEDBACK) {
            this.udpateStorage(message);
        } else {
            SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"beginSendMQ", (Object)message);
            if ("ZooKeeper".equalsIgnoreCase(ZkConfig.getMessageMode())) {
                ZkMessageSender sender = new ZkMessageSender();
                sender.setZooKeeper();
                sender.broadcastMsg(message);
            } else if ("MQ".equalsIgnoreCase(ZkConfig.getMessageMode())) {
                if (Boolean.parseBoolean(System.getProperty(BROADCAST_DEBUG_KEY, "false"))) {
                    BroadcastService.broadcastMessageContainSelf((String)BROADCAST_RABBITMQ_CUSTOMER, (String)"onMessage", (Object[])new Object[]{SerializationUtils.toJsonString((Object)message)});
                } else if (Instance.isAppSplit()) {
                    BroadcastService.broadcastMessageWithApp((String)((JobInfo)message.getJobInfo()).getAppId(), (String)BROADCAST_RABBITMQ_CUSTOMER, (String)"onMessage", (Object[])new Object[]{SerializationUtils.toJsonString((Object)message)});
                } else {
                    BroadcastService.broadcastMessage((String)BROADCAST_RABBITMQ_CUSTOMER, (String)"onMessage", (Object[])new Object[]{SerializationUtils.toJsonString((Object)message)});
                }
            }
            SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"sendMQSuccess", (Object)message);
        }
    }
}

