/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.clearlogtask;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.StrategyType;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.dao.dbImpl.TaskCache;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;

public class ClearLogTask
implements Task {
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final Log log = LogFactory.getLog(ClearLogTask.class);
    private static final String BATCH_DELETE_SIZE = "batchDeleteSize";
    private JobDispatcherProxy proxy = new JobDispatcherProxy();
    private long thresholdTimeStamp;
    private long thresholdTimeStamp_wf = this.thresholdTimeStamp = System.currentTimeMillis() - Long.parseLong("8") * 1000L * 60L * 60L * 24L;
    int batchSize = 500;
    boolean selectAllData = false;
    long clearSize = 200000L;

    private String getProptyByTenant(String key, String tenantId) {
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((CharSequence)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }

    private void init(Map<String, Object> param) {
        if (param == null) {
            return;
        }
        if (StringUtils.isNotBlank((Object)param.get("deleteBeforeDay"))) {
            String taskDeleteBefore_d = String.valueOf(param.get("deleteBeforeDay"));
            this.thresholdTimeStamp = System.currentTimeMillis() - Long.parseLong(taskDeleteBefore_d) * 1000L * 60L * 60L * 24L;
        }
        if (StringUtils.isNotBlank((Object)param.get(BATCH_DELETE_SIZE))) {
            this.batchSize = Integer.parseInt(String.valueOf(param.get(BATCH_DELETE_SIZE)));
        }
        if (StringUtils.isNotBlank((Object)param.get("selectAllData"))) {
            this.selectAllData = Boolean.parseBoolean(String.valueOf(param.get("selectAllData")));
        }
        if (StringUtils.isNotBlank((Object)param.get("maxJobDeleteSize"))) {
            this.clearSize = Long.parseLong(String.valueOf(param.get(BATCH_DELETE_SIZE)));
        }
        if (StringUtils.isNotBlank((Object)param.get("deleteBeforeDay_wf"))) {
            String taskDeleteBefore_wf = String.valueOf(param.get("deleteBeforeDay_wf"));
            this.thresholdTimeStamp_wf = System.currentTimeMillis() - Long.parseLong(taskDeleteBefore_wf) * 1000L * 60L * 60L * 24L;
        } else {
            this.thresholdTimeStamp_wf = this.thresholdTimeStamp;
        }
    }

    public void execute(RequestContext rc, Map<String, Object> param) throws KDException {
        this.init(param);
        this.clearRealTimeJob();
        this.clearWorkFlowJob();
        this.clearJobRecordByTime(JobType.REALTIME.name());
        this.clearJobRecordByTime(JobType.WORKFLOW.name());
        String ArchiveEnable = this.getProptyByTenant("Schedule.Archive.Enable", RequestContext.get().getTenantId());
        if (StringUtils.isBlank((CharSequence)ArchiveEnable) || !ArchiveEnable.toLowerCase(Locale.ENGLISH).equals("true")) {
            this.deleteTaskRecord();
        }
        this.clearErrorJobRecord();
        this.clearTaskTraceRecord();
        this.updateTaskRecordStatus();
        this.clearDBAccountLockData();
    }

    private void clearDBAccountLockData() {
        String sql = "SELECT FID FROM T_SCH_LOCK WHERE FENABLE = '0' AND FUNLOCKTIME < ?";
        ArrayList<String> ids = new ArrayList<String>(16);
        Object[] params = new Object[]{new Date(this.thresholdTimeStamp)};
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"ClearHistorySchDBAccountLock", (DBRoute)DBRoute.base, (String)sql, (Object[])params));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String id = row.getString("FID");
                ids.add(id);
                if (ids.size() != 1000) continue;
                this.deleteDBAccountLockData(ids);
                ids.clear();
            }
            if (!ids.isEmpty()) {
                this.deleteDBAccountLockData(ids);
            }
        }
    }

    private void deleteDBAccountLockData(List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(ids.size());
            for (String id : ids) {
                paramsList.add(new Object[]{id});
            }
            String deleteSQL = "DELETE FROM T_SCH_LOCK WHERE FID = ?";
            try {
                DB.executeBatch((DBRoute)DBRoute.base, (String)deleteSQL, paramsList);
            }
            catch (Exception e) {
                log.error("Schedule***deleteDBAccountLockData error", (Throwable)e);
                handle.markRollback();
            }
        }
    }

    private void clearTaskTraceRecord() {
        String sql = "select fid from t_sch_tasktrace where fmodifytime < ?";
        ArrayList<Long> ids = new ArrayList<Long>(16);
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"ClearHistorySchTaskTrace", (DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{new Date(this.thresholdTimeStamp)}));){
            while (ds.hasNext()) {
                Row row = ds.next();
                long id = row.getLong("fid");
                ids.add(id);
                if (ids.size() != 1000) continue;
                this.deleteTaskTrace(ids);
                ids.clear();
            }
            if (!ids.isEmpty()) {
                this.deleteTaskTrace(ids);
            }
        }
    }

    private void clearErrorJobRecord() {
        String sql = "select ftaskid from t_sch_errorjob where fexecutetime < ?";
        ArrayList<Object[]> ids = new ArrayList<Object[]>(16);
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"clearErrorJobRecord", (DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{new Date(this.thresholdTimeStamp)}));){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(new Object[]{row.getString("ftaskid")});
                if (ids.size() != 1000) continue;
                this.deleteErrorJobRecord(ids);
                ids.clear();
            }
            if (!ids.isEmpty()) {
                this.deleteErrorJobRecord(ids);
            }
        }
    }

    private void deleteErrorJobRecord(List<Object[]> ids) {
        try (TXHandle txHandle = TX.requiresNew((String)"deleteErrorJobRecord");){
            try {
                DB.executeBatch((DBRoute)DBRoute.base, (String)"delete from t_sch_errorjob where ftaskid = ?", ids);
            }
            catch (Exception e) {
                log.error("Schedule***ClearLogTask error", (Throwable)e);
                txHandle.markRollback();
            }
        }
    }

    private void deleteTaskTrace(List<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(ids.size());
        for (Long id : ids) {
            paramsList.add(new Object[]{id});
        }
        String deleteSQL = "delete from t_sch_tasktrace where fid = ?";
        try (TXHandle txHandle = TX.requiresNew((String)"deleteTaskTrace");){
            try {
                DB.executeBatch((DBRoute)DBRoute.base, (String)deleteSQL, paramsList);
            }
            catch (Exception e) {
                log.error("Schedule***ClearLogTask error", (Throwable)e);
                txHandle.markRollback();
            }
        }
    }

    private void updateTaskRecordStatus() {
        String sql = "select t1.fid, t1.fstatus, t1.fjobid, t1.fscheduleid, t2.fjobtype, t2.fstrategy,t2.fconcurrent from t_sch_task t1 left join t_sch_job t2 on t1.fjobid = t2.fid where t1.fstatus in ('SCHEDULED')";
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"UpdateTaskRecordStatus", (DBRoute)DBRoute.base, (String)sql));){
            ArrayList<String> paramsList = new ArrayList<String>();
            while (ds.hasNext()) {
                String lockTaskId;
                Row row = ds.next();
                String id = row.getString("fid");
                String status = row.getString("fstatus");
                String scheduleId = row.getString("fscheduleid");
                String jobid = row.getString("fjobid");
                String jobType = row.getString("fjobtype");
                String strategy = row.getString("fstrategy");
                String concurrent = row.getString("fconcurrent");
                if ("1".equals(concurrent) || JobType.WORKFLOW.name().equals(jobType) || StrategyType.COVERBEFORETASK.getValue() == strategy) {
                    if (TaskCache.getTaskInfo((String)id) != null) continue;
                    paramsList.add(id);
                    continue;
                }
                String jobLockKey = "schedule-" + scheduleId + "-" + jobid;
                String string = lockTaskId = DLock.getLockInfo((String)jobLockKey) == null ? "" : DLock.getLockInfo((String)jobLockKey).getDesc();
                if (DLock.getLockInfo((String)jobLockKey) != null && (!StringUtils.isNotBlank((CharSequence)lockTaskId) || id.equals(lockTaskId))) continue;
                paramsList.add(id);
            }
            if (!paramsList.isEmpty()) {
                for (String taskId : paramsList) {
                    try {
                        this.proxy.abortTask(taskId);
                    }
                    catch (Exception e) {
                        log.error("Schedule**** abortTask error taskid:" + taskId, (Throwable)e);
                    }
                }
            }
        }
    }

    private void clearWorkFlowJob() {
        this.clearJobRecord("WORKFLOW");
    }

    public void setTaskId(String arg0) {
    }

    public void stop() throws KDException {
    }

    private void clearRealTimeJob() {
        this.clearJobRecord("REALTIME");
    }

    private void clearJobRecord(String jobType) {
        long max = this.clearSize;
        if (this.selectAllData) {
            String selectCountsql = "select count(fid) from t_sch_job where fcreatetime is null";
            max = (Long)DB.query((DBRoute)Sch_Route, (String)selectCountsql, rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            });
        }
        long times = max / (long)this.batchSize;
        int i = 1;
        while ((long)i < times) {
            String selectIdSql = " select top " + this.batchSize + " fid from t_sch_job where fjobtype= ? and fcreatetime is null";
            Object[] jobparams = new SqlParameter[]{new SqlParameter(":fjobtype", 12, (Object)jobType)};
            List pkIds = (List)DB.query((DBRoute)Sch_Route, (String)selectIdSql, (Object[])jobparams, rs -> {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("fid"));
                }
                return list;
            });
            if (pkIds.isEmpty()) break;
            ArrayList<String> jobIds = new ArrayList<String>(10);
            for (String id : pkIds) {
                SqlParameter[] delParams = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
                jobIds.add(id);
                if (jobIds.size() != this.batchSize) continue;
                this.deleteJobRecord(jobIds.toArray());
                jobIds.clear();
            }
            if (jobIds.size() > 0) {
                this.deleteJobRecord(jobIds.toArray());
            }
            ++i;
        }
    }

    private void deleteJobRecord(Object[] ids) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                ScheduleDataEntityUtils.getInvoker().delete(SchEntityType.Job, ids);
            }
            catch (Exception e) {
                log.error("deleteJobRecord error. ids: {}", (Object)ids, (Object)e);
            }
        }
    }

    private void deleteTaskRecord() {
        for (JobType jobType : JobType.values()) {
            this.deleteTaskRecord(jobType.name());
        }
        this.deleteTaskRecord(JobType.WORKFLOW.name(), new Timestamp(this.thresholdTimeStamp_wf));
        this.deleteTaskRecord(" ");
    }

    private void deleteTaskRecord(String jobType) {
        Object[] params;
        Timestamp date = new Timestamp(this.thresholdTimeStamp);
        StringBuilder sql = new StringBuilder("select fid,fdispatchtime,fendtime,fjobid from t_sch_task where (fdispatchtime < ? or fendtime < ?)");
        if (StringUtils.isBlank((CharSequence)jobType)) {
            sql.append("  and (fjobtype = ? or fjobtype=? or fjobtype is null )");
            params = new Object[]{date, date, jobType, ""};
        } else {
            sql.append("  and fjobtype = ?");
            params = new Object[]{date, date, jobType};
        }
        ArrayList<String> taskIds = new ArrayList<String>(8);
        ArrayList<String> jobIds = new ArrayList<String>(8);
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"ClearHistorySchRecordTask", (DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String id = row.getString("fid");
                String jobId = row.getString("fjobid");
                taskIds.add(id);
                jobIds.add(jobId);
                if (taskIds.size() != 1000) continue;
                this.deleteTask(jobType, taskIds, jobIds);
                taskIds.clear();
                jobIds.clear();
            }
            if (!taskIds.isEmpty()) {
                this.deleteTask(jobType, taskIds, jobIds);
            }
        }
    }

    private void deleteTaskRecord(String jobType, Date date) {
        if (date.getTime() == this.thresholdTimeStamp) {
            log.debug("\u65f6\u95f4\u8bbe\u7f6e\u4e0e\u603b\u7684\u65f6\u95f4\u4e00\u81f4\uff0c\u65e0\u987b\u5355\u72ec\u5904\u7406. jobType:{} thresholdTime:{}", (Object)jobType, (Object)date);
            return;
        }
        int batchSize = 1000;
        String sql = "select top %d fid,fjobid from t_sch_task where (fdispatchtime < ? or fendtime < ?) and fjobtype = ?";
        sql = String.format(sql, batchSize);
        List taskIds = null;
        while (taskIds == null || !taskIds.isEmpty()) {
            ArrayList<String> jobIds = new ArrayList<String>(8);
            taskIds = (List)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{date, date, jobType}, rs -> {
                ArrayList<String> list = new ArrayList<String>(8);
                while (rs.next()) {
                    list.add(rs.getString("fid"));
                    jobIds.add(rs.getString("fjobid"));
                }
                return list;
            });
            if (taskIds.isEmpty()) continue;
            this.deleteTask(JobType.WORKFLOW.name(), taskIds, jobIds);
        }
    }

    private void deleteTask(String jobType, List<String> taskIds, List<String> jobIds) {
        if (taskIds.isEmpty()) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(taskIds.size());
            for (String id : taskIds) {
                paramsList.add(new Object[]{id});
            }
            DB.executeBatch((DBRoute)DBRoute.base, (String)"delete from t_sch_errorjob where ftaskid = ?", paramsList);
            DB.executeBatch((DBRoute)DBRoute.base, (String)"delete from t_sch_task where fid = ?", paramsList);
        }
    }

    private void clearJobRecordByTime(String jobType) {
        Timestamp date = JobType.WORKFLOW.name().equals(jobType) ? new Timestamp(this.thresholdTimeStamp_wf) : new Timestamp(this.thresholdTimeStamp);
        int batchSize = 1000;
        String sql = "select top %d fid from t_sch_job where fcreatetime < ? and fjobtype = ?";
        sql = String.format(sql, batchSize);
        List jobIds = null;
        while (jobIds == null || !jobIds.isEmpty()) {
            jobIds = (List)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{date, jobType}, rs -> {
                ArrayList<String> list = new ArrayList<String>(8);
                while (rs.next()) {
                    list.add(rs.getString("fid"));
                }
                return list;
            });
            if (jobIds.isEmpty()) continue;
            this.deleteJobRecord(jobIds.toArray());
        }
    }
}

